local a = Integer(5)
local b = Integer(3)
local c = Integer(-12)
local d = Integer("-54321")
local e = Integer("99989999999999999989999999999999999999999999999999999999989999999999999999999999999998999999999999999999999999989999999998")
local f = Integer("-1267650600228229401496703205376")
local g = Integer(16)
local h = Integer(8)
local x = Integer(8) / Integer(5)
local y = Integer(1) / Integer(12)
local z = Integer(-7) / Integer(10)


starttest("integer construction")
testeq(a, 5)
testeq(b, 3)
testeq(c, -12)
testeq(d, "-54321")
testeq(e, "99989999999999999989999999999999999999999999999999999999989999999999999999999999999998999999999999999999999999989999999998")
testeq(f, "-1267650600228229401496703205376")
endtest()

starttest("integer operations")
testeq(-c, 12)
testeq(a + b, 8)
testeq(b - c, 15)
testeq(d - d, 0)
testeq(e + f, "99989999999999999989999999999999999999999999999999999999989999999999999999999999999998999998732349399771770598493296794622")
testeq(a * c, -60)
testeq(f * f, "1606938044258990275541962092341162602522202993782792835301376")
testeq(e * f, "-126752383516820657842978847503263945985032967946239999999987323493997717705985032967944972349399771770598503296781947493995182404784576509143246593589248")
testeq(a // b, 1)
testeq(a % b, 2)
testeq(f // d, "23336289836862896513258283")
testeq(f % d, "-14533")
testeq(e // -f, "78878201913048970415230130190415677050906625793723347950240237316957169209243093407705758276")
testeq(e % -f, "1011644662020502370048160308222")
testeq(c ^ a, -248832)
testeq(d ^ a, "-472975648731213834575601")
testeq(a == b, false)
testeq(b < a, true)
testeq(a <= a, true)
testeq(f < d, true)
testeq(e <= f, false)
endtest()



starttest("integer conversions")
testeq(a / b, "5/3")
testeq(g / c, "-4/3")
testeq(c / b, -4)
endtest()


starttest("rational operations")
testeq(-x, "-8/5")
testeq(x + y, "101/60")
testeq(z - y, "-47/60")
testeq(x * z, "-28/25")
testeq(x / y, "96/5")
testeq(y<x, true)
testeq(z<z, false)
testeq(z<=z, true)
endtest()

starttest("combined integer/rational operations")
testeq(a + x, "33/5")
testeq(x + a, "33/5")
testeq(b - y, "35/12")
testeq(y - b, "-35/12")
testeq(c * y, -1)
testeq(y * c, -1)
testeq(a / x, "25/8")
testeq(x / a, "8/25")
testeq(a/h == x, false)
testeq(h/a == x, true)
testeq(y < b , true)
testeq(b < y, false)
endtest()

local f = Integer(3)
local g = Integer(216)
local h = Integer(945)
local i = Integer("7766999")
local j = Integer(4)
local k = Integer(8)
local m = Integer(16)
local n = Integer(100000000003)
local o = Integer(200250077)

starttest("Miller-Rabin Primes")
testeq(f:isprime(), true, f)
testeq(g:isprime(), false, g)
testeq(h:isprime(), false, h)
testeq(i:isprime(), false, i)
testeq(n:isprime(), true, n)
testeq(o:isprime(), false, o)
endtest()


starttest("Pollard Rho algorithm")
testeq(f:findafactor(), 3, f)
testeq(g:findafactor(), 2, g)
testeq(h:findafactor(), 3, h)
testeq(i:findafactor(), 41, i)
testeq(j:findafactor(), 2, j)
testeq(k:findafactor(), 2, k)
testeq(m:findafactor(), 2, m)
endtest()

starttest("prime factorization")
testeq(f:primefactorization(), "* (3 ^ 1)", f, true)
testeq(g:primefactorization(), "(2 ^ 3) * (3 ^ 3)", g, true)
testeq(h:primefactorization(), "(3 ^ 3) * (5 ^ 1) * (7 ^ 1)", h, true)
testeq(i:primefactorization(), "(41 ^ 1) * (189439 ^ 1)", i, true)
testeq(o:primefactorization(), "(10007 ^ 1) * (20011 ^ 1)", o, true)
endtest()