Punctuation marks
===================

References:

1. [Unicode Vertical Text Layout](http://www.unicode.org/reports/tr50/)
2. [Vertical Orientation](http://www.unicode.org/Public/10.0.0/ucd/VerticalOrientation.txt)
3. [East Asian Width](http://www.unicode.org/reports/tr11/)
4. [EastAsianWidth.txt](http://www.unicode.org/Public/10.0.0/ucd/EastAsianWidth.txt)
5. [General Category Value](http://www.unicode.org/reports/tr44/#General_Category_Values)
6. [Scripts.txt](http://www.unicode.org/Public/10.0.0/ucd/Scripts.txt)


Brackets
--------

|Unicode | name                                     |  |width|gc|vo|JIS X 0208|JIS X 0213|UniJIS-*-H| -V | upjis*.pl |
|--------|-------------------------------------------|:-:|:-:|:-:|:-:|--------|----------|:-----:|:-----:|:-----:|
| U+00AB | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK  | « |N|Pi|R | NA     | 1-09-08  | 109   | (109) | type1 |
| U+00BB | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK | » |N|Pf|R | NA     | 1-09-18  | 123   | (123) | type2 |
| U+2018 | LEFT SINGLE QUOTATION MARK                 | ‘ |A|Pi|R | 01-38 | 1-01-38  | 98    | (98)  | type1 |
| U+2019 | RIGHT SINGLE QUOTATION MARK                | ’ |A|Pf|R | 01-39 | 1-01-39  | 96    | (96)  | type2 |
| U+201A | SINGLE LOW-9 QUOTATION MARK                | ‚ |N|Ps|R | NA     | NA       | 120   | (120) | NA    |
| U+201B | SINGLE HIGH-REVERSED-9 QUOTATION MARK      | ‛ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+201C | LEFT DOUBLE QUOTATION MARK                 | “ |A|Pi|R | 01-40 | 1-01-40  | 108   | (108) | type1 |
| U+201D | RIGHT DOUBLE QUOTATION MARK                | ” |A|Pf|R | 01-41 | 1-01-41  | 122   | (122) | type2 |
| U+201E | DOUBLE LOW-9 QUOTATION MARK                | „ |N|Ps|R | NA     | NA       | 121   | (121) | NA    |
| U+201F | DOUBLE HIGH-REVERSED-9 QUOTATION MARK      | ‟ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+2039 | SINGLE LEFT-POINTING ANGLE QUOTATION MARK  | ‹ |N|Pi|R | NA     | NA       | 110   | (110) | NA    |
| U+203A | SINGLE RIGHT-POINTING ANGLE QUOTATION MARK | › |N|Pf|R | NA     | NA       | 111   | (111) | NA    |
| U+2045 | LEFT SQUARE BRACKET WITH QUILL             | ⁅ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+2046 | RIGHT SQUARE BRACKET WITH QUILL            | ⁆ |N|Pe|R | NA     | NA       | NA    | NA    | NA    |
| U+2329 | LEFT-POINTING ANGLE BRACKET                | 〈  |W|Ps|Tr| NA    | NA       | 682   | (682) | type1 |
| U+232A | RIGHT-POINTING ANGLE BRACKET               | 〉  |W|Pe|Tr| NA    | NA       | 683   | (682) | type2 |
| U+3008 | LEFT ANGLE BRACKET                         | 〈 |W|Ps|Tr| 01-50 | 1-01-50  | 682   | 7907  | type1 |
| U+3009 | RIGHT ANGLE BRACKET                        | 〉 |W|Pe|Tr| 01-51 | 1-01-51  | 683   | 7908  | type2 |
| U+300A | LEFT DOUBLE ANGLE BRACKET                  | 《 |W|Ps|Tr| 01-52 | 1-01-52  | 684   | 7909  | type1 |
| U+300B | RIGHT DOUBLE ANGLE BRACKET                 | 》 |W|Pe|Tr| 01-53 | 1-01-53  | 685   | 7910  | type2 |
| U+300C | LEFT CORNER BRACKET                        | 「 |W|Ps|Tr| 01-54 | 1-01-54  | 686   | 7911  | type1 |
| U+300D | RIGHT CORNER BRACKET                       | 」 |W|Pe|Tr| 01-55 | 1-01-55  | 687   | 7912  | type2 |
| U+300E | LEFT WHITE CORNER BRACKET                  | 『 |W|Ps|Tr| 01-56 | 1-01-56  | 688   | 7913  | type1 |
| U+300F | RIGHT WHITE CORNER BRACKET                 | 』 |W|Pe|Tr| 01-57 | 1-01-57  | 689   | 7914  | type2 |
| U+3010 | LEFT BLACK LENTICULAR BRACKET              | 【 |W|Ps|Tr| 01-58 | 1-01-58  | 690   | 7915  | type1 |
| U+3011 | RIGHT BLACK LENTICULAR BRACKET             | 】 |W|Pe|Tr| 01-59 | 1-01-59  | 691   | 7916  | type2 |
| U+3014 | LEFT TORTOISE SHELL BRACKET                | 〔 |W|Ps|Tr| 01-44 | 1-01-44  | 676   | 7901  | type1 |
| U+3015 | RIGHT TORTOISE SHELL BRACKET               | 〕 |W|Pe|Tr| 01-45 | 1-01-45  | 677   | 7902  | type2 |
| U+3016 | LEFT WHITE LENTICULAR BRACKET              | 〖 |W|Ps|Tr| NA    | 1-02-58  | 16197 | 16329 | type1 |
| U+3017 | RIGHT WHITE LENTICULAR BRACKET             | 〗 |W|Pe|Tr| NA    | 1-02-59  | 16198 | 16330 | type2 |
| U+3018 | LEFT WHITE TORTOISE SHELL BRACKET          | 〘 |W|Ps|Tr| NA    | 1-02-56  | 12129 | 12139 | type1 |
| U+3019 | RIGHT WHITE TORTOISE SHELL BRACKET         | 〙 |W|Pe|Tr| NA    | 1-02-57  | 12130 | 12140 | type2 |
| U+301A | LEFT WHITE SQUARE BRACKET                  | 〚 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+301B | RIGHT WHITE SQUARE BRACKET                 | 〛 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301D | REVERSED DOUBLE PRIME QUOTATION MARK       | 〝 |W|Ps|Tr| NA    | 1-13-64  | 7608  | 7956  | type1 |
| U+301E | DOUBLE PRIME QUOTATION MARK                | 〞 |W|Pe|Tr| NA    | NA       | 12170 |(12170)| type2 |
| U+301F | LOW DOUBLE PRIME QUOTATION MARK            | 〟 |W|Pe|Tr| NA    | 1-13-65  | 7609  | 7957  | type2 |
| U+FE59 | SMALL LEFT PARENTHESIS                     | ﹙ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5A | SMALL RIGHT PARENTHESIS                    | ﹚ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5B | SMALL LEFT CURLY BRACKET                   | ﹛ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5C | SMALL RIGHT CURLY BRACKET                  | ﹜ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5D | SMALL LEFT TORTOISE SHELL BRACKET          | ﹝ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5E | SMALL RIGHT TORTOISE SHELL BRACKET         | ﹞ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FF08 | FULLWIDTH LEFT PARENTHESIS                 | （ |F|Ps|Tr| 01-42*| 1-01-42* | 674   | 7899  | type1 |
| U+FF09 | FULLWIDTH RIGHT PARENTHESIS                | ） |F|Pe|Tr| 01-43*| 1-01-43* | 675   | 7900  | type2 |
| U+FF3B | FULLWIDTH LEFT SQUARE BRACKET              | ［ |F|Ps|Tr| 01-46*| 1-01-46* | 678   | 7903  | type1 |
| U+FF3D | FULLWIDTH RIGHT SQUARE BRACKET             | ］ |F|Pe|Tr| 01-47*| 1-01-47* | 679   | 7904  | type2 |
| U+FF5B | FULLWIDTH LEFT CURLY BRACKET               | ｛ |F|Ps|Tr| 01-48*| 1-01-48* | 680   | 7905  | type1 |
| U+FF5D | FULLWIDTH RIGHT CURLY BRACKET              | ｝ |F|Pe|Tr| 01-49*| 1-01-49* | 681   | 7906  | type2 |
| U+FF5F | FULLWIDTH LEFT WHITE PARENTHESIS           | ｟ |F|Ps|Tr| NA    | 1-02-54  | 12131 | 12141 | type1 |
| U+FF60 | FULLWIDTH RIGHT WHITE PARENTHESIS          | ｠ |F|Pe|Tr| NA    | 1-02-55  | 12132 | 12142 | type2 |
| U+FF62 | HALFWIDTH LEFT CORNER BRACKET              | ｢ |H|Ps|R |(半角カナ)|        | 328   | (328) | NA    |
| U+FF63 | HALFWIDTH RIGHT CORNER BRACKET             | ｣ |H|Pe|R |(半角カナ)|        | 329   | (329) | NA    |

* UniJIS-*-{H,V} は、UniJIS-UTF16-{H,V} を示す。UniJIS-UCS2-{H,V}では一部異なっている。
* UniJIS-*-V の "()"は、縦組みの設定が無くHの字形がフォールバックされることを示す。
* "width"は"East Asian Width"。N: Neutral (= Not East Asian), A: Ambiguos, W: Wide, Na: Narrow, F: Fullwidth, H: Halfwidth
* "gc"は"General Category Value"。Ps: Open_Punctuation, Pe: Close_Punctuation, Pi: Initial_Punctuation, Pf: Final_Punctuation
* "vo"は"Vertical Orientation Property"。R: Rotated 90 degrees clockwise compared to the code charts, Tr: Transformed typographically, with fallback to Rotated. "vo"がTrのものは"Table 4. Glyph Changes for Vertical Orientation"において縦組み字形が示されている。
* JIS X 0208, JIS X 0213の"*"は、広く実装されている「全角形」への対応関係であること示す。
* (U+201C, U+201D), (U+2018, U+2019)の各組は UniJIS-UCS2-{H,V}と UniJIS-UTF16-{H,V} に違いがあり、UCS2は和文用に、UTF16は欧文用に割り当てられている。
* U+301A, U+301Bの組は Unicodeの "CJK Symbols and Punctuation" ブロック内にある。CJK用を意図しているようだがどの規格に基づいているのか不明。
* U+2329, U+232Aの組は U+3008, U+3009の組とよく似ている。UniJIS-UTF16-{H,V} のCIDでは違いがない。違いが分からない。
* U+FE17, U+FE18, U+FE35..U+FE44, U+FE47, U+FE48に"PRESENTATION FORM FOR VERTICAL LEFT/RIGHT ... BRACKET"がある。それらを除くと、この表には `grep -E "[FWAH]\s+# P[ifse]" EastAsianWidth.txt` で検索される文字(Fullwidth, Wide, Ambiguos, Halfwidthの括弧類)が全て含まれている。 `grep -E "N.*\s+# P[ifse]" EastAsianWidth.txt` で検索される文字(Newtral, Narrowの括弧類)はこの表以外にまだ大量に存在する。
* U+301Eの縦組み字形は、"Table 4. Glyph Changes for Vertical Orientation"によるとU+301Fの縦組み字形と同じで良い。従ってCID7957を割り当てれば正しく組める。


|Unicode | name                                     |  |width|gc|vo| GB-EUC | GBK2K |UniGB-*-H| -V | upsch*.pl |
|--------|-------------------------------------------|:-:|:-:|:-:|:-:|-----|----------|:-----:|:-----:|:-----:|
| U+00AB | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK  | « |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+00BB | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK | » |N|Pf|R | NA     | NA       | NA    | NA    | NA    |
| U+2018 | LEFT SINGLE QUOTATION MARK                 | ‘ |A|Pi|R | a1ae  | a1ae     | 109   | (109) | type1 |
| U+2019 | RIGHT SINGLE QUOTATION MARK                | ’ |A|Pf|R | a1af  | a1af     | 110   | (110) | type2 |
| U+201A | SINGLE LOW-9 QUOTATION MARK                | ‚ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201B | SINGLE HIGH-REVERSED-9 QUOTATION MARK      | ‛ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+201C | LEFT DOUBLE QUOTATION MARK                 | “ |A|Pi|R | a1b0  | a1b0     | 111   | (111) | type1 |
| U+201D | RIGHT DOUBLE QUOTATION MARK                | ” |A|Pf|R | a1b1  | a1b1     | 112   | (112) | type2 |
| U+201E | DOUBLE LOW-9 QUOTATION MARK                | „ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201F | DOUBLE HIGH-REVERSED-9 QUOTATION MARK      | ‟ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+2039 | SINGLE LEFT-POINTING ANGLE QUOTATION MARK  | ‹ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+203A | SINGLE RIGHT-POINTING ANGLE QUOTATION MARK | › |N|Pf|R | NA     | NA       | NA    | NA    | NA    |
| U+2045 | LEFT SQUARE BRACKET WITH QUILL             | ⁅ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+2046 | RIGHT SQUARE BRACKET WITH QUILL            | ⁆ |N|Pe|R | NA     | NA       | NA    | NA    | NA    |
| U+2329 | LEFT-POINTING ANGLE BRACKET                | 〈  |W|Ps|Tr| NA    | NA       | 115   | (115) | type1 |
| U+232A | RIGHT-POINTING ANGLE BRACKET               | 〉  |W|Pe|Tr| NA    | NA       | 116   | (116) | type2 |
| U+3008 | LEFT ANGLE BRACKET                         | 〈 |W|Ps|Tr| a1b4  | a1b4     | 115   | 584   | type1 |
| U+3009 | RIGHT ANGLE BRACKET                        | 〉 |W|Pe|Tr| a1b5  | a1b5     | 116   | 585   | type2 |
| U+300A | LEFT DOUBLE ANGLE BRACKET                  | 《 |W|Ps|Tr| a1b6  | a1b6     | 117   | 586   | type1 |
| U+300B | RIGHT DOUBLE ANGLE BRACKET                 | 》 |W|Pe|Tr| a1b7  | a1b7     | 118   | 587   | type2 |
| U+300C | LEFT CORNER BRACKET                        | 「 |W|Ps|Tr| a1b8  | a1b8     | 119   | 588   | type1 |
| U+300D | RIGHT CORNER BRACKET                       | 」 |W|Pe|Tr| a1b9  | a1b9     | 120   | 589   | type2 |
| U+300E | LEFT WHITE CORNER BRACKET                  | 『 |W|Ps|Tr| a1c0  | a1c0     | 121   | 590   | type1 |
| U+300F | RIGHT WHITE CORNER BRACKET                 | 』 |W|Pe|Tr| a1c1  | a1c1     | 122   | 591   | type2 |
| U+3010 | LEFT BLACK LENTICULAR BRACKET              | 【 |W|Ps|Tr| a1c2  | a1c2     | 125   | 594   | type1 |
| U+3011 | RIGHT BLACK LENTICULAR BRACKET             | 】 |W|Pe|Tr| a1c3  | a1c3     | 126   | 595   | type2 |
| U+3014 | LEFT TORTOISE SHELL BRACKET                | 〔 |W|Ps|Tr| a1b2  | a1b2     | 113   | 582   | type1 |
| U+3015 | RIGHT TORTOISE SHELL BRACKET               | 〕 |W|Pe|Tr| a1b3  | a1b3     | 114   | 583   | type2 |
| U+3016 | LEFT WHITE LENTICULAR BRACKET              | 〖 |W|Ps|Tr| a1bc  | a1bc     | 123   | 592   | type1 |
| U+3017 | RIGHT WHITE LENTICULAR BRACKET             | 〗 |W|Pe|Tr| a1bd  | a1bd     | 124   | 593   | type2 |
| U+3018 | LEFT WHITE TORTOISE SHELL BRACKET          | 〘 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+3019 | RIGHT WHITE TORTOISE SHELL BRACKET         | 〙 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301A | LEFT WHITE SQUARE BRACKET                  | 〚 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+301B | RIGHT WHITE SQUARE BRACKET                 | 〛 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301D | REVERSED DOUBLE PRIME QUOTATION MARK       | 〝 |W|Ps|Tr| NA    | a894     | 9990  |(9990) | type1 |
| U+301E | DOUBLE PRIME QUOTATION MARK                | 〞 |W|Pe|Tr| NA    | a895     | 9991  |(9991) | type2 |
| U+301F | LOW DOUBLE PRIME QUOTATION MARK            | 〟 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+FE59 | SMALL LEFT PARENTHESIS                     | ﹙ |W|Ps|Tr| NA    | a976     | 10041  |(10041)| NA    |
| U+FE5A | SMALL RIGHT PARENTHESIS                    | ﹚ |W|Pe|Tr| NA    | a977     | 10042  |(10042)| NA    |
| U+FE5B | SMALL LEFT CURLY BRACKET                   | ﹛ |W|Ps|Tr| NA    | a978     | 10043  |(10043)| NA    |
| U+FE5C | SMALL RIGHT CURLY BRACKET                  | ﹜ |W|Pe|Tr| NA    | a979     | 10044  |(10044)| NA    |
| U+FE5D | SMALL LEFT TORTOISE SHELL BRACKET          | ﹝ |W|Ps|Tr| NA    | a97a     | 10045  |(10045)| NA    |
| U+FE5E | SMALL RIGHT TORTOISE SHELL BRACKET         | ﹞ |W|Pe|Tr| NA    | a97b     | 10046  |(10046)| NA    |
| U+FF08 | FULLWIDTH LEFT PARENTHESIS                 | （ |F|Ps|Tr| a3a8  | a3a8     | 269   | 580   | type1 |
| U+FF09 | FULLWIDTH RIGHT PARENTHESIS                | ） |F|Pe|Tr| a3a9  | a3a9     | 270   | 581   | type2 |
| U+FF3B | FULLWIDTH LEFT SQUARE BRACKET              | ［ |F|Ps|Tr| a3db  | a3db     | 320   | 7709  | type1 |
| U+FF3D | FULLWIDTH RIGHT SQUARE BRACKET             | ］ |F|Pe|Tr| a3dd  | a3dd     | 322   | 7710  | type2 |
| U+FF5B | FULLWIDTH LEFT CURLY BRACKET               | ｛ |F|Ps|Tr| a3fb  | a3fb     | 352   | 596   | type1 |
| U+FF5D | FULLWIDTH RIGHT CURLY BRACKET              | ｝ |F|Pe|Tr| a3fd  | a3fd     | 354   | 597   | type2 |
| U+FF5F | FULLWIDTH LEFT WHITE PARENTHESIS           | ｟ |F|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+FF60 | FULLWIDTH RIGHT WHITE PARENTHESIS          | ｠ |F|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+FF62 | HALFWIDTH LEFT CORNER BRACKET              | ｢ |H|Ps|R | NA    | NA       | NA    | NA    | NA    |
| U+FF63 | HALFWIDTH RIGHT CORNER BRACKET             | ｣ |H|Pe|R | NA    | NA       | NA    | NA    | NA    |

* U+FE59..U+FE5Eは CNS 互換で導入されたものらしい。
該当のグリフは、5080.Adobe-CNS1-6.pdfとUnicodeのUFE50.pdfでは仮想ボディの左右端に寄っているが 5079.Adobe-GB1-5.pdfでは仮想ボディの中央に位置している。
このためupsch*.plではtype1,type2に指定しないことにする。

|Unicode | name                                     |  |width|gc|vo| B5    | ETen-B5  |UniCNS-*-H| -V | uptch*.pl |
|--------|-------------------------------------------|:-:|:-:|:-:|:-:|-----|----------|:-----:|:-----:|:-----:|
| U+00AB | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK  | « |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+00BB | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK | » |N|Pf|R | NA     | NA       | NA    | NA    | NA    |
| U+2018 | LEFT SINGLE QUOTATION MARK                 | ‘ |A|Pi|R | a1a5  | a1a5     | 166   | (166) | type1 |
| U+2019 | RIGHT SINGLE QUOTATION MARK                | ’ |A|Pf|R | a1a6  | a1a6     | 167   | (167) | type2 |
| U+201A | SINGLE LOW-9 QUOTATION MARK                | ‚ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201B | SINGLE HIGH-REVERSED-9 QUOTATION MARK      | ‛ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+201C | LEFT DOUBLE QUOTATION MARK                 | “ |A|Pi|R | a1a7  | a1a7     | 168   | (168) | type1 |
| U+201D | RIGHT DOUBLE QUOTATION MARK                | ” |A|Pf|R | a1a8  | a1a8     | 169   | (169) | type2 |
| U+201E | DOUBLE LOW-9 QUOTATION MARK                | „ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201F | DOUBLE HIGH-REVERSED-9 QUOTATION MARK      | ‟ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+2039 | SINGLE LEFT-POINTING ANGLE QUOTATION MARK  | ‹ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+203A | SINGLE RIGHT-POINTING ANGLE QUOTATION MARK | › |N|Pf|R | NA     | NA       | NA    | NA    | NA    |
| U+2045 | LEFT SQUARE BRACKET WITH QUILL             | ⁅ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+2046 | RIGHT SQUARE BRACKET WITH QUILL            | ⁆ |N|Pe|R | NA     | NA       | NA    | NA    | NA    |
| U+2329 | LEFT-POINTING ANGLE BRACKET                | 〈  |W|Ps|Tr| NA    | NA       | 148   | (148) | type1 |
| U+232A | RIGHT-POINTING ANGLE BRACKET               | 〉  |W|Pe|Tr| NA    | NA       | 149   | (148) | type2 |
| U+3008 | LEFT ANGLE BRACKET                         | 〈 |W|Ps|Tr| a171  | a171     | 148   | 150   | type1 |
| U+3009 | RIGHT ANGLE BRACKET                        | 〉 |W|Pe|Tr| a172  | a172     | 149   | 151   | type2 |
| U+300A | LEFT DOUBLE ANGLE BRACKET                  | 《 |W|Ps|Tr| a16d  | a16d     | 144   | 146   | type1 |
| U+300B | RIGHT DOUBLE ANGLE BRACKET                 | 》 |W|Pe|Tr| a16e  | a16e     | 145   | 147   | type2 |
| U+300C | LEFT CORNER BRACKET                        | 「 |W|Ps|Tr| a175  | a175     | 152   | 154   | type1 |
| U+300D | RIGHT CORNER BRACKET                       | 」 |W|Pe|Tr| a176  | a176     | 153   | 155   | type2 |
| U+300E | LEFT WHITE CORNER BRACKET                  | 『 |W|Ps|Tr| a179  | a179     | 156   | 158   | type1 |
| U+300F | RIGHT WHITE CORNER BRACKET                 | 』 |W|Pe|Tr| a17a  | a17a     | 157   | 159   | type2 |
| U+3010 | LEFT BLACK LENTICULAR BRACKET              | 【 |W|Ps|Tr| a169  | a169     | 140   | 142   | type1 |
| U+3011 | RIGHT BLACK LENTICULAR BRACKET             | 】 |W|Pe|Tr| a16a  | a16a     | 141   | 143   | type2 |
| U+3014 | LEFT TORTOISE SHELL BRACKET                | 〔 |W|Ps|Tr| a165  | a165     | 136   | 138   | type1 |
| U+3015 | RIGHT TORTOISE SHELL BRACKET               | 〕 |W|Pe|Tr| a166  | a166     | 137   | 139   | type2 |
| U+3016 | LEFT WHITE LENTICULAR BRACKET              | 〖 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+3017 | RIGHT WHITE LENTICULAR BRACKET             | 〗 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+3018 | LEFT WHITE TORTOISE SHELL BRACKET          | 〘 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+3019 | RIGHT WHITE TORTOISE SHELL BRACKET         | 〙 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301A | LEFT WHITE SQUARE BRACKET                  | 〚 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+301B | RIGHT WHITE SQUARE BRACKET                 | 〛 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301D | REVERSED DOUBLE PRIME QUOTATION MARK       | 〝 |W|Ps|Tr| a1a9  | a1a9     | 170   |(170)  | type1 |
| U+301E | DOUBLE PRIME QUOTATION MARK                | 〞 |W|Pe|Tr| a1aa  | a1aa     | 171   |(171)  | type2 |
| U+301F | LOW DOUBLE PRIME QUOTATION MARK            | 〟 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+FE59 | SMALL LEFT PARENTHESIS                     | ﹙ |W|Ps|Tr| a17d    | a17d     | 160    |(160)  | type1 |
| U+FE5A | SMALL RIGHT PARENTHESIS                    | ﹚ |W|Pe|Tr| a17e    | a17e     | 161    |(161)  | type2 |
| U+FE5B | SMALL LEFT CURLY BRACKET                   | ﹛ |W|Ps|Tr| a1a1    | a1a1     | 162    |(162)  | type1 |
| U+FE5C | SMALL RIGHT CURLY BRACKET                  | ﹜ |W|Pe|Tr| a1a2    | a1a2     | 163    |(163)  | type2 |
| U+FE5D | SMALL LEFT TORTOISE SHELL BRACKET          | ﹝ |W|Ps|Tr| a1a3    | a1a3     | 164    |(164)  | type1 |
| U+FE5E | SMALL RIGHT TORTOISE SHELL BRACKET         | ﹞ |W|Pe|Tr| a1a4    | a1a4     | 165    |(165)  | type2 |
| U+FF08 | FULLWIDTH LEFT PARENTHESIS                 | （ |F|Ps|Tr| a15d  | a15d     | 128   | 130   | type1 |
| U+FF09 | FULLWIDTH RIGHT PARENTHESIS                | ） |F|Pe|Tr| a15e  | a15e     | 129   | 131   | type2 |
| U+FF3B | FULLWIDTH LEFT SQUARE BRACKET              | ［ |F|Ps|Tr| NA    | c6e4     | 13758 |(13758)| type1 |
| U+FF3D | FULLWIDTH RIGHT SQUARE BRACKET             | ］ |F|Pe|Tr| NA    | c6e5     | 13759 |(13759)| type2 |
| U+FF5B | FULLWIDTH LEFT CURLY BRACKET               | ｛ |F|Ps|Tr| a161  | a161     | 132   | 134   | type1 |
| U+FF5D | FULLWIDTH RIGHT CURLY BRACKET              | ｝ |F|Pe|Tr| a162  | a162     | 133   | 135   | type2 |
| U+FF5F | FULLWIDTH LEFT WHITE PARENTHESIS           | ｟ |F|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+FF60 | FULLWIDTH RIGHT WHITE PARENTHESIS          | ｠ |F|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+FF62 | HALFWIDTH LEFT CORNER BRACKET              | ｢ |H|Ps|R | NA    | NA       | NA    | NA    | NA    |
| U+FF63 | HALFWIDTH RIGHT CORNER BRACKET             | ｣ |H|Pe|R | NA    | NA       | NA    | NA    | NA    |


|Unicode | name                                     |  |width|gc|vo| KSC-EUC | KSCpc-EUC |UniKS-*-H| -V | upkor*.pl |
|--------|-------------------------------------------|:-:|:-:|:-:|:-:|-----|----------|:-----:|:-----:|:-----:|
| U+00AB | LEFT-POINTING DOUBLE ANGLE QUOTATION MARK  | « |N|Pi|R | a1ec   | a1ec     | 176   | (176) | NA    |
| U+00BB | RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK | » |N|Pf|R | a1ed   | a1ed     | 177   | (177) | NA    |
| U+2018 | LEFT SINGLE QUOTATION MARK                 | ‘ |A|Pi|R | a1ae  | a1ae     | 114   | (114) | type1 |
| U+2019 | RIGHT SINGLE QUOTATION MARK                | ’ |A|Pf|R | a1af  | a1af     | 115   | (115) | type2 |
| U+201A | SINGLE LOW-9 QUOTATION MARK                | ‚ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201B | SINGLE HIGH-REVERSED-9 QUOTATION MARK      | ‛ |N|Pi|R | NA     | a170     | 8238  |(8238) | NA    |
| U+201C | LEFT DOUBLE QUOTATION MARK                 | “ |A|Pi|R | a1b0  | a1b0     | 116   | (116) | type1 |
| U+201D | RIGHT DOUBLE QUOTATION MARK                | ” |A|Pf|R | a1b1  | a1b1     | 117   | (117) | type2 |
| U+201E | DOUBLE LOW-9 QUOTATION MARK                | „ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+201F | DOUBLE HIGH-REVERSED-9 QUOTATION MARK      | ‟ |N|Pi|R | NA     | a16f     | 8237  |(8237) | NA    |
| U+2039 | SINGLE LEFT-POINTING ANGLE QUOTATION MARK  | ‹ |N|Pi|R | NA     | NA       | NA    | NA    | NA    |
| U+203A | SINGLE RIGHT-POINTING ANGLE QUOTATION MARK | › |N|Pf|R | NA     | NA       | NA    | NA    | NA    |
| U+2045 | LEFT SQUARE BRACKET WITH QUILL             | ⁅ |N|Ps|R | NA     | NA       | NA    | NA    | NA    |
| U+2046 | RIGHT SQUARE BRACKET WITH QUILL            | ⁆ |N|Pe|R | NA     | NA       | NA    | NA    | NA    |
| U+2329 | LEFT-POINTING ANGLE BRACKET                | 〈  |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+232A | RIGHT-POINTING ANGLE BRACKET               | 〉  |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+3008 | LEFT ANGLE BRACKET                         | 〈 |W|Ps|Tr| a1b4  | a1b4     | 120   | 8065  | type1 |
| U+3009 | RIGHT ANGLE BRACKET                        | 〉 |W|Pe|Tr| a1b5  | a1b5     | 121   | 8066  | type2 |
| U+300A | LEFT DOUBLE ANGLE BRACKET                  | 《 |W|Ps|Tr| a1b6  | a1b6     | 122   | 8067  | type1 |
| U+300B | RIGHT DOUBLE ANGLE BRACKET                 | 》 |W|Pe|Tr| a1b7  | a1b7     | 123   | 8068  | type2 |
| U+300C | LEFT CORNER BRACKET                        | 「 |W|Ps|Tr| a1b8  | a1b8     | 124   | 8069  | type1 |
| U+300D | RIGHT CORNER BRACKET                       | 」 |W|Pe|Tr| a1b9  | a1b9     | 125   | 8070  | type2 |
| U+300E | LEFT WHITE CORNER BRACKET                  | 『 |W|Ps|Tr| a1ba  | a1ba     | 126   | 8071  | type1 |
| U+300F | RIGHT WHITE CORNER BRACKET                 | 』 |W|Pe|Tr| a1bb  | a1bb     | 127   | 8072  | type2 |
| U+3010 | LEFT BLACK LENTICULAR BRACKET              | 【 |W|Ps|Tr| a1bc  | a1bc     | 128   | 8073  | type1 |
| U+3011 | RIGHT BLACK LENTICULAR BRACKET             | 】 |W|Pe|Tr| a1bd  | a1bd     | 129   | 8074  | type2 |
| U+3014 | LEFT TORTOISE SHELL BRACKET                | 〔 |W|Ps|Tr| a1b2  | a1b2     | 118   | 8063  | type1 |
| U+3015 | RIGHT TORTOISE SHELL BRACKET               | 〕 |W|Pe|Tr| a1b3  | a1b3     | 119   | 8064  | type2 |
| U+3016 | LEFT WHITE LENTICULAR BRACKET              | 〖 |W|Ps|Tr| NA    | a15d     | 8219  |(8219) | type1 |
| U+3017 | RIGHT WHITE LENTICULAR BRACKET             | 〗 |W|Pe|Tr| NA    | a15e     | 8220  |(8220) | type2 |
| U+3018 | LEFT WHITE TORTOISE SHELL BRACKET          | 〘 |W|Ps|Tr| NA    | a15f     | 8221  |(8221) | type1 |
| U+3019 | RIGHT WHITE TORTOISE SHELL BRACKET         | 〙 |W|Pe|Tr| NA    | a160     | 8222  |(8222) | type2 |
| U+301A | LEFT WHITE SQUARE BRACKET                  | 〚 |W|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+301B | RIGHT WHITE SQUARE BRACKET                 | 〛 |W|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+301D | REVERSED DOUBLE PRIME QUOTATION MARK       | 〝 |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+301E | DOUBLE PRIME QUOTATION MARK                | 〞 |W|Pe|Tr| NA    | ada9     | 9322  |(9322) | NA    |
| U+301F | LOW DOUBLE PRIME QUOTATION MARK            | 〟 |W|Pe|Tr| NA    | adaa     | 9323  |(9323) | NA    |
| U+FE59 | SMALL LEFT PARENTHESIS                     | ﹙ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5A | SMALL RIGHT PARENTHESIS                    | ﹚ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5B | SMALL LEFT CURLY BRACKET                   | ﹛ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5C | SMALL RIGHT CURLY BRACKET                  | ﹜ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5D | SMALL LEFT TORTOISE SHELL BRACKET          | ﹝ |W|Ps|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FE5E | SMALL RIGHT TORTOISE SHELL BRACKET         | ﹞ |W|Pe|Tr| NA    | NA       | NA    | NA    | NA    |
| U+FF08 | FULLWIDTH LEFT PARENTHESIS                 | （ |F|Ps|Tr| a3a8  | a3a8     | 271   | 8077  | type1 |
| U+FF09 | FULLWIDTH RIGHT PARENTHESIS                | ） |F|Pe|Tr| a3a9  | a3a9     | 272   | 8078  | type2 |
| U+FF3B | FULLWIDTH LEFT SQUARE BRACKET              | ［ |F|Ps|Tr| a3db  | a3db     | 322   | 8087  | type1 |
| U+FF3D | FULLWIDTH RIGHT SQUARE BRACKET             | ］ |F|Pe|Tr| a3dd  | a3dd     | 324   | 8088  | type2 |
| U+FF5B | FULLWIDTH LEFT CURLY BRACKET               | ｛ |F|Ps|Tr| a3fb  | a3fb     | 354   | 8090  | type1 |
| U+FF5D | FULLWIDTH RIGHT CURLY BRACKET              | ｝ |F|Pe|Tr| a3fd  | a3fd     | 356   | 8092  | type2 |
| U+FF5F | FULLWIDTH LEFT WHITE PARENTHESIS           | ｟ |F|Ps|Tr| NA    | NA       | NA    | NA    | type1 |
| U+FF60 | FULLWIDTH RIGHT WHITE PARENTHESIS          | ｠ |F|Pe|Tr| NA    | NA       | NA    | NA    | type2 |
| U+FF62 | HALFWIDTH LEFT CORNER BRACKET              | ｢ |H|Ps|R | NA    | NA       | NA    | NA    | NA    |
| U+FF63 | HALFWIDTH RIGHT CORNER BRACKET             | ｣ |H|Pe|R | NA    | NA       | NA    | NA    | NA    |

* KSCms-UHCは、この表の範囲においてKSC-EUCと同じ。KSCpc-EUCは、"MacOS-KH character set"
* 5093.Adobe-Korea1-2.pdf によると、CID176, CID177の組はU+226A, U+226Bの組(≪,≫, 数学記号)のように見える。
括弧類として扱うのは不適切と思われる。
* Adobe-Korea1 では CID9322が U+301E, CID9323が U+301F ということになっているが、CID9322がopen, CID9323がcloseのように見える。
Unicodeの"General Category Value"との対応関係がしっくりこない。
U+301E(CID9322)をtype1(Ps相当), U+301F(CID9323)をtype2(Pe相当)とすれば、Adobe-Korea1に対してはそれっぽく組めそうだが場当たり感が否めない。
その上これらはUHCのようなメジャーなレガシーエンコーディングには含まれていない。
* U+201Bをtype1(Pi)とすると、U+201B(CID8238), U+2019(CID115)の組でそれっぽく組めそう。
しかし、通常これらは利用されずU+2018(CID114), U+2019(CID115)の組が使われると思われる。
* U+201Fをtype1(Pi)とすると、U+201F(CID8237), U+201D(CID117)の組でそれっぽく組めそう。
しかし、通常これらは利用されずU+201C(CID116), U+201D(CID117)の組が使われると思われる。

