/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.widgets.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rBE\b\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J<\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001c\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u001f\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140 2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u001f\u0010'\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b(J(\u0010)\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/github/ajalt/mordant/widgets/Text;", "Lcom/github/ajalt/mordant/rendering/Widget;", "text", "", "whitespace", "Lcom/github/ajalt/mordant/rendering/Whitespace;", "align", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "overflowWrap", "Lcom/github/ajalt/mordant/rendering/OverflowWrap;", "width", "", "tabWidth", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "(Lcom/github/ajalt/mordant/rendering/Lines;Lcom/github/ajalt/mordant/rendering/Whitespace;Lcom/github/ajalt/mordant/rendering/TextAlign;Lcom/github/ajalt/mordant/rendering/OverflowWrap;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "alignLine", "", "Lcom/github/ajalt/mordant/rendering/Span;", "line", "wrapWidth", "endStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "alignLineCenter", "", "extraWidth", "alignLineLeft", "alignLineRight", "justifyLine", "lastNonWhitespace", "", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "render", "toString", "withAlign", "withAlign$mordant", "wrap", "mordant"})
public final class Text
implements Widget {
    @NotNull
    private final Lines lines;
    @NotNull
    private final Whitespace whitespace;
    @NotNull
    private final TextAlign align;
    @NotNull
    private final OverflowWrap overflowWrap;
    @Nullable
    private final Integer width;
    @Nullable
    private final Integer tabWidth;

    public Text(@NotNull Lines lines, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this.lines = lines;
        this.whitespace = whitespace2;
        this.align = align;
        this.overflowWrap = overflowWrap2;
        this.width = width;
        this.tabWidth = tabWidth;
        if (!(this.width == null || this.width >= 0)) {
            boolean $i$a$-require-Text$32 = false;
            String $i$a$-require-Text$32 = "width cannot be negative";
            throw new IllegalArgumentException($i$a$-require-Text$32.toString());
        }
        if (!(this.tabWidth == null || this.tabWidth >= 0)) {
            boolean bl = false;
            String string = "tab width cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Text(Lines lines, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(lines, whitespace2, textAlign2, overflowWrap2, n, n2);
    }

    public Text(@NotNull String text, @NotNull Whitespace whitespace2, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width, @Nullable Integer tabWidth) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter((Object)whitespace2, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        this(ParsingKt.parseText(text, ConstantsKt.getDEFAULT_STYLE()), whitespace2, align, overflowWrap2, width, tabWidth);
    }

    public /* synthetic */ Text(String string, Whitespace whitespace2, TextAlign textAlign2, OverflowWrap overflowWrap2, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            whitespace2 = Whitespace.PRE;
        }
        if ((n3 & 4) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n3 & 8) != 0) {
            overflowWrap2 = OverflowWrap.NORMAL;
        }
        if ((n3 & 0x10) != 0) {
            n = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(string, whitespace2, textAlign2, overflowWrap2, n, n2);
    }

    @NotNull
    public final Text withAlign$mordant(@NotNull TextAlign align, @Nullable OverflowWrap overflowWrap2) {
        Text text;
        Intrinsics.checkNotNullParameter((Object)align, "align");
        if (align == this.align && (overflowWrap2 == null || overflowWrap2 == this.overflowWrap)) {
            text = this;
        } else {
            OverflowWrap overflowWrap3 = overflowWrap2;
            if (overflowWrap3 == null) {
                overflowWrap3 = this.overflowWrap;
            }
            text = new Text(this.lines, this.whitespace, align, overflowWrap3, this.width, this.tabWidth);
        }
        return text;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        int n;
        Iterator iterator2;
        Iterator iterator3;
        Intrinsics.checkNotNullParameter(t, "t");
        Integer n2 = this.width;
        Integer n3 = this.tabWidth;
        Lines lines = this.wrap(n2 != null ? n2 : width, n3 != null ? n3.intValue() : t.getTabWidth(), TextAlign.NONE, OverflowWrap.NORMAL);
        Iterator iterator4 = ((Iterable)lines.getLines()).iterator();
        if (!iterator4.hasNext()) {
            iterator3 = null;
        } else {
            Line l = (Line)iterator4.next();
            boolean bl = false;
            Iterable iterable = l;
            int n4 = 0;
            for (Object object : iterable) {
                Object it;
                Span span = (Span)object;
                int n5 = n4;
                boolean bl2 = false;
                int n6 = ((Span)it).getCellWidth$mordant();
                n4 = n5 + n6;
            }
            iterator2 = n4;
            while (iterator4.hasNext()) {
                Object l2 = (Line)iterator4.next();
                $i$a$-maxOfOrNull-Text$measure$max$1 = false;
                Iterable iterable2 = (Iterable)l2;
                int n7 = 0;
                for (Object it : iterable2) {
                    void it2;
                    Span span = (Span)it;
                    int n8 = n7;
                    boolean bl3 = false;
                    int n9 = it2.getCellWidth$mordant();
                    n7 = n8 + n9;
                }
                l2 = n7;
                if (iterator2.compareTo(l2) >= 0) continue;
                iterator2 = l2;
            }
            iterator3 = iterator2;
        }
        Integer n10 = (Integer)((Object)iterator3);
        int max = n10 != null ? n10 : 0;
        if (this.whitespace.getWrap()) {
            Comparable comparable;
            iterator2 = ((Iterable)lines.getLines()).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                Iterator<Object> iterator5;
                Iterator<Object> iterator6;
                Line l = (Line)iterator2.next();
                boolean bl = false;
                Iterator iterator7 = ((Iterable)l).iterator();
                if (!iterator7.hasNext()) {
                    iterator6 = null;
                } else {
                    Span it = (Span)iterator7.next();
                    boolean bl4 = false;
                    iterator5 = it.getCellWidth$mordant();
                    while (iterator7.hasNext()) {
                        Object it3 = (Span)iterator7.next();
                        $i$a$-maxOfOrNull-Text$measure$min$1$1 = false;
                        if (iterator5.compareTo((Object)(it3 = (Comparable)Integer.valueOf(((Span)it3).getCellWidth$mordant()))) >= 0) continue;
                        iterator5 = it3;
                    }
                    iterator6 = iterator5;
                }
                Integer n11 = (Integer)((Object)iterator6);
                Comparable comparable2 = Integer.valueOf(n11 != null ? n11 : 0);
                while (iterator2.hasNext()) {
                    Comparable comparable3;
                    Line l3 = (Line)iterator2.next();
                    $i$a$-maxOfOrNull-Text$measure$min$1 = false;
                    iterator5 = ((Iterable)l3).iterator();
                    if (!iterator5.hasNext()) {
                        comparable3 = null;
                    } else {
                        Span it = (Span)iterator5.next();
                        boolean bl5 = false;
                        Comparable comparable4 = Integer.valueOf(it.getCellWidth$mordant());
                        while (iterator5.hasNext()) {
                            Span it4 = (Span)iterator5.next();
                            $i$a$-maxOfOrNull-Text$measure$min$1$1 = false;
                            Comparable comparable5 = Integer.valueOf(it4.getCellWidth$mordant());
                            if (comparable4.compareTo(comparable5) >= 0) continue;
                            comparable4 = comparable5;
                        }
                        comparable3 = comparable4;
                    }
                    Integer n12 = (Integer)comparable3;
                    Comparable comparable6 = Integer.valueOf(n12 != null ? n12 : 0);
                    if (comparable2.compareTo(comparable6) >= 0) continue;
                    comparable2 = comparable6;
                }
                comparable = comparable2;
            }
            Integer n13 = (Integer)comparable;
            n = n13 != null ? n13 : 0;
        } else {
            n = max;
        }
        int min = n;
        return new WidthRange(min, max);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        Integer n = this.width;
        Integer n2 = this.tabWidth;
        return this.wrap(n != null ? n : width, n2 != null ? n2.intValue() : t.getTabWidth(), this.align, this.overflowWrap);
    }

    private final Lines wrap(int wrapWidth, int tabWidth, TextAlign align, OverflowWrap overflowWrap2) {
        if (wrapWidth <= 0 && overflowWrap2 != OverflowWrap.NORMAL) {
            return ConstantsKt.getEMPTY_LINES();
        }
        List lines = new ArrayList();
        Ref.ObjectRef<List<Span>> line = new Ref.ObjectRef<List<Span>>();
        line.element = new ArrayList();
        Ref.ObjectRef<TextStyle> endStyle = new Ref.ObjectRef<TextStyle>();
        endStyle.element = ConstantsKt.getDEFAULT_STYLE();
        Ref.IntRef width = new Ref.IntRef();
        Ref.BooleanRef lastPieceWasWhitespace = new Ref.BooleanRef();
        lastPieceWasWhitespace.element = true;
        for (Line oldLine : this.lines.getLines()) {
            int lastNonWhitespace = this.lastNonWhitespace(oldLine, align);
            endStyle.element = oldLine.getEndStyle();
            Iterator<Span> iterator2 = oldLine.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Span span;
                boolean pieceIsWhitespace;
                int i = n++;
                Span piece = iterator2.next();
                if (Intrinsics.areEqual(piece.getText(), "\u0085") || Intrinsics.areEqual(piece.getText(), "\u2028")) {
                    Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
                    continue;
                }
                if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                    if (0 <= lastNonWhitespace ? lastNonWhitespace < i : false) continue;
                }
                if (i == 0 && !lastPieceWasWhitespace.element) {
                    Span span2 = (Span)CollectionsKt.firstOrNull(oldLine);
                    TextStyle style = Intrinsics.areEqual(((Span)CollectionsKt.last((List)line.element)).getStyle(), span2 != null ? span2.getStyle() : null) ? ((Span)CollectionsKt.last((List)line.element)).getStyle() : ConstantsKt.getDEFAULT_STYLE();
                    ((List)line.element).add(Span.Companion.word(" ", style));
                    lastPieceWasWhitespace.element = true;
                    ++width.element;
                }
                if ((pieceIsWhitespace = piece.isWhitespace$mordant()) && lastPieceWasWhitespace.element && this.whitespace.getCollapseSpaces()) continue;
                Span span3 = null;
                if (pieceIsWhitespace && this.whitespace.getCollapseSpaces()) {
                    span = Span.Companion.space(1, piece.getStyle());
                } else if (piece.isTab$mordant()) {
                    if (tabWidth <= 0) continue;
                    span = Span.Companion.space(tabWidth - width.element % tabWidth, piece.getStyle());
                } else {
                    span = piece;
                }
                span3 = span;
                int cellWidth2 = span3.getCellWidth$mordant();
                if (this.whitespace.getWrap() && width.element > 0 && width.element + cellWidth2 > wrapWidth) {
                    Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
                    if (pieceIsWhitespace) continue;
                }
                if (cellWidth2 > wrapWidth) {
                    switch (WhenMappings.$EnumSwitchMapping$0[overflowWrap2.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            span3 = Span.Companion.word(StringsKt.take(span3.getText(), wrapWidth), span3.getStyle());
                            break;
                        }
                        case 3: {
                            span3 = Span.Companion.word(StringsKt.take(span3.getText(), wrapWidth - 1) + '\u2026', span3.getStyle());
                            break;
                        }
                        case 4: {
                            Iterable $this$forEach$iv = StringsKt.chunked(span3.getText(), wrapWidth);
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                if (it.length() == wrapWidth) {
                                    ((Collection)lines).add(new Line(CollectionsKt.listOf(Span.Companion.word(it, span3.getStyle()))));
                                    continue;
                                }
                                span3 = Span.Companion.word(it, span3.getStyle());
                            }
                            break;
                        }
                    }
                }
                width.element += span3.getCellWidth$mordant();
                ((List)line.element).add(span3);
                lastPieceWasWhitespace.element = pieceIsWhitespace;
            }
            if (this.whitespace.getCollapseNewlines()) continue;
            Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
        }
        if (!((Collection)line.element).isEmpty()) {
            Text.wrap$breakLine(this, align, line, width, wrapWidth, endStyle, lines, lastPieceWasWhitespace);
        }
        return new Lines(lines);
    }

    private final int lastNonWhitespace(List<Span> line, TextAlign align) {
        int n;
        block3: {
            if (this.whitespace.getTrimEol() || align == TextAlign.JUSTIFY) {
                List<Span> $this$indexOfLast$iv = line;
                boolean $i$f$indexOfLast = false;
                ListIterator<Span> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Span it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(!it.isWhitespace$mordant())) continue;
                    n = iterator$iv.nextIndex();
                    break block3;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    private final List<Span> alignLine(List<Span> line, int wrapWidth, int width, TextAlign align, TextStyle endStyle) {
        int extraWidth = wrapWidth - width;
        switch (WhenMappings.$EnumSwitchMapping$1[align.ordinal()]) {
            case 1: {
                this.alignLineLeft(line, extraWidth, endStyle);
                break;
            }
            case 2: {
                this.alignLineRight(line, extraWidth, endStyle);
                break;
            }
            case 3: {
                this.alignLineCenter(line, extraWidth, endStyle);
                break;
            }
            case 4: {
                return this.justifyLine(line, extraWidth, endStyle);
            }
        }
        return line;
    }

    private final void alignLineLeft(List<Span> line, int extraWidth, TextStyle endStyle) {
        Object object = CollectionsKt.lastOrNull(line);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = endStyle;
        }
        line.add(Span.Companion.space(extraWidth, (TextStyle)object));
    }

    private final void alignLineRight(List<Span> line, int extraWidth, TextStyle endStyle) {
        Object object = CollectionsKt.firstOrNull(line);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = endStyle;
        }
        line.add(0, Span.Companion.space(extraWidth, (TextStyle)object));
    }

    private final void alignLineCenter(List<Span> line, int extraWidth, TextStyle endStyle) {
        int halfExtra = extraWidth / 2;
        this.alignLineLeft(line, halfExtra + extraWidth % 2, endStyle);
        if (halfExtra > 0) {
            this.alignLineRight(line, halfExtra, endStyle);
        }
    }

    private final List<Span> justifyLine(List<Span> line, int extraWidth, TextStyle endStyle) {
        int spaceCount;
        int n;
        Iterable $this$count$iv = line;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Span it = (Span)element$iv;
                boolean bl = false;
                if (!it.isWhitespace$mordant() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = spaceCount = count$iv;
        }
        if (spaceCount == 0) {
            this.alignLineCenter(line, extraWidth, endStyle);
            return line;
        }
        int spaceSize = extraWidth / spaceCount;
        int skipRemainder = spaceCount - extraWidth % spaceCount;
        ArrayList justifiedLine = new ArrayList(line.size() + skipRemainder + (spaceSize > 0 ? spaceCount : 0));
        for (Span span : line) {
            ((Collection)justifiedLine).add(span);
            if (!span.isWhitespace$mordant() || skipRemainder-- > 0 && spaceSize == 0) continue;
            ((Collection)justifiedLine).add(Span.Companion.space(spaceSize + (skipRemainder < 0 ? 1 : 0), span.getStyle()));
        }
        return justifiedLine;
    }

    @NotNull
    public String toString() {
        String plain2 = CollectionsKt.joinToString$default(CollectionsKt.flatten((Iterable)this.lines.getLines()), "", null, null, 0, null, toString.plain.1.INSTANCE, 30, null);
        return "Text(" + StringsKt.take(plain2, 25) + (plain2.length() > 25 ? "\u2026" : "") + ')';
    }

    private static final void wrap$breakLine(Text this$0, TextAlign $align, Ref.ObjectRef<List<Span>> line, Ref.IntRef width, int $wrapWidth, Ref.ObjectRef<TextStyle> endStyle, List<Line> lines, Ref.BooleanRef lastPieceWasWhitespace) {
        int lastNonWhitespace;
        if ((this$0.whitespace.getTrimEol() || $align == TextAlign.JUSTIFY) && (lastNonWhitespace = this$0.lastNonWhitespace((List)line.element, $align)) >= 0) {
            int n = CollectionsKt.getLastIndex((List)line.element) - lastNonWhitespace;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                ((List)line.element).remove(CollectionsKt.getLastIndex((List)line.element));
            }
        }
        if (width.element < $wrapWidth) {
            line.element = this$0.alignLine((List)line.element, $wrapWidth, width.element, $align, (TextStyle)endStyle.element);
        }
        Collection collection = lines;
        List list = (List)line.element;
        Object object = (Span)CollectionsKt.lastOrNull((List)line.element);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = (TextStyle)endStyle.element;
        }
        collection.add(new Line(list, (TextStyle)object));
        line.element = new ArrayList();
        width.element = 0;
        lastPieceWasWhitespace.element = true;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OverflowWrap.values().length];
            try {
                nArray[OverflowWrap.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.TRUNCATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.ELLIPSES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverflowWrap.BREAK_WORD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.JUSTIFY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.NONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

