/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  4 13:50:24 EST 2014 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_r2cb.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -name r2cb_64 -include r2cb.h */

/*
 * This function contains 394 FP additions, 216 FP multiplications,
 * (or, 178 additions, 0 multiplications, 216 fused multiply/add),
 * 143 stack variables, 18 constants, and 128 memory accesses
 */
#include "r2cb.h"

static void r2cb_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ovs, R1 = R1 + ovs, Cr = Cr + ivs, Ci = Ci + ivs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E T3d, T32, T37, T2Z, T3f, T3b, T3c, T35;
	       {
		    E T5H, T9, T5j, T4p, T2T, T1b, T3Z, T3j, Tg, T5I, T5k, T4u, T40, T3m, T2U;
		    E T1m, T3o, T1s, T1J, T3r, T5K, Tw, T5N, T6c, T4A, T5n, T3s, T1D, T5m, T4F;
		    E T3p, T1M, T3w, T1U, T2z, T3H, T5Q, TM, T6f, T5Y, T5q, T4M, T3I, T25, T5t;
		    E T53, T3x, T2C, T3A, T5V, T11, T6g, T5T, T55, T4W, T3z, T2E, T2h, T2F, T2s;
		    E T3L, T3E, T54, T4R;
		    {
			 E Td, T1c, Tc, T4r, T1k, Te, T1d, T1e;
			 {
			      E T3h, T15, T1a, T3i;
			      {
				   E T4, T14, T17, T13, T3, T16, T8, T18;
				   T4 = Cr[WS(csr, 16)];
				   T14 = Ci[WS(csi, 16)];
				   {
					E T1, T2, T6, T7;
					T1 = Cr[0];
					T2 = Cr[WS(csr, 32)];
					T6 = Cr[WS(csr, 8)];
					T7 = Cr[WS(csr, 24)];
					T17 = Ci[WS(csi, 8)];
					T13 = T1 - T2;
					T3 = T1 + T2;
					T16 = T6 - T7;
					T8 = T6 + T7;
					T18 = Ci[WS(csi, 24)];
				   }
				   {
					E T4n, T5, T4o, T19;
					T4n = FNMS(KP2_000000000, T4, T3);
					T5 = FMA(KP2_000000000, T4, T3);
					T3h = FMA(KP2_000000000, T14, T13);
					T15 = FNMS(KP2_000000000, T14, T13);
					T4o = T17 - T18;
					T19 = T17 + T18;
					T5H = FNMS(KP2_000000000, T8, T5);
					T9 = FMA(KP2_000000000, T8, T5);
					T5j = FMA(KP2_000000000, T4o, T4n);
					T4p = FNMS(KP2_000000000, T4o, T4n);
					T1a = T16 - T19;
					T3i = T16 + T19;
				   }
			      }
			      {
				   E Ta, Tb, T1i, T1j;
				   Ta = Cr[WS(csr, 4)];
				   T2T = FNMS(KP1_414213562, T1a, T15);
				   T1b = FMA(KP1_414213562, T1a, T15);
				   T3Z = FMA(KP1_414213562, T3i, T3h);
				   T3j = FNMS(KP1_414213562, T3i, T3h);
				   Tb = Cr[WS(csr, 28)];
				   T1i = Ci[WS(csi, 4)];
				   T1j = Ci[WS(csi, 28)];
				   Td = Cr[WS(csr, 20)];
				   T1c = Ta - Tb;
				   Tc = Ta + Tb;
				   T4r = T1i - T1j;
				   T1k = T1i + T1j;
				   Te = Cr[WS(csr, 12)];
				   T1d = Ci[WS(csi, 20)];
				   T1e = Ci[WS(csi, 12)];
			      }
			 }
			 {
			      E T4B, T4E, T1K, T1L;
			      {
				   E T1o, Tk, T4C, T1I, T1F, Tn, T4D, T1r, Ts, T1t, Tr, T4y, T1w, Tt, T1z;
				   E T1A;
				   {
					E Tl, Tm, T1p, T1q;
					{
					     E Ti, Tj, T1G, T1H, T1h, Tf;
					     Ti = Cr[WS(csr, 2)];
					     T1h = Td - Te;
					     Tf = Td + Te;
					     {
						  E T4s, T1f, T3k, T1l;
						  T4s = T1d - T1e;
						  T1f = T1d + T1e;
						  T3k = T1k - T1h;
						  T1l = T1h + T1k;
						  {
						       E T4q, T4t, T3l, T1g;
						       T4q = Tc - Tf;
						       Tg = Tc + Tf;
						       T4t = T4r - T4s;
						       T5I = T4s + T4r;
						       T3l = T1c + T1f;
						       T1g = T1c - T1f;
						       T5k = T4q + T4t;
						       T4u = T4q - T4t;
						       T40 = FMA(KP414213562, T3k, T3l);
						       T3m = FNMS(KP414213562, T3l, T3k);
						       T2U = FMA(KP414213562, T1g, T1l);
						       T1m = FNMS(KP414213562, T1l, T1g);
						       Tj = Cr[WS(csr, 30)];
						  }
					     }
					     T1G = Ci[WS(csi, 2)];
					     T1H = Ci[WS(csi, 30)];
					     Tl = Cr[WS(csr, 18)];
					     T1o = Ti - Tj;
					     Tk = Ti + Tj;
					     T4C = T1G - T1H;
					     T1I = T1G + T1H;
					     Tm = Cr[WS(csr, 14)];
					     T1p = Ci[WS(csi, 18)];
					     T1q = Ci[WS(csi, 14)];
					}
					{
					     E Tp, Tq, T1u, T1v;
					     Tp = Cr[WS(csr, 10)];
					     T1F = Tl - Tm;
					     Tn = Tl + Tm;
					     T4D = T1p - T1q;
					     T1r = T1p + T1q;
					     Tq = Cr[WS(csr, 22)];
					     T1u = Ci[WS(csi, 10)];
					     T1v = Ci[WS(csi, 22)];
					     Ts = Cr[WS(csr, 6)];
					     T1t = Tp - Tq;
					     Tr = Tp + Tq;
					     T4y = T1u - T1v;
					     T1w = T1u + T1v;
					     Tt = Cr[WS(csr, 26)];
					     T1z = Ci[WS(csi, 6)];
					     T1A = Ci[WS(csi, 26)];
					}
				   }
				   {
					E T1y, T4x, T1B, T4w, To, Tv, Tu;
					T3o = T1o + T1r;
					T1s = T1o - T1r;
					T1y = Ts - Tt;
					Tu = Ts + Tt;
					T4x = T1A - T1z;
					T1B = T1z + T1A;
					T1J = T1F + T1I;
					T3r = T1I - T1F;
					T4w = Tk - Tn;
					To = Tk + Tn;
					Tv = Tr + Tu;
					T4B = Tr - Tu;
					{
					     E T4z, T5L, T5M, T1x, T1C;
					     T4E = T4C - T4D;
					     T5L = T4D + T4C;
					     T5M = T4y + T4x;
					     T4z = T4x - T4y;
					     T5K = To - Tv;
					     Tw = To + Tv;
					     T5N = T5L - T5M;
					     T6c = T5M + T5L;
					     T1K = T1t + T1w;
					     T1x = T1t - T1w;
					     T1C = T1y - T1B;
					     T1L = T1y + T1B;
					     T4A = T4w + T4z;
					     T5n = T4w - T4z;
					     T3s = T1C - T1x;
					     T1D = T1x + T1C;
					}
				   }
			      }
			      {
				   E T4Z, T52, T2A, T2B;
				   {
					E T1Q, TA, T50, T2y, T2v, TD, T51, T1T, TI, T1V, TH, T4K, T1Y, TJ, T21;
					E T22;
					{
					     E TB, TC, T1R, T1S;
					     {
						  E Ty, Tz, T2w, T2x;
						  Ty = Cr[WS(csr, 1)];
						  T5m = T4E - T4B;
						  T4F = T4B + T4E;
						  T3p = T1K + T1L;
						  T1M = T1K - T1L;
						  Tz = Cr[WS(csr, 31)];
						  T2w = Ci[WS(csi, 1)];
						  T2x = Ci[WS(csi, 31)];
						  TB = Cr[WS(csr, 17)];
						  T1Q = Ty - Tz;
						  TA = Ty + Tz;
						  T50 = T2w - T2x;
						  T2y = T2w + T2x;
						  TC = Cr[WS(csr, 15)];
						  T1R = Ci[WS(csi, 17)];
						  T1S = Ci[WS(csi, 15)];
					     }
					     {
						  E TF, TG, T1W, T1X;
						  TF = Cr[WS(csr, 9)];
						  T2v = TB - TC;
						  TD = TB + TC;
						  T51 = T1R - T1S;
						  T1T = T1R + T1S;
						  TG = Cr[WS(csr, 23)];
						  T1W = Ci[WS(csi, 9)];
						  T1X = Ci[WS(csi, 23)];
						  TI = Cr[WS(csr, 7)];
						  T1V = TF - TG;
						  TH = TF + TG;
						  T4K = T1W - T1X;
						  T1Y = T1W + T1X;
						  TJ = Cr[WS(csr, 25)];
						  T21 = Ci[WS(csi, 7)];
						  T22 = Ci[WS(csi, 25)];
					     }
					}
					{
					     E T20, T4J, T23, T4I, TE, TL, TK;
					     T3w = T1Q + T1T;
					     T1U = T1Q - T1T;
					     T20 = TI - TJ;
					     TK = TI + TJ;
					     T4J = T22 - T21;
					     T23 = T21 + T22;
					     T2z = T2v + T2y;
					     T3H = T2y - T2v;
					     T4I = TA - TD;
					     TE = TA + TD;
					     TL = TH + TK;
					     T4Z = TH - TK;
					     {
						  E T4L, T5W, T5X, T1Z, T24;
						  T52 = T50 - T51;
						  T5W = T51 + T50;
						  T5X = T4K + T4J;
						  T4L = T4J - T4K;
						  T5Q = TE - TL;
						  TM = TE + TL;
						  T6f = T5X + T5W;
						  T5Y = T5W - T5X;
						  T2A = T1V + T1Y;
						  T1Z = T1V - T1Y;
						  T24 = T20 - T23;
						  T2B = T20 + T23;
						  T5q = T4I - T4L;
						  T4M = T4I + T4L;
						  T3I = T24 - T1Z;
						  T25 = T1Z + T24;
					     }
					}
				   }
				   {
					E T27, TP, T4O, T2f, T2c, TS, T4P, T2a, TX, T2i, TW, T4T, T2q, TY, T2j;
					E T2k;
					{
					     E TQ, TR, T28, T29;
					     {
						  E TN, TO, T2d, T2e;
						  TN = Cr[WS(csr, 5)];
						  T5t = T52 - T4Z;
						  T53 = T4Z + T52;
						  T3x = T2A + T2B;
						  T2C = T2A - T2B;
						  TO = Cr[WS(csr, 27)];
						  T2d = Ci[WS(csi, 5)];
						  T2e = Ci[WS(csi, 27)];
						  TQ = Cr[WS(csr, 21)];
						  T27 = TN - TO;
						  TP = TN + TO;
						  T4O = T2d - T2e;
						  T2f = T2d + T2e;
						  TR = Cr[WS(csr, 11)];
						  T28 = Ci[WS(csi, 21)];
						  T29 = Ci[WS(csi, 11)];
					     }
					     {
						  E TU, TV, T2o, T2p;
						  TU = Cr[WS(csr, 3)];
						  T2c = TQ - TR;
						  TS = TQ + TR;
						  T4P = T28 - T29;
						  T2a = T28 + T29;
						  TV = Cr[WS(csr, 29)];
						  T2o = Ci[WS(csi, 3)];
						  T2p = Ci[WS(csi, 29)];
						  TX = Cr[WS(csr, 13)];
						  T2i = TU - TV;
						  TW = TU + TV;
						  T4T = T2p - T2o;
						  T2q = T2o + T2p;
						  TY = Cr[WS(csr, 19)];
						  T2j = Ci[WS(csi, 13)];
						  T2k = Ci[WS(csi, 19)];
					     }
					}
					{
					     E T4N, T2n, T2l, T4Q, T2b, T2g, TT, TZ, T4U;
					     T4N = TP - TS;
					     TT = TP + TS;
					     T2n = TX - TY;
					     TZ = TX + TY;
					     T4U = T2j - T2k;
					     T2l = T2j + T2k;
					     {
						  E T5S, T10, T4S, T4V, T5R;
						  T5S = T4P + T4O;
						  T4Q = T4O - T4P;
						  T10 = TW + TZ;
						  T4S = TW - TZ;
						  T4V = T4T - T4U;
						  T5R = T4U + T4T;
						  T3A = T27 + T2a;
						  T2b = T27 - T2a;
						  T5V = TT - T10;
						  T11 = TT + T10;
						  T6g = T5S + T5R;
						  T5T = T5R - T5S;
						  T55 = T4V - T4S;
						  T4W = T4S + T4V;
						  T2g = T2c + T2f;
						  T3z = T2f - T2c;
					     }
					     {
						  E T3D, T3C, T2m, T2r;
						  T3D = T2i + T2l;
						  T2m = T2i - T2l;
						  T2r = T2n - T2q;
						  T3C = T2n + T2q;
						  T2E = FMA(KP414213562, T2b, T2g);
						  T2h = FNMS(KP414213562, T2g, T2b);
						  T2F = FNMS(KP414213562, T2m, T2r);
						  T2s = FMA(KP414213562, T2r, T2m);
						  T3L = FMA(KP414213562, T3C, T3D);
						  T3E = FNMS(KP414213562, T3D, T3C);
						  T54 = T4N + T4Q;
						  T4R = T4N - T4Q;
					     }
					}
				   }
			      }
			 }
		    }
		    {
			 E T3K, T3B, T5u, T5r, T5d, T5g;
			 {
			      E T6e, T6h, T6b, T5J, T5O, T5Z, T66, T69, T65, T67, T5U, T12, T6m, Th;
			      T6e = TM - T11;
			      T12 = TM + T11;
			      T6m = T6g + T6f;
			      T6h = T6f - T6g;
			      T6b = FNMS(KP2_000000000, Tg, T9);
			      Th = FMA(KP2_000000000, Tg, T9);
			      T3K = FMA(KP414213562, T3z, T3A);
			      T3B = FNMS(KP414213562, T3A, T3z);
			      {
				   E T63, T64, T6l, Tx;
				   T5J = FNMS(KP2_000000000, T5I, T5H);
				   T63 = FMA(KP2_000000000, T5I, T5H);
				   T64 = T5K + T5N;
				   T5O = T5K - T5N;
				   T5Z = T5V + T5Y;
				   T66 = T5Y - T5V;
				   T6l = FNMS(KP2_000000000, Tw, Th);
				   Tx = FMA(KP2_000000000, Tw, Th);
				   T69 = FMA(KP1_414213562, T64, T63);
				   T65 = FNMS(KP1_414213562, T64, T63);
				   R0[WS(rs, 8)] = FNMS(KP2_000000000, T6m, T6l);
				   R0[WS(rs, 24)] = FMA(KP2_000000000, T6m, T6l);
				   R0[0] = FMA(KP2_000000000, T12, Tx);
				   R0[WS(rs, 16)] = FNMS(KP2_000000000, T12, Tx);
				   T67 = T5Q - T5T;
				   T5U = T5Q + T5T;
			      }
			      {
				   E T6j, T6d, T6a, T68;
				   T6a = FMA(KP414213562, T66, T67);
				   T68 = FNMS(KP414213562, T67, T66);
				   T6j = FMA(KP2_000000000, T6c, T6b);
				   T6d = FNMS(KP2_000000000, T6c, T6b);
				   R0[WS(rs, 14)] = FNMS(KP1_847759065, T6a, T69);
				   R0[WS(rs, 30)] = FMA(KP1_847759065, T6a, T69);
				   R0[WS(rs, 22)] = FMA(KP1_847759065, T68, T65);
				   R0[WS(rs, 6)] = FNMS(KP1_847759065, T68, T65);
				   {
					E T61, T5P, T6k, T6i;
					T6k = T6e + T6h;
					T6i = T6e - T6h;
					T61 = FNMS(KP1_414213562, T5O, T5J);
					T5P = FMA(KP1_414213562, T5O, T5J);
					R0[WS(rs, 12)] = FNMS(KP1_414213562, T6k, T6j);
					R0[WS(rs, 28)] = FMA(KP1_414213562, T6k, T6j);
					R0[WS(rs, 4)] = FMA(KP1_414213562, T6i, T6d);
					R0[WS(rs, 20)] = FNMS(KP1_414213562, T6i, T6d);
					{
					     E T5b, T4v, T5f, T4Y, T5e, T57, T4G, T5c;
					     {
						  E T4X, T56, T62, T60;
						  T5u = T4W - T4R;
						  T4X = T4R + T4W;
						  T56 = T54 + T55;
						  T5r = T54 - T55;
						  T5b = FNMS(KP1_414213562, T4u, T4p);
						  T4v = FMA(KP1_414213562, T4u, T4p);
						  T62 = FMA(KP414213562, T5U, T5Z);
						  T60 = FNMS(KP414213562, T5Z, T5U);
						  T5f = FNMS(KP707106781, T4X, T4M);
						  T4Y = FMA(KP707106781, T4X, T4M);
						  T5e = FNMS(KP707106781, T56, T53);
						  T57 = FMA(KP707106781, T56, T53);
						  R0[WS(rs, 10)] = FNMS(KP1_847759065, T62, T61);
						  R0[WS(rs, 26)] = FMA(KP1_847759065, T62, T61);
						  R0[WS(rs, 2)] = FMA(KP1_847759065, T60, T5P);
						  R0[WS(rs, 18)] = FNMS(KP1_847759065, T60, T5P);
						  T4G = FNMS(KP414213562, T4F, T4A);
						  T5c = FMA(KP414213562, T4A, T4F);
					     }
					     {
						  E T5a, T59, T5h, T5i, T58, T4H;
						  T5a = FMA(KP198912367, T4Y, T57);
						  T58 = FNMS(KP198912367, T57, T4Y);
						  T59 = FNMS(KP1_847759065, T4G, T4v);
						  T4H = FMA(KP1_847759065, T4G, T4v);
						  T5h = FMA(KP1_847759065, T5c, T5b);
						  T5d = FNMS(KP1_847759065, T5c, T5b);
						  T5i = FMA(KP668178637, T5e, T5f);
						  T5g = FNMS(KP668178637, T5f, T5e);
						  R0[WS(rs, 1)] = FMA(KP1_961570560, T58, T4H);
						  R0[WS(rs, 17)] = FNMS(KP1_961570560, T58, T4H);
						  R0[WS(rs, 29)] = FMA(KP1_662939224, T5i, T5h);
						  R0[WS(rs, 13)] = FNMS(KP1_662939224, T5i, T5h);
						  R0[WS(rs, 25)] = FMA(KP1_961570560, T5a, T59);
						  R0[WS(rs, 9)] = FNMS(KP1_961570560, T5a, T59);
					     }
					}
				   }
			      }
			 }
			 {
			      E T43, T42, T46, T4a, T49, T3V, T3G, T47, T3P, T3v, T3X, T3T, T3U, T3N, T5B;
			      E T5E;
			      {
				   E T5s, T5D, T5z, T5l, T5C, T5v, T5o, T5A;
				   R0[WS(rs, 21)] = FMA(KP1_662939224, T5g, T5d);
				   R0[WS(rs, 5)] = FNMS(KP1_662939224, T5g, T5d);
				   T5s = FNMS(KP707106781, T5r, T5q);
				   T5D = FMA(KP707106781, T5r, T5q);
				   T5z = FMA(KP1_414213562, T5k, T5j);
				   T5l = FNMS(KP1_414213562, T5k, T5j);
				   T5C = FMA(KP707106781, T5u, T5t);
				   T5v = FNMS(KP707106781, T5u, T5t);
				   T5o = FNMS(KP414213562, T5n, T5m);
				   T5A = FMA(KP414213562, T5m, T5n);
				   {
					E T5y, T5x, T5F, T5G, T5w, T5p;
					T5y = FMA(KP668178637, T5s, T5v);
					T5w = FNMS(KP668178637, T5v, T5s);
					T5x = FMA(KP1_847759065, T5o, T5l);
					T5p = FNMS(KP1_847759065, T5o, T5l);
					T5F = FMA(KP1_847759065, T5A, T5z);
					T5B = FNMS(KP1_847759065, T5A, T5z);
					T5G = FMA(KP198912367, T5C, T5D);
					T5E = FNMS(KP198912367, T5D, T5C);
					R0[WS(rs, 3)] = FMA(KP1_662939224, T5w, T5p);
					R0[WS(rs, 19)] = FNMS(KP1_662939224, T5w, T5p);
					R0[WS(rs, 31)] = FMA(KP1_961570560, T5G, T5F);
					R0[WS(rs, 15)] = FNMS(KP1_961570560, T5G, T5F);
					R0[WS(rs, 27)] = FMA(KP1_662939224, T5y, T5x);
					R0[WS(rs, 11)] = FNMS(KP1_662939224, T5y, T5x);
				   }
			      }
			      {
				   E T3R, T3n, T3J, T3S, T3u, T3M;
				   T3R = FMA(KP1_847759065, T3m, T3j);
				   T3n = FNMS(KP1_847759065, T3m, T3j);
				   R0[WS(rs, 23)] = FMA(KP1_961570560, T5E, T5B);
				   R0[WS(rs, 7)] = FNMS(KP1_961570560, T5E, T5B);
				   {
					E T3q, T3t, T3y, T3F;
					T43 = FMA(KP707106781, T3p, T3o);
					T3q = FNMS(KP707106781, T3p, T3o);
					T3t = FNMS(KP707106781, T3s, T3r);
					T42 = FMA(KP707106781, T3s, T3r);
					T46 = FMA(KP707106781, T3x, T3w);
					T3y = FNMS(KP707106781, T3x, T3w);
					T3F = T3B + T3E;
					T4a = T3B - T3E;
					T49 = FMA(KP707106781, T3I, T3H);
					T3J = FNMS(KP707106781, T3I, T3H);
					T3S = FMA(KP668178637, T3q, T3t);
					T3u = FNMS(KP668178637, T3t, T3q);
					T3V = FMA(KP923879532, T3F, T3y);
					T3G = FNMS(KP923879532, T3F, T3y);
					T3M = T3K - T3L;
					T47 = T3K + T3L;
				   }
				   T3P = FNMS(KP1_662939224, T3u, T3n);
				   T3v = FMA(KP1_662939224, T3u, T3n);
				   T3X = FMA(KP1_662939224, T3S, T3R);
				   T3T = FNMS(KP1_662939224, T3S, T3R);
				   T3U = FNMS(KP923879532, T3M, T3J);
				   T3N = FMA(KP923879532, T3M, T3J);
			      }
			      {
				   E T2X, T2W, T30, T34, T33, T2P, T2u, T31, T2J, T1P, T2R, T2N, T2O, T2H;
				   {
					E T2L, T1n, T2D, T2M, T1O, T2G;
					T2L = FNMS(KP1_847759065, T1m, T1b);
					T1n = FMA(KP1_847759065, T1m, T1b);
					{
					     E T3W, T3Y, T3Q, T3O;
					     T3W = FNMS(KP534511135, T3V, T3U);
					     T3Y = FMA(KP534511135, T3U, T3V);
					     T3Q = FMA(KP303346683, T3G, T3N);
					     T3O = FNMS(KP303346683, T3N, T3G);
					     R1[WS(rs, 21)] = FMA(KP1_763842528, T3W, T3T);
					     R1[WS(rs, 5)] = FNMS(KP1_763842528, T3W, T3T);
					     R1[WS(rs, 29)] = FMA(KP1_763842528, T3Y, T3X);
					     R1[WS(rs, 13)] = FNMS(KP1_763842528, T3Y, T3X);
					     R1[WS(rs, 25)] = FMA(KP1_913880671, T3Q, T3P);
					     R1[WS(rs, 9)] = FNMS(KP1_913880671, T3Q, T3P);
					     R1[WS(rs, 1)] = FMA(KP1_913880671, T3O, T3v);
					     R1[WS(rs, 17)] = FNMS(KP1_913880671, T3O, T3v);
					}
					{
					     E T1E, T1N, T26, T2t;
					     T2X = FNMS(KP707106781, T1D, T1s);
					     T1E = FMA(KP707106781, T1D, T1s);
					     T1N = FMA(KP707106781, T1M, T1J);
					     T2W = FNMS(KP707106781, T1M, T1J);
					     T30 = FNMS(KP707106781, T25, T1U);
					     T26 = FMA(KP707106781, T25, T1U);
					     T2t = T2h + T2s;
					     T34 = T2s - T2h;
					     T33 = FNMS(KP707106781, T2C, T2z);
					     T2D = FMA(KP707106781, T2C, T2z);
					     T2M = FMA(KP198912367, T1E, T1N);
					     T1O = FNMS(KP198912367, T1N, T1E);
					     T2P = FNMS(KP923879532, T2t, T26);
					     T2u = FMA(KP923879532, T2t, T26);
					     T2G = T2E + T2F;
					     T31 = T2E - T2F;
					}
					T2J = FNMS(KP1_961570560, T1O, T1n);
					T1P = FMA(KP1_961570560, T1O, T1n);
					T2R = FMA(KP1_961570560, T2M, T2L);
					T2N = FNMS(KP1_961570560, T2M, T2L);
					T2O = FNMS(KP923879532, T2G, T2D);
					T2H = FMA(KP923879532, T2G, T2D);
				   }
				   {
					E T4j, T48, T4d, T45, T4l, T4h, T4i, T4b;
					{
					     E T4f, T41, T4g, T44;
					     T4f = FMA(KP1_847759065, T40, T3Z);
					     T41 = FNMS(KP1_847759065, T40, T3Z);
					     {
						  E T2Q, T2S, T2K, T2I;
						  T2Q = FNMS(KP820678790, T2P, T2O);
						  T2S = FMA(KP820678790, T2O, T2P);
						  T2K = FMA(KP098491403, T2u, T2H);
						  T2I = FNMS(KP098491403, T2H, T2u);
						  R1[WS(rs, 20)] = FMA(KP1_546020906, T2Q, T2N);
						  R1[WS(rs, 4)] = FNMS(KP1_546020906, T2Q, T2N);
						  R1[WS(rs, 28)] = FMA(KP1_546020906, T2S, T2R);
						  R1[WS(rs, 12)] = FNMS(KP1_546020906, T2S, T2R);
						  R1[WS(rs, 24)] = FMA(KP1_990369453, T2K, T2J);
						  R1[WS(rs, 8)] = FNMS(KP1_990369453, T2K, T2J);
						  R1[0] = FMA(KP1_990369453, T2I, T1P);
						  R1[WS(rs, 16)] = FNMS(KP1_990369453, T2I, T1P);
					     }
					     T4g = FMA(KP198912367, T42, T43);
					     T44 = FNMS(KP198912367, T43, T42);
					     T4j = FMA(KP923879532, T47, T46);
					     T48 = FNMS(KP923879532, T47, T46);
					     T4d = FMA(KP1_961570560, T44, T41);
					     T45 = FNMS(KP1_961570560, T44, T41);
					     T4l = FMA(KP1_961570560, T4g, T4f);
					     T4h = FNMS(KP1_961570560, T4g, T4f);
					     T4i = FMA(KP923879532, T4a, T49);
					     T4b = FNMS(KP923879532, T4a, T49);
					}
					{
					     E T39, T2V, T3a, T2Y;
					     T39 = FMA(KP1_847759065, T2U, T2T);
					     T2V = FNMS(KP1_847759065, T2U, T2T);
					     {
						  E T4k, T4m, T4e, T4c;
						  T4k = FNMS(KP098491403, T4j, T4i);
						  T4m = FMA(KP098491403, T4i, T4j);
						  T4e = FMA(KP820678790, T48, T4b);
						  T4c = FNMS(KP820678790, T4b, T48);
						  R1[WS(rs, 23)] = FMA(KP1_990369453, T4k, T4h);
						  R1[WS(rs, 7)] = FNMS(KP1_990369453, T4k, T4h);
						  R1[WS(rs, 31)] = FMA(KP1_990369453, T4m, T4l);
						  R1[WS(rs, 15)] = FNMS(KP1_990369453, T4m, T4l);
						  R1[WS(rs, 27)] = FMA(KP1_546020906, T4e, T4d);
						  R1[WS(rs, 11)] = FNMS(KP1_546020906, T4e, T4d);
						  R1[WS(rs, 3)] = FMA(KP1_546020906, T4c, T45);
						  R1[WS(rs, 19)] = FNMS(KP1_546020906, T4c, T45);
					     }
					     T3a = FMA(KP668178637, T2W, T2X);
					     T2Y = FNMS(KP668178637, T2X, T2W);
					     T3d = FMA(KP923879532, T31, T30);
					     T32 = FNMS(KP923879532, T31, T30);
					     T37 = FMA(KP1_662939224, T2Y, T2V);
					     T2Z = FNMS(KP1_662939224, T2Y, T2V);
					     T3f = FMA(KP1_662939224, T3a, T39);
					     T3b = FNMS(KP1_662939224, T3a, T39);
					     T3c = FMA(KP923879532, T34, T33);
					     T35 = FNMS(KP923879532, T34, T33);
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    E T3g, T3e, T36, T38;
		    T3g = FMA(KP303346683, T3c, T3d);
		    T3e = FNMS(KP303346683, T3d, T3c);
		    T36 = FNMS(KP534511135, T35, T32);
		    T38 = FMA(KP534511135, T32, T35);
		    R1[WS(rs, 22)] = FMA(KP1_913880671, T3e, T3b);
		    R1[WS(rs, 6)] = FNMS(KP1_913880671, T3e, T3b);
		    R1[WS(rs, 30)] = FMA(KP1_913880671, T3g, T3f);
		    R1[WS(rs, 14)] = FNMS(KP1_913880671, T3g, T3f);
		    R1[WS(rs, 26)] = FMA(KP1_763842528, T38, T37);
		    R1[WS(rs, 10)] = FNMS(KP1_763842528, T38, T37);
		    R1[WS(rs, 2)] = FMA(KP1_763842528, T36, T2Z);
		    R1[WS(rs, 18)] = FNMS(KP1_763842528, T36, T2Z);
	       }
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cb_64", {178, 0, 216, 0}, &GENUS };

void X(codelet_r2cb_64) (planner *p) {
     X(kr2c_register) (p, r2cb_64, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_r2cb.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 64 -name r2cb_64 -include r2cb.h */

/*
 * This function contains 394 FP additions, 134 FP multiplications,
 * (or, 342 additions, 82 multiplications, 52 fused multiply/add),
 * 110 stack variables, 19 constants, and 128 memory accesses
 */
#include "r2cb.h"

static void r2cb_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP1_268786568, +1.268786568327290996430343226450986741351374190);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP196034280, +0.196034280659121203988391127777283691722273346);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP942793473, +0.942793473651995297112775251810508755314920638);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP580569354, +0.580569354508924735272384751634790549382952557);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP1_111140466, +1.111140466039204449485661627897065748749874382);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP390180644, +0.390180644032256535696569736954044481855383236);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP765366864, +0.765366864730179543456919968060797733522689125);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ovs, R1 = R1 + ovs, Cr = Cr + ivs, Ci = Ci + ivs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E Ta, T2S, T18, T2u, T3F, T4V, T5l, T61, Th, T2T, T1h, T2v, T3M, T4W, T5o;
	       E T62, T3Q, T5q, T5u, T44, Tp, Tw, T2V, T2W, T2X, T2Y, T3X, T5t, T1r, T2x;
	       E T41, T5r, T1A, T2y, T4a, T5y, T5N, T4H, TN, T31, T4E, T5z, T39, T3q, T1L;
	       E T2B, T4h, T5M, T2h, T2F, T12, T36, T5D, T5J, T5G, T5K, T1U, T26, T23, T27;
	       E T4p, T4z, T4w, T4A, T34, T3r;
	       {
		    E T5, T3A, T3, T3y, T9, T3C, T17, T3D, T6, T14;
		    {
			 E T4, T3z, T1, T2;
			 T4 = Cr[WS(csr, 16)];
			 T5 = KP2_000000000 * T4;
			 T3z = Ci[WS(csi, 16)];
			 T3A = KP2_000000000 * T3z;
			 T1 = Cr[0];
			 T2 = Cr[WS(csr, 32)];
			 T3 = T1 + T2;
			 T3y = T1 - T2;
			 {
			      E T7, T8, T15, T16;
			      T7 = Cr[WS(csr, 8)];
			      T8 = Cr[WS(csr, 24)];
			      T9 = KP2_000000000 * (T7 + T8);
			      T3C = T7 - T8;
			      T15 = Ci[WS(csi, 8)];
			      T16 = Ci[WS(csi, 24)];
			      T17 = KP2_000000000 * (T15 - T16);
			      T3D = T15 + T16;
			 }
		    }
		    T6 = T3 + T5;
		    Ta = T6 + T9;
		    T2S = T6 - T9;
		    T14 = T3 - T5;
		    T18 = T14 - T17;
		    T2u = T14 + T17;
		    {
			 E T3B, T3E, T5j, T5k;
			 T3B = T3y - T3A;
			 T3E = KP1_414213562 * (T3C - T3D);
			 T3F = T3B + T3E;
			 T4V = T3B - T3E;
			 T5j = T3y + T3A;
			 T5k = KP1_414213562 * (T3C + T3D);
			 T5l = T5j - T5k;
			 T61 = T5j + T5k;
		    }
	       }
	       {
		    E Td, T3G, T1c, T3K, Tg, T3J, T1f, T3H, T19, T1g;
		    {
			 E Tb, Tc, T1a, T1b;
			 Tb = Cr[WS(csr, 4)];
			 Tc = Cr[WS(csr, 28)];
			 Td = Tb + Tc;
			 T3G = Tb - Tc;
			 T1a = Ci[WS(csi, 4)];
			 T1b = Ci[WS(csi, 28)];
			 T1c = T1a - T1b;
			 T3K = T1a + T1b;
		    }
		    {
			 E Te, Tf, T1d, T1e;
			 Te = Cr[WS(csr, 20)];
			 Tf = Cr[WS(csr, 12)];
			 Tg = Te + Tf;
			 T3J = Te - Tf;
			 T1d = Ci[WS(csi, 20)];
			 T1e = Ci[WS(csi, 12)];
			 T1f = T1d - T1e;
			 T3H = T1d + T1e;
		    }
		    Th = KP2_000000000 * (Td + Tg);
		    T2T = KP2_000000000 * (T1f + T1c);
		    T19 = Td - Tg;
		    T1g = T1c - T1f;
		    T1h = KP1_414213562 * (T19 - T1g);
		    T2v = KP1_414213562 * (T19 + T1g);
		    {
			 E T3I, T3L, T5m, T5n;
			 T3I = T3G - T3H;
			 T3L = T3J + T3K;
			 T3M = FNMS(KP765366864, T3L, KP1_847759065 * T3I);
			 T4W = FMA(KP765366864, T3I, KP1_847759065 * T3L);
			 T5m = T3G + T3H;
			 T5n = T3K - T3J;
			 T5o = FNMS(KP1_847759065, T5n, KP765366864 * T5m);
			 T62 = FMA(KP1_847759065, T5m, KP765366864 * T5n);
		    }
	       }
	       {
		    E Tl, T3O, T1v, T43, To, T42, T1y, T3P, Ts, T3R, T1p, T3S, Tv, T3U, T1m;
		    E T3V;
		    {
			 E Tj, Tk, T1t, T1u;
			 Tj = Cr[WS(csr, 2)];
			 Tk = Cr[WS(csr, 30)];
			 Tl = Tj + Tk;
			 T3O = Tj - Tk;
			 T1t = Ci[WS(csi, 2)];
			 T1u = Ci[WS(csi, 30)];
			 T1v = T1t - T1u;
			 T43 = T1t + T1u;
		    }
		    {
			 E Tm, Tn, T1w, T1x;
			 Tm = Cr[WS(csr, 18)];
			 Tn = Cr[WS(csr, 14)];
			 To = Tm + Tn;
			 T42 = Tm - Tn;
			 T1w = Ci[WS(csi, 18)];
			 T1x = Ci[WS(csi, 14)];
			 T1y = T1w - T1x;
			 T3P = T1w + T1x;
		    }
		    {
			 E Tq, Tr, T1n, T1o;
			 Tq = Cr[WS(csr, 10)];
			 Tr = Cr[WS(csr, 22)];
			 Ts = Tq + Tr;
			 T3R = Tq - Tr;
			 T1n = Ci[WS(csi, 10)];
			 T1o = Ci[WS(csi, 22)];
			 T1p = T1n - T1o;
			 T3S = T1n + T1o;
		    }
		    {
			 E Tt, Tu, T1k, T1l;
			 Tt = Cr[WS(csr, 6)];
			 Tu = Cr[WS(csr, 26)];
			 Tv = Tt + Tu;
			 T3U = Tt - Tu;
			 T1k = Ci[WS(csi, 26)];
			 T1l = Ci[WS(csi, 6)];
			 T1m = T1k - T1l;
			 T3V = T1l + T1k;
		    }
		    T3Q = T3O - T3P;
		    T5q = T3O + T3P;
		    T5u = T43 - T42;
		    T44 = T42 + T43;
		    Tp = Tl + To;
		    Tw = Ts + Tv;
		    T2V = Tp - Tw;
		    {
			 E T3T, T3W, T1j, T1q;
			 T2W = T1y + T1v;
			 T2X = T1p + T1m;
			 T2Y = T2W - T2X;
			 T3T = T3R - T3S;
			 T3W = T3U - T3V;
			 T3X = KP707106781 * (T3T + T3W);
			 T5t = KP707106781 * (T3T - T3W);
			 T1j = Tl - To;
			 T1q = T1m - T1p;
			 T1r = T1j + T1q;
			 T2x = T1j - T1q;
			 {
			      E T3Z, T40, T1s, T1z;
			      T3Z = T3R + T3S;
			      T40 = T3U + T3V;
			      T41 = KP707106781 * (T3Z - T40);
			      T5r = KP707106781 * (T3Z + T40);
			      T1s = Ts - Tv;
			      T1z = T1v - T1y;
			      T1A = T1s + T1z;
			      T2y = T1z - T1s;
			 }
		    }
	       }
	       {
		    E TB, T48, T2c, T4G, TE, T4F, T2f, T49, TI, T4b, T1J, T4c, TL, T4e, T1G;
		    E T4f;
		    {
			 E Tz, TA, T2a, T2b;
			 Tz = Cr[WS(csr, 1)];
			 TA = Cr[WS(csr, 31)];
			 TB = Tz + TA;
			 T48 = Tz - TA;
			 T2a = Ci[WS(csi, 1)];
			 T2b = Ci[WS(csi, 31)];
			 T2c = T2a - T2b;
			 T4G = T2a + T2b;
		    }
		    {
			 E TC, TD, T2d, T2e;
			 TC = Cr[WS(csr, 17)];
			 TD = Cr[WS(csr, 15)];
			 TE = TC + TD;
			 T4F = TC - TD;
			 T2d = Ci[WS(csi, 17)];
			 T2e = Ci[WS(csi, 15)];
			 T2f = T2d - T2e;
			 T49 = T2d + T2e;
		    }
		    {
			 E TG, TH, T1H, T1I;
			 TG = Cr[WS(csr, 9)];
			 TH = Cr[WS(csr, 23)];
			 TI = TG + TH;
			 T4b = TG - TH;
			 T1H = Ci[WS(csi, 9)];
			 T1I = Ci[WS(csi, 23)];
			 T1J = T1H - T1I;
			 T4c = T1H + T1I;
		    }
		    {
			 E TJ, TK, T1E, T1F;
			 TJ = Cr[WS(csr, 7)];
			 TK = Cr[WS(csr, 25)];
			 TL = TJ + TK;
			 T4e = TJ - TK;
			 T1E = Ci[WS(csi, 25)];
			 T1F = Ci[WS(csi, 7)];
			 T1G = T1E - T1F;
			 T4f = T1F + T1E;
		    }
		    {
			 E TF, TM, T1D, T1K;
			 T4a = T48 - T49;
			 T5y = T48 + T49;
			 T5N = T4G - T4F;
			 T4H = T4F + T4G;
			 TF = TB + TE;
			 TM = TI + TL;
			 TN = TF + TM;
			 T31 = TF - TM;
			 {
			      E T4C, T4D, T37, T38;
			      T4C = T4b + T4c;
			      T4D = T4e + T4f;
			      T4E = KP707106781 * (T4C - T4D);
			      T5z = KP707106781 * (T4C + T4D);
			      T37 = T2f + T2c;
			      T38 = T1J + T1G;
			      T39 = T37 - T38;
			      T3q = T38 + T37;
			 }
			 T1D = TB - TE;
			 T1K = T1G - T1J;
			 T1L = T1D + T1K;
			 T2B = T1D - T1K;
			 {
			      E T4d, T4g, T29, T2g;
			      T4d = T4b - T4c;
			      T4g = T4e - T4f;
			      T4h = KP707106781 * (T4d + T4g);
			      T5M = KP707106781 * (T4d - T4g);
			      T29 = TI - TL;
			      T2g = T2c - T2f;
			      T2h = T29 + T2g;
			      T2F = T2g - T29;
			 }
		    }
	       }
	       {
		    E TQ, T4j, T1P, T4n, TT, T4m, T1S, T4k, TX, T4q, T1Y, T4u, T10, T4t, T21;
		    E T4r;
		    {
			 E TO, TP, T1N, T1O;
			 TO = Cr[WS(csr, 5)];
			 TP = Cr[WS(csr, 27)];
			 TQ = TO + TP;
			 T4j = TO - TP;
			 T1N = Ci[WS(csi, 5)];
			 T1O = Ci[WS(csi, 27)];
			 T1P = T1N - T1O;
			 T4n = T1N + T1O;
		    }
		    {
			 E TR, TS, T1Q, T1R;
			 TR = Cr[WS(csr, 21)];
			 TS = Cr[WS(csr, 11)];
			 TT = TR + TS;
			 T4m = TR - TS;
			 T1Q = Ci[WS(csi, 21)];
			 T1R = Ci[WS(csi, 11)];
			 T1S = T1Q - T1R;
			 T4k = T1Q + T1R;
		    }
		    {
			 E TV, TW, T1W, T1X;
			 TV = Cr[WS(csr, 3)];
			 TW = Cr[WS(csr, 29)];
			 TX = TV + TW;
			 T4q = TV - TW;
			 T1W = Ci[WS(csi, 29)];
			 T1X = Ci[WS(csi, 3)];
			 T1Y = T1W - T1X;
			 T4u = T1X + T1W;
		    }
		    {
			 E TY, TZ, T1Z, T20;
			 TY = Cr[WS(csr, 13)];
			 TZ = Cr[WS(csr, 19)];
			 T10 = TY + TZ;
			 T4t = TY - TZ;
			 T1Z = Ci[WS(csi, 13)];
			 T20 = Ci[WS(csi, 19)];
			 T21 = T1Z - T20;
			 T4r = T1Z + T20;
		    }
		    {
			 E TU, T11, T5B, T5C;
			 TU = TQ + TT;
			 T11 = TX + T10;
			 T12 = TU + T11;
			 T36 = TU - T11;
			 T5B = T4j + T4k;
			 T5C = T4n - T4m;
			 T5D = FNMS(KP923879532, T5C, KP382683432 * T5B);
			 T5J = FMA(KP923879532, T5B, KP382683432 * T5C);
		    }
		    {
			 E T5E, T5F, T1M, T1T;
			 T5E = T4q + T4r;
			 T5F = T4t + T4u;
			 T5G = FNMS(KP923879532, T5F, KP382683432 * T5E);
			 T5K = FMA(KP923879532, T5E, KP382683432 * T5F);
			 T1M = TQ - TT;
			 T1T = T1P - T1S;
			 T1U = T1M - T1T;
			 T26 = T1M + T1T;
		    }
		    {
			 E T1V, T22, T4l, T4o;
			 T1V = TX - T10;
			 T22 = T1Y - T21;
			 T23 = T1V + T22;
			 T27 = T22 - T1V;
			 T4l = T4j - T4k;
			 T4o = T4m + T4n;
			 T4p = FNMS(KP382683432, T4o, KP923879532 * T4l);
			 T4z = FMA(KP382683432, T4l, KP923879532 * T4o);
		    }
		    {
			 E T4s, T4v, T32, T33;
			 T4s = T4q - T4r;
			 T4v = T4t - T4u;
			 T4w = FMA(KP923879532, T4s, KP382683432 * T4v);
			 T4A = FNMS(KP382683432, T4s, KP923879532 * T4v);
			 T32 = T21 + T1Y;
			 T33 = T1S + T1P;
			 T34 = T32 - T33;
			 T3r = T33 + T32;
		    }
	       }
	       {
		    E T13, T3x, Ty, T3w, Ti, Tx;
		    T13 = KP2_000000000 * (TN + T12);
		    T3x = KP2_000000000 * (T3r + T3q);
		    Ti = Ta + Th;
		    Tx = KP2_000000000 * (Tp + Tw);
		    Ty = Ti + Tx;
		    T3w = Ti - Tx;
		    R0[WS(rs, 16)] = Ty - T13;
		    R0[WS(rs, 24)] = T3w + T3x;
		    R0[0] = Ty + T13;
		    R0[WS(rs, 8)] = T3w - T3x;
	       }
	       {
		    E T3g, T3k, T3j, T3l;
		    {
			 E T3e, T3f, T3h, T3i;
			 T3e = T2S + T2T;
			 T3f = KP1_414213562 * (T2V + T2Y);
			 T3g = T3e - T3f;
			 T3k = T3e + T3f;
			 T3h = T31 - T34;
			 T3i = T39 - T36;
			 T3j = FNMS(KP1_847759065, T3i, KP765366864 * T3h);
			 T3l = FMA(KP1_847759065, T3h, KP765366864 * T3i);
		    }
		    R0[WS(rs, 22)] = T3g - T3j;
		    R0[WS(rs, 30)] = T3k + T3l;
		    R0[WS(rs, 6)] = T3g + T3j;
		    R0[WS(rs, 14)] = T3k - T3l;
	       }
	       {
		    E T3o, T3u, T3t, T3v;
		    {
			 E T3m, T3n, T3p, T3s;
			 T3m = Ta - Th;
			 T3n = KP2_000000000 * (T2X + T2W);
			 T3o = T3m - T3n;
			 T3u = T3m + T3n;
			 T3p = TN - T12;
			 T3s = T3q - T3r;
			 T3t = KP1_414213562 * (T3p - T3s);
			 T3v = KP1_414213562 * (T3p + T3s);
		    }
		    R0[WS(rs, 20)] = T3o - T3t;
		    R0[WS(rs, 28)] = T3u + T3v;
		    R0[WS(rs, 4)] = T3o + T3t;
		    R0[WS(rs, 12)] = T3u - T3v;
	       }
	       {
		    E T30, T3c, T3b, T3d;
		    {
			 E T2U, T2Z, T35, T3a;
			 T2U = T2S - T2T;
			 T2Z = KP1_414213562 * (T2V - T2Y);
			 T30 = T2U + T2Z;
			 T3c = T2U - T2Z;
			 T35 = T31 + T34;
			 T3a = T36 + T39;
			 T3b = FNMS(KP765366864, T3a, KP1_847759065 * T35);
			 T3d = FMA(KP765366864, T35, KP1_847759065 * T3a);
		    }
		    R0[WS(rs, 18)] = T30 - T3b;
		    R0[WS(rs, 26)] = T3c + T3d;
		    R0[WS(rs, 2)] = T30 + T3b;
		    R0[WS(rs, 10)] = T3c - T3d;
	       }
	       {
		    E T25, T2p, T2i, T2q, T1C, T2k, T2o, T2s, T24, T28;
		    T24 = KP707106781 * (T1U + T23);
		    T25 = T1L + T24;
		    T2p = T1L - T24;
		    T28 = KP707106781 * (T26 + T27);
		    T2i = T28 + T2h;
		    T2q = T2h - T28;
		    {
			 E T1i, T1B, T2m, T2n;
			 T1i = T18 + T1h;
			 T1B = FNMS(KP765366864, T1A, KP1_847759065 * T1r);
			 T1C = T1i + T1B;
			 T2k = T1i - T1B;
			 T2m = T18 - T1h;
			 T2n = FMA(KP765366864, T1r, KP1_847759065 * T1A);
			 T2o = T2m - T2n;
			 T2s = T2m + T2n;
		    }
		    {
			 E T2j, T2t, T2l, T2r;
			 T2j = FNMS(KP390180644, T2i, KP1_961570560 * T25);
			 R0[WS(rs, 17)] = T1C - T2j;
			 R0[WS(rs, 1)] = T1C + T2j;
			 T2t = FMA(KP1_662939224, T2p, KP1_111140466 * T2q);
			 R0[WS(rs, 13)] = T2s - T2t;
			 R0[WS(rs, 29)] = T2s + T2t;
			 T2l = FMA(KP390180644, T25, KP1_961570560 * T2i);
			 R0[WS(rs, 9)] = T2k - T2l;
			 R0[WS(rs, 25)] = T2k + T2l;
			 T2r = FNMS(KP1_662939224, T2q, KP1_111140466 * T2p);
			 R0[WS(rs, 21)] = T2o - T2r;
			 R0[WS(rs, 5)] = T2o + T2r;
		    }
	       }
	       {
		    E T2D, T2N, T2G, T2O, T2A, T2I, T2M, T2Q, T2C, T2E;
		    T2C = KP707106781 * (T27 - T26);
		    T2D = T2B + T2C;
		    T2N = T2B - T2C;
		    T2E = KP707106781 * (T1U - T23);
		    T2G = T2E + T2F;
		    T2O = T2F - T2E;
		    {
			 E T2w, T2z, T2K, T2L;
			 T2w = T2u - T2v;
			 T2z = FNMS(KP1_847759065, T2y, KP765366864 * T2x);
			 T2A = T2w + T2z;
			 T2I = T2w - T2z;
			 T2K = T2u + T2v;
			 T2L = FMA(KP1_847759065, T2x, KP765366864 * T2y);
			 T2M = T2K - T2L;
			 T2Q = T2K + T2L;
		    }
		    {
			 E T2H, T2R, T2J, T2P;
			 T2H = FNMS(KP1_111140466, T2G, KP1_662939224 * T2D);
			 R0[WS(rs, 19)] = T2A - T2H;
			 R0[WS(rs, 3)] = T2A + T2H;
			 T2R = FMA(KP1_961570560, T2N, KP390180644 * T2O);
			 R0[WS(rs, 15)] = T2Q - T2R;
			 R0[WS(rs, 31)] = T2Q + T2R;
			 T2J = FMA(KP1_111140466, T2D, KP1_662939224 * T2G);
			 R0[WS(rs, 11)] = T2I - T2J;
			 R0[WS(rs, 27)] = T2I + T2J;
			 T2P = FNMS(KP1_961570560, T2O, KP390180644 * T2N);
			 R0[WS(rs, 23)] = T2M - T2P;
			 R0[WS(rs, 7)] = T2M + T2P;
		    }
	       }
	       {
		    E T5p, T5T, T5w, T5U, T5I, T5W, T5P, T5X, T5s, T5v;
		    T5p = T5l + T5o;
		    T5T = T5l - T5o;
		    T5s = T5q - T5r;
		    T5v = T5t + T5u;
		    T5w = FNMS(KP1_111140466, T5v, KP1_662939224 * T5s);
		    T5U = FMA(KP1_111140466, T5s, KP1_662939224 * T5v);
		    {
			 E T5A, T5H, T5L, T5O;
			 T5A = T5y - T5z;
			 T5H = T5D + T5G;
			 T5I = T5A + T5H;
			 T5W = T5A - T5H;
			 T5L = T5J - T5K;
			 T5O = T5M + T5N;
			 T5P = T5L + T5O;
			 T5X = T5O - T5L;
		    }
		    {
			 E T5x, T5Q, T5Z, T60;
			 T5x = T5p + T5w;
			 T5Q = FNMS(KP580569354, T5P, KP1_913880671 * T5I);
			 R1[WS(rs, 17)] = T5x - T5Q;
			 R1[WS(rs, 1)] = T5x + T5Q;
			 T5Z = T5T + T5U;
			 T60 = FMA(KP1_763842528, T5W, KP942793473 * T5X);
			 R1[WS(rs, 13)] = T5Z - T60;
			 R1[WS(rs, 29)] = T5Z + T60;
		    }
		    {
			 E T5R, T5S, T5V, T5Y;
			 T5R = T5p - T5w;
			 T5S = FMA(KP580569354, T5I, KP1_913880671 * T5P);
			 R1[WS(rs, 9)] = T5R - T5S;
			 R1[WS(rs, 25)] = T5R + T5S;
			 T5V = T5T - T5U;
			 T5Y = FNMS(KP1_763842528, T5X, KP942793473 * T5W);
			 R1[WS(rs, 21)] = T5V - T5Y;
			 R1[WS(rs, 5)] = T5V + T5Y;
		    }
	       }
	       {
		    E T3N, T4N, T46, T4O, T4y, T4Q, T4J, T4R, T3Y, T45;
		    T3N = T3F + T3M;
		    T4N = T3F - T3M;
		    T3Y = T3Q + T3X;
		    T45 = T41 + T44;
		    T46 = FNMS(KP390180644, T45, KP1_961570560 * T3Y);
		    T4O = FMA(KP390180644, T3Y, KP1_961570560 * T45);
		    {
			 E T4i, T4x, T4B, T4I;
			 T4i = T4a + T4h;
			 T4x = T4p + T4w;
			 T4y = T4i + T4x;
			 T4Q = T4i - T4x;
			 T4B = T4z + T4A;
			 T4I = T4E + T4H;
			 T4J = T4B + T4I;
			 T4R = T4I - T4B;
		    }
		    {
			 E T47, T4K, T4T, T4U;
			 T47 = T3N + T46;
			 T4K = FNMS(KP196034280, T4J, KP1_990369453 * T4y);
			 R1[WS(rs, 16)] = T47 - T4K;
			 R1[0] = T47 + T4K;
			 T4T = T4N + T4O;
			 T4U = FMA(KP1_546020906, T4Q, KP1_268786568 * T4R);
			 R1[WS(rs, 12)] = T4T - T4U;
			 R1[WS(rs, 28)] = T4T + T4U;
		    }
		    {
			 E T4L, T4M, T4P, T4S;
			 T4L = T3N - T46;
			 T4M = FMA(KP196034280, T4y, KP1_990369453 * T4J);
			 R1[WS(rs, 8)] = T4L - T4M;
			 R1[WS(rs, 24)] = T4L + T4M;
			 T4P = T4N - T4O;
			 T4S = FNMS(KP1_546020906, T4R, KP1_268786568 * T4Q);
			 R1[WS(rs, 20)] = T4P - T4S;
			 R1[WS(rs, 4)] = T4P + T4S;
		    }
	       }
	       {
		    E T63, T6h, T66, T6i, T6a, T6k, T6d, T6l, T64, T65;
		    T63 = T61 - T62;
		    T6h = T61 + T62;
		    T64 = T5q + T5r;
		    T65 = T5u - T5t;
		    T66 = FNMS(KP1_961570560, T65, KP390180644 * T64);
		    T6i = FMA(KP1_961570560, T64, KP390180644 * T65);
		    {
			 E T68, T69, T6b, T6c;
			 T68 = T5y + T5z;
			 T69 = T5J + T5K;
			 T6a = T68 - T69;
			 T6k = T68 + T69;
			 T6b = T5D - T5G;
			 T6c = T5N - T5M;
			 T6d = T6b + T6c;
			 T6l = T6c - T6b;
		    }
		    {
			 E T67, T6e, T6n, T6o;
			 T67 = T63 + T66;
			 T6e = FNMS(KP1_268786568, T6d, KP1_546020906 * T6a);
			 R1[WS(rs, 19)] = T67 - T6e;
			 R1[WS(rs, 3)] = T67 + T6e;
			 T6n = T6h + T6i;
			 T6o = FMA(KP1_990369453, T6k, KP196034280 * T6l);
			 R1[WS(rs, 15)] = T6n - T6o;
			 R1[WS(rs, 31)] = T6n + T6o;
		    }
		    {
			 E T6f, T6g, T6j, T6m;
			 T6f = T63 - T66;
			 T6g = FMA(KP1_268786568, T6a, KP1_546020906 * T6d);
			 R1[WS(rs, 11)] = T6f - T6g;
			 R1[WS(rs, 27)] = T6f + T6g;
			 T6j = T6h - T6i;
			 T6m = FNMS(KP1_990369453, T6l, KP196034280 * T6k);
			 R1[WS(rs, 23)] = T6j - T6m;
			 R1[WS(rs, 7)] = T6j + T6m;
		    }
	       }
	       {
		    E T4X, T5b, T50, T5c, T54, T5e, T57, T5f, T4Y, T4Z;
		    T4X = T4V - T4W;
		    T5b = T4V + T4W;
		    T4Y = T3Q - T3X;
		    T4Z = T44 - T41;
		    T50 = FNMS(KP1_662939224, T4Z, KP1_111140466 * T4Y);
		    T5c = FMA(KP1_662939224, T4Y, KP1_111140466 * T4Z);
		    {
			 E T52, T53, T55, T56;
			 T52 = T4a - T4h;
			 T53 = T4A - T4z;
			 T54 = T52 + T53;
			 T5e = T52 - T53;
			 T55 = T4p - T4w;
			 T56 = T4H - T4E;
			 T57 = T55 + T56;
			 T5f = T56 - T55;
		    }
		    {
			 E T51, T58, T5h, T5i;
			 T51 = T4X + T50;
			 T58 = FNMS(KP942793473, T57, KP1_763842528 * T54);
			 R1[WS(rs, 18)] = T51 - T58;
			 R1[WS(rs, 2)] = T51 + T58;
			 T5h = T5b + T5c;
			 T5i = FMA(KP1_913880671, T5e, KP580569354 * T5f);
			 R1[WS(rs, 14)] = T5h - T5i;
			 R1[WS(rs, 30)] = T5h + T5i;
		    }
		    {
			 E T59, T5a, T5d, T5g;
			 T59 = T4X - T50;
			 T5a = FMA(KP942793473, T54, KP1_763842528 * T57);
			 R1[WS(rs, 10)] = T59 - T5a;
			 R1[WS(rs, 26)] = T59 + T5a;
			 T5d = T5b - T5c;
			 T5g = FNMS(KP1_913880671, T5f, KP580569354 * T5e);
			 R1[WS(rs, 22)] = T5d - T5g;
			 R1[WS(rs, 6)] = T5d + T5g;
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cb_64", {342, 82, 52, 0}, &GENUS };

void X(codelet_r2cb_64) (planner *p) {
     X(kr2c_register) (p, r2cb_64, &desc);
}

#endif				/* HAVE_FMA */
