//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)


static const boost::array<boost::array<typename table_type<T>::type, 4>, 1000> ibeta_derivative_int_data = { {
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0000000000000000000000000000000000000000e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.9032168585284850711226834224884111659355e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7919167471302149857894117105727288106455e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.8402217532088586724785894260966498447903e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1449889671400766256961502493901985491918e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.1304192077168798209720537362353541080334e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.8894663284104037088805917624923892628565e-03) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.7037510984206319021783306002647261753185e-03) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.9368476790910369670266367935021445640783e-04) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8141842505072001857666065220730508719256e-04) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.6950203415824131177990203365349096466534e-06) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0343205259518420518735332481669911487185e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.8061276842462178909118985497273505498510e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2191097963539107993821218360593921936004e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.7195990455409980953587385153068556499237e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.0011239767112320752115061811340852668426e-03) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2486892908052771643824398259232092327304e-05) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.9383979916587334435774060287938424829487e-06) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.5795570734112143788492340885774897019240e-08) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8510678784889979376472606705019899810000e-08) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.9355577628341500944328871478533028923854e-12) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5449061459242510382566663365495531612768e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.2632927420227926179662106959722224563768e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.4810268374236331362483047394960679951276e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5611234416466805636843335630131798434903e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.9159946671589042281490839627098212252494e-05) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.1245216872661445677068356388784065029638e-08) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.2839502404127910102332131278231533750593e-09) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.3456947131687540580527180755272893565862e-12) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3178798704448729194701990669762263448459e-12) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0763308145289139971825935958293944076638e-17) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9323545422421639182144847122391923565732e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6526418995676753841047604087645099726239e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.1192454104473155107389018216315244939531e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.6749192291532778226276649846973671097723e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8903045321116997202073334336428418341196e-06) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.2724474153728842855537484981335019859648e-11) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.1184218556583111416402557340078531399699e-12) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.5337626086753452328495210609408437541245e-16) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.7059999606392573290720121438477592365995e-16) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3216571717576725922006498131655673667381e-23) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.3860109406767343835584120999292115260011e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1399389473488677391810296197268616017018e+00) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.4181431578346228623107860982047022603833e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3224394086197810607781442880529698223986e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.2640556350231245171361137219581516696512e-08) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.7615570135409103356269695535949262693543e-14) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.6835831996654990285225995661517063908955e-15) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.3549528399482585128034968036488346604573e-20) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.1861289721474697586663193751127586358864e-20) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.5330512167766074630890173552599700539358e-29) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.5806912597086173364175746685173336897809e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.5776538995459338722318438495667944805572e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.2135664005037544407270630264769520402088e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6051869823354687204609595426226903673512e-03) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.2696703506639365287291494694106508140858e-10) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.6769118338227600310823332497088881104961e-17) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.1301967667394070880700672105908225699136e-18) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.9567812711150703900877713411857055705582e-24) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.9475844583040545409676373948992482997908e-25) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7137396779652003883532830764440041450925e-35) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.4530392565178753864140325196737674581431e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.9082334876549384358885425325932595153372e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.6527668928098049038650326989562683504283e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.5767264206626401720422957586191109865415e-04) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9635546482786115650097216635136780880619e-11) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.1230398021508726160243445253840095725668e-20) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.5489552282690257658841085642810702179904e-21) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.4406182011138186824940773353114874066023e-28) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.1889043468153358488432941691480203476646e-29) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8666818943878542695166526725683638588841e-41) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.2637302608473859631063477925540658346405e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.1187001104089825910240774958764503849089e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1110028848086130783751393519382210026936e-02) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4955387659880053689236767464564213838598e-04) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.0801830586860572995246132760493878665569e-13) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2228169510400073761556556832453840526123e-22) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.9914947946431214073825583745271796009173e-24) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.8746428244819852363299161694453426804406e-32) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.3233350715618639913508089404863519857279e-33) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.9945904300598675552105872229918046883802e-47) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.7757923770901629399307089756967176033925e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9525126636274211709684054602914073512977e-01) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.5846176988240247151762249811941424388763e-03) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.4074230971324377637183415209351120111344e-05) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.3538783363093509460549544908184939640424e-15) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.6149354701909398514241326623183312541133e-25) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4845504779904566808061052189470179034155e-27) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3033749862333829343173195042033326685053e-36) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0972221639349201108982438389642995954324e-37) }},
{{ SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.0999501682636217640701057065741245300356e-53) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.3037624869466859309736488467116668550432e-03) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6886538006870965542449582987803289569721e-03) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1951402933928053859757464418404898633581e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.5134084455487239707519294750980947438079e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.9969904581388308366847211442839795473561e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.2031844921710485420544341619756568519062e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4309054471930805135738663981506278698849e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3659051225009324414132379644809681947827e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.4800425066408732809342386657350396582405e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.4058896298813515923479651025235834973735e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.5384651836840192327415735948437822847544e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1880743682133350378300742406229855017935e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.5422943784154023113809938266325407886016e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3022863243362333226858511949689753622387e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8400000571295686691197432984829485590664e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.2698463822431760031382074034471414148572e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2688741174899134768098658102190432922104e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3392660539287239444432844852922558356547e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.4679571649476547382223142149029496189808e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.2128068416351086747833294722298974431505e-04) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.6571275834049400163928046057791088638546e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.7761667962783889948186527698555916400632e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.0835203527602123353594255840082951877471e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.0461113814200265662104665633989555426310e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.4319942521795481521787032195123043599842e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.9340628198904193918905065082646443338683e-03) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.7166833367012735282412253037104448120234e-03) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.6855771420593998220619804534172673143845e-05) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4188227491237984615591543484160791917708e-05) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.9997364066071479226504137530550731745466e-09) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.5793457069475070011725354598227339309457e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8192329160609311245704672717633295109361e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.6869704863994002235074666084038431846470e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.3538901576103760612562296368335920604760e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.0132767698295070568656909419234942909403e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.2280194997009398044769029409281809579410e-05) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.1141169089275211261703145535283663560962e-06) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0166887018259734172236587831522154666535e-08) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.8395685458312495274482277625400947713398e-09) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.2572847124500327151746313337460047646723e-14) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0156396422966730978809256324831332771077e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3405158097809984451071202817536174018444e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.4623392423823810826122076982692762961252e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.5256484457548885876034008014594740500249e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8094746525609798225492239511780668993631e-03) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.6301370602027377922664462450211162889001e-08) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4893552285232428903197917307401324158174e-08) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.6324453965393243572025069124447790778232e-12) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.1065319980846698587009600125164805333636e-13) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.9702215258846188955412830932628216622175e-20) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.5717835495085974439595451957584751127806e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.8701544570595412972833708953808859676116e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.2880464752105008297324223711003177074896e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5100834264845178987973850319921728714263e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.6272018932420190654440462655573286371116e-05) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.6541189084178711361550464666176986730328e-10) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.8804930218495612804394340904543004796963e-11) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.4117125842601239708548859154378212502380e-16) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0443281480821551363044135833541336528621e-16) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7088769778924798189086924231456077189895e-25) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.9334491040446585160754178721605156449544e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.0783720981169839037654832015951407083630e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.5275382178554422943056025289308223385112e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.7293740862087079640080030074967678857209e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5212978627874054014490477792555316310355e-06) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.9877667981111968888069570267617448529895e-13) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.7692567660232498970636300545193247397546e-14) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.5241322813922010313046129351950072313946e-20) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3138070735142632605732405540581536107240e-20) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.5866612518024738804667447160170213214666e-31) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.8853878489276097411548750024650021596431e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.7831505581285789478553434459369202687256e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5946787683477326889168827067060104901962e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.5374257999684891458216202672524838111227e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.2850948740322818763772756110495028517405e-07) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.6449627063415894574788277520467653122122e-15) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(7.0604796895657108557705383962282351191447e-17) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4987035664138343367760559845606662329552e-23) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4778346133341293461243199504646665458603e-24) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.7308443775907601039317224055546198162760e-37) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.3427398729006403973360031764043756191160e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.9563940932471037164841360659992053700845e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7538967179800924576287708425452316602622e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.4877806227406289520697257933808993313377e-01) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.3099890450348179398663826625730375321490e-09) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.5586252553586674305117504833573154582194e-18) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.6056389457353696127426205630236739511225e-20) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1672779361065910436956316125650189584013e-27) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.5276667265537852304904946617549741587074e-28) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1607996935755484826331176157028456947113e-42) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.3298698845146369291422458169112738583803e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.6779826560784954699120870015113846045795e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1097695921411112743273657325603820500484e+00) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.8573185706631371326569703872342772082559e-02) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.3530864017557267242895135478069450507313e-10) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.2063747874713322731593360303512466344909e-21) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2232823146731984678618052524231086514815e-22) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.9337416518929861698755291961664733969549e-31) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4782224478545368752036499888305802783271e-32) }},
{{ SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8739301915448936364412188079050039711098e-48) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.1192678405298666491838588171872162935718e-07) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0265585970869915094206681756433014299944e-06) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.1420971552077473743820940489492422068365e-05) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.3335080866861975796756931535135489419346e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3022668299522862705942526009002723188509e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7474478863554803796186809365058650570465e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1273484655494766712059347006624363333820e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.0785542257240861289670594518506500920532e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.3598505052898253193076562446023475107595e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.9882708350505719960041863737734020634491e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5404753025762833877902929374141238689021e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.0984745789382685635059754592873221280331e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.3531516630241160319424635593524288812913e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2007403765054167308709163969885101408052e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.0059545638244702710819625958718089959889e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4716895746899819941560547917394683197427e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1267211978883317637129370575214722334906e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2961004834751997982230628733794695262314e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.7545274355970053671613577544263472765073e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.6918405423960859202686261631450470719197e-03) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.0153744944380096227021927942744093002529e-03) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.7809678739451416376696608389761536323034e-03) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6932674054676506509930241849435184728874e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.3488744877886020634643972355376003998591e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8663025195205668058291266214978967536757e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.8938770132863082602317917903709103708671e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.8377045145190488737140887286790718033744e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.1467905443438207785158027735634892562750e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.3575431639111173750348909771723578958054e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4979235014487266312011205453494034749368e-07) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.5210467841517555880479276578396473854509e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.2532133284507273835961191270437822776647e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.5350243509266489929664607355396580484777e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.5885084238390414963316618123961011364806e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.1206118935059121784275485539431352093237e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.3939419970928328806623417054064758344722e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.5415456568755164781956756730777204111352e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8517528831849226234065430295976739775799e-07) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2848783586778398738416249217855828427370e-07) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7006543893727356331500587501719593425435e-12) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.4210207049475119959105996405730810418926e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0388094339511861784138097839175392242214e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.9275424601912204027044202776935642528725e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.1200265792370742371227819957689499094015e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.2299984818369723447999611623004996458333e-02) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.8721248378519665776579525534932867511808e-06) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3085455423844707632738540480616517139413e-06) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.2024600650909638394411399257535604004536e-10) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.9385020818842164110743657795366778107836e-11) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1099481092763308229549755852509116155251e-17) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.0448087975503028616800600688724223941171e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.5808096802484368405029635692091683145049e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.4777008993047917172593619320280976873833e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.6250819649864877994822789017567360492231e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.6817734518362733153574566741625327607422e-03) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.9681227421276935893799600812296527106242e-08) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.7516971119943317523214540142352689054850e-09) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.2360910118475049496271330498870997817782e-13) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.4662402865363716755546178785795955203164e-14) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.1092631091369379338539271238765486869458e-23) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.0442650883911416774825545456559468902915e-01) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2000393447796098401295591444309800783956e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.9289929497564058866728015364155593293114e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.0786509933632376646219402480304934232812e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.2922811969579401604138811344027004404094e-04) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.7999351144834259220127658270340102956834e-10) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3554588952428463810164955504341129044761e-11) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.7479593283292268702263427704875087530044e-17) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.3454432731042900457643682005528745758605e-18) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8475302386701375918989974700722338457087e-28) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6939429897458035575172348484504924184065e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.1614439535553571571834554825943458190949e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.8515967076020436187548203153668620545010e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.0127554196797450464412282773913252849136e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9392494157543923144982282466755539700128e-05) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.8387829849193163885431926506131142315177e-13) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.2387257559623555437524418658676150430244e-14) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.5189601993282730261257751546810163240913e-21) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.7047037626186601825560427590000374502634e-22) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.5959659496020987385877550366055353256143e-34) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.7699337986932184965123951666222308359221e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3988935655605444628226626266275144141263e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.0650679331753434379711993081368295633473e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.9429261829926774542365970974967095208012e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.9727632634079214652427863275046375311160e-07) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.2685371106715272010268097475929349987555e-15) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.7562714621221363139306898648641682858983e-17) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1107132932124667246735501340405812522868e-24) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.5382464936348060161531306957729107527021e-25) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4798021842897408381295260919139524111128e-39) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.0681634771656700671560886370697646289909e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.8005340976266985463279022901482473710270e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.6461883252789018114950879400019117248538e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1254005749441233251173794165849258031479e+00) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.6063375269788438165858366656105766224422e-08) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.7588274812485123929136775077979841335749e-18) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2658971264820020438607047369875355796104e-19) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.2036581102733442077767600267839247274220e-28) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.1899186988088799498936588351493641477240e-29) }},
{{ SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.5147195098895536857661597473615130213257e-45) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.3047763145512719675468518857140276724305e-10) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.0078948879525569401376548995535605201527e-10) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7753746118995747266366028006708512642597e-07) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.5619672298075893927309044374825474359204e-06) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.3187928072407461757667823841014178711607e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.1122078020720250089605256983912764532892e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.4939550810837074420014767997019939902291e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.9658743397758407826186466102410972186751e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.3831565789579480345950269550287973199017e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(8.8947588897415757819391869931176793617707e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.1850423549341839974761607156689838338619e-07) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.6552537882382467667720383571086416961540e-07) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5551314989142702452476387594116223528045e-04) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.2114131635674941102451825156524943188130e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.3115896612330311368837310028405276222981e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.1179477506373022449580853692674840447861e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6338211797361160426165063896358298825130e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.4318085584938914523299950199835071994378e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.8714648609169868627268703839659789064134e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.9878271186304464622441785767613957754752e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.5812145408552444553592937674622478447104e-05) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.1773363808310924803116007208615776887091e-05) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.8936554509179991561691615587927682805795e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0203588084093618730991017078462442533613e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.6090888320011916949589722440594660613322e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.1400812577817507531108697056056094347018e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6681080929609891048633934686780544763588e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.0031006050174044553905693094383494154964e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8254986535688346523574737903248022293774e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.5959239775357665774242893219008684509553e-06) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.3463111194468987900148313198159272823725e-04) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.5339944225976438838358673241131889609543e-04) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.6027657313385197709262905376395314168102e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.9713089550037856469057407327442272496175e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.6842385819186303925530875018544087978917e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.4521836718244184586099770222962028891831e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.1577758928119556847812626389091104058916e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0067071891506662812471697131443821317789e-05) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.0640866143591650414292636889862870032462e-06) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.8297021639430972999538136211391629118595e-11) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.7778928493034115150770290798230628297836e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3038776245196366687674705354958921803481e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.2106986117944240371403318418699983663980e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.7844786298175235275883493786720041329353e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.0136069219679303525993661741211145753845e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4529430858406897305862734986116483065877e-04) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.0525557581393713108808835643744727222853e-05) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0344089967554682080518895375642996297971e-08) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.9850801096777665046025138753968395063940e-09) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.6929182156598221428833318460435498133416e-16) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.7188036955017883565121551274053401038952e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5581105056071933354405273916762268675739e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.8718162489042191633705243799693449640736e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.4513141550180168120776133014781812216006e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.1900961400883926347044846519007192122920e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4454277394298492133178432523538948340831e-06) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.9097531636358301678176673310693017978415e-07) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(6.8788009135093977663234950586182148600769e-12) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4189933434178077543916130916463680567622e-12) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.7217937590151221438769817809057950068822e-21) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.1465635342615030022386754052302159292891e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.4075537911276544133402143233186745764334e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5719612161632270089889781091496598249378e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.9123117787297892928793404676304749212151e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.0256779891706610351166865363623357994124e-03) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0582114511773971755472433165413172061646e-08) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.7926373270067503109991614659354544816226e-10) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3663671536945357817524073713805871513315e-15) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.9640141976533146192335511643139020898475e-16) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.1721504877899302273380803366959168241029e-26) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.0365546120610743273988023671683368517629e-02) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4934483495321693826106201413348645394042e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.8615338138647745142727096661473929426707e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.5638334390508296162534805166856128452823e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.3455000783740062173720494659974849344158e-04) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.1650314325423149441474286847962278402277e-11) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.2214236930814190120026239166882997854343e-12) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3109827814294226487078151716330806168201e-18) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3818867044321451601737117058380524780467e-19) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0088213936372466335112629685629232083366e-31) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1740241383932947760938795984032429089083e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.4552118316440678178025879176079238442860e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.3636614555996903878301391641458746704007e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.2790701049249313710035585524455275630605e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.8010759780567870583420662665761660539361e-05) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.0087994808519078931823765523807692561873e-13) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.8871619741926915445540924045869674445225e-15) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.2768853328243019162471887616558157047050e-22) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.2226042364913234816323239071338826009135e-23) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.9249467490188410245804368711890198864863e-37) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.5404974856524281477628132406017574775950e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.9396368204847584418422322724669513286419e-01) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.7767132524250047204305274194644782588343e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.3482883101639993235364264323310231757847e+00) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.1534714057482421773843552888544460459430e-06) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2747610618383836831498426409911843344203e-15) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.6343473796489851044729698382685153267231e-17) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.2112556588041242764891496116059956053789e-25) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.5240773665625892783983513968875237033960e-27) }},
{{ SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3256560182568682435484280054292161329458e-42) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.8589192761781725600408738341046477052888e-14) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.2117263463339020909172374892078674574779e-13) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.5493799211250042301219236548897815579564e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1287232031819278082851182604644155104984e-07) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.1124364624330288920674009303351621771509e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.4087357980222234348196342861220031790870e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(9.4981969624551999794572079598894270300017e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.4912133052706246297905919694394903699643e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.9893955467171736744168790534884269893526e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0249516018374236051683116195834443714077e+01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.7310927878100695030972871204558229551740e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.3914221241992956298489619120372786452073e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2223871308266607688451788651390267435870e-06) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5469736106741823031925806168065172502065e-04) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.2157942459023883606621832606301049714541e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.5179608327085924638400833441415827463940e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.2109212046952620757301502186176729068167e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6452016872685488593937765899882055893534e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3438592257588192731175688593752977419750e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.7601658378577259250036576893495987157418e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8657507425932362425532877365983501279570e-08) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.4585250129374039206366889486346420584880e-08) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.1302033916345056523247524102197888877903e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.4018676045676159159796420613814591079421e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.0121141675156614320946620387535019129059e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.6170281198864484447122001906661388990894e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.6369137448928004122189237892434008036463e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3409397662463438334790082376394686145935e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.3668749563020072770372811615104168732839e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.7745089032091745547428835031216261806000e-06) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.9840746168283612529908795057341608471215e-07) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9983065445575519908171319433570621720383e-06) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.4357481552948402013958970303696766737496e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.0341995860771458030895918358138438439364e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5153672057652988994600548342333225138359e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.4353000700410651244495527938594916812403e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0035024555202613913300929373071279116910e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.8439351093821385926694314266171062229144e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.6913736780150631813383642265624431978161e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.4039169579589277667480816976364410008131e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0423133418880852108031051891302277336012e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.5087582128905906812413691122946003597315e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.1880717240508245265841779498745925321316e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6216812219121657533758658402938719468096e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4432967961153645962760247568017421860066e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4394404453846933564763529228259786456032e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.3367671788962629314507690783892416531486e-04) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5656273228052339809402664430712796461823e-07) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.6712678671460151714317503761623815295657e-08) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.2975994432364024474083574932037714479194e-15) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(8.2499997000422239542805417050352094005929e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9095781198832154874006512187294777922959e-04) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.9605862802253266370072677761404208631142e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1305445534434165481486553249232383309047e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.5927129900307170377177693185961883432766e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.3112440347630669398015685149968445121193e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.3693323915145634414579958002947977610167e-06) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.6804018943745162890932837225850570270583e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.5839625174318664793713231921030974252475e-11) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1901027784310504331247134745889291771885e-19) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.5653534250536706568245652854403641940226e-04) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0162039711354492754764927161178957831090e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.0907405047130117146776405127845606762463e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.4673455595107095509199011327771163757075e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.2525077137735140051189777869324047259475e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.5945541581505437065651455179215597597055e-07) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3786286441842058468881127309249472479714e-08) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.2609642337268330894675228601824080148206e-13) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.9224585343546301002152580427747690507113e-14) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0650326979248136535965733767944986897248e-24) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9289974820313418706324924815700465889648e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.1291544826085734467351292753397402427234e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.5994848378538674348487974891557569669644e-01) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.1115829812287437194490602843628219509313e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.3085020975106034422831465504496424833690e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.2239061887192196648681000670473780392460e-09) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2821717903286001764712447727478318901103e-10) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.2248554071511061974840512557245683610203e-17) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.8738527585134179751750754668527828821257e-18) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.2774327252649202087379833536813436720852e-30) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.5993812076972194696775561490405661481612e-03) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3584875824393454327700637632446856574235e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2142561481140646097210240080707030170494e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.5475655121395693727843345044121096630305e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.9393415239542776996782071402526386692761e-04) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.5434212823341218142409428541308778417160e-11) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.5960307045511670027322982798374216434693e-13) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3517363514623088009829917718521367788412e-20) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.6111504467572450266852985441018524765707e-21) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.0263150600324755711191285033556147084647e-35) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9048846409915411117785547578210346296701e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.7708922597007267373217491939599604132807e-02) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.2216030274949084964226625745676693157670e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.3152380948858073222590122713312506404639e+00) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.1148824815521023725000077066965578105224e-05) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.0374605578639613996545372743081782050984e-14) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.0606672517442035432554647581844523605100e-15) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3119112269967736570432322272314898414415e-23) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.3058442727066307354881207661650377511988e-25) }},
{{ SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.8794519240602118874550367671031767652691e-40) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.5314052581728160716689246693563026647729e-17) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.2272520137820137775573215355402709924110e-17) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6385651586907187777436719740160962864069e-12) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2586137128998887965142185719988213235827e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.1978708150895953879238729859097162483680e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.4883785154953441059995813395185337485973e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.7043952167699700505004877417997483596174e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.9032111494944699750959662130617012804831e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.4299833840702467454424048837867644441160e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1156740741997821103699668380282361328936e+01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.8593522605876278614806135082352199093383e-13) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.5177150150990584073876319580174087160617e-13) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.6287678201541491816929241206014558489854e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.6459800023587989420188281367186965047051e-06) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.0770729222621222872265688120617236170858e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.1978060153633050049505041634902767707495e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.3452979926341053252901306461369247695159e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.8916635191770269976673475927219977693225e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.4421091203948250060362882191211392863510e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3252424556548581910551543944541232059737e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6631525796786806014971471750991275380238e-11) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2348428353715295803239899304653642958228e-10) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.5266105808326678426681149928977249550119e-07) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.8328882268096793857707510650248221406235e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.1457048681533156345779275870102898699766e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.0773509161269311650401560748293191757790e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3434687537254587300814612103817162360281e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.7252087393054653029841803690606131094413e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.6637090537173846369354103613423125134185e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.2222765386416085619980764431870982742515e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.7583078190146288592487126460318125196287e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.6999962750172536416931830722039483618295e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.8984712361660619687641273979401972166591e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.3627945978656552431104857265659823497061e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.7486385527992606348548665386413888847477e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.0227687277732482107956625404868761686189e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.2267781355433824300894529339933263155316e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.0282777225103147649259335958220681680725e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.1699233792293245799505937684836683189039e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.2775141404691442798359463941447728156689e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.7048696843432611865668368346958442873479e-08) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1549829890752526231190799806360963328495e-07) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.8711295654014086613162983226274067505404e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.4564703084657580383648913356674119577281e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.1467220558530540079562754039648447763996e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.6461093944096208819035127660522390991648e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.2114143867360521638985933184556654267162e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4367010880749552814115265090985561100772e-06) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.4319564010859054500359734959437926869158e-07) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1168133700172827892071278142678791772585e-13) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.4964465782619880009974340163483355285358e-07) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3480160897803109501873999482521442811192e-06) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.9780013595688528565995636337587848036347e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.1330908045995875901428447894926743395734e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.2010639348672211537781383461752781275590e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.1286962423543842627117655497038676373120e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4239620951202638441508451809444583104666e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3644604646464295018013910194295505468457e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.2139280268470517312284058580070723706419e-10) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.1919725287534054925383568773715012797170e-18) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6608403841810810837595803900274911038841e-06) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0554299605286179324749393136999704606029e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5368338954399489758162830990229449870965e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.8492422042501632159159965544619660571445e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.0753087423008526207285483388126815975619e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.5157785754696236793151832776649170438551e-06) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.5563346409283582812186149645600484467535e-07) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.6104329768226295642208824499887004737550e-12) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.1148067034774046678534548570986763827841e-13) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.8860540734318114853186565108341475874946e-23) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.1996223371991909509793800352781572528745e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.0984537243569657271589346088291731067040e-05) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.8530864839700265336654909164137346756812e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6230491687180245943491513346280308408327e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.8112196530439502501241177848086740627966e-02) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.2853402400515270577062349188912379504678e-08) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.7260402500776298734186226663213065657882e-09) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1269094921331629374526617282878477629336e-15) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3965683381529389543684606011022289297640e-16) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.8043343561159759289631984184624023000791e-28) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0400304696048005820358621781737685259319e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7729412036468448477563026495962583901078e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7541776200658262820723147015311995933666e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.0265750184080550895637409774144790600175e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.6412480861077969984279315626626183273901e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.1103586380917987628857566575792374128597e-10) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.6443434085791807058343486952683996371278e-11) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3636913502035867228520256579376568034250e-18) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.0984007231858278362968567644749191305440e-19) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.1443009370660671658218951726476770587589e-33) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.0495938255571150771537397868933036180788e-04) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.0383148144949068233049091443528102952021e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.3294193289394081749837571157335008593053e-01) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.6477062410598318036704007864113310416301e+00) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.0581643288777847741570121164244615591572e-03) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.2466956974441226464978550896788209792419e-12) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(8.1680848523584561866514904465576674120956e-14) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.2003005233316290549091249567124008141634e-22) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.1457132919602519422343649191798262338963e-23) }},
{{ SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3502343094728627442911424296974319771894e-38) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.8579790830126386731541754513651320008970e-21) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.7099129007073007145104761567298758110716e-20) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.6626553440496532286168857396573444689670e-15) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3525328003537607256984325254545719924335e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.1848456991650735658313903001970703462884e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.8298908209909537837503266057105278806488e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.3016298584257794047311317820758239901172e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3266507809012516306916959391868813889971e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8420209461038968259397030125781126130414e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1703659128200708561847833279481070602080e+01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0836829508536042192300113035745610851857e-16) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(4.9201469353517525341302128476017938474232e-16) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.0758235075177975338154468870925850369589e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.3563266140024278294145466693838119709760e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8150227075580437180967508116004581661724e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.1193287196819065136845514226981492669533e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.8087417952976414946905220923715546295144e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3510263136465965182556309386961540332649e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.7991959878268732031027288258170446063354e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.6101834875331840545085987059525271379681e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6783182220561089710406326129026563215681e-14) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6060095270370754519298200364215815621649e-13) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.7690613938652452682430385903585559451542e-09) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.8475883501497897327636555829328896712980e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.9374939782783377777324612094263458635669e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.5249790563839362496674408285438401121801e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.5153095865468924472179602271651354978185e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.0026631297106442679840049902684304726449e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.2500051630107176483930945657993406490357e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4327687376369294979313170274958739538337e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8496630878160922530003093297846680746667e-12) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1965072164157514041548582743707274768594e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.3061386784449606523900592848698268629911e-07) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.0088180727890712440803153952205904802230e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.7205849834411491530467486146085757275180e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.5398400463304900145273316393345552405327e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4859820045886373268364149342469388872286e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.1038814056711389896963972977211612529426e-03) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.3870488138407026116147792181401822379764e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7950573002578436570028248746689631886599e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.2068784940972284161574093114472667104752e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.7175532988737073065633146381685615947355e-10) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.8185582904145612049003125657888367289659e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.8338635207616363062957922981256970808572e-03) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.7965166468118371651251694257902965922489e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.6308857720491227790991839819253187499224e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0246586048480201448794324006458170359032e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(9.2174180428434087283590867134385319837797e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.9398219087112187651944544418094759534189e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.3789714141341715036264028985501218323309e-13) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6439923699030690909004736379048188428978e-09) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.3836280793030343378821459728770724626504e-09) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.9810368478110583651037373578375703175365e-05) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.6998886886645023853464074850000750022515e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.6935471535879828368261712458063843574292e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.3152140454587766826664092216398774631392e-03) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3341507085507655646962325650695254482725e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.2318541241253508679726644640941164127787e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.0884025209548156711050623273590309380502e-09) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.7083238811111015928743454570555497517743e-17) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.9033612528759818983907454967089712033395e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.1074201560444811755310330666369310976909e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.3246650312206513226448013062007698137338e-04) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2327900222762794402508099291193200534483e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.8074759100309923423115618026349599976061e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.0889745537462346132825301800548811913002e-05) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4475663751173453239892770886087638430865e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.5039376251153221385235540878657316029258e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.7105236790549162182252566336184459484252e-12) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.0708413935901900411612534852007599531613e-22) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.5805743809443568646558951887231297035656e-07) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.6758210005266161999506519150624518451696e-07) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.8554241716837645574281836677372307339298e-03) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(4.0374266915883969381556160012549367762394e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.5613103540247291992982862657982127931915e-01) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.2036072612279703061317207938584936216272e-07) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.6523186989192801670999119712294558806455e-08) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.9456559698763902686046768882569322447602e-14) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.5966633922444589454900144246207114403184e-15) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.8097589987782515810472465588017878774133e-27) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.0081213638062636620500254848552479938707e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.4813649876001588927450238064666155376739e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5586935164868024651168242822699834703736e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.0156038876556603459187946128272152648499e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.1377305747667292254146390753185729303408e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.7328487299503598409266706813071020727290e-09) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.9718635333655202430938266567365036510801e-10) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.4126066299932156771060117731080140464914e-17) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8419316792522188012326562877727310982751e-18) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.0240504686777685221770324686722016943620e-32) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.1858503448297953185796739487064473915653e-06) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7221846154858516570061402646513228250020e-05) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0822798268645735297176725643984047258829e-02) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.0604085377612640889992100158251117084146e+00) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(8.3116974828519083693593654623386148838235e-03) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.0259084172049437401514282667606363326037e-11) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.9502861672159909179043469315272085414237e-12) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.3804689781713675901317810061794748782350e-20) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4170782932777880378705477050631655048455e-21) }},
{{ SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.8432273705025734190875231272368293952905e-37) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.3768256975813143670514459867228499943099e-24) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4534239766394140631027705520702049833355e-23) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.2928263280034720036030205462127068750230e-17) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.4162516476476125172328824672889694844037e-13) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.7641517010014888606109040398873135149687e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.3532820236823288452164261068506470749188e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.8620204017313107622194610105163538134387e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.8168583013558656590601476667430400463579e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.2945620577516229496555233286365994464451e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1963087049228527478951972739657584134341e+01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(5.6473204520054719693736629053766336843803e-20) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3209352256836467989397729359345092872760e-19) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.9470449087576975971886665276653632101862e-13) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3271113112073859476698086145563630100343e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.8016343118694453856208477962510438892273e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.5082251078393019233409140228517803765958e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.6440629525459438367881704414700128450454e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8537650862636131069195824459902364842919e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.2846710192359505993889863482579449764141e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.5967021277013433730442570117766802537711e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0938112142129407414033255283671607776287e-17) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.7495838807424212918686641806098422411861e-16) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.7611104244414816819265724086646362578053e-11) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.8673489765250991542067307168665112403648e-07) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(9.9956943785115817776784035553696018249313e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.0101812430020785565184349305373458648481e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.9446233627409131155601888031681831018352e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.3486634878802579578616858387072985529160e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.8063535614377932743843544385014618842354e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.0724498058211847459532577118824982966673e-04) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.6751823580242129081467672154597713734428e-15) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9986780332831081177825178751756230127724e-14) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0908909690450423508463462386382218075183e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3433446854297017329438332197236548918125e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.7343007645805965338486441179614994405896e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.2073550044551022074739820169344805132318e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.9779591442979623977094774002194262589553e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.0050303380015457626949064742264656948613e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.2314729143742350277994560049778818415774e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.8234592560887026975179424394343566976032e-08) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.7469829740224973046405017346689716770962e-13) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.1364105230774505929746641073694082710979e-13) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.5338901489249544238322969587318040032476e-07) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.5183672655427155790642795570620461452449e-04) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.5825203342443035297375030568654151403297e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.1642365568659512237082723602830467825100e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.6251421263080698617173296912566473580614e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.5153241627508668587235327566736908973792e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4889610958828634452410628281290804873166e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.0140440609681635422459423062815677181235e-12) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.4359447573890805809837690008305904427848e-12) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.2309819096337732785115280294405576732564e-11) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.4687800433087415456098646026208196663028e-06) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.5219608888446514189938221261791602127545e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.4579891909134697231396244544510512894202e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(5.9970152702782198218272942213556513075424e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.1743155478404204298903564873785255300745e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.5547319586013048181879708644268947285186e-07) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.6648302058649174815577537506785008111865e-08) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.4695741091268240675242277382991821765212e-16) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.0979664493568338616021701234635533563538e-11) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.4329450240272112998080393114490767137267e-10) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5039225667586606955427085020814596436147e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5915049184809819763892523702010364581233e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.2433553154006605521020451606430276822526e+00) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.9466121685732523703849346008966018414053e-04) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.3971485081365220846337778523364944886486e-05) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.3734359881811976523544368554895167269242e-10) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.6842703141585998370669412225218605121344e-11) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.3903975641979998994488255844583109620531e-21) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.9511069429941800356669466231701077809277e-10) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.6981411900051915421379052932884193678812e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.7778914033008029115948347086761396815572e-04) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.0311030409341655905175188484177570917872e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(7.9031997460556336933846795449818059353999e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.4235358627362469597433123881477071847953e-06) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.4257124740893478516993386127979655779596e-07) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.1243084201089820906392788811894523536760e-13) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.1722204086579557738493113382831717768373e-14) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1576560116801300328601565687924200815265e-25) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(6.6998832264022628764156350981565374804029e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.9967196335110948800566835343594125669575e-08) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.4958873002214390720603252900104218460950e-04) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.3366029787009749295192872970091406238283e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.0943720711528264491654577267390511698564e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(7.5614599671328604829212106449959923478293e-08) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.6825857123609093317620360376424768611918e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.8552310110192809465785860769779619676756e-16) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.0414343473766853609406088281230471557050e-17) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.5775283440074812834452023263393582453732e-30) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.4713521369123691806558319291752087306795e-08) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9232721384357527513456084827218099767723e-07) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.0169634027707976454039140703885161899143e-03) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.1500463821649914647178648715178596271806e-01) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.3957877958408549182993621226301788967074e-02) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0237024992302913113334498246392547428106e-09) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.1353557182206013755982210432701007487575e-11) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.2988888438406093135298077619391463256584e-19) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(3.2613605028520304134537728504646417004533e-20) }},
{{ SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7025771971814851440315430242837625403521e-35) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(7.0524782084878896415293217575021345867277e-28) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(5.5857163745753595165551739237453030319740e-27) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.5164545944516152928107531131956931768676e-20) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.4547588335723861258798350843365807325794e-15) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4130792781095808355748705962826193818772e-05) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.6898703095228407840923929168704011902472e-02) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0301451912597145985293114966235332409956e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.3917744682202598898535203145862445570377e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.8173153471609168247929590030028311216187e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1995623163183500877191720785315926028714e+01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.7045260576924946462140091380583631233462e-23) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.0599244089565074872228441412892390415253e-22) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(8.5476181859380418280906231688138774379890e-16) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.2002004293955936586750428141659214529290e-11) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.7042259966964104359504984039291523022757e-02) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.6484358669706604106341632656652085240316e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.0397636876776826498923908643746491366385e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.2374806759175698646654996712918747408278e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.7554263354099324230739293297831259243326e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(7.4392684809941886867450560591301962535309e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.2718696659183478794254455359657545711235e-20) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.6640505431053915602603283163990615574445e-19) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.5512222108629114795163063998114948067256e-13) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(7.2891403526076571592771489713627334247705e-09) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.5022610160753848456960960009290469175849e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.2172084029428879176457647839094023918988e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.4008825367858979405899290561347095051943e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.2442052316487882284694164908565983507157e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.5007012232668770239968836079914983459805e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0106027516768307186286461655785006085113e-03) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.9706296493131221398525596235789676170215e-18) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.7968261287789775853457742278689984681944e-17) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(5.0419053859025813904504021069415528248291e-11) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.0242831407701197777697144728689283880514e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.4746733336516424994992834798853987980141e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.2042855806597100651073474548452893068907e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2042121826093070186726052747707486163287e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.9538620499764363465588562352474612821502e-02) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.3189520230565280010436899213474846363281e-03) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.8563698867818919898649791143269977061739e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.6839797278526559249426824792277123532112e-16) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8180603904781437193996685264702571368188e-15) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.1602560237414802483468762182543757953075e-09) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3394169199064174144595873057562014033732e-05) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.2607658144263244142599508502147097826576e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.0226243444150079554208108531794558657160e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.0384490246933290618901009225868957929817e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.7909476127044074523188465999049287828046e-04) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.1060446684879043063243520483493355970242e-05) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.1224270245469358892329302088249059403789e-11) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.4189626466017762117319216600606905242641e-15) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(6.1355731057242963937742416074336528895343e-14) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.8052916452129758492242750897603341979808e-08) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.8537939007594467060615261862089655019566e-04) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.8060938768252964850537216722019352366832e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.1518127934399138512248655234869690589330e-02) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.6491262758399065347594396064877048987240e-03) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.5226736828725387775644141162247313980470e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.0770974447610543365816254046486673834429e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.7720425323507472450706077937794336165428e-15) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.0330629503801759032942343128699963308872e-13) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.2735789528332142641562814745423047399062e-12) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.5744312127902750692353195756004505149473e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.5780873017231029284483564649301358257993e-03) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.9413322392896485557288661527252607748893e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(9.4221215549270207027932614864479448051304e-04) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.2802105739971065719540445840026785299629e-04) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(2.4945530636867215278695081314041267412137e-09) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.3458794374105118507308760070204862489310e-10) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(6.1855723946810904999498245364795456914642e-20) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.0087509280770786724218122012763987970460e-12) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.8125261091412248275206854267355384593087e-11) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(6.1671467116515512999879506094524005234973e-06) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.2106071941504521630905239611039644499896e-03) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8343816519011428135913119490941208568301e+00) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.8286588985823695704498802345993316492048e-05) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4170138408466216364545842510525637443736e-06) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.0060743162830337997869765742342674475252e-12) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.2342775957715378677082754672856037481729e-13) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4803803319335332094694562082803537746123e-24) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.2892005544542094822530039120281247191414e-11) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.9055106284843419181332447795545426138539e-10) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.2734544645312891532074379871580457022874e-05) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.9711309071778992075023393167348062531906e-02) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.3067418717004696730811737322166916005991e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.2730848761493732717399775351838377628752e-07) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.3708976873735970446423698115851860774549e-08) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.4211386352863426165185563237032242614945e-15) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.6063762617429963794982101443646285269849e-16) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.6171910423115371785495835569442367788599e-29) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.8029359073696633858227859102530844995749e-10) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.5615546022296353287742237624591993052256e-09) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.3083017255263024070707998835343148806002e-04) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.3346237252931012315679486921422637055247e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.6902039384246161579512240343093105185675e-01) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.0844272997771515383429958676727509721187e-08) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.6646347856978107597425937271636255337542e-10) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.5755600395664627569416180341144168930073e-18) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(5.4570655246210004841067394613654189575725e-19) }},
{{ SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.6067516465961476971496213375304486156258e-34) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(2.0618544942103801838853509996155295285845e-31) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(2.1151310537152287042086352965300278191863e-30) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(9.4241389879678262573137262821839177190490e-23) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.4723579988499519382465038389611165670172e-17) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(2.5340249432395935294623452903187759297886e-06) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.3170183808525082056008023392477068202964e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.6154464001709651489171304863573507263213e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0504817578308945871428988353585610670667e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(1.4181841350021806993077388293446642686354e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1851524199087786305745119745221586649779e+01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2124066127325174115998523575512276624210e-26) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.1960533475691015920482204121988354463138e-25) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(3.5125510783345646254676238667015705116870e-18) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(3.4144875038021095657272305217701390148523e-13) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.6861092463547468731011348125168833471805e-03) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(2.7638611916780686431238208891450018024569e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(4.2124706226138777962468065908725932959324e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(8.3762172419122585706909760040476902930337e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(8.0834351130935025657081721929349865570971e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(5.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.1269963032566097070633540906643938004727e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.4984126254497293579176445577780306447685e-23) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.4215320798642930126833415388419118114936e-22) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.7516706950661382758052688367728840081740e-15) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6642956564879110072657400599192399830774e-10) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.8214060595070911352851787203842505453557e-01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.9294030227323529053811887758023049562037e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(8.3502507209777832031250000000000000000000e-01), SC_(6.6417470055044866008517435888848659200663e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4037836972549325109088301927724344851245e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.6839410017871502191582623870306889735332e-01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0000000000000000000000000000000000000000e+00), SC_(9.6887087821960449218750000000000000000000e-01), SC_(2.2524938810862095081211259263349580300966e-03) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.7240668028596286653887291247503943591536e-21) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.3975487014631944936312802259116605728792e-20) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(4.3348410850293973258719497840868886021391e-13) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.6313169313292445170576551629017147291911e-08) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4236527029076449184460082534739224572747e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.4936414079908625201957302297528129913518e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.1058657631416366199576267036907074127176e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(4.7310263650156370629281564174172472328744e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.3329811249001609760252476171597116901426e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(9.0533155988708181425347242858430303356633e-07) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(3.4790742662278084223551773815292581240982e-19) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.0523541000156616742704519244561682601556e-18) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(2.5669068014637515967625022495252807713088e-11) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(6.0104419262178309995704628477004854497116e-07) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.1827464040554137280633135412478028666970e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.6209609913386253573118287377174105497498e-01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.5098007045212061546475603156388224535134e-01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(5.9933651708971837824433356570763999849678e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.1126643940430601697578354283798460773414e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.3677662966718905598198990214612924902052e-10) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.6469767985452090018363939191284476341561e-17) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(1.3895740097161584984123744244701172009132e-16) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(7.7023733412182693945002584502211787808185e-10) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.1221528370251312708946342147971767349962e-05) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(6.2272536657075781814182562554741898750804e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(6.3583038320950275858780221746906173369262e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.5157421744747750873096774759912912808009e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.8473673585301652794188477031294747983122e-06) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(9.6945430987671977519684276061615019412284e-07) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.1000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.0471133119260994511717556154781184581911e-14) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(4.6965288149086090958166653910281599176278e-16) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(3.8106071618000543777569623421742601487525e-15) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.3922100311455543760056317740331209246191e-08) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(1.2620115996277450424997365174953625821635e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(5.5846673281830696580791851106974286945189e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(3.6781315084217052086014842166911050962964e-03) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(5.5141320347709790491182302649051260681043e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.4877237660946364790041926957588846093973e-08) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(2.6797230189875633988599432969374123432951e-09) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.5000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(4.8288219473960672136187562353530104816312e-19) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(9.0173075326342807819434121980487321584976e-15) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(7.0358578454331982473810712096235297826213e-14) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.6943195885832231709328334925596189492155e-07) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(9.5561962874183677703911245705991845046235e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(3.3721620674143996051532919558857473585821e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(1.4325955877968320041801220462036368679062e-04) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(1.3506392533316301611285325459045117286369e-05) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(3.8733908805552136034305659064788554915374e-11) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(4.9872696274869044086492072539233061720526e-12) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.9000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(1.4993363953835269135097568636823803801720e-23) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.2587288058104885333881886203263412264494e-13) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.4448558208118903495268690778360651877568e-13) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.4991369364448091261246814873048070883719e-06) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(5.2609257960043299659664958370920817438753e-03) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(1.4803859998527084654420857389801067340171e+00) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(4.0567230993929465814460073474746767255541e-06) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(2.4052320001537906062908412095317336255633e-07) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(7.3318867831217361012863757640290923725842e-14) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(6.7482503975291755885381845732271826547738e-15) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.3000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(3.3846391540743696119389862727114852905971e-28) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.2707412242889404296875000000000000000000e-01), SC_(1.3504856911851851972505888781380439345662e-12) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(1.3556346297264099121093750000000000000000e-01), SC_(9.7448719187493771551964614639834526498524e-12) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(2.2111195325851440429687500000000000000000e-01), SC_(1.0195060415611269968650686323989425889496e-05) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.0823621153831481933593750000000000000000e-01), SC_(2.2260853783689257664796322826882999268624e-02) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(6.3239604234695434570312500000000000000000e-01), SC_(4.9950981484474557493841195932666298154387e-01) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.1474220752716064453125000000000000000000e-01), SC_(8.8293685866417562283040955441032546432263e-08) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(8.3502507209777832031250000000000000000000e-01), SC_(3.2921309785292367441565271327137398845465e-09) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.0580135583877563476562500000000000000000e-01), SC_(1.0667009964751525320973325774852377604550e-16) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.1338449716567993164062500000000000000000e-01), SC_(7.0181404630079437293523348379289471772848e-18) }},
{{ SC_(3.7000000000000000000000000000000000000000e+01), SC_(3.7000000000000000000000000000000000000000e+01), SC_(9.6887087821960449218750000000000000000000e-01), SC_(5.8725698522226275610020602694401374349781e-33) }}
}};

