//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 432> bessel_yv_data = {{
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.177219114266335964202880859375e-2), SC_(-0.4109981080896677237358777348659577384814e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.22177286446094512939453125e-2), SC_(-0.3967198166482792888587309535339999462266e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.7444499991834163665771484375e-2), SC_(-0.3196174808457488271204616814902805588745e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1433600485324859619140625e-1), SC_(-0.277886401743182085883175930163269197664e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1760916970670223236083984375e-1), SC_(-0.2647863781670063492437517931273354439201e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.6152711808681488037109375e-1), SC_(-0.1849304044017019356004789772749790770502e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.11958599090576171875e0), SC_(-0.1421209575863162389893134075657579819718e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.15262925624847412109375e0), SC_(-0.1262161021028632624881669027784829995884e1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.408089816570281982421875e0), SC_(-0.5944072046497630295250342068284430797962e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.6540834903717041015625e0), SC_(-0.2453277969150709954915717817184428440924e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1097540378570556640625e1), SC_(0.1584374949163769422822208482661516201397e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.30944411754608154296875e1), SC_(0.3458497563774182491234075001630772667854e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.51139926910400390625e1), SC_(-0.3227704013798722509157489558679982720248e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.95070552825927734375e1), SC_(0.1703157314350648605712543095319781057303e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.24750102996826171875e2), SC_(-0.1480199026826370992952794039024870144586e0) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.637722015380859375e2), SC_(0.1495108590261458231741268546248788758226e-1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1252804412841796875e3), SC_(-0.6570327554025865783732578959902760519929e-1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.25554705810546875e3), SC_(-0.1424286729418854798832322396053032304441e-1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.503011474609375e3), SC_(-0.1488793551072535726513345519376745937703e-1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.10074598388671875e4), SC_(0.2459116676878273669207049701272585713077e-1) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1185395751953125e4), SC_(-0.5216296486026963890192536381882756251574e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.353451806640625e4), SC_(0.7150321510933910509861478052167676486744e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.80715478515625e4), SC_(-0.7217584852080900819222715241239866307669e-4) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.1622925e5), SC_(-0.5289900963274037297853946955886625205773e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.3206622265625e5), SC_(0.3201736535368103742253839832309804984043e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.3636794921875e5), SC_(0.3530160743525716867126510667470988391367e-3) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.177219114266335964202880859375e-2), SC_(-0.4110719287432131383209663091223613660449e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.22177286446094512939453125e-2), SC_(-0.3967931677865958623227899442296989234961e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.7444499991834163665771484375e-2), SC_(-0.3196888768021427112833222816547069531807e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1433600485324859619140625e-1), SC_(-0.2779570979763027030915138623734707116309e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1760916970670223236083984375e-1), SC_(-0.2648568990595505812071805953119049709201e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.6152711808681488037109375e-1), SC_(-0.185000202041826350471111738892195254951e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.11958599090576171875e0), SC_(-0.1421904434134942202214431845401629010964e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.15262925624847412109375e0), SC_(-0.1262854140408887233259773811621052871948e1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.408089816570281982421875e0), SC_(-0.5950761265617472237995217111777038762135e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.6540834903717041015625e0), SC_(-0.2459534859171060177043599079460653627876e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1097540378570556640625e1), SC_(0.1579332201794321120135728809601595120035e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.30944411754608154296875e1), SC_(0.3460521593933925495064774929401352783066e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.51139926910400390625e1), SC_(-0.3226720162699480428923607985495542415611e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.95070552825927734375e1), SC_(0.1704518545616096824583473906088353974798e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.24750102996826171875e2), SC_(-0.1480630443547165728353407967940434766385e0) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.637722015380859375e2), SC_(0.1488194766429228836377915641199018452658e-1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1252804412841796875e3), SC_(-0.6572261100873119967302664606455129430061e-1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.25554705810546875e3), SC_(-0.142093855992607823112630880080107228544e-1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.503011474609375e3), SC_(-0.1491054423538811528779378781658535282739e-1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.10074598388671875e4), SC_(0.2458751210966411371396701227739563430579e-1) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1185395751953125e4), SC_(-0.5200492855806017431912763481277953331404e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.353451806640625e4), SC_(0.7158268136941132273892772334045520934666e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.80715478515625e4), SC_(-0.6596068471414521611228855010215014704418e-4) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.1622925e5), SC_(-0.5292246367479866864908050314944924753669e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.3206622265625e5), SC_(0.320390439737211080762980520435506250823e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.3636794921875e5), SC_(0.3500983370716348944297898811549471925567e-3) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.177219114266335964202880859375e-2), SC_(-0.4120027412731051041206450410057429639349e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.22177286446094512939453125e-2), SC_(-0.3977105851156557119151823261612798218773e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.7444499991834163665771484375e-2), SC_(-0.3205504928732404892476271281075272444522e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1433600485324859619140625e-1), SC_(-0.2787987583373352069958752481599007631499e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1760916970670223236083984375e-1), SC_(-0.2656935742898321978445839607405640033284e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.6152711808681488037109375e-1), SC_(-0.1858171712468613875843642326777393322995e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.11958599090576171875e0), SC_(-0.1430015519366236809172334709693214910441e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.15262925624847412109375e0), SC_(-0.1270941805522165919290496753078963837638e1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.408089816570281982421875e0), SC_(-0.6028887952741650472210391450598434501064e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.6540834903717041015625e0), SC_(-0.253272254375116720240110301955438274904e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1097540378570556640625e1), SC_(0.1520201824220985075413827678589759450294e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.30944411754608154296875e1), SC_(0.3484128787584500743767953634177680046837e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.51139926910400390625e1), SC_(-0.3215065328791237601271218312483710525199e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.95070552825927734375e1), SC_(0.1720422311734142500970235815393168124624e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.24750102996826171875e2), SC_(-0.1485637008291705383805876287336390101122e0) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.637722015380859375e2), SC_(0.1407034822297315991341655297564501076178e-1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1252804412841796875e3), SC_(-0.6594703326047541907061713679421759907013e-1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.25554705810546875e3), SC_(-0.1381608643410309470753787566141410262816e-1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.503011474609375e3), SC_(-0.151752265807192360259537475829210125324e-1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.10074598388671875e4), SC_(0.2454373914040585157738066701355246448403e-1) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1185395751953125e4), SC_(-0.5014906543268439324794963661123810184093e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.353451806640625e4), SC_(0.7251230144724707071573863762664925369871e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.80715478515625e4), SC_(0.6953369197393758981781818649242121542468e-5) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.1622925e5), SC_(-0.5319567322960577952508664100308821679854e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.3206622265625e5), SC_(0.3229218945935765810090443669915499659257e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.3636794921875e5), SC_(0.3158568198916460292543522938944683153232e-3) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.177219114266335964202880859375e-2), SC_(-0.4134159952672901498743626308790551330992e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.22177286446094512939453125e-2), SC_(-0.3990837132176071416552743859631846467869e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.7444499991834163665771484375e-2), SC_(-0.3217563179354922543332500792794151411069e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1433600485324859619140625e-1), SC_(-0.2799446740519488969651219625146622998737e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1760916970670223236083984375e-1), SC_(-0.2668245252505030375352857746281865483493e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.6152711808681488037109375e-1), SC_(-0.186889810951487968438608309966422611667e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.11958599090576171875e0), SC_(-0.1440599803781774335574526240384283073629e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.15262925624847412109375e0), SC_(-0.1281485849537878284125998432302154093319e1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.408089816570281982421875e0), SC_(-0.6130927188528948957629699386553428087544e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.6540834903717041015625e0), SC_(-0.2628616657161443753490102972580233083382e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1097540378570556640625e1), SC_(0.1442321647711284365164473485125952896532e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.30944411754608154296875e1), SC_(0.3514866696796145177802316946038001144499e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.51139926910400390625e1), SC_(-0.3199381849177278131427345797992957474537e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.95070552825927734375e1), SC_(0.1741206187508240360674576027852156076872e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.24750102996826171875e2), SC_(-0.1492084150385547414276112923072727245566e0) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.637722015380859375e2), SC_(0.1299887757401767858160759862904849183224e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1252804412841796875e3), SC_(-0.6623612901898277817530531932876652691197e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.25554705810546875e3), SC_(-0.1329610971315120839879080119446416949079e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.503011474609375e3), SC_(-0.1552264157837515558947215728593300366424e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.10074598388671875e4), SC_(0.2448349643616932259319127554623091231607e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1185395751953125e4), SC_(-0.47696968979306790828599052079788410586e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.353451806640625e4), SC_(0.7373052438334910802888978807399790026358e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.80715478515625e4), SC_(0.103089084794957453201580199017916172336e-3) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.1622925e5), SC_(-0.5355041661602504411571715046096891970658e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.3206622265625e5), SC_(0.3262263227226572779950829863684658963946e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.3636794921875e5), SC_(0.2706771716021933545864407071325455578847e-3) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.177219114266335964202880859375e-2), SC_(-0.414163021695610839626594818544969888135e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.22177286446094512939453125e-2), SC_(-0.3998026070140048622843715154177888482864e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.7444499991834163665771484375e-2), SC_(-0.3223578342484987127570834604684301589064e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1433600485324859619140625e-1), SC_(-0.2805041020636338065368011730266984060386e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1760916970670223236083984375e-1), SC_(-0.267373432386994086040320847241502745921e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.6152711808681488037109375e-1), SC_(-0.1873977940712246327248229129947691547029e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.11958599090576171875e0), SC_(-0.1445584955936751054756344852413175332245e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.15262925624847412109375e0), SC_(-0.1286447747582521750173263376465901265201e1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.408089816570281982421875e0), SC_(-0.6179007959306159994943227076029876848904e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.6540834903717041015625e0), SC_(-0.2673921464115963617566602706386145183268e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1097540378570556640625e1), SC_(0.1405367244577930779444752573642221194523e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.30944411754608154296875e1), SC_(0.3529310757485741487989834078847461593602e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.51139926910400390625e1), SC_(-0.3191807476807918423425983840614851867899e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.95070552825927734375e1), SC_(0.1751003260410698666912982862559683670239e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.24750102996826171875e2), SC_(-0.1495084729585684921291461478816209223886e0) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.637722015380859375e2), SC_(0.1248946039223008205510939332494376913451e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1252804412841796875e3), SC_(-0.6637071714440504131055759573477771115416e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.25554705810546875e3), SC_(-0.1304859708108673820507099372068032506799e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.503011474609375e3), SC_(-0.1568701289437447707813809641531635445578e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.10074598388671875e4), SC_(0.2445387849848271978523841180571972475043e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1185395751953125e4), SC_(-0.4653035771077139081514171654686800186401e-2) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.353451806640625e4), SC_(0.7430610913917337789479410806889488764298e-2) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.80715478515625e4), SC_(0.1487458062664166412984226358595502470712e-3) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.1622925e5), SC_(-0.537167087642907956691133964558344518225e-2) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.3206622265625e5), SC_(0.3277824155177529590726952113577543721695e-2) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.3636794921875e5), SC_(0.2492073722350484842676832902730326078634e-3) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.177219114266335964202880859375e-2), SC_(-0.4292940726473448880897730442688338370774e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.22177286446094512939453125e-2), SC_(-0.4139594451768182343149316176689693506539e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.7444499991834163665771484375e-2), SC_(-0.3324405228509003301543600431690304669101e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1433600485324859619140625e-1), SC_(-0.289116825843158298380019838740552456809e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1760916970670223236083984375e-1), SC_(-0.2756169643209375330425426300012166738459e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.6152711808681488037109375e-1), SC_(-0.1941930359957125953844375392293686969652e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.11958599090576171875e0), SC_(-0.1510287703059554968070346992508222455085e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.15262925624847412109375e0), SC_(-0.1350493103600317134372967104624432827604e1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.408089816570281982421875e0), SC_(-0.6801012727910123129970618031395633644183e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.6540834903717041015625e0), SC_(-0.3266809716404727789897521564028191305653e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1097540378570556640625e1), SC_(0.9121684833092535114160250332060007321553e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.30944411754608154296875e1), SC_(0.3713362444001405892085606575647550468814e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.51139926910400390625e1), SC_(-0.3082526106141768675991166438651428774512e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.95070552825927734375e1), SC_(0.1877705518067313565933947201563061550321e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.24750102996826171875e2), SC_(-0.1531476921994101085162285120136628348174e0) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.637722015380859375e2), SC_(0.562941381137391192098245372472229515696e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1252804412841796875e3), SC_(-0.6800536247115209633596242822932234847679e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.25554705810546875e3), SC_(-0.969704704114331942524684275330572200605e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.503011474609375e3), SC_(-0.1785058419366988685366579487841757752913e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.10074598388671875e4), SC_(0.2399430046803155251471264438876628392554e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1185395751953125e4), SC_(-0.3077088266217558875050653104550633805392e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.353451806640625e4), SC_(0.8183303082876395286226387629959940568145e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.80715478515625e4), SC_(0.7604840868773285601052369065861898040009e-3) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.1622925e5), SC_(-0.5580889615501464409500720865934539802095e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.3206622265625e5), SC_(0.3478071919776372267448776161533522487954e-2) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.3636794921875e5), SC_(-0.3927499423390955993421945019764612132227e-4) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.177219114266335964202880859375e-2), SC_(-0.4662711968954806460973605174258521521312e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.22177286446094512939453125e-2), SC_(-0.4477138680645578160407689953232324493123e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.7444499991834163665771484375e-2), SC_(-0.3527410314260739933949251023527368148888e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1433600485324859619140625e-1), SC_(-0.304548646714993151965168331417548646789e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1760916970670223236083984375e-1), SC_(-0.2898198451540783987616093707567689094637e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.6152711808681488037109375e-1), SC_(-0.2034979311731508160444434046301755475242e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.11958599090576171875e0), SC_(-0.15918750699490726131708020923177891458e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.15262925624847412109375e0), SC_(-0.1429765382269563230335025550811110014582e1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.408089816570281982421875e0), SC_(-0.7561699826982982853865900164457810379908e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.6540834903717041015625e0), SC_(-0.4008071252759831719003923041747667000953e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1097540378570556640625e1), SC_(0.2699659858995017289859369975377052124758e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.30944411754608154296875e1), SC_(0.3928399183339494061316907063772373011542e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.51139926910400390625e1), SC_(-0.2917127033288249961640070553378430506292e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.95070552825927734375e1), SC_(0.203101380189260169721113461634311026839e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.24750102996826171875e2), SC_(-0.1568367813900324087800336277325469365214e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.637722015380859375e2), SC_(-0.3470515067358225145580914808778240166558e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1252804412841796875e3), SC_(-0.6966858229467119310444675564577822624705e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.25554705810546875e3), SC_(-0.5198791947942985790298010613645897099016e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.503011474609375e3), SC_(-0.2057865996304334428779427497609371309674e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.10074598388671875e4), SC_(0.2321202437961357464166797283210694166823e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1185395751953125e4), SC_(-0.9725459466549755834711551459782215342604e-3) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.353451806640625e4), SC_(0.9118028934660826183794375366147794026503e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.80715478515625e4), SC_(0.1563159895391056065771030244390579936308e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.1622925e5), SC_(-0.581657817365252067424386050405171969457e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.3206622265625e5), SC_(0.3717255178024793681304263460516998303412e-2) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.3636794921875e5), SC_(-0.4201312103560340489144435860837908700008e-3) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.177219114266335964202880859375e-2), SC_(-0.4977779926926542353059228031796835350788e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.22177286446094512939453125e-2), SC_(-0.4761951939449421937239087770423139052337e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.7444499991834163665771484375e-2), SC_(-0.3686787737785302200866289598549495681873e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1433600485324859619140625e-1), SC_(-0.3159705800712971675724552443868565994786e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1760916970670223236083984375e-1), SC_(-0.3001012009718572425169932224958217077494e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.6152711808681488037109375e-1), SC_(-0.2091962433667603814016989316893596007293e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.11958599090576171875e0), SC_(-0.1637749035585494860187579257700026991347e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.15262925624847412109375e0), SC_(-0.1473304151879824689672720779139176901547e1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.408089816570281982421875e0), SC_(-0.7966381066202503486734451752671339500326e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.6540834903717041015625e0), SC_(-0.440873515389695194835449285430733903282e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1097540378570556640625e1), SC_(-0.8923352021521999638822908128425671499494e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.30944411754608154296875e1), SC_(0.4036203010724160516638173918058901177518e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.51139926910400390625e1), SC_(-0.2812984058336528420208693453784041163462e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.95070552825927734375e1), SC_(0.2110680699300315249471142060227263210602e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.24750102996826171875e2), SC_(-0.15835719700285027084519186294293673336e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.637722015380859375e2), SC_(-0.8639232294195542233654095360600952238844e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1252804412841796875e3), SC_(-0.7035741186537872253630312300513228309485e-1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.25554705810546875e3), SC_(-0.2617276139618803722044774270264881470449e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.503011474609375e3), SC_(-0.2205625891108253596616165323866152758295e-1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.10074598388671875e4), SC_(0.2268020138273471069010046643229342437598e-1) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1185395751953125e4), SC_(0.2299258899992207644349423243212142391736e-3) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.353451806640625e4), SC_(0.9616643806149397704892154882547852379076e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.80715478515625e4), SC_(0.2014611033785550148345812820922668156027e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.1622925e5), SC_(-0.5929238923887145592582884102467331977891e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.3206622265625e5), SC_(0.3839703818458927177622338508760594616066e-2) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.3636794921875e5), SC_(-0.6355320831805601377685830225903198089416e-3) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.177219114266335964202880859375e-2), SC_(-0.1216098415624359085164389233777320527868e2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.22177286446094512939453125e-2), SC_(-0.1109391544566476201283336993445300189393e2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.7444499991834163665771484375e-2), SC_(-0.6746387454790833823372321439626960991484e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1433600485324859619140625e-1), SC_(-0.5144532755624635131909083437025686838187e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1760916970670223236083984375e-1), SC_(-0.4722701913808450630507018141629091248201e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.6152711808681488037109375e-1), SC_(-0.2778508627713558438432466459028242731355e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.11958599090576171875e0), SC_(-0.2064637308329725656569048416302141462205e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.15262925624847412109375e0), SC_(-0.1840565039923489634062350723294869352596e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.408089816570281982421875e0), SC_(-0.1061414954055097358496216696738429007774e1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.6540834903717041015625e0), SC_(-0.7043211203945329497445521867480185882863e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1097540378570556640625e1), SC_(-0.2654807124956544972666615206250416353835e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.30944411754608154296875e1), SC_(0.4510925137262370905119744573953322651961e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.51139926910400390625e1), SC_(-0.1806453558424950468290509585718018205779e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.95070552825927734375e1), SC_(0.2523478512134588121378318026348829617079e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.24750102996826171875e2), SC_(-0.1557802509536818484670749210763092314144e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.637722015380859375e2), SC_(-0.4673313403019925980595538368472289250023e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1252804412841796875e3), SC_(-0.6925487680958300152270088587171786594633e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.25554705810546875e3), SC_(0.1704595616453665777348485900557460695511e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.503011474609375e3), SC_(-0.3120440979510162589525679041599582225325e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.10074598388671875e4), SC_(0.1664570501102325321061766743633311666484e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1185395751953125e4), SC_(0.9261705869616819234196249409310454386594e-2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.353451806640625e4), SC_(0.1250912065937196121162392317905712302737e-1) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.80715478515625e4), SC_(0.5232944152586024935229752731300531520259e-2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.1622925e5), SC_(-0.6246313199015065699789717747783425338237e-2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.3206622265625e5), SC_(0.4417634100219461434933361800590186275505e-2) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.3636794921875e5), SC_(-0.2200279839615866962514594908603977011034e-2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.177219114266335964202880859375e-2), SC_(-0.4349879798431813885270146043838577474953e2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.22177286446094512939453125e-2), SC_(-0.3756560628900433767907947644692121542971e2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.7444499991834163665771484375e-2), SC_(-0.1702469833048694656862594262713469086195e2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1433600485324859619140625e-1), SC_(-0.1110210496063627097302725792319534087708e2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1760916970670223236083984375e-1), SC_(-0.9710344449255787788726730246591808854836e1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.6152711808681488037109375e-1), SC_(-0.4321493892524488658140071270019414546539e1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.11958599090576171875e0), SC_(-0.2830596316531304630715793221391732617852e1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.15262925624847412109375e0), SC_(-0.2427236051275184660442288958966263583903e1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.408089816570281982421875e0), SC_(-0.1294026530188776863448644979748701600671e1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.6540834903717041015625e0), SC_(-0.9032365416837750371813872501986670530392e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1097540378570556640625e1), SC_(-0.4709883371100438159125891040177907441467e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.30944411754608154296875e1), SC_(0.4399601938767528154337206958454694029373e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.51139926910400390625e1), SC_(-0.6210765541767245873285586927426405803337e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.95070552825927734375e1), SC_(0.2559725937405908531227695407471959354216e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.24750102996826171875e2), SC_(-0.1304387315263791799134860712690027242388e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.637722015380859375e2), SC_(-0.7643767142230910518516204444934557743577e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1252804412841796875e3), SC_(-0.5782684506129610765914930518457064018588e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.25554705810546875e3), SC_(0.3344919472494898162179043734842784587399e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.503011474609375e3), SC_(-0.353413749118978213698043097774766209977e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.10074598388671875e4), SC_(0.8322601848796904104734267068262526005141e-2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1185395751953125e4), SC_(0.1658280094075792117004847330465534984654e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.353451806640625e4), SC_(0.1341904429754271101456338504436987175932e-1) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.80715478515625e4), SC_(0.755122789888742761887900787792369887595e-2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.1622925e5), SC_(-0.5612984169534578815279553115671623471181e-2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.3206622265625e5), SC_(0.4310955691751761321112661781026772677854e-2) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.3636794921875e5), SC_(-0.3379149073109385331605592547147643941766e-2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.177219114266335964202880859375e-2), SC_(-0.6790649408247469800621233123801444861572e3) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.22177286446094512939453125e-2), SC_(-0.5309023793691736869911977507548321067639e3) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.7444499991834163665771484375e-2), SC_(-0.1405483920259913723302804659455822251842e3) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1433600485324859619140625e-1), SC_(-0.6848197458237380840871520195951737963797e2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1760916970670223236083984375e-1), SC_(-0.5465400933711216326384613891227551789831e2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.6152711808681488037109375e-1), SC_(-0.1390640161809635303531467450464926130497e2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.11958599090576171875e0), SC_(-0.6779972795805360700268883407251376360584e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.15262925624847412109375e0), SC_(-0.5230188106089836894095574814579061778079e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.408089816570281982421875e0), SC_(-0.1940364677406695435536141888301340367828e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.6540834903717041015625e0), SC_(-0.1258913339933174576125833815144747662275e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1097540378570556640625e1), SC_(-0.7568137990423140729799498646313529955195e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.30944411754608154296875e1), SC_(0.3106721800512397648066075975669929520773e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.51139926910400390625e1), SC_(0.1532463012254471428679272534101317828655e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.95070552825927734375e1), SC_(0.1795720198794879018589729311892687868592e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.24750102996826171875e2), SC_(-0.426119470995069389375610251435217015414e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.637722015380859375e2), SC_(-0.9991515899339130877855875009015505027048e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1252804412841796875e3), SC_(-0.1782475610742370713823213199156428105309e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.25554705810546875e3), SC_(0.4941465813153273008691987625508488252334e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.503011474609375e3), SC_(-0.2973780187175982193061632773071794284645e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.10074598388671875e4), SC_(-0.8825895728540824863141772678377750524939e-2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1185395751953125e4), SC_(0.2310553476437098618936053438922380947456e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.353451806640625e4), SC_(0.101589275443841919149919344121094613628e-1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.80715478515625e4), SC_(0.8791317582224321865732618338075563697595e-2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.1622925e5), SC_(-0.2522722964557820040273711186006517007107e-2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.3206622265625e5), SC_(0.258397824447906229553670008476611944394e-2) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.3636794921875e5), SC_(-0.417480108075693992475205704357140995532e-2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.177219114266335964202880859375e-2), SC_(-0.1942343499528155920524126715070782690541e10) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.22177286446094512939453125e-2), SC_(-0.9703630006865635475903879247242241398295e9) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.7444499991834163665771484375e-2), SC_(-0.2288159461744037678366460719341675062862e8) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1433600485324859619140625e-1), SC_(-0.3011889201464639074119983111525408485189e7) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1760916970670223236083984375e-1), SC_(-0.1593960598953953050750765471935635161763e7) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.6152711808681488037109375e-1), SC_(-0.3321713713175172190228472797552520740135e5) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.11958599090576171875e0), SC_(-0.4254118871135070233664553244962818903364e4) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.15262925624847412109375e0), SC_(-0.2001693995214501846884416354395053174427e4) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.408089816570281982421875e0), SC_(-0.970988777161180438797807686924524874125e2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.6540834903717041015625e0), SC_(-0.2329573990954411858075170530446160362372e2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1097540378570556640625e1), SC_(-0.5200632977809169336766800729820978507611e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.30944411754608154296875e1), SC_(-0.5329576094022020505058136690762536306046e0) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.51139926910400390625e1), SC_(0.14640809909396319606747593991896372233e0) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.95070552825927734375e1), SC_(-0.2487626271286555126242091608007328960055e0) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.24750102996826171875e2), SC_(0.6899494167370661487160613334588061312001e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.637722015380859375e2), SC_(0.9965334753843372266399348590241564763384e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1252804412841796875e3), SC_(0.2045578697008089530731276399864479675129e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.25554705810546875e3), SC_(-0.4925574069959335047220096940241247271523e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.503011474609375e3), SC_(0.2999299205597144062860765336888378011112e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.10074598388671875e4), SC_(0.8613185832793205965055983599907862919609e-2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1185395751953125e4), SC_(-0.2308976022780410326076549817488441794247e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.353451806640625e4), SC_(-0.1021182175239869770949352937441151990552e-1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.80715478515625e4), SC_(-0.879797165324950027712579648155227851932e-2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.1622925e5), SC_(0.2552075611539902756755038024290602747726e-2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.3206622265625e5), SC_(-0.2602090942073823160504180862039818453534e-2) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.3636794921875e5), SC_(0.4176123078746405140111266085626400865273e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.177219114266335964202880859375e-2), SC_(-0.3705145969568337941802650403899252403029e17) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.22177286446094512939453125e-2), SC_(-0.1176829388540461248581697597808143424237e17) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.7444499991834163665771484375e-2), SC_(-0.2405067947035033705202967079723549756935e14) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1433600485324859619140625e-1), SC_(-0.8428044246884604619367392293775778936658e12) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1760916970670223236083984375e-1), SC_(-0.2944388392231566982919496064045544428695e12) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.6152711808681488037109375e-1), SC_(-0.4903576620639020509957069042240674115486e9) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.11958599090576171875e0), SC_(-0.1639917510636321068978029106448535649587e8) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.15262925624847412109375e0), SC_(-0.4711874247908616757347296653130355246512e7) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.408089816570281982421875e0), SC_(-0.3109588326325974161334123952358850162935e5) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.6540834903717041015625e0), SC_(-0.2830725124947216537321801451310484294036e4) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1097540378570556640625e1), SC_(-0.2104661612886298655726260945388582131597e3) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.30944411754608154296875e1), SC_(-0.1888124889886336116656831326611227465732e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.51139926910400390625e1), SC_(-0.4502816651263076317047550255894504871467e0) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.95070552825927734375e1), SC_(0.2458061701377387431698520597090428728893e0) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.24750102996826171875e2), SC_(-0.1103164195769582870346249817695790724681e0) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.637722015380859375e2), SC_(-0.9847313739997287331303984148500219822959e-1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1252804412841796875e3), SC_(-0.2287030143290536321415817389012637378489e-1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.25554705810546875e3), SC_(0.4924486044820256040353500126548862785902e-1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.503011474609375e3), SC_(-0.2971813072556458947611283801910740933706e-1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.10074598388671875e4), SC_(-0.914198951137015567743407321630724763347e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1185395751953125e4), SC_(0.2313027433919596748247622964935823817085e-1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.353451806640625e4), SC_(0.9960728167292770124952691895945517711526e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.80715478515625e4), SC_(0.8758138084274607832414759797461488744105e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.1622925e5), SC_(-0.2378202666327817646745494184799241735663e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.3206622265625e5), SC_(0.2490754331055981326771399550006089117352e-2) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.3636794921875e5), SC_(-0.4166414486312467926799625817046850354171e-2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.7444499991834163665771484375e-2), SC_(-0.4793857282393980268990021769884499235171e28) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1433600485324859619140625e-1), SC_(-0.9441682282520009526127009065586945348002e25) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1760916970670223236083984375e-1), SC_(-0.1336498814425001834295979079796689529041e25) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.6152711808681488037109375e-1), SC_(-0.9132012729534820690893688725973611118483e19) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.11958599090576171875e0), SC_(-0.1647532535413444379836824559687942115102e17) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.15262925624847412109375e0), SC_(-0.1620336347472352716237502536254711872759e16) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.408089816570281982421875e0), SC_(-0.1415141492890980600322201015154802594311e12) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.6540834903717041015625e0), SC_(-0.1608264454762084375698364907160097100812e10) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1097540378570556640625e1), SC_(-0.120015587287511759584346665646808106427e8) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.30944411754608154296875e1), SC_(-0.8105176056335026839128696211510720272233e3) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.51139926910400390625e1), SC_(-0.1160352724450753224556363614108562877848e2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.95070552825927734375e1), SC_(-0.3659422723460527740106062454828972103671e0) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.24750102996826171875e2), SC_(-0.1656253122409641484804602706609470522898e0) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.637722015380859375e2), SC_(-0.1002534211044969996921076214999199932342e0) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1252804412841796875e3), SC_(0.2459323267268387590656935772173305995007e-2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.25554705810546875e3), SC_(0.4727621388677414365424200901932102781138e-1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.503011474609375e3), SC_(-0.1499853482621027133664160846069426563295e-1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.10074598388671875e4), SC_(-0.2056061337856806920336623108105325621513e-1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1185395751953125e4), SC_(0.200124531064386856030146552792672982826e-1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.353451806640625e4), SC_(0.3033471650974938272104310339983302036505e-2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.80715478515625e4), SC_(0.6313804457726326168433814890910007150901e-2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.1622925e5), SC_(0.1403165866529678983739736802708333117488e-2) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.3206622265625e5), SC_(-0.1035230096656936586615653548264063815176e-3) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.3636794921875e5), SC_(-0.3178411510645339458375062818266053238935e-2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1097540378570556640625e1), SC_(-0.2538488265063196712152114613748075086351e30) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.30944411754608154296875e1), SC_(-0.2001658856691900027586107047291395903374e19) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.51139926910400390625e1), SC_(-0.9503574259305993133759318213869719739108e13) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.95070552825927734375e1), SC_(-0.4122129578428727018796511082180354925791e7) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.24750102996826171875e2), SC_(-0.2658990584952737858668063924548287218421e0) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.637722015380859375e2), SC_(-0.6691180036576346233956293507614315544893e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1252804412841796875e3), SC_(0.7533197321533906425069813365786808047345e-2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.25554705810546875e3), SC_(-0.1542283080029640948900332378050454496484e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.503011474609375e3), SC_(-0.2991988069469062154012100511573471727669e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.10074598388671875e4), SC_(0.1184200276216747266219053634744663039601e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1185395751953125e4), SC_(0.147538779157775165689894252998980132164e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.353451806640625e4), SC_(0.1337803088680303126911599983254711741179e-1) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.80715478515625e4), SC_(0.8029832288031143409523993739201196219101e-2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.1622925e5), SC_(-0.5198547432330736842863301364433701996388e-2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.3206622265625e5), SC_(0.4109381361370256630410240644020816524515e-2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.3636794921875e5), SC_(-0.3695089835104638523036034542189491664868e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.24750102996826171875e2), SC_(-0.6267975543587496709349337927794592271998e18) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.637722015380859375e2), SC_(-0.1939298752945934292999130903839341072815e0) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1252804412841796875e3), SC_(-0.7053508497894543897551296718023593343408e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.25554705810546875e3), SC_(-0.3550962870822991127395561395887028412934e-1) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.503011474609375e3), SC_(-0.2648416216528672574838824635772159441549e-1) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.10074598388671875e4), SC_(-0.1420732900757196265534805768438896498951e-1) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1185395751953125e4), SC_(-0.1724003388206597138922485614964423834268e-1) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.353451806640625e4), SC_(-0.4904153149047725659903093785508227452329e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.80715478515625e4), SC_(-0.5165055881176750174649276537848635493731e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.1622925e5), SC_(-0.3111673836710409913488025509896936578918e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.3206622265625e5), SC_(0.1643282532322944952844854407146135350371e-2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.3636794921875e5), SC_(0.2009528090577840712976850241949224122986e-2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.637722015380859375e2), SC_(-0.3797174624982978861579399751499143354312e23) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1252804412841796875e3), SC_(-0.154839290844967491628030470782884890493e0) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.25554705810546875e3), SC_(0.5249253389690028543295568223911202330116e-1) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.503011474609375e3), SC_(0.2263770495318548220431423611155582287596e-1) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.10074598388671875e4), SC_(0.1928421153706604388682313816599232350549e-1) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1185395751953125e4), SC_(0.2303577167941297280388538081309628427215e-1) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.353451806640625e4), SC_(0.4602232701140352366182281154234657598423e-2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.80715478515625e4), SC_(0.7605554856039814835669547074154003071661e-2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.1622925e5), SC_(-0.3591967493051195246860689634970817279493e-2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.3206622265625e5), SC_(0.2427101323753481633835014493220406978017e-2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.3636794921875e5), SC_(-0.4144432737996561571547765270607343786669e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.25554705810546875e3), SC_(-0.1220899231301180796588329975642599451792e0) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.503011474609375e3), SC_(-0.2587460388550158251245313556927425626503e-1) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.10074598388671875e4), SC_(-0.2709588740650161660564368137667279157517e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.1185395751953125e4), SC_(0.7388450600504248491679263004388188205535e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.353451806640625e4), SC_(-0.4070364240355399016905231104224278184321e-3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.80715478515625e4), SC_(0.8869456474018290057215067339235844280777e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.1622925e5), SC_(0.6193548860770801980645313593061881324053e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.3206622265625e5), SC_(-0.3573956395914134221575915050921377055356e-2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.3636794921875e5), SC_(0.4150896139122617211447974747314758032795e-2) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.503011474609375e3), SC_(-0.9741864482364844408259833924093581326514e-1) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.10074598388671875e4), SC_(-0.1584672339561671902535695362033324616336e-1) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.1185395751953125e4), SC_(0.5943568069873248119538400255697357733917e-2) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.353451806640625e4), SC_(0.1015104946539387860338179999806441182473e-1) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.80715478515625e4), SC_(0.8883753528547744135823658482106607009966e-2) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.1622925e5), SC_(0.5522874844418632574706826538336184699582e-2) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.3206622265625e5), SC_(0.4455587256750903432452764772837804809816e-2) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.3636794921875e5), SC_(-0.3843435197254867050137588280055312232508e-2) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.10074598388671875e4), SC_(-0.7728430027806412142852417589285707550701e-1) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.1185395751953125e4), SC_(0.3043120394295723532238172036669867077737e-1) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.353451806640625e4), SC_(-0.4742168167846528568912593945029413563666e-2) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.80715478515625e4), SC_(-0.7420503792165366240145846571768477365506e-2) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.1622925e5), SC_(-0.1795717524473915811452628563407404683787e-2) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.3206622265625e5), SC_(0.7500534979641494608228235889183901707366e-3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.3636794921875e5), SC_(0.3051253358553692403837737104117441878866e-2) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.10074598388671875e4), SC_(-0.7251757054382535422878260094266093685031e29) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.1185395751953125e4), SC_(-0.7320587935179758776740758943706909907242e-1) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.353451806640625e4), SC_(0.4795852538068195975343600795948509285902e-3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.80715478515625e4), SC_(0.1749093092873678394701882014413670671251e-2) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.1622925e5), SC_(0.4162877531169379039027191426399181611799e-2) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.3206622265625e5), SC_(-0.3200560495047506921416083730251596135541e-3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.3636794921875e5), SC_(-0.4176563093033758974497368789398642132897e-2) }}
   }};


