# -*- coding: utf-8 -*-

# Copyright 2010-2015 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action, Tasks
from calculate.lib.cl_lang import setLocalTranslate, getLazyLocalTranslate
from calculate.lib.cl_template import TemplatesError
from calculate.lib.utils.files import FilesError
from calculate.update.update import UpdateError
from calculate.lib.utils.git import GitError

_ = lambda x: x
setLocalTranslate('cl_update3', sys.modules[__name__])
__ = getLazyLocalTranslate(_)


class ClUpdateProfileAction(Action):
    """
    Действие обновление конфигурационных файлов
    """
    # ошибки, которые отображаются без подробностей
    native_error = (FilesError,
                    TemplatesError,
                    UpdateError, GitError)

    successMessage = __("The profile was successfully updated")
    failedMessage = __("Failed to update the profile")
    interruptMessage = __("Profile update manually interrupted")

    # список задач для действия
    tasks = [
        {'name': 'migrate_repository',
         'method': 'Update.migrateCacheRepository('
                   'cl_update_profile_url,cl_update_profile_branch,'
                   'cl_update_profile_storage)',
         'message': __("Repository transfer"),
         'condition': lambda Get: not (
             Get('cl_update_profile_storage').is_local(
                 Get('cl_update_profile_url'),
                 Get('cl_update_profile_branch')))
         },
        {'name': 'reconfigure_vars1',
         'method': 'Update.invalidateVariables("cl_update_profile_storage")',
         'depend': Tasks.has('migrate_repository')
         },
        {'name': 'drop_binhosts',
         'method': 'Update.drop_binhosts(update.cl_update_profile_datavars)'
         },
        {'name': 'reconfigure_vars',
         'method': 'Update.reconfigureProfileVars(cl_update_profile_datavars,'
                          'cl_chroot_path)'
         },
        {'name': 'reps_synchronization',
         'group': __("Repositories synchronization"),
         'tasks': [
             {'name': 'sync_reps',
              'foreach': 'cl_update_profile_sync_rep',
              'message': __("Syncing the {eachvar:capitalize} repository"),
              'method': 'Update.syncRepositories(eachvar)',
              # TODO: неиспользуемое условие
              # 'condition': lambda Get: Get('cl_update_profile_sync_rep')
              },
             {'name': 'sync_reps:regen_cache',
              'foreach': 'cl_update_sync_overlay_rep',
              'message': __("Updating the {eachvar:capitalize} repository cache"),
              'essential': False,
              'method': 'Update.regenCache(eachvar)',
              'condition': (
                  lambda Get: (Get('cl_update_outdate_set') == 'on' and
                               Get('cl_update_metadata_force') != 'skip' or
                               Get('cl_update_metadata_force') == 'force'))
              },
             {'name': 'emerge_metadata',
              'message': __("Metadata transfer"),
              'method': 'Update.emergeMetadata()',
              'condition': (
                  lambda Get: (Get('cl_update_outdate_set') == 'on' and
                               Get('cl_update_metadata_force') != 'skip' or
                               Get('cl_update_metadata_force') == 'force'))
              },
             {'name': 'eix_update',
              'message': __("Updating the eix cache for {cl_repository_name}"),
              'method': 'Update.eixUpdate(cl_repository_name)',
              'condition': (
                  lambda Get: (Get('cl_update_outdate_set') == 'on' and
                               Get('cl_update_eixupdate_force') != 'skip' or
                               Get('cl_update_eixupdate_force') == 'force'))
              },
             # сообщение удачного завершения при обновлении репозиториев
             {'name': 'success_syncrep',
              'message': __("Synchronization finished"),
              'depend': (Tasks.success() & Tasks.has_any("sync_reps",
                                                         "sync_other_reps",
                                                         "emerge_metadata",
                                                         "eix_update")),
              }
         ]
         },
        {'name': 'reps_synchronization',
         'group': __("Setting up the profile"),
         'tasks': [
             {'name': 'set_profile',
              'message': __("Switching to profile {cl_update_profile_system}"),
              'method': 'Update.setProfile(cl_update_profile_system)'
              },
             {'name': 'revision',
              'message': __("Fixing the settings"),
              'method': 'Update.applyProfileTemplates(cl_template_clt_set,'
                        'True,False,"update_profile")',
              'condition': lambda Get: Get('cl_templates_locate')
              },
             {'name': 'reconfigure',
              'message': __("The system is being configured"),
              'method': 'Update.applyProfileTemplates(cl_template_clt_set,'
                        'True,False,"merge")',
              'condition': lambda Get: (
                  Get('cl_update_templates_locate') and
                  Get('cl_update_skip_setup_set') == 'off')
              },
             {'name': 'dispatch_conf',
              'message': __("Updating configuration files"),
              'method': 'Update.dispatchConf()',
              'condition': lambda Get: Get('cl_dispatch_conf') != 'skip'
              },
         ]
         }
        ]
