#-*- coding: utf-8 -*-

# Copyright 2008-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import re
import os
import types
import pwd, grp

from cl_vars_share import varsShare, clLocale
from os.path import exists as pathexists
from os import path
from utils.files import isMount, process, listDirectory, readLinesFile
from utils.device import lspci, getUdevDeviceInfo
from utils.common import genpassword,getAvailableVideo
from utils.portage import isPkgInstalled
from utils import ip
from encrypt import getHash

from calculate.lib.datavars import VariableError


class fillVars(varsShare):
    """Auxilary object for creating variables
    
    Contains filling methods"""
    def get_cl_api(self):
        """The path to the module api,

        and additional parameters caluclate packages"""
        return {}

    def get_cl_ca_cert(self):
        """CA certificate"""
        return 'CA.crt'

    def get_cl_ca_key(self):
        """CA key"""
        return 'CA.key'

    def get_cl_ca_path(self):
        """CA path"""
        return '/var/calculate/ssl/main'
