#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-install

# Copyright 2010 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

__app__ = 'calculate-install'
__version__ = '3.2.2'

import os
import stat
from distutils.core import setup, Extension
from calculate.install_data import install_data
from os import system,path
import glob
import sys

data_files = []

data_files += [('/etc/init.d', [('data/calculate',0755)]),
               ('/usr/bin',[('bin/xautologin',0755)]),
               ('/usr/share/calculate/doc', ['data/handbook-en.html',
                                             'data/handbook-ru.html']),
               ('/bin',[('bin/bashlogin',0755)])]

packages = [
    "calculate."+str('.'.join(root.split(os.sep)[1:]))
    for root, dirs, files in os.walk('pym/install')
    if '__init__.py' in files
]

setup(
    name = __app__,
    version = __version__,
    description = "Calculate Linux installer",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    package_dir = {'calculate.install': "pym/install"},
    packages = packages,
    data_files = data_files,
    scripts=[],
    cmdclass={'install_data': install_data}
)
