#-*- coding: utf-8 -*-

# Copyright 2008-2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
import sys
from os import path
from calculate.lib.datavars import Variable,VariableError,ReadonlyVariable
from calculate.lib.variables.linux import (Linux,VariableOsLinuxName,
        VariableOsLinuxSystem,VariableOsLinuxSubname)

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_install3',sys.modules[__name__])

class InstallLinux(Linux):
    def __getFromImageOrCurrent(self,field,currentVar):
        """Get value from install image or current system"""
        if self.Get('cl_action') == 'system':
            image = self.Get('cl_image')
            if image:
                d = image.getInfo()
                # support lazy values
                res = d.get(field,"")
                return str(res()) if callable(res) else res
            else:
                return ""
        else:
            return self.Get(currentVar)

    # variable for get current system info (example: os_linux_shortname)
    current_variable = ""
    # field of distroinfo (name,ver,build,march and etc)
    distroinfo_field = ""

    def get(self):
        """Get by distroinfo or current info"""
        return self.__getFromImageOrCurrent(self.distroinfo_field,
                                            self.current_variable)

class VariableOsInstallLinuxShortname(InstallLinux,ReadonlyVariable):
    """Shortname of system"""
    current_variable = "os_linux_shortname"
    distroinfo_field = "name"

class VariableOsInstallLinuxVer(InstallLinux,ReadonlyVariable):
    """Shortname of system"""
    current_variable = "os_linux_ver"
    distroinfo_field = "ver"

class VariableOsInstallLinuxBuild(InstallLinux,ReadonlyVariable):
    """Shortname of system"""
    current_variable = "os_linux_build"
    distroinfo_field = "build"

class VariableOsInstallArchMachine(InstallLinux,ReadonlyVariable):
    """Shortname of system"""
    current_variable = "os_arch_machine"
    distroinfo_field = "march"

class VariableOsInstallLinuxFiles(InstallLinux,ReadonlyVariable):
    """Shortname of system"""
    current_variable = "os_linux_files"
    distroinfo_field = "filesnum"

class VariableOsInstallLinuxName(VariableOsLinuxName):
    """
    Install distro name
    """
    source_variable = "os_install_linux_shortname"

class VariableOsInstallLinuxSystem(VariableOsLinuxSystem):
    """
    Install system name
    """
    source_variable = "os_install_linux_shortname"

class VariableOsInstallLinuxSubname(VariableOsLinuxSubname):
    """
    Install subname
    """
    source_variable = "os_install_linux_shortname"
