# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import soaplib, sys, time, os
import threading

from soaplib.serializers.primitive import String, Integer, Any, Boolean
from soaplib.serializers.clazz import Array
from soaplib.service import rpc, DefinitionBase
from calculate.core.server.api_types import ReturnedMessage,CommonInfo
from calculate.core.server.api_types import ChoiceValue, Table, Option, Field, \
                                           GroupField, ViewInfo, ViewParams
from calculate.lib.datavars import VariableError,DataVarsError
from calculate.desktop.cl_desktop import DesktopError

from cl_desktop import Desktop,DataVarsDesktop
import cl_desktop
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.core.server.decorators import Dec
from calculate.core.server.func import catchExcept
core_method = Dec.core_method
setLocalTranslate('cl_desktop3',sys.modules[__name__])
import traceback
from functools import wraps,WRAPPER_ASSIGNMENTS

__ = getLazyLocalTranslate(_)

class DesktopInfo(CommonInfo):
    """Parameters for method install"""
    ur_login = String

desktopCatchExcept = catchExcept(VariableError,DataVarsError,
                                 cl_desktop.DesktopError)

class Wsdl:
    """
    cl-desktop
    """
    @rpc(Integer, DesktopInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Desktop'),title=__('Configure user'),
        image='user-desktop,preferences-desktop',
        gui=True,command='cl-desktop',
        rights=['userconfigure'])
    def desktop(self, sid, info):
        return self.callMethod(sid,info,method_name="desktop",
                               logicClass=Desktop,
                               method="createHome")

    def desktop_vars(self,dv=None):
        if not dv:
            dv = DataVarsDesktop()
            dv.importDesktop()
            dv.flIniFile()
            dv.Set('cl_action','desktop',True)
        dv.addGroup(None,
            normal=('ur_login',),
            expert=('cl_verbose_set','cl_templates_locate'),
            next_label=_("Configure"),)
        return dv

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    def desktop_view (self, sid, params):
        dv = self.get_cache(sid,"desktop","vars")
        if not dv:
            dv = self.desktop_vars()
        else:
            dv.processRefresh()
        view = ViewInfo(dv,viewparams=params)
        self.set_cache(sid, 'desktop', "vars",dv,smart=False)
        return view

    @rpc(Integer, DesktopInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Desktop'),title=__('Logout user'),
        image='system-log-out',
        gui=True,command='cl-desktop-logout',
        rights=['userconfigure'])
    def desktop_logout(self, sid, info):
        return self.callMethod(sid,info,method_name="desktop_logout",
                               logicClass=Desktop,
                               method="userLogout")

    def desktop_logout_vars(self,dv=None):
        if not dv:
            dv = DataVarsDesktop()
            dv.importDesktop()
            dv.flIniFile()
        dv.addGroup(None,
            normal=('ur_login',),
            next_label=_("Logout"),)
        return dv

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    def desktop_logout_view (self, sid, params):
        dv = self.get_cache(sid,"desktop_logout","vars")
        if not dv:
            dv = self.desktop_logout_vars()
        else:
            dv.processRefresh()
        view = ViewInfo(dv,viewparams=params)
        self.set_cache(sid, 'desktop_logout', "vars",dv,smart=False)
        return view
