#-*- coding: utf-8 -*-

# Copyright 2012-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

class Dec:
    conMethods = {}
    guiMethods = {}
    rightsMethods = {}

    # add needed rights for call method
    @classmethod
    def check_permissions(cls, add_right=[]):
        def wrapper(function):
            cls.rightsMethods[function.__name__] = add_right
            return function
        return wrapper

    # add needed rights for call method
    @classmethod
    def core_method(cls, gui=False, category=None, title=None, image=None, \
                    command=None, rights=[], user=False):
        def wrapper(function):
            if gui:
                if not category in cls.guiMethods.keys():
                    cls.guiMethods[category] = []
                cls.guiMethods[category].append(function.__name__)
                cls.guiMethods[category].append(title)
                cls.guiMethods[category].append(image)

            if command:
                if not command in cls.conMethods.keys():
                    cls.conMethods[command] = []
                cls.conMethods[command].append(function.__name__)
                cls.conMethods[command].append(user)
                if title:
                    cls.conMethods[command].append(title)

            if rights:
                cls.rightsMethods[function.__name__] = rights
                if not function.__name__.endswith('_view'):
                    cls.rightsMethods[function.__name__+'_view'] = rights
            return function
        return wrapper
