#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-ldap

# Copyright 2010 Calculate Ltd. http://www.calculate-linux.org
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
from os import path
import glob
import sys

import distutils
from distutils.core import setup
from distutils.command.install_data import install_data
import distutils.command.build
import distutils.command.install_egg_info

data_files = []

var_data_files = []

__version__ = "0.1"
__app__ = "calculate-console"

locales = ("ru",'en')

class cl_console_data(install_data):
    def run (self):
        install_data.run(self)
        data_file = []
        fileNames = map(lambda x: path.split(x[0])[1], data_file)
        listNames = map(lambda x: filter(lambda y: y, x[0].split("/")),
                        data_file)
        data_find = {}
        for i in range(len(fileNames)):
            listNames[i].reverse()
            data_find[fileNames[i]] =[listNames[i],data_file[i][1]]
            
        for path in self.get_outputs():
            nameFile = path.split(path)[1]
            if nameFile in data_find.keys():
                data = data_find[nameFile][0]
                mode = data_find[nameFile][1]
                flagFound = True
                iMax = len(data)
                pathFile = path
                for i in range(iMax):
                    if data[i] != path.split(pathFile)[1]:
                        flagFound = False
                        break
                    pathFile = path.split(pathFile)[0]
                if flagFound:
                    os.chmod(path, mode)

class build(distutils.command.build.build):
    def run (self):
        distutils.command.build.build.run(self)

    def has_po( self ) :
        return len(glob.glob("ru/*.po")) > 0
    sub_commands = distutils.command.build.build.sub_commands + [
        ('build_po',has_po),
    ]

class empty_egg_info( distutils.command.install_egg_info.install_egg_info ):
    def run(self):
        pass

def cout(string):
    sys.stdout.write(string)
    sys.stdout.flush()

class build_po( distutils.core.Command ) :
    description = "build translation files"
    user_options = []

    def initialize_options( self ) :
        pass
    def finalize_options( self ) :
        pass

    def run( self ) :
        #self.mkpath("build")
        #build.run( self )
        for locale in locales:
            localepath = path.join("build",locale,"LC_MESSAGES")
            self.mkpath(localepath)
            self.mkpath(locale)
            for po in glob.glob("%s/*.po"%locale):
                cmd = "msgfmt -c -o %s/%s %s" % \
                    (localepath,path.basename(po)[:-2]+'mo',po)
                cout( cmd + "\n" )
                os.system(cmd)

setup(
    name = __app__,
    version = __version__,
    description = "client for WSDL server",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",

    data_files = data_files + [
        (path.join('/usr/share/locale',locale,"LC_MESSAGES"),
         glob.glob(path.join("build",locale,"LC_MESSAGES/*.mo")))
         for locale in locales ],

    package_dir = {'calculate.console': "console"},
    packages = ['calculate.console','calculate.console.variables',
                'calculate.console.application'],
    scripts = ['./scripts/cl-console','./scripts/cl-consoled'],
    cmdclass={'cl_console_data': cl_console_data,'build': build, \
              'build_po':build_po, 'install_egg_info':empty_egg_info}
)
