#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-ldap

# Copyright 2010 Calculate Ltd. http://www.calculate-linux.org
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
from os import path
import glob
import sys

import distutils
from distutils.core import setup
from distutils.command.install_data import install_data

import itertools

icon_system_path = ['/usr/share/icons/Calculate/16x16/client-gui']
icon_path = 'consolegui/images/'
icon_names = ['console_ok.png', 'console_cancel.png']
data_files = list(itertools.product(icon_system_path, \
                                    map (lambda x: [icon_path+x], icon_names)))

data_files.append(('/usr/share/pixmaps',['data/calculate-console-online.png',
                                         'data/calculate-console-offline.png',
                                         'data/calculate-console-update.png',
                                         'data/cl-console-gui-install.png']))
data_files.append(('/usr/share/applications',
                           ['data/cl-console-gui-install.desktop',
                            'data/cl-console-gui-update.desktop',
                            'data/cl-console-gui.desktop']))
data_files.append(('/usr/share/calculate/themes/install',
                   ['data/install/conf','data/install/welcome.jpg',
                    'data/install/finish.jpg']))
for size in [16,22,24,48,64,72,96,128]:
    data_files.append(('/usr/share/icons/Calculate/%dx%d/apps' %(size,size),
                   glob.glob('data/%dx%d/calculate-console.png' %(size,size))))
    data_files.append(('/usr/share/icons/Calculate/%dx%d/apps' %(size,size),
                   glob.glob('data/%dx%d/calculate-install.png' %(size,size))))
    data_files.append(('/usr/share/icons/Calculate/%dx%d/apps' %(size,size),
                   glob.glob('data/%dx%d/calculate-update.png' %(size,size))))

var_data_files = []

__version__ = "3.1.8"
__app__ = "calculate-console-gui"

class cl_console_data(install_data):
    def run (self):
        install_data.run(self)
        data_file = []
        fileNames = map(lambda x: path.split(x[0])[1], data_file)
        listNames = map(lambda x: filter(lambda y: y, x[0].split("/")),
                        data_file)
        data_find = {}
        for i in range(len(fileNames)):
            listNames[i].reverse()
            data_find[fileNames[i]] =[listNames[i],data_file[i][1]]

        for path in self.get_outputs():
            nameFile = path.split(path)[1]
            if nameFile in data_find.keys():
                data = data_find[nameFile][0]
                mode = data_find[nameFile][1]
                flagFound = True
                iMax = len(data)
                pathFile = path
                for i in range(iMax):
                    if data[i] != path.split(pathFile)[1]:
                        flagFound = False
                        break
                    pathFile = path.split(pathFile)[0]
                if flagFound:
                    os.chmod(path, mode)

setup(
    name = __app__,
    version = __version__,
    description = "GUI client for WSDL server",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
#    data_files = [("",(glob.glob("build/locale/*.mo")))],

    data_files = data_files,

    package_dir = {'calculate.consolegui': "consolegui"},
    packages = ['calculate.consolegui','calculate.consolegui.variables',
                'calculate.consolegui.application'],
    scripts = ['./scripts/cl-console-gui'],
    cmdclass={'cl_console_data': cl_console_data}
)
