# -*- coding: utf-8 -*-

# Copyright 2015 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action, Tasks
from calculate.lib.cl_lang import setLocalTranslate, getLazyLocalTranslate
from calculate.lib.utils.files import FilesError
from calculate.update.emerge_parser import EmergeError
from calculate.update.update import UpdateError
from ..datavars import BuilderError
from calculate.lib.utils.portage import GitError
from calculate.install.distr import DistributiveError, IsoDistributive
from calculate.builder.variables.action import Actions

setLocalTranslate('cl_builder3', sys.modules[__name__])
__ = getLazyLocalTranslate(_)


class ClBuilderMenuAction(Action):
    """
    Действие обновление конфигурационных файлов
    """
    # ошибки, которые отображаются без подробностей
    native_error = (DistributiveError, FilesError, UpdateError,
                    BuilderError, GitError, EmergeError)

    successMessage =__("Boot menu updated successfully")
    failedMessage = __("Failed to update boot menu")
    interruptMessage = __("Boot menu updating manually interrupted")

    # список задач для действия
    tasks = [
        {'name': 'mount_flash',
         'method': 'Builder.remount_rw(cl_builder_flash_path)',
        },
        {'name': 'protect_off',
         'method': 'Builder.setVariable("cl_protect_use_set","off",True)'
         },
        {'name': 'image_menu',
         'method': 'Builder.set_builder_action("%s")' % Actions.ImageMenu,
         },
        {'name': 'image_menu:sync_vmlinuz',
         'message': __("Extracting kernels from ISO images"),
         'method': 'Builder.sync_vmlinuz(cl_builder_flash_path)'
         },
        {'name': 'image_menu:update_menu',
         'message': __("Recreating ISO image menu"),
         'method': 'Builder.update_menu(cl_builder_flash_path)',
         },
    ]
