# The PEP 484 type hints stub file for the QtXml module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]


class QDomImplementation(PyQt5.sipsimplewrapper):

    class InvalidDataPolicy(int):
        AcceptInvalidChars = ... # type: QDomImplementation.InvalidDataPolicy
        DropInvalidChars = ... # type: QDomImplementation.InvalidDataPolicy
        ReturnNullNode = ... # type: QDomImplementation.InvalidDataPolicy

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDomImplementation') -> None: ...

    def isNull(self) -> bool: ...
    @staticmethod
    def setInvalidDataPolicy(policy: 'QDomImplementation.InvalidDataPolicy') -> None: ...
    @staticmethod
    def invalidDataPolicy() -> 'QDomImplementation.InvalidDataPolicy': ...
    def createDocument(self, nsURI: str|None, qName: str|None, doctype: 'QDomDocumentType') -> 'QDomDocument': ...
    def createDocumentType(self, qName: str|None, publicId: str|None, systemId: str|None) -> 'QDomDocumentType': ...
    def hasFeature(self, feature: str|None, version: str|None) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QDomNode(PyQt5.sipsimplewrapper):

    class EncodingPolicy(int):
        EncodingFromDocument = ... # type: QDomNode.EncodingPolicy
        EncodingFromTextStream = ... # type: QDomNode.EncodingPolicy

    class NodeType(int):
        ElementNode = ... # type: QDomNode.NodeType
        AttributeNode = ... # type: QDomNode.NodeType
        TextNode = ... # type: QDomNode.NodeType
        CDATASectionNode = ... # type: QDomNode.NodeType
        EntityReferenceNode = ... # type: QDomNode.NodeType
        EntityNode = ... # type: QDomNode.NodeType
        ProcessingInstructionNode = ... # type: QDomNode.NodeType
        CommentNode = ... # type: QDomNode.NodeType
        DocumentNode = ... # type: QDomNode.NodeType
        DocumentTypeNode = ... # type: QDomNode.NodeType
        DocumentFragmentNode = ... # type: QDomNode.NodeType
        NotationNode = ... # type: QDomNode.NodeType
        BaseNode = ... # type: QDomNode.NodeType
        CharacterDataNode = ... # type: QDomNode.NodeType

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDomNode') -> None: ...

    def columnNumber(self) -> int: ...
    def lineNumber(self) -> int: ...
    def nextSiblingElement(self, taName: str|None = ...) -> 'QDomElement': ...
    def previousSiblingElement(self, tagName: str|None = ...) -> 'QDomElement': ...
    def lastChildElement(self, tagName: str|None = ...) -> 'QDomElement': ...
    def firstChildElement(self, tagName: str|None = ...) -> 'QDomElement': ...
    def save(self, a0: QtCore.QTextStream, a1: int, a2: 'QDomNode.EncodingPolicy' = ...) -> None: ...
    def toComment(self) -> 'QDomComment': ...
    def toCharacterData(self) -> 'QDomCharacterData': ...
    def toProcessingInstruction(self) -> 'QDomProcessingInstruction': ...
    def toNotation(self) -> 'QDomNotation': ...
    def toEntity(self) -> 'QDomEntity': ...
    def toText(self) -> 'QDomText': ...
    def toEntityReference(self) -> 'QDomEntityReference': ...
    def toElement(self) -> 'QDomElement': ...
    def toDocumentType(self) -> 'QDomDocumentType': ...
    def toDocument(self) -> 'QDomDocument': ...
    def toDocumentFragment(self) -> 'QDomDocumentFragment': ...
    def toCDATASection(self) -> 'QDomCDATASection': ...
    def toAttr(self) -> 'QDomAttr': ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...
    def namedItem(self, name: str|None) -> 'QDomNode': ...
    def isComment(self) -> bool: ...
    def isCharacterData(self) -> bool: ...
    def isProcessingInstruction(self) -> bool: ...
    def isNotation(self) -> bool: ...
    def isEntity(self) -> bool: ...
    def isText(self) -> bool: ...
    def isEntityReference(self) -> bool: ...
    def isElement(self) -> bool: ...
    def isDocumentType(self) -> bool: ...
    def isDocument(self) -> bool: ...
    def isDocumentFragment(self) -> bool: ...
    def isCDATASection(self) -> bool: ...
    def isAttr(self) -> bool: ...
    def setPrefix(self, pre: str|None) -> None: ...
    def prefix(self) -> str: ...
    def setNodeValue(self, a0: str|None) -> None: ...
    def nodeValue(self) -> str: ...
    def hasAttributes(self) -> bool: ...
    def localName(self) -> str: ...
    def namespaceURI(self) -> str: ...
    def ownerDocument(self) -> 'QDomDocument': ...
    def attributes(self) -> 'QDomNamedNodeMap': ...
    def nextSibling(self) -> 'QDomNode': ...
    def previousSibling(self) -> 'QDomNode': ...
    def lastChild(self) -> 'QDomNode': ...
    def firstChild(self) -> 'QDomNode': ...
    def childNodes(self) -> 'QDomNodeList': ...
    def parentNode(self) -> 'QDomNode': ...
    def nodeType(self) -> 'QDomNode.NodeType': ...
    def nodeName(self) -> str: ...
    def isSupported(self, feature: str|None, version: str|None) -> bool: ...
    def normalize(self) -> None: ...
    def cloneNode(self, deep: bool = ...) -> 'QDomNode': ...
    def hasChildNodes(self) -> bool: ...
    def appendChild(self, newChild: 'QDomNode') -> 'QDomNode': ...
    def removeChild(self, oldChild: 'QDomNode') -> 'QDomNode': ...
    def replaceChild(self, newChild: 'QDomNode', oldChild: 'QDomNode') -> 'QDomNode': ...
    def insertAfter(self, newChild: 'QDomNode', refChild: 'QDomNode') -> 'QDomNode': ...
    def insertBefore(self, newChild: 'QDomNode', refChild: 'QDomNode') -> 'QDomNode': ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QDomNodeList(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDomNodeList') -> None: ...

    def isEmpty(self) -> bool: ...
    def size(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def length(self) -> int: ...
    def at(self, index: int) -> QDomNode: ...
    def item(self, index: int) -> QDomNode: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QDomDocumentType(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomDocumentType') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def internalSubset(self) -> str: ...
    def systemId(self) -> str: ...
    def publicId(self) -> str: ...
    def notations(self) -> 'QDomNamedNodeMap': ...
    def entities(self) -> 'QDomNamedNodeMap': ...
    def name(self) -> str: ...


class QDomDocument(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, name: str|None) -> None: ...
    @typing.overload
    def __init__(self, doctype: QDomDocumentType) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomDocument') -> None: ...

    def toByteArray(self, indent: int = ...) -> QtCore.QByteArray: ...
    def toString(self, indent: int = ...) -> str: ...
    @typing.overload
    def setContent(self, text: QtCore.QByteArray|bytes|bytearray, namespaceProcessing: bool) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, text: str|None, namespaceProcessing: bool) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, dev: QtCore.QIODevice|None, namespaceProcessing: bool) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, source: 'QXmlInputSource|None', namespaceProcessing: bool) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, text: QtCore.QByteArray|bytes|bytearray) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, text: str|None) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, dev: QtCore.QIODevice|None) -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, source: 'QXmlInputSource|None', reader: 'QXmlReader|None') -> typing.Tuple[bool, str, int, int]: ...
    @typing.overload
    def setContent(self, reader: QtCore.QXmlStreamReader|None, namespaceProcessing: bool) -> typing.Tuple[bool, str, int, int]: ...
    def nodeType(self) -> QDomNode.NodeType: ...
    def documentElement(self) -> 'QDomElement': ...
    def implementation(self) -> QDomImplementation: ...
    def doctype(self) -> QDomDocumentType: ...
    def elementById(self, elementId: str|None) -> 'QDomElement': ...
    def elementsByTagNameNS(self, nsURI: str|None, localName: str|None) -> QDomNodeList: ...
    def createAttributeNS(self, nsURI: str|None, qName: str|None) -> 'QDomAttr': ...
    def createElementNS(self, nsURI: str|None, qName: str|None) -> 'QDomElement': ...
    def importNode(self, importedNode: QDomNode, deep: bool) -> QDomNode: ...
    def elementsByTagName(self, tagname: str|None) -> QDomNodeList: ...
    def createEntityReference(self, name: str|None) -> 'QDomEntityReference': ...
    def createAttribute(self, name: str|None) -> 'QDomAttr': ...
    def createProcessingInstruction(self, target: str|None, data: str|None) -> 'QDomProcessingInstruction': ...
    def createCDATASection(self, data: str|None) -> 'QDomCDATASection': ...
    def createComment(self, data: str|None) -> 'QDomComment': ...
    def createTextNode(self, data: str|None) -> 'QDomText': ...
    def createDocumentFragment(self) -> 'QDomDocumentFragment': ...
    def createElement(self, tagName: str|None) -> 'QDomElement': ...


class QDomNamedNodeMap(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDomNamedNodeMap') -> None: ...

    def contains(self, name: str|None) -> bool: ...
    def isEmpty(self) -> bool: ...
    def size(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def length(self) -> int: ...
    def removeNamedItemNS(self, nsURI: str|None, localName: str|None) -> QDomNode: ...
    def setNamedItemNS(self, newNode: QDomNode) -> QDomNode: ...
    def namedItemNS(self, nsURI: str|None, localName: str|None) -> QDomNode: ...
    def item(self, index: int) -> QDomNode: ...
    def removeNamedItem(self, name: str|None) -> QDomNode: ...
    def setNamedItem(self, newNode: QDomNode) -> QDomNode: ...
    def namedItem(self, name: str|None) -> QDomNode: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QDomDocumentFragment(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomDocumentFragment') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...


class QDomCharacterData(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomCharacterData') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def setData(self, a0: str|None) -> None: ...
    def data(self) -> str: ...
    def length(self) -> int: ...
    def replaceData(self, offset: int, count: int, arg: str|None) -> None: ...
    def deleteData(self, offset: int, count: int) -> None: ...
    def insertData(self, offset: int, arg: str|None) -> None: ...
    def appendData(self, arg: str|None) -> None: ...
    def substringData(self, offset: int, count: int) -> str: ...


class QDomAttr(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomAttr') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def setValue(self, a0: str|None) -> None: ...
    def value(self) -> str: ...
    def ownerElement(self) -> 'QDomElement': ...
    def specified(self) -> bool: ...
    def name(self) -> str: ...


class QDomElement(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomElement') -> None: ...

    def text(self) -> str: ...
    def nodeType(self) -> QDomNode.NodeType: ...
    def attributes(self) -> QDomNamedNodeMap: ...
    def setTagName(self, name: str|None) -> None: ...
    def tagName(self) -> str: ...
    def hasAttributeNS(self, nsURI: str|None, localName: str|None) -> bool: ...
    def elementsByTagNameNS(self, nsURI: str|None, localName: str|None) -> QDomNodeList: ...
    def setAttributeNodeNS(self, newAttr: QDomAttr) -> QDomAttr: ...
    def attributeNodeNS(self, nsURI: str|None, localName: str|None) -> QDomAttr: ...
    def removeAttributeNS(self, nsURI: str|None, localName: str|None) -> None: ...
    @typing.overload
    def setAttributeNS(self, nsURI: str|None, qName: str|None, value: str|None) -> None: ...
    @typing.overload
    def setAttributeNS(self, nsURI: str|None, qName: str|None, value: int) -> None: ...
    @typing.overload
    def setAttributeNS(self, nsURI: str|None, qName: str|None, value: int) -> None: ...
    @typing.overload
    def setAttributeNS(self, nsURI: str|None, qName: str|None, value: float) -> None: ...
    @typing.overload
    def setAttributeNS(self, nsURI: str|None, qName: str|None, value: int) -> None: ...
    def attributeNS(self, nsURI: str|None, localName: str|None, defaultValue: str|None = ...) -> str: ...
    def hasAttribute(self, name: str|None) -> bool: ...
    def elementsByTagName(self, tagname: str|None) -> QDomNodeList: ...
    def removeAttributeNode(self, oldAttr: QDomAttr) -> QDomAttr: ...
    def setAttributeNode(self, newAttr: QDomAttr) -> QDomAttr: ...
    def attributeNode(self, name: str|None) -> QDomAttr: ...
    def removeAttribute(self, name: str|None) -> None: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: str|None) -> None: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: int) -> None: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: int) -> None: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: float) -> None: ...
    @typing.overload
    def setAttribute(self, name: str|None, value: int) -> None: ...
    def attribute(self, name: str|None, defaultValue: str|None = ...) -> str: ...


class QDomText(QDomCharacterData):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomText') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def splitText(self, offset: int) -> 'QDomText': ...


class QDomComment(QDomCharacterData):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomComment') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...


class QDomCDATASection(QDomText):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomCDATASection') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...


class QDomNotation(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomNotation') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def systemId(self) -> str: ...
    def publicId(self) -> str: ...


class QDomEntity(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomEntity') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def notationName(self) -> str: ...
    def systemId(self) -> str: ...
    def publicId(self) -> str: ...


class QDomEntityReference(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomEntityReference') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...


class QDomProcessingInstruction(QDomNode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: 'QDomProcessingInstruction') -> None: ...

    def nodeType(self) -> QDomNode.NodeType: ...
    def setData(self, d: str|None) -> None: ...
    def data(self) -> str: ...
    def target(self) -> str: ...


class QXmlNamespaceSupport(PyQt5.sipsimplewrapper):

    def __init__(self) -> None: ...

    def reset(self) -> None: ...
    def popContext(self) -> None: ...
    def pushContext(self) -> None: ...
    @typing.overload
    def prefixes(self) -> list[str]: ...
    @typing.overload
    def prefixes(self, a0: str|None) -> list[str]: ...
    def processName(self, a0: str|None, a1: bool, a2: str|None, a3: str|None) -> None: ...
    def splitName(self, a0: str|None, a1: str|None, a2: str|None) -> None: ...
    def uri(self, a0: str|None) -> str: ...
    def prefix(self, a0: str|None) -> str: ...
    def setPrefix(self, a0: str|None, a1: str|None) -> None: ...


class QXmlAttributes(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlAttributes') -> None: ...

    def swap(self, other: 'QXmlAttributes') -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def append(self, qName: str|None, uri: str|None, localPart: str|None, value: str|None) -> None: ...
    def clear(self) -> None: ...
    @typing.overload
    def value(self, index: int) -> str: ...
    @typing.overload
    def value(self, qName: str|None) -> str: ...
    @typing.overload
    def value(self, uri: str|None, localName: str|None) -> str: ...
    @typing.overload
    def type(self, index: int) -> str: ...
    @typing.overload
    def type(self, qName: str|None) -> str: ...
    @typing.overload
    def type(self, uri: str|None, localName: str|None) -> str: ...
    def uri(self, index: int) -> str: ...
    def qName(self, index: int) -> str: ...
    def localName(self, index: int) -> str: ...
    def length(self) -> int: ...
    @typing.overload
    def index(self, qName: str|None) -> int: ...
    @typing.overload
    def index(self, uri: str|None, localPart: str|None) -> int: ...


class QXmlInputSource(PyQt5.sipsimplewrapper):

    EndOfData = ... # type: int
    EndOfDocument = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, dev: QtCore.QIODevice|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlInputSource') -> None: ...

    def fromRawData(self, data: QtCore.QByteArray|bytes|bytearray, beginning: bool = ...) -> str: ...
    def reset(self) -> None: ...
    def next(self) -> str: ...
    def data(self) -> str: ...
    def fetchData(self) -> None: ...
    @typing.overload
    def setData(self, dat: str|None) -> None: ...
    @typing.overload
    def setData(self, dat: QtCore.QByteArray|bytes|bytearray) -> None: ...


class QXmlParseException(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self, name: str|None = ..., column: int = ..., line: int = ..., publicId: str|None = ..., systemId: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QXmlParseException') -> None: ...

    def message(self) -> str: ...
    def systemId(self) -> str: ...
    def publicId(self) -> str: ...
    def lineNumber(self) -> int: ...
    def columnNumber(self) -> int: ...


class QXmlReader(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlReader') -> None: ...

    @typing.overload
    def parse(self, input: QXmlInputSource) -> bool: ...
    @typing.overload
    def parse(self, input: QXmlInputSource|None) -> bool: ...
    def declHandler(self) -> 'QXmlDeclHandler|None': ...
    def setDeclHandler(self, handler: 'QXmlDeclHandler|None') -> None: ...
    def lexicalHandler(self) -> 'QXmlLexicalHandler|None': ...
    def setLexicalHandler(self, handler: 'QXmlLexicalHandler|None') -> None: ...
    def errorHandler(self) -> 'QXmlErrorHandler|None': ...
    def setErrorHandler(self, handler: 'QXmlErrorHandler|None') -> None: ...
    def contentHandler(self) -> 'QXmlContentHandler|None': ...
    def setContentHandler(self, handler: 'QXmlContentHandler|None') -> None: ...
    def DTDHandler(self) -> 'QXmlDTDHandler|None': ...
    def setDTDHandler(self, handler: 'QXmlDTDHandler|None') -> None: ...
    def entityResolver(self) -> 'QXmlEntityResolver|None': ...
    def setEntityResolver(self, handler: 'QXmlEntityResolver|None') -> None: ...
    def hasProperty(self, name: str|None) -> bool: ...
    def setProperty(self, name: str|None, value: PyQt5.sip.voidptr) -> None: ...
    def property(self, name: str|None) -> typing.Tuple[PyQt5.sip.voidptr, bool]: ...
    def hasFeature(self, name: str|None) -> bool: ...
    def setFeature(self, name: str|None, value: bool) -> None: ...
    def feature(self, name: str|None) -> typing.Tuple[bool, bool]: ...


class QXmlSimpleReader(QXmlReader):

    def __init__(self) -> None: ...

    def parseContinue(self) -> bool: ...
    @typing.overload
    def parse(self, input: QXmlInputSource|None) -> bool: ...
    @typing.overload
    def parse(self, input: QXmlInputSource|None, incremental: bool) -> bool: ...
    def declHandler(self) -> 'QXmlDeclHandler|None': ...
    def setDeclHandler(self, handler: 'QXmlDeclHandler|None') -> None: ...
    def lexicalHandler(self) -> 'QXmlLexicalHandler|None': ...
    def setLexicalHandler(self, handler: 'QXmlLexicalHandler|None') -> None: ...
    def errorHandler(self) -> 'QXmlErrorHandler|None': ...
    def setErrorHandler(self, handler: 'QXmlErrorHandler|None') -> None: ...
    def contentHandler(self) -> 'QXmlContentHandler|None': ...
    def setContentHandler(self, handler: 'QXmlContentHandler|None') -> None: ...
    def DTDHandler(self) -> 'QXmlDTDHandler|None': ...
    def setDTDHandler(self, handler: 'QXmlDTDHandler|None') -> None: ...
    def entityResolver(self) -> 'QXmlEntityResolver|None': ...
    def setEntityResolver(self, handler: 'QXmlEntityResolver|None') -> None: ...
    def hasProperty(self, name: str|None) -> bool: ...
    def setProperty(self, name: str|None, value: PyQt5.sip.voidptr) -> None: ...
    def property(self, name: str|None) -> typing.Tuple[PyQt5.sip.voidptr, bool]: ...
    def hasFeature(self, name: str|None) -> bool: ...
    def setFeature(self, name: str|None, value: bool) -> None: ...
    def feature(self, name: str|None) -> typing.Tuple[bool, bool]: ...


class QXmlLocator(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlLocator') -> None: ...

    def lineNumber(self) -> int: ...
    def columnNumber(self) -> int: ...


class QXmlContentHandler(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlContentHandler') -> None: ...

    def errorString(self) -> str: ...
    def skippedEntity(self, name: str|None) -> bool: ...
    def processingInstruction(self, target: str|None, data: str|None) -> bool: ...
    def ignorableWhitespace(self, ch: str|None) -> bool: ...
    def characters(self, ch: str|None) -> bool: ...
    def endElement(self, namespaceURI: str|None, localName: str|None, qName: str|None) -> bool: ...
    def startElement(self, namespaceURI: str|None, localName: str|None, qName: str|None, atts: QXmlAttributes) -> bool: ...
    def endPrefixMapping(self, prefix: str|None) -> bool: ...
    def startPrefixMapping(self, prefix: str|None, uri: str|None) -> bool: ...
    def endDocument(self) -> bool: ...
    def startDocument(self) -> bool: ...
    def setDocumentLocator(self, locator: QXmlLocator|None) -> None: ...


class QXmlErrorHandler(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlErrorHandler') -> None: ...

    def errorString(self) -> str: ...
    def fatalError(self, exception: QXmlParseException) -> bool: ...
    def error(self, exception: QXmlParseException) -> bool: ...
    def warning(self, exception: QXmlParseException) -> bool: ...


class QXmlDTDHandler(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlDTDHandler') -> None: ...

    def errorString(self) -> str: ...
    def unparsedEntityDecl(self, name: str|None, publicId: str|None, systemId: str|None, notationName: str|None) -> bool: ...
    def notationDecl(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...


class QXmlEntityResolver(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlEntityResolver') -> None: ...

    def errorString(self) -> str: ...
    def resolveEntity(self, publicId: str|None, systemId: str|None) -> typing.Tuple[bool, QXmlInputSource|None]: ...


class QXmlLexicalHandler(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlLexicalHandler') -> None: ...

    def errorString(self) -> str: ...
    def comment(self, ch: str|None) -> bool: ...
    def endCDATA(self) -> bool: ...
    def startCDATA(self) -> bool: ...
    def endEntity(self, name: str|None) -> bool: ...
    def startEntity(self, name: str|None) -> bool: ...
    def endDTD(self) -> bool: ...
    def startDTD(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...


class QXmlDeclHandler(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QXmlDeclHandler') -> None: ...

    def errorString(self) -> str: ...
    def externalEntityDecl(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...
    def internalEntityDecl(self, name: str|None, value: str|None) -> bool: ...
    def attributeDecl(self, eName: str|None, aName: str|None, type: str|None, valueDefault: str|None, value: str|None) -> bool: ...


class QXmlDefaultHandler(QXmlContentHandler, QXmlErrorHandler, QXmlDTDHandler, QXmlEntityResolver, QXmlLexicalHandler, QXmlDeclHandler):

    def __init__(self) -> None: ...

    def errorString(self) -> str: ...
    def externalEntityDecl(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...
    def internalEntityDecl(self, name: str|None, value: str|None) -> bool: ...
    def attributeDecl(self, eName: str|None, aName: str|None, type: str|None, valueDefault: str|None, value: str|None) -> bool: ...
    def comment(self, ch: str|None) -> bool: ...
    def endCDATA(self) -> bool: ...
    def startCDATA(self) -> bool: ...
    def endEntity(self, name: str|None) -> bool: ...
    def startEntity(self, name: str|None) -> bool: ...
    def endDTD(self) -> bool: ...
    def startDTD(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...
    def resolveEntity(self, publicId: str|None, systemId: str|None) -> typing.Tuple[bool, QXmlInputSource|None]: ...
    def unparsedEntityDecl(self, name: str|None, publicId: str|None, systemId: str|None, notationName: str|None) -> bool: ...
    def notationDecl(self, name: str|None, publicId: str|None, systemId: str|None) -> bool: ...
    def fatalError(self, exception: QXmlParseException) -> bool: ...
    def error(self, exception: QXmlParseException) -> bool: ...
    def warning(self, exception: QXmlParseException) -> bool: ...
    def skippedEntity(self, name: str|None) -> bool: ...
    def processingInstruction(self, target: str|None, data: str|None) -> bool: ...
    def ignorableWhitespace(self, ch: str|None) -> bool: ...
    def characters(self, ch: str|None) -> bool: ...
    def endElement(self, namespaceURI: str|None, localName: str|None, qName: str|None) -> bool: ...
    def startElement(self, namespaceURI: str|None, localName: str|None, qName: str|None, atts: QXmlAttributes) -> bool: ...
    def endPrefixMapping(self, prefix: str|None) -> bool: ...
    def startPrefixMapping(self, prefix: str|None, uri: str|None) -> bool: ...
    def endDocument(self) -> bool: ...
    def startDocument(self) -> bool: ...
    def setDocumentLocator(self, locator: QXmlLocator|None) -> None: ...
