# LinearAlgebraForCAP, single 11
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("linearalgebraforcap11.tst");

# doc/_Chapter_Examples_and_Tests.xml:528-581
gap> LoadPackage( "LinearAlgebraForCAP", false );
true
gap> Q := HomalgFieldOfRationals();;
gap> vec := MatrixCategory( Q );;
gap> a := MatrixCategoryObject( vec, 1 );
<A vector space object over Q of dimension 1>
gap> b := MatrixCategoryObject( vec, 2 );
<A vector space object over Q of dimension 2>
gap> c := MatrixCategoryObject( vec, 3 );
<A vector space object over Q of dimension 3>
gap> z := ZeroObject( vec );
<A vector space object over Q of dimension 0>
gap> alpha := VectorSpaceMorphism( a, [ [ 1, 0 ] ], b );
<A morphism in Category of matrices over Q>
gap> beta := VectorSpaceMorphism( b,
>                 [ [ 1, 0, 0 ], [ 0, 1, 0 ] ], c );
<A morphism in Category of matrices over Q>
gap> gamma := VectorSpaceMorphism( c,
>                  [ [ 0, 1, 1 ], [ 1, 0, 1 ], [ 1, 1, 0 ] ], c );
<A morphism in Category of matrices over Q>
gap> IsCongruentForMorphisms(
>     TensorProductOnMorphisms( alpha, beta ),
>     TensorProductOnMorphisms( beta, alpha )
> );
false
gap> IsCongruentForMorphisms(
>     AssociatorRightToLeft( a, b, c ),
>     IdentityMorphism( TensorProductOnObjects( a, TensorProductOnObjects( b, c ) ) )
> );
true
gap> IsCongruentForMorphisms(
>     gamma,
>     LambdaElimination( c, c, LambdaIntroduction( gamma ) )
> );
true
gap> IsZeroForMorphisms( TraceMap( gamma ) );
true
gap> IsCongruentForMorphisms(
>     RankMorphism( DirectSum( a, b ) ),
>     RankMorphism( c )
> );
true
gap> IsCongruentForMorphisms(
>     Braiding( b, c ),
>     IdentityMorphism( TensorProductOnObjects( b, c ) )
> );
false
gap> IsCongruentForMorphisms(
>     PreCompose( Braiding( b, c ), Braiding( c, b ) ),
>     IdentityMorphism( TensorProductOnObjects( b, c ) )
> );
true

#
gap> STOP_TEST("linearalgebraforcap11.tst", 1);
