# corefreesub, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("corefreesub01.tst");

# doc/_Chapter_Obtaining_Core-Free_Subgroups.xml:19-30
gap> G := SymmetricGroup(4);; H := Subgroup(G, [(1,3)(2,4)]);;
gap> Core(G,H);
Group(())
gap> IsCoreFree(G,H);
true
gap> H := Subgroup(G, [(1,4)(2,3), (1,3)(2,4)]);;
gap> IsCoreFree(G,H);
false
gap> Core(G,H);# H is a normal subgroup of G, hence it does not have a trivial core
Group([ (1,4)(2,3), (1,3)(2,4) ])

# doc/_Chapter_Obtaining_Core-Free_Subgroups.xml:44-50
gap> G := SymmetricGroup(4);; dh := DihedralGroup(10);;
gap> cfccs := CoreFreeConjugacyClassesSubgroups(G);; Size(cfccs);
7
gap> cfccs_dh := CoreFreeConjugacyClassesSubgroups(dh);; Size(cfccs_dh);
2

# doc/_Chapter_Obtaining_Core-Free_Subgroups.xml:64-70
gap> G := SymmetricGroup(4);; dh := DihedralGroup(10);;
gap> acfs := AllCoreFreeSubgroups(G);; Size(acfs);
24
gap> acfs_dh := AllCoreFreeSubgroups(dh);; Size(acfs_dh);
6

# doc/_Chapter_Obtaining_Core-Free_Subgroups.xml:90-96
gap> G := SymmetricGroup(4);; dh := DihedralGroup(10);;
gap> CoreFreeDegrees(G);
[ 4, 6, 8, 12, 24 ]
gap> CoreFreeDegrees(dh);
[ 5, 10 ]

#
gap> STOP_TEST("corefreesub01.tst", 1);
