/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private Map<Class<?>, Lookup> classLookups = new HashMap();
    private Map<List<String>, Lookup> pathsLookups = new HashMap<List<String>, Lookup>();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class<?> clazz) {
        String string = this.LOCK;
        synchronized (string) {
            Lookup lookup = this.classLookups.get(clazz);
            if (lookup == null) {
                lookup = this.createLookup(clazz);
                this.classLookups.put(clazz, lookup);
            }
            return lookup;
        }
    }

    private Lookup createLookup(Class<?> clazz) {
        Lookup lookup;
        MimeLocation mimeLocation = clazz.getAnnotation(MimeLocation.class);
        if (mimeLocation == null) {
            mimeLocation = new MimeLocation(){

                public String subfolderName() {
                    return null;
                }

                public Class<? extends InstanceProvider> instanceProviderClass() {
                    return null;
                }

                public Class<? extends Annotation> annotationType() {
                    return MimeLocation.class;
                }
            };
        }
        List<String> list = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, mimeLocation.subfolderName());
        if (mimeLocation.instanceProviderClass() != null && mimeLocation.instanceProviderClass() != InstanceProvider.class) {
            try {
                lookup = this.getLookupForProvider(list, (InstanceProvider)mimeLocation.instanceProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Exceptions.printStackTrace((Throwable)reflectiveOperationException);
                lookup = Lookup.EMPTY;
            }
        } else {
            lookup = this.getLookupForPaths(list);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List<String> list) {
        Object object = this.pathsLookups.get(list);
        if (object == null) {
            object = new FolderPathLookup(list.toArray(new String[0]));
            this.pathsLookups.put(list, (Lookup)object);
        }
        return object;
    }

    private Lookup getLookupForProvider(List<String> list, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(list.toArray(new String[0]), instanceProvider);
    }

    private static List<String> computePaths(MimePath mimePath, String string, String string2) {
        try {
            Method method = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            method.setAccessible(true);
            List list = (List)method.invoke((Object)mimePath, string, string2);
            return list;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
            }
            if (mimePath.size() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(mimePath.getPath());
            }
            if (string2 != null && string2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string2);
            }
            return Collections.singletonList(stringBuilder.toString());
        }
    }
}

