/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.testing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.List;

public class ListConsistencyListener<E> {
    private List<E> expected;
    private String name;
    private EventList<E> source;
    private boolean verbose = false;
    private boolean previousElementTracked = true;
    private List<Integer> changeCounts = new ArrayList<Integer>();
    private List<Boolean> reorderings = new ArrayList<Boolean>();

    private ListConsistencyListener(EventList<E> source, String name, boolean verbose) {
        this.source = source;
        this.name = name != null ? name : source.getClass().getName();
        this.verbose = verbose;
        this.expected = new ArrayList<E>(source);
        source.addListEventListener(new ListChangeHandler());
    }

    public static <E> ListConsistencyListener<E> install(EventList<E> source, String name, boolean verbose) {
        return new ListConsistencyListener<E>(source, name, verbose);
    }

    public static <E> ListConsistencyListener<E> install(EventList<E> source) {
        return ListConsistencyListener.install(source, null, false);
    }

    public int getEventCount() {
        return this.changeCounts.size();
    }

    public int getChangeCount(int event) {
        return this.changeCounts.get(event);
    }

    public boolean isReordering(int event) {
        return this.reorderings.get(event);
    }

    public void assertConsistent() {
        this.assertTrue(this.expected.size() == this.source.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            this.assertTrue("Different elements at " + i + " (expected=" + this.expected.get(i) + ", is=" + this.source.get(i), this.expected.get(i) == this.source.get(i));
        }
    }

    public void assertTrue(boolean condition) {
        if (!condition) {
            System.out.println("");
        }
        this.assertTrue("Assertion failed", condition);
    }

    public void assertTrue(String message, boolean condition) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public void setPreviousElementTracked(boolean previousElementTracked) {
        this.previousElementTracked = previousElementTracked;
    }

    public static void assertEventsInIncreasingOrder(ListEvent listChanges) {
        listChanges.reset();
        StringBuffer changeDescription = new StringBuffer();
        int previousChangeIndex = -1;
        int previousChangeType = 0;
        boolean increasingOrder = true;
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 1) {
                changeDescription.append("U");
            } else if (changeType == 2) {
                changeDescription.append("I");
            } else if (changeType == 0) {
                changeDescription.append("D");
            }
            changeDescription.append(changeIndex);
            if (changeIndex < previousChangeIndex || changeIndex == previousChangeIndex && previousChangeType != 0) {
                increasingOrder = false;
                changeDescription.append("*");
            }
            changeDescription.append(" ");
            previousChangeIndex = changeIndex;
            previousChangeType = changeType;
        }
        if (!increasingOrder) {
            System.out.println("List changes not in increasing order: " + changeDescription);
        }
        listChanges.reset();
    }

    private class ListChangeHandler
    implements ListEventListener<E> {
        private ListChangeHandler() {
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            try {
                ListConsistencyListener.this.assertTrue(ListConsistencyListener.this.source == listChanges.getSource());
                ListConsistencyListener.assertEventsInIncreasingOrder(listChanges);
                if (ListConsistencyListener.this.verbose) {
                    System.out.println(ListConsistencyListener.this.name + ": " + listChanges + ", size: " + ListConsistencyListener.this.source.size() + ", source: " + ListConsistencyListener.this.source);
                }
                ArrayList<Integer> changedIndices = new ArrayList<Integer>();
                int highestChangeIndex = 0;
                if (listChanges.isReordering()) {
                    int[] reorderMap = listChanges.getReorderMap();
                    ListConsistencyListener.this.assertTrue(ListConsistencyListener.this.expected.size() == reorderMap.length);
                    ArrayList newExpectedValues = new ArrayList(ListConsistencyListener.this.expected.size());
                    for (int i = 0; i < reorderMap.length; ++i) {
                        newExpectedValues.add(i, ListConsistencyListener.this.expected.get(reorderMap[i]));
                        changedIndices.add(new Integer(i));
                    }
                    ListConsistencyListener.this.expected = newExpectedValues;
                    ListConsistencyListener.this.changeCounts.add(new Integer(2 * reorderMap.length));
                    ListConsistencyListener.this.reorderings.add(Boolean.TRUE);
                } else {
                    int changesForEvent = 0;
                    while (listChanges.next()) {
                        ++changesForEvent;
                        int changeIndex = listChanges.getIndex();
                        int changeType = listChanges.getType();
                        changedIndices.add(new Integer(changeIndex));
                        ListConsistencyListener.this.assertTrue(changeIndex >= 0);
                        ListConsistencyListener.this.assertTrue(changeIndex >= highestChangeIndex);
                        highestChangeIndex = changeIndex;
                        if (changeType == 2) {
                            Object inserted = ListConsistencyListener.this.source.get(changeIndex);
                            ListConsistencyListener.this.expected.add(changeIndex, inserted);
                            if (!ListConsistencyListener.this.previousElementTracked) continue;
                            Object reportedNew = listChanges.getNewValue();
                            continue;
                        }
                        if (changeType == 0) {
                            Object removed = ListConsistencyListener.this.expected.remove(changeIndex);
                            if (!ListConsistencyListener.this.previousElementTracked) continue;
                            Object reportedRemoved = listChanges.getOldValue();
                            ListConsistencyListener.this.assertTrue(removed == reportedRemoved);
                            continue;
                        }
                        if (changeType != 1) continue;
                        Object updated = ListConsistencyListener.this.source.get(changeIndex);
                        Object replaced = ListConsistencyListener.this.expected.set(changeIndex, updated);
                        if (!ListConsistencyListener.this.previousElementTracked) continue;
                        Object reportedReplaced = listChanges.getOldValue();
                        ListConsistencyListener.this.assertTrue(replaced == reportedReplaced);
                    }
                    ListConsistencyListener.this.changeCounts.add(new Integer(changesForEvent));
                    ListConsistencyListener.this.reorderings.add(Boolean.FALSE);
                }
                ListConsistencyListener.this.assertConsistent();
            }
            catch (RuntimeException unexpected) {
                throw new RuntimeException("Failure for " + ListConsistencyListener.this.name, unexpected);
            }
        }

        public String toString() {
            return "ConsistencyListener:" + ListConsistencyListener.this.name;
        }
    }
}

