/*
 * Decompiled with CFR 0.152.
 */
package mediathek.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;

public class WindowsVersionHelper {
    private static final int VER_MINORVERSION = 1;
    private static final int VER_MAJORVERSION = 2;
    private static final int VER_SERVICEPACKMAJOR = 32;
    private static final byte VER_GREATER_EQUAL = 3;
    private static final GroupLayout OSVERSIONINFOEXW_LAYOUT = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("dwOSVersionInfoSize"), ValueLayout.JAVA_INT.withName("dwMajorVersion"), ValueLayout.JAVA_INT.withName("dwMinorVersion"), ValueLayout.JAVA_INT.withName("dwBuildNumber"), ValueLayout.JAVA_INT.withName("dwPlatformId"), MemoryLayout.sequenceLayout(128L, ValueLayout.JAVA_CHAR).withName("szCSDVersion"), ValueLayout.JAVA_SHORT.withName("wServicePackMajor"), ValueLayout.JAVA_SHORT.withName("wServicePackMinor"), ValueLayout.JAVA_SHORT.withName("wSuiteMask"), ValueLayout.JAVA_BYTE.withName("wProductType"), ValueLayout.JAVA_BYTE.withName("wReserved")).withName("OSVERSIONINFOEXW");
    private static final long OSVERSIONINFOEXW_STRUCT_SIZE = OSVERSIONINFOEXW_LAYOUT.byteSize();

    public static boolean IsWindows10OrGreater() throws Throwable {
        return WindowsVersionHelper.isWindowsVersionOrGreater(10, 0, 0);
    }

    public static boolean IsWindows11OrGreater() throws Throwable {
        return WindowsVersionHelper.isWindowsVersionOrGreater(11, 0, 0);
    }

    protected static boolean isWindowsVersionOrGreater(int major, int minor, int servicePackMajor) throws Throwable {
        try (Arena arena = Arena.ofConfined();){
            SymbolLookup kernel32 = SymbolLookup.libraryLookup("kernel32.dll", Arena.global());
            Linker nativeLinker = Linker.nativeLinker();
            MethodHandle MH_VerSetConditionMask = nativeLinker.downcallHandle(kernel32.find("VerSetConditionMask").orElseThrow(() -> new UnsatisfiedLinkError("VerSetConditionMask not found")), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_BYTE), new Linker.Option[0]);
            MethodHandle MH_VerifyVersionInfoW = nativeLinker.downcallHandle(kernel32.find("VerifyVersionInfoW").orElseThrow(() -> new UnsatisfiedLinkError("VerifyVersionInfoW not found")), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG), new Linker.Option[0]);
            VarHandle VH_dwOSVersionInfoSize = OSVERSIONINFOEXW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("dwOSVersionInfoSize"));
            VarHandle VH_dwMajorVersion = OSVERSIONINFOEXW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("dwMajorVersion"));
            VarHandle VH_dwMinorVersion = OSVERSIONINFOEXW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("dwMinorVersion"));
            VarHandle VH_wServicePackMajor = OSVERSIONINFOEXW_LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("wServicePackMajor"));
            MemorySegment osvi = arena.allocate(OSVERSIONINFOEXW_LAYOUT);
            VH_dwOSVersionInfoSize.set(osvi, 0L, (int)OSVERSIONINFOEXW_STRUCT_SIZE);
            VH_dwMajorVersion.set(osvi, 0L, major);
            VH_dwMinorVersion.set(osvi, 0L, minor);
            VH_wServicePackMajor.set(osvi, 0L, (short)servicePackMajor);
            long conditionMask = 0L;
            conditionMask = MH_VerSetConditionMask.invokeExact(conditionMask, 2, (byte)3);
            conditionMask = MH_VerSetConditionMask.invokeExact(conditionMask, 1, (byte)3);
            conditionMask = MH_VerSetConditionMask.invokeExact(conditionMask, 32, (byte)3);
            int result = MH_VerifyVersionInfoW.invokeExact(osvi, 35, conditionMask);
            boolean bl = result != 0;
            return bl;
        }
    }
}

