/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;
import mediathek.javafx.bookmark.BookmarkData;
import org.jetbrains.annotations.NotNull;

public class BookmarkNoteDialogController
implements Initializable {
    @FXML
    private TextArea fxNote;
    @FXML
    protected Button SaveButton;
    @FXML
    protected Button CancelButton;
    protected Stage stage;
    protected boolean datachanged;
    private BookmarkData data;

    public void initialize(URL arg0, ResourceBundle arg1) {
        ButtonBar.setButtonData((Node)this.CancelButton, (ButtonBar.ButtonData)ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonBar.setButtonData((Node)this.SaveButton, (ButtonBar.ButtonData)ButtonBar.ButtonData.OK_DONE);
    }

    @FXML
    protected void handleCancel() {
        this.datachanged = false;
        this.stage.hide();
    }

    @FXML
    protected void handleSave() {
        String fxNoteText = this.fxNote.getText();
        if (!fxNoteText.equals(this.data.getNote())) {
            this.data.setNote(fxNoteText);
            this.datachanged = true;
        }
        this.stage.hide();
    }

    public final boolean setAndShow(@NotNull Stage dlgstage, @NotNull BookmarkData data) {
        this.data = data;
        this.stage = dlgstage;
        data.getNoteOptional().ifPresentOrElse(note -> {
            this.stage.setTitle("Notizen \u00e4ndern");
            this.fxNote.setText(note);
        }, () -> {
            this.stage.setTitle("Neue Notiz");
            this.fxNote.setText("");
        });
        this.stage.showAndWait();
        return this.datachanged;
    }
}

