/*
 * Decompiled with CFR 0.152.
 */
package mediathek.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.config.Config;
import mediathek.config.Konstanten;
import mediathek.filmlisten.FilmListDownloadType;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0019\u001a\u00020\u0005H\u0007J\b\u0010\u001a\u001a\u00020\u000eH\u0007J\b\u0010\u001b\u001a\u00020\u000eH\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmediathek/config/StandardLocations;", "", "<init>", "()V", "portableBaseDirectory", "", "getPortableBaseDirectory", "()Ljava/lang/String;", "setPortableBaseDirectory", "(Ljava/lang/String;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getSettingsDirectory", "Ljava/nio/file/Path;", "getBookmarkFilePath", "getMediathekXmlFile", "getXDGDownloadDirectory", "Ljava/util/Optional;", "getStandardDownloadPath", "getFilmListUrl", "type", "Lmediathek/filmlisten/FilmListDownloadType;", "OSX_CACHE_DIRECTORY_NAME", "LOCKFILE_NAME", "getFilmlistFilePathString", "getFilmIndexPath", "getLockFilePath", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nStandardLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardLocations.kt\nmediathek/config/StandardLocations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class StandardLocations {
    @NotNull
    public static final StandardLocations INSTANCE = new StandardLocations();
    @Nullable
    private static String portableBaseDirectory;
    private static final Logger logger;
    @NotNull
    private static final String OSX_CACHE_DIRECTORY_NAME = "Library/Caches/MediathekView";
    @NotNull
    private static final String LOCKFILE_NAME = "MediathekView.lock";

    private StandardLocations() {
    }

    @Nullable
    public final String getPortableBaseDirectory() {
        return portableBaseDirectory;
    }

    public final void setPortableBaseDirectory(@Nullable String string) {
        portableBaseDirectory = string;
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final Path getSettingsDirectory() throws IllegalStateException {
        if (StandardLocations.portableBaseDirectory == null) ** GOTO lbl-1000
        v0 = StandardLocations.portableBaseDirectory;
        Intrinsics.checkNotNull((Object)v0);
        if (((CharSequence)v0).length() == 0) lbl-1000:
        // 2 sources

        {
            var2 = new String[]{".mediathek3"};
            var1_2 = Paths.get(SystemUtils.USER_HOME, var2);
            Intrinsics.checkNotNull((Object)var1_2);
            v1 = var1_2;
        } else {
            v2 = StandardLocations.portableBaseDirectory;
            Intrinsics.checkNotNull((Object)v2);
            var1_2 = Paths.get(v2, new String[0]);
            Intrinsics.checkNotNull((Object)var1_2);
            v1 = baseDirectoryPath = var1_2;
        }
        if (Files.notExists(baseDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(baseDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException ioException) {
                var4_4 = "Der Ordner \"%s\" konnte nicht angelegt werden.%n Bitte pr\u00fcfen Sie die Dateirechte.";
                var5_5 = new Object[]{baseDirectoryPath.toString()};
                v3 = String.format(var4_4, Arrays.copyOf(var5_5, var5_5.length));
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"format(...)");
                errMsg = v3;
                StandardLocations.logger.error(errMsg, (Throwable)ioException);
                throw new IllegalStateException(errMsg, ioException);
            }
        }
        return baseDirectoryPath;
    }

    @JvmStatic
    @NotNull
    public static final Path getBookmarkFilePath() {
        Path path = INSTANCE.getSettingsDirectory().resolve("bookmarks.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getMediathekXmlFile() throws InvalidPathException {
        Path path = INSTANCE.getSettingsDirectory().resolve("mediathek.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Optional<Path> getXDGDownloadDirectory() throws InvalidPathException {
        Optional<Path> optional;
        try {
            String string;
            String[] stringArray = new String[]{"xdg-user-dir", "DOWNLOAD"};
            Process process = new ProcessBuilder(stringArray).directory(new File(SystemUtils.USER_HOME)).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
            Closeable closeable = process.inputReader();
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                string = reader.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String line = string;
            optional = Optional.of(line).filter(arg_0 -> StandardLocations.getXDGDownloadDirectory$lambda$2(StandardLocations::getXDGDownloadDirectory$lambda$1, arg_0)).map(arg_0 -> StandardLocations.getXDGDownloadDirectory$lambda$4(StandardLocations::getXDGDownloadDirectory$lambda$3, arg_0));
            Intrinsics.checkNotNull(optional);
        }
        catch (IOException iOException) {
            Optional<Path> optional2 = Optional.empty();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        }
        return optional;
    }

    @JvmStatic
    @NotNull
    public static final String getStandardDownloadPath() throws InvalidPathException {
        Path path;
        String userHome = SystemUtils.USER_HOME;
        if (SystemUtils.IS_OS_MAC_OSX) {
            var2_1 = new String[]{"Downloads"};
            path = Paths.get(userHome, var2_1);
        } else if (SystemUtils.IS_OS_LINUX) {
            var2_1 = new String[]{"MediathekView"};
            path = INSTANCE.getXDGDownloadDirectory().orElse(Paths.get(userHome, var2_1));
        } else {
            var2_1 = new String[]{"MediathekView"};
            path = Paths.get(userHome, var2_1);
        }
        Path path2 = path;
        return ((Object)path2.toAbsolutePath()).toString();
    }

    @JvmStatic
    @NotNull
    public static final String getFilmListUrl(@NotNull FilmListDownloadType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> String.valueOf(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-akt.xz"));
            case 2 -> String.valueOf(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-diff.xz"));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    @NotNull
    public static final String getFilmlistFilePathString() {
        String filePart = File.separator + "filme.json";
        return Config.isPortableMode() ? INSTANCE.getSettingsDirectory() + filePart : (SystemUtils.IS_OS_MAC_OSX ? SystemUtils.USER_HOME + File.separator + OSX_CACHE_DIRECTORY_NAME + filePart : INSTANCE.getSettingsDirectory() + filePart);
    }

    @JvmStatic
    @NotNull
    public static final Path getFilmIndexPath() {
        Path path;
        String indexDirectory = "mv_index";
        if (Config.isPortableMode()) {
            Path path2 = INSTANCE.getSettingsDirectory().resolve(indexDirectory);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else {
            Path path3;
            if (SystemUtils.IS_OS_MAC_OSX) {
                Path base = Paths.get(SystemUtils.USER_HOME + File.separator + OSX_CACHE_DIRECTORY_NAME, new String[0]);
                path3 = base.resolve(indexDirectory);
            } else {
                path3 = INSTANCE.getSettingsDirectory().resolve(indexDirectory);
            }
            Path path4 = path3;
            Intrinsics.checkNotNull((Object)path4);
            path = path4;
        }
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getLockFilePath() {
        Path path = INSTANCE.getSettingsDirectory().resolve(LOCKFILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final boolean getXDGDownloadDirectory$lambda$1(String s) {
        Intrinsics.checkNotNull((Object)s);
        return ((CharSequence)s).length() > 0;
    }

    private static final boolean getXDGDownloadDirectory$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Path getXDGDownloadDirectory$lambda$3(String s) {
        return Paths.get(s, new String[0]);
    }

    private static final Path getXDGDownloadDirectory$lambda$4(Function1 $tmp0, Object p0) {
        return (Path)$tmp0.invoke(p0);
    }

    static {
        logger = LogManager.getLogger();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilmListDownloadType.values().length];
            try {
                nArray[FilmListDownloadType.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilmListDownloadType.DIFF_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

