/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.file.FileCollection;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.catalog.AbstractSourceGenerator;
import org.gradle.api.internal.catalog.ClassSource;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependenciesAccessorsWorkspaceProvider;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.internal.catalog.LibrariesSourceGenerator;
import org.gradle.api.internal.catalog.ProjectAccessorsSourceGenerator;
import org.gradle.api.internal.catalog.RootProjectAccessorSourceGenerator;
import org.gradle.api.internal.catalog.SimpleGeneratedJavaClassCompiler;
import org.gradle.api.internal.catalog.TypeSafeProjectDependencyFactory;
import org.gradle.api.internal.catalog.VersionCatalogView;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.problems.Problems;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.initialization.DependenciesAccessors;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.management.VersionCatalogBuilderInternal;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.util.internal.IncubationLogger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDependenciesAccessors
implements DependenciesAccessors {
    private static final String SUPPORTED_PROJECT_NAMES = "[a-zA-Z]([A-Za-z0-9\\-_])*";
    private static final Pattern SUPPORTED_PATTERN = Pattern.compile("[a-zA-Z]([A-Za-z0-9\\-_])*");
    private static final String ACCESSORS_PACKAGE = "org.gradle.accessors.dm";
    private static final String ACCESSORS_CLASSNAME_PREFIX = "LibrariesFor";
    private static final String ROOT_PROJECT_ACCESSOR_FQCN = "org.gradle.accessors.dm.RootProjectAccessor";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependenciesAccessors.class);
    private final ClassPath classPath;
    private final DependenciesAccessorsWorkspaceProvider workspace;
    private final DefaultProjectDependencyFactory projectDependencyFactory;
    private final FeatureFlags featureFlags;
    private final ExecutionEngine engine;
    private final FileCollectionFactory fileCollectionFactory;
    private final InputFingerprinter inputFingerprinter;
    private final AttributesFactory attributesFactory;
    private final CapabilityNotationParser capabilityNotationParser;
    private final Problems problemsService;
    private final List<DefaultVersionCatalog> models = new ArrayList<DefaultVersionCatalog>();
    private final Map<String, Class<? extends ExternalModuleDependencyFactory>> factories = new HashMap<String, Class<? extends ExternalModuleDependencyFactory>>();
    private ClassLoaderScope classLoaderScope;
    private Class<? extends TypeSafeProjectDependencyFactory> generatedProjectFactory;
    private ClassPath sources = DefaultClassPath.of((File[])new File[0]);
    private ClassPath classes = DefaultClassPath.of((File[])new File[0]);

    @Inject
    public DefaultDependenciesAccessors(ClassPathRegistry registry, DependenciesAccessorsWorkspaceProvider workspace, DefaultProjectDependencyFactory projectDependencyFactory, FeatureFlags featureFlags, ExecutionEngine engine, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser, Problems problemsService) {
        this.classPath = registry.getClassPath("DEPENDENCIES-EXTENSION-COMPILER");
        this.workspace = workspace;
        this.projectDependencyFactory = projectDependencyFactory;
        this.featureFlags = featureFlags;
        this.engine = engine;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.attributesFactory = attributesFactory;
        this.capabilityNotationParser = capabilityNotationParser;
        this.problemsService = problemsService;
    }

    public void generateAccessors(List<VersionCatalogBuilder> builders, ClassLoaderScope classLoaderScope, Settings settings) {
        try {
            this.classLoaderScope = classLoaderScope;
            this.models.clear();
            for (VersionCatalogBuilder builder : builders) {
                DefaultVersionCatalog model = ((VersionCatalogBuilderInternal)builder).build();
                this.models.add(model);
            }
            if (this.models.stream().anyMatch(DefaultVersionCatalog::isNotEmpty)) {
                for (DefaultVersionCatalog model : this.models) {
                    if (!model.isNotEmpty()) continue;
                    this.writeDependenciesAccessors(model);
                }
            }
            if (this.featureFlags.isEnabled((FeatureFlag)FeaturePreviews.Feature.TYPESAFE_PROJECT_ACCESSORS)) {
                IncubationLogger.incubatingFeatureUsed((String)"Type-safe project accessors");
                this.writeProjectAccessors(((SettingsInternal)settings).getProjectRegistry());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDependenciesAccessors(DefaultVersionCatalog model) {
        this.executeWork((UnitOfWork)new DependencyAccessorUnitOfWork(model));
    }

    private void writeProjectAccessors(ProjectDescriptorRegistry projectRegistry) {
        if (!DefaultDependenciesAccessors.assertCanGenerateAccessors(projectRegistry)) {
            return;
        }
        DefaultDependenciesAccessors.warnIfRootProjectNameNotSetExplicitly(projectRegistry.getRootProject());
        this.executeWork((UnitOfWork)new ProjectAccessorUnitOfWork(projectRegistry));
    }

    private static void warnIfRootProjectNameNotSetExplicitly(@Nullable ProjectDescriptorInternal project) {
        if (!project.isExplicitName()) {
            LOGGER.warn("Project accessors enabled, but root project name not explicitly set for '" + project.getName() + "'. Checking out the project in different folders will impact the generated code and implicitly the buildscript classpath, breaking caching.");
        }
    }

    private void executeWork(UnitOfWork work) {
        ExecutionEngine.Result result = this.engine.createRequest(work).execute();
        GeneratedAccessors accessors = (GeneratedAccessors)result.getOutputAs(GeneratedAccessors.class).get();
        ClassPath generatedClasses = DefaultClassPath.of((File[])new File[]{accessors.classesDir});
        this.sources = this.sources.plus(DefaultClassPath.of((File[])new File[]{accessors.sourcesDir}));
        this.classes = this.classes.plus(generatedClasses);
        this.classLoaderScope.export(generatedClasses);
    }

    private static boolean assertCanGenerateAccessors(ProjectDescriptorRegistry projectRegistry) {
        ArrayList errors = new ArrayList();
        projectRegistry.getAllProjects().stream().map(ProjectDescriptor::getName).filter(p -> !SUPPORTED_PATTERN.matcher((CharSequence)p).matches()).map(name -> "project '" + name + "' doesn't follow the naming convention: " + SUPPORTED_PROJECT_NAMES).forEach(errors::add);
        for (ProjectDescriptor project : projectRegistry.getAllProjects()) {
            project.getChildren().stream().map(ProjectDescriptor::getName).collect(Collectors.groupingBy(AbstractSourceGenerator::toJavaName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEachOrdered(e -> {
                String javaName = (String)e.getKey();
                List names = (List)e.getValue();
                errors.add("subprojects " + names + " of project " + project.getPath() + " map to the same method name get" + javaName + "()");
            });
        }
        if (!errors.isEmpty()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot generate project dependency accessors");
            formatter.startChildren();
            for (String error : errors) {
                formatter.node("Cannot generate project dependency accessors because " + error);
            }
            formatter.endChildren();
            throw new InvalidUserDataException(formatter.toString());
        }
        return errors.isEmpty();
    }

    private static <T> @Nullable Class<? extends T> loadFactory(ClassLoaderScope classLoaderScope, String className) {
        Class clazz;
        try {
            clazz = (Class)Cast.uncheckedCast(classLoaderScope.getExportClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExtensions(ProjectInternal project) {
        ExtensionContainerInternal container = project.getExtensions();
        ProviderFactory providerFactory = project.getProviders();
        try {
            if (this.models.isEmpty()) {
                this.addVersionCatalogsProjectExtension((ExtensionContainer)container, Collections.emptyMap());
            } else {
                ImmutableMap.Builder catalogs = ImmutableMap.builderWithExpectedSize((int)this.models.size());
                for (DefaultVersionCatalog model : this.models) {
                    Class<? extends ExternalModuleDependencyFactory> factory;
                    if (!model.isNotEmpty() || (factory = this.loadVersionCatalogFactoryClass(this.accessorClassNameSuffix(model))) == null) continue;
                    container.create(model.getName(), factory, new Object[]{model});
                    catalogs.put((Object)model.getName(), (Object)new VersionCatalogView(model, providerFactory, project.getObjects(), this.attributesFactory, this.capabilityNotationParser));
                }
                this.addVersionCatalogsProjectExtension((ExtensionContainer)container, (Map<String, VersionCatalog>)catalogs.build());
            }
        }
        finally {
            if (this.featureFlags.isEnabled((FeatureFlag)FeaturePreviews.Feature.TYPESAFE_PROJECT_ACCESSORS)) {
                ServiceRegistry services = project.getServices();
                DependencyResolutionManagementInternal drm = (DependencyResolutionManagementInternal)services.get(DependencyResolutionManagementInternal.class);
                ProjectFinder projectFinder = (ProjectFinder)services.get(ProjectFinder.class);
                this.createProjectsExtension((ExtensionContainer)container, drm, projectFinder);
            }
        }
    }

    private void addVersionCatalogsProjectExtension(ExtensionContainer container, Map<String, VersionCatalog> catalogs) {
        container.create(VersionCatalogsExtension.class, "versionCatalogs", DefaultVersionCatalogsExtension.class, new Object[]{catalogs});
    }

    private String accessorClassNameSuffix(DefaultVersionCatalog model) {
        return StringUtils.capitalize((String)model.getName());
    }

    public Map<String, ExternalModuleDependencyFactory> createPluginsBlockFactories(ObjectFactory objects) {
        if (!this.models.isEmpty()) {
            ImmutableMap.Builder catalogs = ImmutableMap.builderWithExpectedSize((int)this.models.size());
            for (DefaultVersionCatalog model : this.models) {
                Class<? extends ExternalModuleDependencyFactory> factory;
                if (!model.isNotEmpty() || (factory = this.loadVersionCatalogFactoryClass(this.pluginsBlockAccessorClassNameSuffix(model))) == null) continue;
                catalogs.put((Object)model.getName(), (Object)((ExternalModuleDependencyFactory)objects.newInstance(factory, new Object[]{model})));
            }
            return catalogs.build();
        }
        return Collections.emptyMap();
    }

    private String pluginsBlockAccessorClassNameSuffix(DefaultVersionCatalog model) {
        return this.accessorClassNameSuffix(model) + "InPluginsBlock";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Class<? extends ExternalModuleDependencyFactory> loadVersionCatalogFactoryClass(String accessorsClassnameSuffix) {
        Class factory;
        DefaultDependenciesAccessors defaultDependenciesAccessors = this;
        synchronized (defaultDependenciesAccessors) {
            factory = this.factories.computeIfAbsent(accessorsClassnameSuffix, n -> DefaultDependenciesAccessors.loadFactory(this.classLoaderScope, "org.gradle.accessors.dm.LibrariesFor" + accessorsClassnameSuffix));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProjectsExtension(ExtensionContainer container, DependencyResolutionManagementInternal drm, ProjectFinder projectFinder) {
        if (this.generatedProjectFactory == null) {
            DefaultDependenciesAccessors defaultDependenciesAccessors = this;
            synchronized (defaultDependenciesAccessors) {
                this.generatedProjectFactory = DefaultDependenciesAccessors.loadFactory(this.classLoaderScope, ROOT_PROJECT_ACCESSOR_FQCN);
            }
        }
        if (this.generatedProjectFactory != null) {
            Property defaultProjectsExtensionName = drm.getDefaultProjectsExtensionName();
            defaultProjectsExtensionName.finalizeValue();
            container.create((String)defaultProjectsExtensionName.get(), this.generatedProjectFactory, new Object[]{this.projectDependencyFactory, projectFinder});
        }
    }

    public ClassPath getSources() {
        return this.sources;
    }

    public ClassPath getClasses() {
        return this.classes;
    }

    private class DependencyAccessorUnitOfWork
    extends AbstractAccessorUnitOfWork {
        private static final String IN_LIBRARIES = "libraries";
        private static final String IN_BUNDLES = "bundles";
        private static final String IN_PLUGINS = "plugins";
        private static final String IN_VERSIONS = "versions";
        private static final String IN_MODEL_NAME = "modelName";
        private static final String IN_CLASSPATH = "classpath";
        private final DefaultVersionCatalog model;

        private DependencyAccessorUnitOfWork(DefaultVersionCatalog model) {
            this.model = model;
        }

        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return Optional.of(NOT_WORTH_CACHING);
        }

        @Override
        protected List<ClassSource> getClassSources() {
            return Arrays.asList(new DependenciesAccessorClassSource(this.model.getName(), this.model, DefaultDependenciesAccessors.this.problemsService), new PluginsBlockDependenciesAccessorClassSource(this.model.getName(), this.model, DefaultDependenciesAccessors.this.problemsService));
        }

        public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
            visitor.visitInputProperty(IN_LIBRARIES, this.model::getLibraryAliases);
            visitor.visitInputProperty(IN_BUNDLES, this.model::getBundleAliases);
            visitor.visitInputProperty(IN_VERSIONS, this.model::getVersionAliases);
            visitor.visitInputProperty(IN_PLUGINS, this.model::getPluginAliases);
            visitor.visitInputProperty(IN_MODEL_NAME, this.model::getName);
        }

        public void visitRegularInputs(UnitOfWork.InputVisitor visitor) {
            visitor.visitInputFileProperty(IN_CLASSPATH, InputBehavior.NON_INCREMENTAL, new UnitOfWork.InputFileValueSupplier((Object)DefaultDependenciesAccessors.this.classPath, (FileNormalizer)InputNormalizer.RUNTIME_CLASSPATH, DirectorySensitivity.IGNORE_DIRECTORIES, LineEndingSensitivity.DEFAULT, () -> DefaultDependenciesAccessors.this.fileCollectionFactory.fixed((Collection)DefaultDependenciesAccessors.this.classPath.getAsFiles())));
        }

        public String getDisplayName() {
            return "generation of dependency accessors for " + this.model.getName();
        }
    }

    private class ProjectAccessorUnitOfWork
    extends AbstractAccessorUnitOfWork {
        private static final String IN_PROJECTS = "projects";
        private final ProjectDescriptorRegistry projectRegistry;

        public ProjectAccessorUnitOfWork(ProjectDescriptorRegistry projectRegistry) {
            this.projectRegistry = projectRegistry;
        }

        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return Optional.of(NOT_WORTH_CACHING);
        }

        @Override
        protected List<ClassSource> getClassSources() {
            ArrayList<ClassSource> sources = new ArrayList<ClassSource>();
            sources.add(new RootProjectAccessorSource((ProjectDescriptor)this.projectRegistry.getRootProject()));
            for (ProjectDescriptor project : this.projectRegistry.getAllProjects()) {
                sources.add(new ProjectAccessorClassSource(project));
            }
            return sources;
        }

        public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
            visitor.visitInputProperty(IN_PROJECTS, this::buildProjectTree);
        }

        private String buildProjectTree() {
            Set allprojects = this.projectRegistry.getAllProjects();
            return allprojects.stream().map(ProjectDescriptor::getPath).sorted().collect(Collectors.joining(","));
        }

        public String getDisplayName() {
            return "generation of project accessors";
        }
    }

    private static class GeneratedAccessors {
        private final File sourcesDir;
        private final File classesDir;

        private GeneratedAccessors(File sourcesDir, File classesDir) {
            this.sourcesDir = sourcesDir;
            this.classesDir = classesDir;
        }
    }

    public static class DefaultVersionCatalogsExtension
    implements VersionCatalogsExtension {
        private final Map<String, VersionCatalog> catalogs;

        @Inject
        public DefaultVersionCatalogsExtension(Map<String, VersionCatalog> catalogs) {
            this.catalogs = catalogs;
        }

        public Optional<VersionCatalog> find(String name) {
            if (this.catalogs.containsKey(name)) {
                return Optional.of(this.catalogs.get(name));
            }
            return Optional.empty();
        }

        public Set<String> getCatalogNames() {
            return ImmutableSet.copyOf(this.catalogs.keySet());
        }

        public Iterator<VersionCatalog> iterator() {
            return this.catalogs.values().iterator();
        }
    }

    private static class RootProjectAccessorSource
    implements ClassSource {
        private final ProjectDescriptor rootProject;

        private RootProjectAccessorSource(ProjectDescriptor rootProject) {
            this.rootProject = rootProject;
        }

        @Override
        public String getPackageName() {
            return DefaultDependenciesAccessors.ACCESSORS_PACKAGE;
        }

        @Override
        public String getSimpleClassName() {
            return "RootProjectAccessor";
        }

        @Override
        public String getSource() {
            StringWriter writer = new StringWriter();
            RootProjectAccessorSourceGenerator.generateSource(writer, this.rootProject, DefaultDependenciesAccessors.ACCESSORS_PACKAGE);
            return writer.toString();
        }
    }

    private static class ProjectAccessorClassSource
    implements ClassSource {
        private final ProjectDescriptor project;
        private String className;
        private String source;

        private ProjectAccessorClassSource(ProjectDescriptor project) {
            this.project = project;
        }

        @Override
        public String getPackageName() {
            return DefaultDependenciesAccessors.ACCESSORS_PACKAGE;
        }

        @Override
        public String getSimpleClassName() {
            this.ensureInitialized();
            return this.className;
        }

        @Override
        public String getSource() {
            this.ensureInitialized();
            return this.source;
        }

        private void ensureInitialized() {
            if (this.className == null) {
                StringWriter writer = new StringWriter();
                this.className = ProjectAccessorsSourceGenerator.generateSource(writer, this.project, DefaultDependenciesAccessors.ACCESSORS_PACKAGE);
                this.source = writer.toString();
            }
        }
    }

    private static class PluginsBlockDependenciesAccessorClassSource
    implements ClassSource {
        private final String name;
        private final DefaultVersionCatalog model;
        private final Problems problemsService;

        private PluginsBlockDependenciesAccessorClassSource(String name, DefaultVersionCatalog model, Problems problemsService) {
            this.name = name;
            this.model = model;
            this.problemsService = problemsService;
        }

        @Override
        public String getPackageName() {
            return DefaultDependenciesAccessors.ACCESSORS_PACKAGE;
        }

        @Override
        public String getSimpleClassName() {
            return DefaultDependenciesAccessors.ACCESSORS_CLASSNAME_PREFIX + StringUtils.capitalize((String)this.name) + "InPluginsBlock";
        }

        @Override
        public String getSource() {
            StringWriter writer = new StringWriter();
            LibrariesSourceGenerator.generatePluginsBlockSource(writer, this.model, DefaultDependenciesAccessors.ACCESSORS_PACKAGE, this.getSimpleClassName(), this.problemsService);
            return writer.toString();
        }
    }

    private static class DependenciesAccessorClassSource
    implements ClassSource {
        private final String name;
        private final DefaultVersionCatalog model;
        private final Problems problemsService;

        private DependenciesAccessorClassSource(String name, DefaultVersionCatalog model, Problems problemsService) {
            this.name = name;
            this.model = model;
            this.problemsService = problemsService;
        }

        @Override
        public String getPackageName() {
            return DefaultDependenciesAccessors.ACCESSORS_PACKAGE;
        }

        @Override
        public String getSimpleClassName() {
            return DefaultDependenciesAccessors.ACCESSORS_CLASSNAME_PREFIX + StringUtils.capitalize((String)this.name);
        }

        @Override
        public String getSource() {
            StringWriter writer = new StringWriter();
            LibrariesSourceGenerator.generateSource(writer, this.model, DefaultDependenciesAccessors.ACCESSORS_PACKAGE, this.getSimpleClassName(), this.problemsService);
            return writer.toString();
        }
    }

    private abstract class AbstractAccessorUnitOfWork
    implements ImmutableUnitOfWork {
        private static final String OUT_SOURCES = "sources";
        private static final String OUT_CLASSES = "classes";

        private AbstractAccessorUnitOfWork() {
        }

        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            Hasher hasher = Hashing.sha1().newHasher();
            identityInputs.values().forEach(s -> s.appendToHasher(hasher));
            String identity = hasher.hash().toString();
            return () -> identity;
        }

        public ImmutableWorkspaceProvider getWorkspaceProvider() {
            return DefaultDependenciesAccessors.this.workspace;
        }

        public InputFingerprinter getInputFingerprinter() {
            return DefaultDependenciesAccessors.this.inputFingerprinter;
        }

        protected abstract List<ClassSource> getClassSources();

        public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
            File workspace = executionRequest.getWorkspace();
            File srcDir = new File(workspace, OUT_SOURCES);
            File dstDir = new File(workspace, OUT_CLASSES);
            List<ClassSource> sources = this.getClassSources();
            SimpleGeneratedJavaClassCompiler.compile(srcDir, dstDir, sources, DefaultDependenciesAccessors.this.classPath);
            return new UnitOfWork.WorkOutput(){

                public UnitOfWork.WorkResult getDidWork() {
                    return UnitOfWork.WorkResult.DID_WORK;
                }

                public Object getOutput(File workspace) {
                    return AbstractAccessorUnitOfWork.this.loadAlreadyProducedOutput(workspace);
                }
            };
        }

        public Object loadAlreadyProducedOutput(File workspace) {
            File srcDir = new File(workspace, OUT_SOURCES);
            File dstDir = new File(workspace, OUT_CLASSES);
            return new GeneratedAccessors(srcDir, dstDir);
        }

        public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
            this.visitOutputDir(visitor, workspace, OUT_SOURCES);
            this.visitOutputDir(visitor, workspace, OUT_CLASSES);
        }

        private void visitOutputDir(UnitOfWork.OutputVisitor visitor, File workspace, String propertyName) {
            File dir = new File(workspace, propertyName);
            visitor.visitOutputProperty(propertyName, TreeType.DIRECTORY, UnitOfWork.OutputFileValueSupplier.fromStatic((File)dir, (FileCollection)DefaultDependenciesAccessors.this.fileCollectionFactory.fixed(new File[]{dir})));
        }
    }
}

