# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import ApplicationInsightsManagementClientConfiguration
from .operations import EASubscriptionMigrateToNewPricingModelOperations
from .operations import EASubscriptionRollbackToLegacyPricingModelOperations
from .operations import EASubscriptionListMigrationDateOperations
from .operations import ComponentCurrentPricingPlanOperations
from .. import models


class ApplicationInsightsManagementClient(object):
    """Composite Swagger for Application Insights Management Client.

    :ivar ea_subscription_migrate_to_new_pricing_model: EASubscriptionMigrateToNewPricingModelOperations operations
    :vartype ea_subscription_migrate_to_new_pricing_model: azure.mgmt.applicationinsights.v2017_10_01.aio.operations.EASubscriptionMigrateToNewPricingModelOperations
    :ivar ea_subscription_rollback_to_legacy_pricing_model: EASubscriptionRollbackToLegacyPricingModelOperations operations
    :vartype ea_subscription_rollback_to_legacy_pricing_model: azure.mgmt.applicationinsights.v2017_10_01.aio.operations.EASubscriptionRollbackToLegacyPricingModelOperations
    :ivar ea_subscription_list_migration_date: EASubscriptionListMigrationDateOperations operations
    :vartype ea_subscription_list_migration_date: azure.mgmt.applicationinsights.v2017_10_01.aio.operations.EASubscriptionListMigrationDateOperations
    :ivar component_current_pricing_plan: ComponentCurrentPricingPlanOperations operations
    :vartype component_current_pricing_plan: azure.mgmt.applicationinsights.v2017_10_01.aio.operations.ComponentCurrentPricingPlanOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ApplicationInsightsManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.ea_subscription_migrate_to_new_pricing_model = EASubscriptionMigrateToNewPricingModelOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.ea_subscription_rollback_to_legacy_pricing_model = EASubscriptionRollbackToLegacyPricingModelOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.ea_subscription_list_migration_date = EASubscriptionListMigrationDateOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.component_current_pricing_plan = ComponentCurrentPricingPlanOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ApplicationInsightsManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
