/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.operation;

import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.text.operation.options.Operation;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.traversal.DataTraversalHandler;
import schemacrawler.utility.BinaryData;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public abstract class BaseJacksonFormatter
implements DataTraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(BaseJacksonFormatter.class.getName());
    private final OperationOptions options;
    private final JsonGenerator generator;
    private final Operation operation;
    private int dataBlockCount;

    public BaseJacksonFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) {
        this.options = Objects.requireNonNull(options, "Operation options not provided");
        Objects.requireNonNull(outputOptions, "Output options not provided");
        this.operation = Objects.requireNonNull(operation, "No operation provided");
        try {
            PrintWriter out = outputOptions.openNewOutputWriter(false);
            this.generator = BaseJacksonFormatter.newConfiguredObjectMapper(this.newMapperBuilder()).createGenerator((Writer)out);
            LOGGER.log(Level.CONFIG, this.generator.version().toFullString());
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not create JSON formatter", (Throwable)e);
        }
    }

    private static ObjectMapper newConfiguredObjectMapper(MapperBuilder<? extends ObjectMapper, ?> mapperBuilder) {
        Objects.requireNonNull(mapperBuilder, "No mapper builder provided");
        mapperBuilder.enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID});
        mapperBuilder.enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION, StreamReadFeature.IGNORE_UNDEFINED});
        mapperBuilder.enable(new StreamWriteFeature[]{StreamWriteFeature.IGNORE_UNKNOWN});
        ObjectMapper objectMapper = mapperBuilder.build();
        return objectMapper;
    }

    protected abstract MapperBuilder<? extends ObjectMapper, ?> newMapperBuilder();

    public void begin() {
        try {
            this.generator.writeStartObject();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not write JSON object", (Throwable)e);
        }
    }

    public void end() {
        try {
            this.generator.writeEndObject();
            this.generator.flush();
            this.generator.close();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not close JSON object", (Throwable)e);
        }
    }

    @Override
    public void handleData(Query query, ResultSet rows) {
        String title;
        this.writeStartDataBlock();
        if (query != null) {
            title = query.name();
            if (!Utility.isBlank((String)title)) {
                try {
                    this.generator.writeStringProperty("query", title);
                }
                catch (JacksonException e) {
                    throw new ExecutionRuntimeException("Could not write query name <%s>".formatted(title), (Throwable)e);
                }
            }
        } else {
            title = "";
        }
        this.handleData(title, rows);
        this.writeEndDataBlock();
    }

    @Override
    public void handleData(Table table, ResultSet rows) {
        String tableName;
        this.writeStartDataBlock();
        if (table != null) {
            tableName = table.getName();
            try {
                String tableType = Utility.toSnakeCase((String)table.getTableType().toString());
                this.generator.writeStringProperty(tableType, tableName);
                this.generator.writeStringProperty("schema", table.getSchema().getFullName());
            }
            catch (JacksonException e) {
                throw new ExecutionRuntimeException("Could not write table name <%s>".formatted(tableName), (Throwable)e);
            }
        } else {
            tableName = "";
        }
        this.handleData(tableName, rows);
        this.writeEndDataBlock();
    }

    public void handleHeader(CrawlInfo crawlInfo) {
        if (crawlInfo == null) {
            return;
        }
        try {
            this.generator.writeStringProperty("db", crawlInfo.getDatabaseVersion().getProductName());
            this.generator.writeStringProperty("operation", this.operation.toString());
            this.generator.flush();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not write database information", (Throwable)e);
        }
    }

    public void handleHeaderEnd() {
    }

    public void handleHeaderStart() {
    }

    private void handleData(String tableName, ResultSet rows) {
        if (rows == null) {
            return;
        }
        if (this.operation == OperationType.count) {
            this.handleTableAggregate(tableName, rows);
        } else {
            this.handleTableData(tableName, rows);
        }
    }

    private void handleTableAggregate(String title, ResultSet results) {
        long aggregate = 0L;
        try {
            aggregate = DatabaseUtility.readResultsForLong((String)title, (ResultSet)results);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not obtain aggregate data for <%s>", new Object[]{title}));
            aggregate = 0L;
        }
        try {
            this.generator.writeNumberProperty(this.operation.getName(), aggregate);
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could notcount for table".formatted(title), (Throwable)e);
        }
    }

    private void handleTableData(String title, ResultSet rows) {
        try {
            String name = "Data for %s for <%s>".formatted(this.operation, title);
            RetrievalCounts retrievalCounts = new RetrievalCounts(name.toLowerCase());
            this.generator.writeName("data");
            this.generator.writeStartArray();
            try (MetadataResultSet dataRows = new MetadataResultSet(rows, name);){
                dataRows.setShowLobs(this.options.isShowLobs());
                dataRows.setMaxRows(this.options.getMaxRows());
                while (dataRows.next()) {
                    retrievalCounts.count();
                    this.generator.writeStartObject();
                    String[] columnNames = dataRows.getColumnNames();
                    List currentRow = dataRows.row();
                    for (int i = 0; i < columnNames.length; ++i) {
                        Object element = currentRow.get(i);
                        String elementData = element == null ? null : (element instanceof BinaryData ? "<BINARY DATA>" : element.toString());
                        this.generator.writeStringProperty(columnNames[i], elementData);
                    }
                    this.generator.writeEndObject();
                    retrievalCounts.countIncluded();
                }
            }
            catch (SQLException e) {
                throw new DatabaseAccessException("Could not handle rows for <%s>".formatted(title), e);
            }
            this.generator.writeEndArray();
            retrievalCounts.log();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not write data in JSON format for <%s>".formatted(title), (Throwable)e);
        }
    }

    private void writeEndDataBlock() {
        try {
            this.generator.writeEndObject();
            this.generator.flush();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not write end of data block", (Throwable)e);
        }
    }

    private void writeStartDataBlock() {
        try {
            this.generator.writePropertyId((long)this.dataBlockCount);
            this.generator.writeStartObject();
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not write start of data block", (Throwable)e);
        }
        ++this.dataBlockCount;
    }
}

