/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedOneOfSchema
implements ComposedChanged {
    private final Map<String, String> oldMapping;
    private final Map<String, String> newMapping;
    private final DiffContext context;
    private Map<String, Schema> increased;
    private Map<String, Schema> missing;
    private Map<String, ChangedSchema> changed;

    public ChangedOneOfSchema(Map<String, String> oldMapping, Map<String, String> newMapping, DiffContext context) {
        this.oldMapping = oldMapping;
        this.newMapping = newMapping;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed.values());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isRequest() && !this.missing.isEmpty() && BackwardIncompatibleProp.REQUEST_ONEOF_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.context.isResponse() && !this.increased.isEmpty() && BackwardIncompatibleProp.RESPONSE_ONEOF_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public Map<String, String> getOldMapping() {
        return this.oldMapping;
    }

    public Map<String, String> getNewMapping() {
        return this.newMapping;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<String, Schema> getIncreased() {
        return this.increased;
    }

    public Map<String, Schema> getMissing() {
        return this.missing;
    }

    public Map<String, ChangedSchema> getChanged() {
        return this.changed;
    }

    public ChangedOneOfSchema setIncreased(Map<String, Schema> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedOneOfSchema setMissing(Map<String, Schema> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedOneOfSchema setChanged(Map<String, ChangedSchema> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedOneOfSchema that = (ChangedOneOfSchema)o;
        return Objects.equals(this.oldMapping, that.oldMapping) && Objects.equals(this.newMapping, that.newMapping) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldMapping, this.newMapping, this.context, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedOneOfSchema(oldMapping=" + this.getOldMapping() + ", newMapping=" + this.getNewMapping() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

