/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.validation.ValidationContext;
import org.keycloak.validation.ValidationError;
import org.keycloak.validation.ValidationResult;

public abstract class DefaultValidationContext<T>
implements ValidationContext<T> {
    private final ValidationContext.Event event;
    private final KeycloakSession session;
    private final T objectToValidate;
    private final Set<ValidationError> errors;

    public DefaultValidationContext(ValidationContext.Event event, KeycloakSession session, T objectToValidate) {
        this.event = event;
        this.session = session;
        this.objectToValidate = objectToValidate;
        this.errors = new HashSet<ValidationError>();
    }

    @Override
    public ValidationContext.Event getEvent() {
        return this.event;
    }

    @Override
    public KeycloakSession getSession() {
        return this.session;
    }

    @Override
    public T getObjectToValidate() {
        return this.objectToValidate;
    }

    @Override
    public ValidationContext<T> addError(String message) {
        return this.addError(null, message, null, new Object[0]);
    }

    @Override
    public ValidationContext<T> addError(String fieldId, String message) {
        return this.addError(fieldId, message, null, new Object[0]);
    }

    @Override
    public ValidationContext<T> addError(String fieldId, String message, String localizedMessageKey, Object ... localizedMessageParams) {
        this.errors.add(new ValidationError(fieldId, message, localizedMessageKey, localizedMessageParams));
        return this;
    }

    @Override
    public ValidationResult toResult() {
        return new ValidationResult(new HashSet<ValidationError>(this.errors));
    }
}

