/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.HandlerRegistry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetricsBuilder;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jdk.jfr.EventSettings;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;

public final class RuntimeMetrics
implements Closeable {
    private static final Logger logger = Logger.getLogger(RuntimeMetrics.class.getName());
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final OpenTelemetry openTelemetry;
    private final List<AutoCloseable> observables;
    @Nullable
    private final JfrRuntimeMetrics jfrRuntimeMetrics;

    RuntimeMetrics(OpenTelemetry openTelemetry, List<AutoCloseable> observables, @Nullable JfrRuntimeMetrics jfrRuntimeMetrics) {
        this.openTelemetry = openTelemetry;
        this.observables = List.copyOf(observables);
        this.jfrRuntimeMetrics = jfrRuntimeMetrics;
    }

    public static RuntimeMetrics create(OpenTelemetry openTelemetry) {
        return new RuntimeMetricsBuilder(openTelemetry).build();
    }

    public static RuntimeMetricsBuilder builder(OpenTelemetry openTelemetry) {
        return new RuntimeMetricsBuilder(openTelemetry);
    }

    OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    JfrRuntimeMetrics getJfrRuntimeMetrics() {
        return this.jfrRuntimeMetrics;
    }

    @Override
    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            logger.log(Level.WARNING, "RuntimeMetrics is already closed");
            return;
        }
        if (this.jfrRuntimeMetrics != null) {
            this.jfrRuntimeMetrics.close();
        }
        JmxRuntimeMetricsUtil.closeObservers(this.observables);
    }

    static class JfrRuntimeMetrics
    implements Closeable {
        private final List<RecordedEventHandler> recordedEventHandlers;
        private final RecordingStream recordingStream;
        private final CountDownLatch startUpLatch = new CountDownLatch(1);

        private JfrRuntimeMetrics(OpenTelemetry openTelemetry, Predicate<JfrFeature> featurePredicate) {
            this.recordedEventHandlers = HandlerRegistry.getHandlers(openTelemetry, featurePredicate);
            this.recordingStream = new RecordingStream();
            this.recordedEventHandlers.forEach(handler -> {
                EventSettings eventSettings = this.recordingStream.enable(handler.getEventName());
                handler.getPollingDuration().ifPresent(eventSettings::withPeriod);
                handler.getThreshold().ifPresent(eventSettings::withThreshold);
                this.recordingStream.onEvent(handler.getEventName(), (Consumer<RecordedEvent>)handler);
            });
            this.recordingStream.onMetadata(event -> this.startUpLatch.countDown());
            Thread daemonRunner = new Thread(() -> this.recordingStream.start());
            daemonRunner.setDaemon(true);
            daemonRunner.start();
        }

        static JfrRuntimeMetrics build(OpenTelemetry openTelemetry, Predicate<JfrFeature> featurePredicate) {
            if (!JfrRuntimeMetrics.hasJfrRecordingStream()) {
                return null;
            }
            return new JfrRuntimeMetrics(openTelemetry, featurePredicate);
        }

        @Override
        public void close() {
            this.recordingStream.close();
            this.recordedEventHandlers.forEach(RecordedEventHandler::close);
        }

        List<RecordedEventHandler> getRecordedEventHandlers() {
            return this.recordedEventHandlers;
        }

        RecordingStream getRecordingStream() {
            return this.recordingStream;
        }

        CountDownLatch getStartUpLatch() {
            return this.startUpLatch;
        }

        private static boolean hasJfrRecordingStream() {
            try {
                Class.forName("jdk.jfr.consumer.RecordingStream");
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

