/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.InsertStatement;
import org.keycloak.connections.jpa.updater.liquibase.lock.CustomInitializeDatabaseChangeLogLockTableStatement;
import org.keycloak.models.dblock.DBLockProvider;

public class CustomInsertLockRecordGenerator
extends AbstractSqlGenerator<InitializeDatabaseChangeLogLockTableStatement> {
    public int getPriority() {
        return super.getPriority() + 1;
    }

    public ValidationErrors validate(InitializeDatabaseChangeLogLockTableStatement initializeDatabaseChangeLogLockTableStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    public Sql[] generateSql(InitializeDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Set<Object> currentIds = new HashSet();
        if (statement instanceof CustomInitializeDatabaseChangeLogLockTableStatement) {
            currentIds = ((CustomInitializeDatabaseChangeLogLockTableStatement)statement).getCurrentIds();
        }
        ArrayList<Sql> result = new ArrayList<Sql>();
        for (DBLockProvider.Namespace lock : DBLockProvider.Namespace.values()) {
            if (currentIds.contains(lock.getId())) continue;
            InsertStatement insertStatement = new InsertStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName()).addColumnValue("ID", (Object)lock.getId()).addColumnValue("LOCKED", (Object)Boolean.FALSE);
            result.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql((SqlStatement)insertStatement, database)));
        }
        return result.toArray(new Sql[result.size()]);
    }
}

