/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class DisableCacheHandler
implements HttpHandler {
    private final HttpHandler next;

    public DisableCacheHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        exchange.addResponseHeader("Pragma", "no-cache");
        exchange.addResponseHeader("Expires", "0");
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new DisableCacheHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "disable-cache";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

