/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.app.DependencyInfoProvider;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;

public class QuarkusBootstrap
implements Serializable {
    private static final long serialVersionUID = -3400622859354530408L;
    private final PathCollection applicationRoot;
    private final Path projectRoot;
    private final List<AdditionalDependency> additionalApplicationArchives;
    private final List<Path> additionalDeploymentArchives;
    private final List<Path> excludeFromClassPath;
    private final Properties buildSystemProperties;
    private final Properties runtimeProperties;
    private final String baseName;
    private final String originalBaseName;
    private final Path targetDirectory;
    private final Mode mode;
    private final Boolean offline;
    private final boolean test;
    private final Boolean localProjectDiscovery;
    private final ClassLoader baseClassLoader;
    private final AppModelResolver appModelResolver;
    private final ResolvedDependency appArtifact;
    private final boolean isolateDeployment;
    private final MavenArtifactResolver mavenArtifactResolver;
    private final ArtifactCoords managingProject;
    private final List<Dependency> forcedDependencies;
    private final boolean disableClasspathCache;
    private final ApplicationModel existingModel;
    private final boolean rebuild;
    private final Set<ArtifactKey> localArtifacts;
    private final List<ClassLoaderEventListener> classLoadListeners;
    private final boolean auxiliaryApplication;
    private final boolean hostApplicationIsTestOnly;
    private final boolean assertionsEnabled;
    private final boolean defaultFlatTestClassPath;
    private final Collection<ArtifactKey> parentFirstArtifacts;
    private final Supplier<DependencyInfoProvider> depInfoProvider;

    private QuarkusBootstrap(Builder builder) {
        this.applicationRoot = builder.applicationRoot;
        this.additionalApplicationArchives = new ArrayList<AdditionalDependency>(builder.additionalApplicationArchives);
        this.excludeFromClassPath = new ArrayList<Path>(builder.excludeFromClassPath);
        this.projectRoot = builder.projectRoot != null ? builder.projectRoot.normalize() : null;
        this.buildSystemProperties = builder.buildSystemProperties != null ? builder.buildSystemProperties : new Properties();
        this.runtimeProperties = builder.runtimeProperties != null ? builder.runtimeProperties : new Properties();
        this.mode = builder.mode;
        this.offline = builder.offline;
        this.test = builder.test;
        this.localProjectDiscovery = builder.localProjectDiscovery;
        this.baseName = builder.baseName;
        this.originalBaseName = builder.originalJarName;
        this.baseClassLoader = builder.baseClassLoader;
        this.targetDirectory = builder.targetDirectory;
        this.appModelResolver = builder.appModelResolver;
        this.assertionsEnabled = builder.assertionsEnabled;
        this.appArtifact = builder.appArtifact;
        this.isolateDeployment = builder.isolateDeployment;
        this.additionalDeploymentArchives = builder.additionalDeploymentArchives;
        this.mavenArtifactResolver = builder.mavenArtifactResolver;
        this.managingProject = builder.managingProject;
        this.forcedDependencies = new ArrayList<Dependency>(builder.forcedDependencies);
        this.disableClasspathCache = builder.disableClasspathCache;
        this.existingModel = builder.existingModel;
        this.rebuild = builder.rebuild;
        this.localArtifacts = new HashSet<ArtifactKey>(builder.localArtifacts);
        this.classLoadListeners = builder.classLoadListeners;
        this.auxiliaryApplication = builder.auxiliaryApplication;
        this.hostApplicationIsTestOnly = builder.hostApplicationIsTestOnly;
        this.defaultFlatTestClassPath = builder.flatClassPath;
        this.parentFirstArtifacts = builder.parentFirstArtifacts;
        this.depInfoProvider = builder.depInfoProvider;
    }

    public CuratedApplication bootstrap() throws BootstrapException {
        CurationResult curationResult;
        CurationResult curationResult2 = curationResult = this.existingModel != null ? new CurationResult(this.existingModel) : this.newAppModelFactory().resolveAppModel();
        if (curationResult.getApplicationModel().getAppArtifact() != null) {
            if (curationResult.getApplicationModel().getAppArtifact().getArtifactId() != null) {
                this.buildSystemProperties.putIfAbsent("quarkus.application.name", curationResult.getApplicationModel().getAppArtifact().getArtifactId());
            }
            if (curationResult.getApplicationModel().getAppArtifact().getVersion() != null) {
                this.buildSystemProperties.putIfAbsent("quarkus.application.version", curationResult.getApplicationModel().getAppArtifact().getVersion());
            }
        }
        ConfiguredClassLoading classLoadingConfig = ConfiguredClassLoading.builder().setApplicationRoot(this.applicationRoot).setDefaultFlatTestClassPath(this.defaultFlatTestClassPath).setMode(this.mode).addParentFirstArtifacts(this.parentFirstArtifacts).setApplicationModel(curationResult.getApplicationModel()).build();
        return new CuratedApplication(this, curationResult, classLoadingConfig);
    }

    public BootstrapAppModelFactory newAppModelFactory() {
        BootstrapAppModelFactory appModelFactory = BootstrapAppModelFactory.newInstance().setOffline(this.offline).setMavenArtifactResolver(this.mavenArtifactResolver).setBootstrapAppModelResolver(this.appModelResolver).setLocalProjectsDiscovery(this.localProjectDiscovery).setAppArtifact(this.appArtifact).setManagingProject(this.managingProject).setForcedDependencies(this.forcedDependencies).setLocalArtifacts(this.localArtifacts).setProjectRoot(this.projectRoot);
        if (this.mode == Mode.TEST || this.test) {
            appModelFactory.setTest(true);
            if (!this.disableClasspathCache) {
                appModelFactory.setEnableClasspathCache(true);
            }
        }
        if (this.mode == Mode.DEV) {
            appModelFactory.setDevMode(true);
            if (!this.disableClasspathCache) {
                appModelFactory.setEnableClasspathCache(true);
            }
        }
        return appModelFactory;
    }

    public PathCollection getApplicationRoot() {
        return this.applicationRoot;
    }

    public List<AdditionalDependency> getAdditionalApplicationArchives() {
        return Collections.unmodifiableList(this.additionalApplicationArchives);
    }

    public List<Path> getAdditionalDeploymentArchives() {
        return Collections.unmodifiableList(this.additionalDeploymentArchives);
    }

    public List<Path> getExcludeFromClassPath() {
        return Collections.unmodifiableList(this.excludeFromClassPath);
    }

    public Properties getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public Properties getRuntimeProperties() {
        return this.runtimeProperties;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isAuxiliaryApplication() {
        return this.auxiliaryApplication;
    }

    public boolean isHostApplicationIsTestOnly() {
        return this.hostApplicationIsTestOnly;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder builder(Path applicationRoot) {
        return new Builder().setApplicationRoot((PathCollection)PathList.of((Path[])new Path[]{applicationRoot}));
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getOriginalBaseName() {
        return this.originalBaseName;
    }

    public ClassLoader getBaseClassLoader() {
        return this.baseClassLoader;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isIsolateDeployment() {
        return this.isolateDeployment;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    public List<ClassLoaderEventListener> getClassLoaderEventListeners() {
        return this.classLoadListeners;
    }

    public Builder clonedBuilder() {
        Builder builder = new Builder().setBaseName(this.baseName).setOriginalBaseName(this.originalBaseName).setProjectRoot(this.projectRoot).setBaseClassLoader(this.baseClassLoader).setBuildSystemProperties(this.buildSystemProperties).setRuntimeProperties(this.runtimeProperties).setMode(this.mode).setTest(this.test).setLocalProjectDiscovery(this.localProjectDiscovery).setTargetDirectory(this.targetDirectory).setAppModelResolver(this.appModelResolver).setAssertionsEnabled(this.assertionsEnabled).setIsolateDeployment(this.isolateDeployment).setMavenArtifactResolver(this.mavenArtifactResolver).setManagingProject(this.managingProject).setForcedDependencies(this.forcedDependencies).setDisableClasspathCache(this.disableClasspathCache).addClassLoaderEventListeners(this.classLoadListeners).setExistingModel(this.existingModel);
        if (this.appArtifact != null) {
            builder.setAppArtifact(this.appArtifact);
        } else {
            builder.setApplicationRoot(this.applicationRoot);
        }
        if (this.offline != null) {
            builder.setOffline(this.offline);
        }
        builder.additionalApplicationArchives.addAll(this.additionalApplicationArchives);
        builder.additionalDeploymentArchives.addAll(this.additionalDeploymentArchives);
        builder.excludeFromClassPath.addAll(this.excludeFromClassPath);
        builder.localArtifacts.addAll(this.localArtifacts);
        return builder;
    }

    public boolean isTest() {
        return this.test;
    }

    public Supplier<DependencyInfoProvider> getDependencyInfoProvider() {
        return this.depInfoProvider;
    }

    public static class Builder {
        public List<ClassLoaderEventListener> classLoadListeners = new ArrayList<ClassLoaderEventListener>();
        public boolean hostApplicationIsTestOnly;
        boolean flatClassPath;
        boolean rebuild;
        PathCollection applicationRoot;
        String baseName;
        String originalJarName;
        Path projectRoot;
        ClassLoader baseClassLoader = ClassLoader.getSystemClassLoader();
        final List<AdditionalDependency> additionalApplicationArchives = new ArrayList<AdditionalDependency>();
        final List<Path> additionalDeploymentArchives = new ArrayList<Path>();
        final List<Path> excludeFromClassPath = new ArrayList<Path>();
        Properties buildSystemProperties;
        Properties runtimeProperties;
        Mode mode = Mode.PROD;
        Boolean offline;
        boolean test;
        Boolean localProjectDiscovery;
        Path targetDirectory;
        AppModelResolver appModelResolver;
        boolean assertionsEnabled = this.inheritedAssertionsEnabled();
        ResolvedDependency appArtifact;
        boolean isolateDeployment;
        MavenArtifactResolver mavenArtifactResolver;
        ArtifactCoords managingProject;
        List<Dependency> forcedDependencies = Collections.emptyList();
        boolean disableClasspathCache;
        ApplicationModel existingModel;
        final Set<ArtifactKey> localArtifacts = new HashSet<ArtifactKey>();
        boolean auxiliaryApplication;
        List<ArtifactKey> parentFirstArtifacts = new ArrayList<ArtifactKey>();
        Supplier<DependencyInfoProvider> depInfoProvider;

        public Builder setApplicationRoot(Path applicationRoot) {
            this.applicationRoot = PathList.of((Path[])new Path[]{applicationRoot});
            return this;
        }

        public Builder setApplicationRoot(PathCollection applicationRoot) {
            if (this.appArtifact != null) {
                throw new IllegalStateException("Cannot set both app artifact and application root");
            }
            this.applicationRoot = applicationRoot;
            return this;
        }

        public Builder addAdditionalApplicationArchive(AdditionalDependency path) {
            this.additionalApplicationArchives.add(path);
            return this;
        }

        public Builder addAdditionalApplicationArchives(Collection<AdditionalDependency> path) {
            this.additionalApplicationArchives.addAll(path);
            return this;
        }

        public Builder addAdditionalDeploymentArchive(Path path) {
            this.additionalDeploymentArchives.add(path);
            return this;
        }

        public Builder setFlatClassPath(boolean flatClassPath) {
            this.flatClassPath = flatClassPath;
            return this;
        }

        public Builder addExcludedPath(Path path) {
            this.excludeFromClassPath.add(path);
            return this;
        }

        public Builder setProjectRoot(Path projectRoot) {
            this.projectRoot = projectRoot;
            return this;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public Builder setRuntimeProperties(Properties runtimeProperties) {
            this.runtimeProperties = runtimeProperties;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setTest(boolean test) {
            this.test = test;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setHostApplicationIsTestOnly(boolean hostApplicationIsTestOnly) {
            this.hostApplicationIsTestOnly = hostApplicationIsTestOnly;
            return this;
        }

        public Builder setAuxiliaryApplication(boolean auxiliaryApplication) {
            this.auxiliaryApplication = auxiliaryApplication;
            return this;
        }

        public Builder setLocalProjectDiscovery(Boolean localProjectDiscovery) {
            this.localProjectDiscovery = localProjectDiscovery;
            return this;
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Builder setOriginalBaseName(String originalJarName) {
            this.originalJarName = originalJarName;
            return this;
        }

        public Builder setBaseClassLoader(ClassLoader baseClassLoader) {
            this.baseClassLoader = baseClassLoader;
            return this;
        }

        public Builder setTargetDirectory(Path targetDirectory) {
            this.targetDirectory = targetDirectory;
            return this;
        }

        public Builder setAppModelResolver(AppModelResolver appModelResolver) {
            this.appModelResolver = appModelResolver;
            return this;
        }

        public Builder setDisableClasspathCache(boolean disableClasspathCache) {
            this.disableClasspathCache = disableClasspathCache;
            return this;
        }

        public Builder addParentFirstArtifact(ArtifactKey appArtifactKey) {
            this.parentFirstArtifacts.add(appArtifactKey);
            return this;
        }

        public Builder setAppArtifact(ResolvedDependency appArtifact) {
            if (this.applicationRoot != null) {
                throw new IllegalStateException("Cannot set both application root and app artifact");
            }
            this.appArtifact = appArtifact;
            this.applicationRoot = PathList.from((Iterable)appArtifact.getResolvedPaths());
            if (appArtifact.getResolvedPaths().isSinglePath()) {
                this.projectRoot = appArtifact.getResolvedPaths().getSinglePath();
            }
            return this;
        }

        public Builder setManagingProject(ArtifactCoords managingProject) {
            this.managingProject = managingProject;
            return this;
        }

        public Builder setIsolateDeployment(boolean isolateDeployment) {
            this.isolateDeployment = isolateDeployment;
            return this;
        }

        public Builder setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
            this.mavenArtifactResolver = mavenArtifactResolver;
            return this;
        }

        public Builder setForcedDependencies(List<Dependency> forcedDependencies) {
            this.forcedDependencies = forcedDependencies;
            return this;
        }

        public ApplicationModel getExistingModel() {
            return this.existingModel;
        }

        public Builder setExistingModel(ApplicationModel existingModel) {
            this.existingModel = existingModel;
            return this;
        }

        public Builder addLocalArtifact(ArtifactKey key) {
            this.localArtifacts.add(key);
            return this;
        }

        public Builder clearLocalArtifacts() {
            this.localArtifacts.clear();
            return this;
        }

        public Builder setRebuild(boolean value) {
            this.rebuild = value;
            return this;
        }

        public Builder addClassLoaderEventListeners(List<ClassLoaderEventListener> classLoadListeners) {
            this.classLoadListeners.addAll(classLoadListeners);
            return this;
        }

        public Builder setAssertionsEnabled(boolean assertionsEnabled) {
            this.assertionsEnabled = assertionsEnabled;
            return this;
        }

        private boolean inheritedAssertionsEnabled() {
            boolean result = false;
            if (!$assertionsDisabled) {
                result = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return result;
        }

        public Builder setDependencyInfoProvider(Supplier<DependencyInfoProvider> depInfoProvider) {
            this.depInfoProvider = depInfoProvider;
            return this;
        }

        public QuarkusBootstrap build() {
            Objects.requireNonNull(this.applicationRoot, "Application root must not be null");
            if (this.appArtifact != null) {
                this.localArtifacts.add(this.appArtifact.getKey());
            }
            return new QuarkusBootstrap(this);
        }
    }

    public static enum Mode {
        DEV,
        TEST,
        RUN,
        PROD,
        REMOTE_DEV_SERVER,
        REMOTE_DEV_CLIENT,
        CONTINUOUS_TEST;

    }
}

