/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticatorFactory;
import org.keycloak.authentication.authenticators.conditional.ConditionalUserAttributeValue;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class ConditionalUserAttributeValueFactory
implements ConditionalAuthenticatorFactory {
    public static final String PROVIDER_ID = "conditional-user-attribute";
    public static final String CONF_ATTRIBUTE_NAME = "attribute_name";
    public static final String CONF_ATTRIBUTE_EXPECTED_VALUE = "attribute_expected_value";
    public static final String CONF_INCLUDE_GROUP_ATTRIBUTES = "include_group_attributes";
    public static final String CONF_NOT = "not";
    public static final String REGEX = "regex";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Condition - user attribute";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Flow is executed only if the user attribute exists and has the expected value";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty authNoteName = new ProviderConfigProperty();
        authNoteName.setType("String");
        authNoteName.setName(CONF_ATTRIBUTE_NAME);
        authNoteName.setLabel("Attribute name");
        authNoteName.setHelpText("Name of the attribute to check");
        ProviderConfigProperty authNoteExpectedValue = new ProviderConfigProperty();
        authNoteExpectedValue.setType("String");
        authNoteExpectedValue.setName(CONF_ATTRIBUTE_EXPECTED_VALUE);
        authNoteExpectedValue.setLabel("Expected attribute value");
        authNoteExpectedValue.setHelpText("Expected value in the attribute");
        ProviderConfigProperty includeGroupAttributes = new ProviderConfigProperty();
        includeGroupAttributes.setType("boolean");
        includeGroupAttributes.setName(CONF_INCLUDE_GROUP_ATTRIBUTES);
        includeGroupAttributes.setLabel("Include group attributes");
        includeGroupAttributes.setHelpText("If On, the condition checks if any of the joined groups has one attribute matching the configured name and value (this option can affect performance)");
        ProviderConfigProperty negateOutput = new ProviderConfigProperty();
        negateOutput.setType("boolean");
        negateOutput.setName(CONF_NOT);
        negateOutput.setLabel("Negate output");
        negateOutput.setHelpText("Apply a not to the check result");
        ProviderConfigProperty regexOutput = new ProviderConfigProperty();
        regexOutput.setType("boolean");
        regexOutput.setName(REGEX);
        regexOutput.setLabel(REGEX);
        regexOutput.setHelpText("Check equality with regex");
        return Arrays.asList(authNoteName, authNoteExpectedValue, includeGroupAttributes, negateOutput, regexOutput);
    }

    @Override
    public ConditionalAuthenticator getSingleton() {
        return ConditionalUserAttributeValue.SINGLETON;
    }
}

