/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import java.lang.invoke.MethodType;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.InvocationCompiler;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.indy.IndyInvocationCompiler;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class NormalInvocationCompiler
implements InvocationCompiler {
    private final IRBytecodeAdapter compiler;
    public static final String SUPER_SPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class));
    public static final String SUPER_SPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class));

    public NormalInvocationCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void invokeOther(String file2, String scopeFieldName, CallBase call2, int arity2) {
        this.invoke(file2, this.compiler.getLastLine(), scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeArrayDeref(String file2, String scopeFieldName, CallBase call2) {
        MethodType type2 = MethodType.methodType(JVM.OBJECT, ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyString.class);
        String incomingSig = CodegenUtils.sig(type2);
        String methodName = this.compiler.getUniqueSiteName(call2.getId());
        String clsName = this.compiler.getClassData().clsName;
        this.compiler.outline(methodName, type2, () -> {
            this.compiler.adapter.aloadMany(0, 1, 2, 3);
            this.compiler.getValueCompiler().pushCallSite(clsName, methodName, scopeFieldName, call2);
            this.compiler.adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "callOptimizedAref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyString.class, CallSite.class));
            this.compiler.adapter.areturn();
        });
        this.compiler.adapter.invokestatic(clsName, methodName, incomingSig);
    }

    public void invoke(String file2, int lineNumber, String scopeFieldName, CallBase call2, int arity2) {
        MethodType outgoing;
        MethodType incoming;
        boolean functional;
        String id = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to '" + id + "' has more than 250 arguments");
        }
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        boolean blockGiven = blockPassType.given();
        boolean bl = functional = call2.getCallType() == CallType.FUNCTIONAL || call2.getCallType() == CallType.VARIABLE;
        if (functional) {
            if (blockGiven) {
                switch (arity2) {
                    case -1: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                        break;
                    }
                    default: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                        break;
                    }
                }
            } else {
                switch (arity2) {
                    case -1: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY));
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2));
                        break;
                    }
                    default: {
                        incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, arity2));
                        outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT_ARRAY));
                        break;
                    }
                }
            }
        } else if (blockGiven) {
            switch (arity2) {
                case -1: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    break;
                }
                default: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
            }
        } else {
            switch (arity2) {
                case -1: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    break;
                }
                default: {
                    incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                }
            }
        }
        String incomingSig = CodegenUtils.sig(incoming);
        String outgoingSig = CodegenUtils.sig(outgoing);
        String methodName = this.compiler.getUniqueSiteName(id);
        String clsName = this.compiler.getClassData().clsName;
        this.compiler.outline(methodName, incoming, () -> {
            int selfBase;
            this.compiler.adapter.line(lineNumber);
            this.compiler.getValueCompiler().pushCallSite(clsName, methodName, scopeFieldName, call2);
            this.compiler.adapter.aload(0);
            if (functional) {
                selfBase = 1;
            } else {
                selfBase = 2;
                this.compiler.adapter.aload(1);
            }
            this.compiler.adapter.aload(selfBase);
            switch (arity2) {
                case -1: 
                case 1: {
                    this.compiler.adapter.aload(selfBase + 1);
                    if (!blockGiven) break;
                    this.compiler.adapter.aload(selfBase + 2);
                    break;
                }
                case 0: {
                    if (!blockGiven) break;
                    this.compiler.adapter.aload(selfBase + 1);
                    break;
                }
                case 2: {
                    this.compiler.adapter.aload(selfBase + 1);
                    this.compiler.adapter.aload(selfBase + 2);
                    if (!blockGiven) break;
                    this.compiler.adapter.aload(selfBase + 3);
                    break;
                }
                case 3: {
                    this.compiler.adapter.aload(selfBase + 1);
                    this.compiler.adapter.aload(selfBase + 2);
                    this.compiler.adapter.aload(selfBase + 3);
                    if (!blockGiven) break;
                    this.compiler.adapter.aload(selfBase + 4);
                    break;
                }
                default: {
                    IRBytecodeAdapter.buildArrayFromLocals(this.compiler.adapter, selfBase + 1, arity2);
                    if (!blockGiven) break;
                    this.compiler.adapter.aload(selfBase + 1 + arity2);
                }
            }
            String callName = functional ? (blockPassType.literal() ? "fcallIter" : "fcall") : (blockPassType.literal() ? "callIter" : "call");
            this.compiler.adapter.invokevirtual(CodegenUtils.p(CachingCallSite.class), callName, outgoingSig);
            this.compiler.adapter.areturn();
        });
        this.setCallInfo(call2.getFlags());
        this.compiler.adapter.invokestatic(clsName, methodName, incomingSig);
    }

    @Override
    public void invokeOtherOneFixnum(String file2, CallBase call2, long fixnum) {
        MethodType outgoing;
        MethodType incoming;
        boolean functional = call2.getCallType() == CallType.FUNCTIONAL || call2.getCallType() == CallType.VARIABLE;
        String id = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id)) {
            this.compiler.getValueCompiler().pushFixnum(fixnum);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, null, call2, 1);
            } else {
                this.invokeSelf(file2, null, call2, 1);
            }
            return;
        }
        if (functional) {
            incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT));
            outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, Long.TYPE));
        } else {
            incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
            outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Long.TYPE));
        }
        String incomingSig = CodegenUtils.sig(incoming);
        String outgoingSig = CodegenUtils.sig(outgoing);
        String methodName = "invokeOtherOneFixnum" + this.compiler.getClassData().cacheFieldCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(id);
        this.compiler.outline(methodName, incoming, () -> {
            String callMethod;
            SkinnyMethodAdapter adapter = this.compiler.adapter;
            adapter.line(this.compiler.getLastLine());
            adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
            adapter.getstatic(this.compiler.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
            adapter.dup();
            Label doCall = new Label();
            adapter.ifnonnull(doCall);
            adapter.pop();
            adapter.ldc(id);
            adapter.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFixnumOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
            adapter.dup();
            adapter.putstatic(this.compiler.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
            adapter.label(doCall);
            adapter.aload(0);
            if (functional) {
                adapter.aload(1);
                callMethod = "fcall";
            } else {
                adapter.aload(1);
                adapter.aload(2);
                callMethod = "call";
            }
            adapter.ldc(fixnum);
            adapter.invokevirtual(CodegenUtils.p(CallSite.class), callMethod, outgoingSig);
            adapter.areturn();
        });
        this.compiler.adapter.invokestatic(this.compiler.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeOtherOneFloat(String file2, CallBase call2, double flote) {
        MethodType outgoing;
        MethodType incoming;
        boolean functional = call2.getCallType() == CallType.FUNCTIONAL || call2.getCallType() == CallType.VARIABLE;
        String id = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id)) {
            this.compiler.getValueCompiler().pushFloat(flote);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, null, call2, 1);
            } else {
                this.invokeSelf(file2, null, call2, 1);
            }
            return;
        }
        if (functional) {
            incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT));
            outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, Double.TYPE));
        } else {
            incoming = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
            outgoing = MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Double.TYPE));
        }
        String incomingSig = CodegenUtils.sig(incoming);
        String outgoingSig = CodegenUtils.sig(outgoing);
        String methodName = "invokeOtherOneFloat" + this.compiler.getClassData().cacheFieldCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(id);
        this.compiler.outline(methodName, incoming, () -> {
            String callMethod;
            SkinnyMethodAdapter adapter = this.compiler.adapter;
            adapter.line(this.compiler.getLastLine());
            adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
            adapter.getstatic(this.compiler.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
            adapter.dup();
            Label doCall = new Label();
            adapter.ifnonnull(doCall);
            adapter.pop();
            adapter.ldc(id);
            adapter.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFloatOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
            adapter.dup();
            adapter.putstatic(this.compiler.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
            adapter.label(doCall);
            adapter.aload(0);
            if (functional) {
                adapter.aload(1);
                callMethod = "fcall";
            } else {
                adapter.aload(1);
                adapter.aload(2);
                callMethod = "call";
            }
            adapter.ldc(flote);
            adapter.invokevirtual(CodegenUtils.p(CallSite.class), callMethod, outgoingSig);
            adapter.areturn();
        });
        this.compiler.adapter.invokestatic(this.compiler.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeSelf(String file2, String scopeFieldName, CallBase call2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to '" + call2.getId() + "' has more than 250 arguments");
        }
        this.invoke(file2, this.compiler.getLastLine(), scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeInstanceSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        String noSplatMethod = literalClosure ? "instanceSuperIter" : "instanceSuper";
        String splatMethod = literalClosure ? "instanceSuperIterSplatArgs" : "instanceSuperSplatArgs";
        this.performSuper(file2, this.compiler.getLastLine(), name2, arity2, hasClosure, splatmap, noSplatMethod, splatMethod, false, flags2);
    }

    @Override
    public void invokeClassSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        String noSplatMethod = literalClosure ? "classSuperIter" : "classSuper";
        String splatMethod = literalClosure ? "classSuperIterSplatArgs" : "classSuperSplatArgs";
        this.performSuper(file2, this.compiler.getLastLine(), name2, arity2, hasClosure, splatmap, noSplatMethod, splatMethod, false, flags2);
    }

    @Override
    public void invokeUnresolvedSuper(String file2, String name2, int arity2, boolean hasClosure, boolean literalClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        String noSplatMethod = literalClosure ? "unresolvedSuperIter" : "unresolvedSuper";
        String splatMethod = literalClosure ? "unresolvedSuperIterSplatArgs" : "unresolvedSuperSplatArgs";
        this.performSuper(file2, this.compiler.getLastLine(), name2, arity2, hasClosure, splatmap, noSplatMethod, splatMethod, true, flags2);
    }

    @Override
    public void invokeZSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap, int flags2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        this.performSuper(file2, this.compiler.getLastLine(), name2, arity2, hasClosure, splatmap, "zSuper", "zSuperSplatArgs", true, flags2);
    }

    private void performSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap, String superHelper, String splatHelper, boolean unresolved, int flags2) {
        boolean needsSplatting = IRRuntimeHelpers.needsSplatting(splatmap);
        MethodType incoming = hasClosure ? MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)) : MethodType.methodType(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2));
        String incomingSig = CodegenUtils.sig(incoming);
        String outgoingSig = unresolved ? (needsSplatting ? SUPER_SPLAT_UNRESOLVED : SUPER_NOSPLAT_UNRESOLVED) : (needsSplatting ? SUPER_SPLAT_RESOLVED : SUPER_NOSPLAT_RESOLVED);
        String methodName = "invokeSuper" + this.compiler.getClassData().cacheFieldCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(name2);
        this.compiler.outline(methodName, incoming, () -> {
            SkinnyMethodAdapter adapter = this.compiler.adapter;
            adapter.line(line);
            adapter.aload(0);
            adapter.aload(2);
            if (!unresolved) {
                adapter.ldc(name2);
            }
            if (!unresolved) {
                adapter.aload(3);
            }
            IRBytecodeAdapter.buildArrayFromLocals(adapter, 4, arity2);
            if (hasClosure) {
                adapter.aload(4 + arity2);
            } else {
                adapter.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
            if (needsSplatting) {
                String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
                adapter.ldc(splatmapString);
                adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "decodeSplatmap", CodegenUtils.sig(boolean[].class, String.class));
                adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), splatHelper, outgoingSig);
            } else {
                adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), superHelper, outgoingSig);
            }
            adapter.areturn();
        });
        this.setCallInfo(flags2);
        this.compiler.adapter.invokestatic(this.compiler.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeEQQ(EQQInstr call2) {
        this.compiler.getValueCompiler().pushCallSite(this.compiler.getClassData().clsName, this.compiler.getUniqueSiteName(call2.getId()), null, call2);
        this.compiler.adapter.ldc(call2.isSplattedValue());
        this.compiler.invokeIRHelper("isEQQ", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, Boolean.TYPE));
    }

    @Override
    public void asString(AsStringInstr call2, String scopeFieldName, String file2) {
        if (call2.isPotentiallyRefined()) {
            String methodName = this.compiler.getUniqueSiteName(call2.getId());
            String clsName = this.compiler.getClassData().clsName;
            this.compiler.getValueCompiler().pushCallSite(clsName, methodName, scopeFieldName, call2);
            this.compiler.invokeIRHelper("asString", CodegenUtils.sig(RubyString.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class));
        } else {
            this.invokeOther(file2, scopeFieldName, call2, 0);
            this.compiler.adapter.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
        }
    }

    @Override
    public void setCallInfo(int flags2) {
        this.compiler.loadContext();
        if (flags2 == 0) {
            this.compiler.adapter.invokestatic(CodegenUtils.p(ThreadContext.class), "clearCallInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
        } else {
            this.compiler.adapter.ldc(flags2);
            this.compiler.invokeIRHelper("setCallInfo", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Integer.TYPE));
        }
    }

    @Override
    public void invokeBlockGiven(String methodName, String file2) {
        IndyInvocationCompiler.invokeBlockGiven(this.compiler, methodName, file2);
    }

    @Override
    public void invokeFrameName(String methodName, String file2) {
        IndyInvocationCompiler.invokeFrameName(this.compiler, methodName, file2);
    }
}

