/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.SourceCacheListener;
import com.oracle.truffle.polyglot.SourceCacheStatisticsListener;
import com.oracle.truffle.polyglot.TracingSourceCacheListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.SandboxPolicy;

final class PolyglotSourceCache {
    private final StrongCache strongCache;
    private final WeakCache weakCache;
    private SourceCacheListener sourceCacheListener;

    PolyglotSourceCache(ReferenceQueue<Source> deadSourcesQueue, TracingSourceCacheListener sourceCacheListener, SourceCacheStatisticsListener sourceCacheStatisticsListener) {
        this.sourceCacheListener = new SourceCacheListenerDispatch(sourceCacheListener, sourceCacheStatisticsListener);
        this.weakCache = new WeakCache(deadSourcesQueue);
        this.strongCache = new StrongCache();
    }

    void patch(SourceCacheListener listener, SourceCacheStatisticsListener statisticsListener) {
        this.sourceCacheListener = new SourceCacheListenerDispatch(listener, statisticsListener);
    }

    CallTarget parseCached(ParseOrigin origin, PolyglotLanguageContext context, Source source, String[] argumentNames) {
        CallTarget target;
        if (source.isCached()) {
            StrongCache strong = this.strongCache;
            boolean useStrong = context.getEngine().storeEngine;
            if ((useStrong || !((Cache)strong).isEmpty()) && (target = ((Cache)strong).lookup(origin, context, source, argumentNames, useStrong)) != null) {
                return target;
            }
            target = this.weakCache.lookup(origin, context, source, argumentNames, true);
        } else {
            long parseStart = System.currentTimeMillis();
            target = PolyglotSourceCache.parseImpl(origin, context, argumentNames, source);
            this.sourceCacheListener.onCacheMiss(source, target, SourceCacheListener.CacheType.UNCACHED, parseStart);
        }
        return target;
    }

    void listCachedSources(PolyglotImpl polyglot, Collection<Object> source) {
        this.strongCache.listSources(polyglot, source);
        this.weakCache.listSources(polyglot, source);
    }

    void cleanupStaleEntries() {
        WeakCache.cleanupStaleEntries(this.weakCache.deadSources, this.sourceCacheListener);
    }

    private static CallTarget parseImpl(ParseOrigin origin, PolyglotLanguageContext context, String[] argumentNames, Source source) {
        PolyglotSourceCache.validateSource(context, source);
        CallTarget parsedTarget = EngineAccessor.LANGUAGE.parse(context.requireEnv(), source, context.getLanguageInstance().parseSourceOptions(origin, source, null), null, argumentNames);
        if (parsedTarget == null) {
            throw new IllegalStateException(String.format("Parsing resulted in a null CallTarget for %s.", source));
        }
        return parsedTarget;
    }

    private static void validateSource(PolyglotLanguageContext context, Source source) {
        boolean expectCharacters;
        if (!source.hasBytes() && !source.hasCharacters()) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The source does not specify characters nor bytes.", new Object[0]));
        }
        String mimeType = source.getMimeType();
        Set<String> mimeTypes = context.language.cache.getMimeTypes();
        if (mimeType != null && !mimeTypes.contains(mimeType)) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s does not support MIME type %s. Supported MIME types are %s.", source.getLanguage(), mimeType, mimeTypes));
        }
        String activeMimeType = mimeType;
        if (activeMimeType == null) {
            activeMimeType = context.language.cache.getDefaultMimeType();
        }
        boolean bl = expectCharacters = activeMimeType != null ? context.language.cache.isCharacterMimeType(activeMimeType) : true;
        if (mimeType != null && source.hasCharacters() != expectCharacters) {
            if (source.hasBytes()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is character based for language '%s' but the source contents are byte based.", mimeType, source.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is byte based for language '%s' but the source contents are character based.", mimeType, source.getLanguage()));
        }
        if (source.hasCharacters() != expectCharacters) {
            HashSet<String> binaryMimeTypes = new HashSet<String>();
            HashSet<String> characterMimeTypes = new HashSet<String>();
            for (String supportedMimeType : mimeTypes) {
                if (context.language.cache.isCharacterMimeType(supportedMimeType)) {
                    characterMimeTypes.add(supportedMimeType);
                    continue;
                }
                binaryMimeTypes.add(supportedMimeType);
            }
            if (expectCharacters) {
                if (binaryMimeTypes.isEmpty()) {
                    throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports character based sources but a binary based source was provided.", source.getLanguage()));
                }
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a binary based source instead or specify a MIME type for the source. Available MIME types for binary based sources are %s.", source.getLanguage(), binaryMimeTypes));
            }
            if (characterMimeTypes.isEmpty()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports binary based sources but a character based source was provided.", source.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a character based source instead or specify a MIME type for the source. Available MIME types for character based sources are %s.", source.getLanguage(), characterMimeTypes));
        }
    }

    static Map<String, OptionValuesImpl> parseSourceOptions(PolyglotEngineImpl engine, Map<String, String> options, String groupOnly, SandboxPolicy policy, boolean allowExperimentalOptions) {
        if (options.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, OptionValuesImpl> optionsById = new LinkedHashMap<String, OptionValuesImpl>();
        for (String optionKey : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(optionKey);
            if (groupOnly != null && !groupOnly.equals(group)) continue;
            String optionValue = options.get(optionKey);
            try {
                OptionDescriptors descriptors;
                String id;
                PolyglotImpl.VMObject object = PolyglotSourceCache.findComponentForSourceOption(engine, optionKey, group);
                if (object instanceof PolyglotLanguage) {
                    PolyglotLanguage language = (PolyglotLanguage)object;
                    id = language.getId();
                    descriptors = language.getSourceOptionsInternal();
                } else if (object instanceof PolyglotInstrument) {
                    PolyglotInstrument instrument = (PolyglotInstrument)object;
                    id = instrument.getId();
                    descriptors = instrument.getSourceOptionsInternal();
                } else {
                    throw new AssertionError((Object)"invalid vm object");
                }
                OptionValuesImpl targetOptions = (OptionValuesImpl)optionsById.get(id);
                if (targetOptions == null) {
                    targetOptions = new OptionValuesImpl(descriptors, policy, false, true);
                    optionsById.put(id, targetOptions);
                }
                targetOptions.put(optionKey, optionValue, allowExperimentalOptions, engine::getAllSourceOptions);
            }
            catch (PolyglotEngineException e) {
                throw PolyglotEngineException.illegalArgument(String.format("Failed to parse source option '%s=%s': %s", optionKey, optionValue, e.e.getMessage()), e.e);
            }
        }
        return optionsById;
    }

    private static PolyglotImpl.VMObject findComponentForSourceOption(PolyglotEngineImpl engine, String optionKey, String group) {
        PolyglotLanguage language = engine.idToLanguage.get(group);
        if (language == null) {
            PolyglotInstrument instrument = engine.idToInstrument.get(group);
            if (instrument != null) {
                return instrument;
            }
            throw OptionValuesImpl.failNotFound(engine.getAllSourceOptions(), optionKey);
        }
        return language;
    }

    private static final class SourceCacheListenerDispatch
    implements SourceCacheListener {
        private final SourceCacheListener[] listeners;

        SourceCacheListenerDispatch(SourceCacheListener ... listeners) {
            this.listeners = (SourceCacheListener[])Arrays.stream(listeners).filter(Objects::nonNull).toArray(SourceCacheListener[]::new);
        }

        @Override
        public void onCacheHit(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
            for (SourceCacheListener l : this.listeners) {
                l.onCacheHit(source, target, cacheType, hits);
            }
        }

        @Override
        public void onCacheMiss(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long startTime) {
            for (SourceCacheListener l : this.listeners) {
                l.onCacheMiss(source, target, cacheType, startTime);
            }
        }

        @Override
        public void onCacheFail(PolyglotSharingLayer sharingLayer, Source source, SourceCacheListener.CacheType cacheType, long startTime, Throwable throwable) {
            for (SourceCacheListener l : this.listeners) {
                l.onCacheFail(sharingLayer, source, cacheType, startTime, throwable);
            }
        }

        @Override
        public void onCacheEvict(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
            for (SourceCacheListener l : this.listeners) {
                l.onCacheEvict(source, target, cacheType, hits);
            }
        }
    }

    private final class WeakCache
    extends Cache {
        private final ConcurrentHashMap<WeakSourceKey, WeakCacheValue> sourceCache = new ConcurrentHashMap();
        private final ReferenceQueue<Source> deadSources;
        private final WeakReference<WeakCache> cacheRef;

        WeakCache(ReferenceQueue<Source> deadSources) {
            this.deadSources = deadSources;
            this.cacheRef = new WeakReference<WeakCache>(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        CallTarget lookup(ParseOrigin origin, PolyglotLanguageContext context, Source source, String[] argumentNames, boolean parse) {
            WeakCache.cleanupStaleEntries(this.deadSources, PolyglotSourceCache.this.sourceCacheListener);
            Object sourceId = EngineAccessor.SOURCE.getSourceIdentifier(source);
            Source sourceValue = EngineAccessor.SOURCE.copySource(source);
            WeakSourceKey ref = new WeakSourceKey(new SourceKey(sourceId, argumentNames), source, this.cacheRef, this.deadSources);
            WeakCacheValue value = this.sourceCache.get(ref);
            if (value == null) {
                if (!parse) return null;
                long parseStart = System.currentTimeMillis();
                try {
                    value = new WeakCacheValue(PolyglotSourceCache.parseImpl(origin, context, argumentNames, sourceValue), sourceValue);
                    WeakCacheValue prev = this.sourceCache.putIfAbsent(ref, value);
                    if (prev != null) {
                        value = prev;
                    }
                    PolyglotSourceCache.this.sourceCacheListener.onCacheMiss(source, value.target, SourceCacheListener.CacheType.WEAK, parseStart);
                    return value.target;
                }
                catch (Throwable t) {
                    PolyglotSourceCache.this.sourceCacheListener.onCacheFail(context.context.layer, source, SourceCacheListener.CacheType.WEAK, parseStart, t);
                    throw t;
                }
            } else {
                value.hits.incrementAndGet();
                PolyglotSourceCache.this.sourceCacheListener.onCacheHit(source, value.target, SourceCacheListener.CacheType.WEAK, value.hits.get());
            }
            return value.target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Object> sources) {
            WeakCache.cleanupStaleEntries(this.deadSources, PolyglotSourceCache.this.sourceCacheListener);
            for (WeakCacheValue value : this.sourceCache.values()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, value.source));
            }
        }

        private static void cleanupStaleEntries(ReferenceQueue<Source> deadSourcesQueue, SourceCacheListener cacheListener) {
            WeakSourceKey sourceRef;
            while ((sourceRef = (WeakSourceKey)deadSourcesQueue.poll()) != null) {
                WeakCache cache = (WeakCache)sourceRef.cacheRef.get();
                WeakCacheValue value = cache != null ? cache.sourceCache.remove(sourceRef) : null;
                if (value == null) continue;
                cacheListener.onCacheEvict(value.source, value.target, SourceCacheListener.CacheType.WEAK, value.hits.get());
            }
        }
    }

    private final class StrongCache
    extends Cache {
        private final ConcurrentHashMap<SourceKey, StrongCacheValue> sourceCache = new ConcurrentHashMap();

        private StrongCache() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        CallTarget lookup(ParseOrigin origin, PolyglotLanguageContext context, Source source, String[] argumentNames, boolean parse) {
            SourceKey key = new SourceKey(source, argumentNames);
            StrongCacheValue value = this.sourceCache.get(key);
            if (value == null) {
                if (!parse) return null;
                long parseStart = System.currentTimeMillis();
                try {
                    value = new StrongCacheValue(PolyglotSourceCache.parseImpl(origin, context, argumentNames, source));
                    StrongCacheValue prevValue = this.sourceCache.putIfAbsent(key, value);
                    if (prevValue != null) {
                        value = prevValue;
                    }
                    PolyglotSourceCache.this.sourceCacheListener.onCacheMiss(source, value.target, SourceCacheListener.CacheType.STRONG, parseStart);
                    return value.target;
                }
                catch (Throwable t) {
                    PolyglotSourceCache.this.sourceCacheListener.onCacheFail(context.context.layer, source, SourceCacheListener.CacheType.STRONG, parseStart, t);
                    throw t;
                }
            } else {
                value.hits.incrementAndGet();
                PolyglotSourceCache.this.sourceCacheListener.onCacheHit(source, value.target, SourceCacheListener.CacheType.STRONG, value.hits.get());
            }
            return value.target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Object> sources) {
            for (SourceKey key : this.sourceCache.keySet()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, (Source)key.key));
            }
        }
    }

    private static abstract class Cache {
        private Cache() {
        }

        abstract boolean isEmpty();

        abstract CallTarget lookup(ParseOrigin var1, PolyglotLanguageContext var2, Source var3, String[] var4, boolean var5);

        abstract void listSources(PolyglotImpl var1, Collection<Object> var2);
    }

    static enum ParseOrigin {
        LANGUAGE,
        INSTRUMENT,
        EMBEDDING;

    }

    private static final class WeakSourceKey
    extends WeakReference<Source> {
        final SourceKey key;
        final WeakReference<WeakCache> cacheRef;

        WeakSourceKey(SourceKey key, Source value, WeakReference<WeakCache> cacheRef, ReferenceQueue<? super Source> q) {
            super(value, q);
            this.cacheRef = cacheRef;
            this.key = key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakSourceKey) {
                WeakSourceKey other = (WeakSourceKey)obj;
                return this.key.equals(other.key);
            }
            return false;
        }
    }

    private static final class SourceKey {
        private final Object key;
        private final String[] arguments;

        SourceKey(Object key, String[] arguments) {
            this.key = key;
            this.arguments = arguments != null && arguments.length == 0 ? null : arguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceKey) {
                SourceKey other = (SourceKey)obj;
                return this.key.equals(other.key) && Arrays.equals(this.arguments, other.arguments);
            }
            return false;
        }
    }

    static class WeakCacheValue {
        final CallTarget target;
        final Source source;
        final AtomicLong hits = new AtomicLong();

        WeakCacheValue(CallTarget target, Source source) {
            this.target = target;
            this.source = source;
        }
    }

    static class StrongCacheValue {
        final CallTarget target;
        final AtomicLong hits = new AtomicLong();

        StrongCacheValue(CallTarget target) {
            this.target = target;
        }
    }
}

