/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.util.Collection;
import java.util.function.Supplier;
import schemacrawler.tools.lint.LinterRegistry;
import us.fatehi.utility.property.PropertyName;

public final class LinterHelp
implements Supplier<String[]> {
    private final boolean generateMarkdown;

    public LinterHelp() {
        this(false);
    }

    public LinterHelp(boolean generateMarkdown) {
        this.generateMarkdown = generateMarkdown;
    }

    @Override
    public String[] get() {
        StringBuilder buffer = new StringBuilder(1024);
        if (this.generateMarkdown) {
            this.printMarkdownHeader(buffer);
        } else {
            this.printHelpHeader(buffer);
        }
        LinterRegistry registry = LinterRegistry.getLinterRegistry();
        Collection<PropertyName> registeredPlugins = registry.getRegisteredPlugins();
        for (PropertyName linterName : registeredPlugins) {
            String linterId = linterName.getName();
            if (this.generateMarkdown) {
                this.printMarkdownLinterHeader(buffer, linterId);
            } else {
                this.printLinterHeader(buffer, linterId);
            }
            buffer.append(linterName.getDescription()).append(System.lineSeparator()).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return new String[]{buffer.toString()};
    }

    private void printHelpHeader(StringBuilder buffer) {
        buffer.append(System.lineSeparator()).append("Available SchemaCrawler linters:").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printLinterHeader(StringBuilder buffer, String linterId) {
        buffer.append("Linter: ").append(linterId).append(System.lineSeparator());
    }

    private void printMarkdownHeader(StringBuilder buffer) {
        buffer.append(System.lineSeparator()).append("## Lint Checks").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printMarkdownLinterHeader(StringBuilder buffer, String linterId) {
        buffer.append("### Linter: *").append(linterId).append("*  ").append(System.lineSeparator());
    }
}

