/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code.deflate;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.sourceforge.plantuml.code.deflate.BitInputStream;

public final class ByteBitInputStream
implements BitInputStream {
    private InputStream input;
    private int currentByte;
    private int numBitsRemaining;

    public ByteBitInputStream(InputStream in) {
        this.input = Objects.requireNonNull(in);
        this.currentByte = 0;
        this.numBitsRemaining = 0;
    }

    @Override
    public int getBitPosition() {
        if (this.numBitsRemaining < 0 || this.numBitsRemaining > 7) {
            throw new IllegalStateException();
        }
        return (8 - this.numBitsRemaining) % 8;
    }

    @Override
    public int readByte() throws IOException {
        this.currentByte = 0;
        this.numBitsRemaining = 0;
        return this.input.read();
    }

    @Override
    public int read() throws IOException {
        if (this.currentByte == -1) {
            return -1;
        }
        if (this.numBitsRemaining == 0) {
            this.currentByte = this.input.read();
            if (this.currentByte == -1) {
                return -1;
            }
            this.numBitsRemaining = 8;
        }
        if (this.numBitsRemaining <= 0) {
            throw new IllegalStateException();
        }
        --this.numBitsRemaining;
        return this.currentByte >>> 7 - this.numBitsRemaining & 1;
    }

    @Override
    public int readNoEof() throws IOException {
        int result = this.read();
        if (result == -1) {
            throw new EOFException();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.currentByte = -1;
        this.numBitsRemaining = 0;
    }
}

