/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service.internalcache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.hibernate.orm.runtime.service.internalcache.QuarkusInternalCache;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.internal.util.cache.InternalCache;
import org.hibernate.internal.util.cache.InternalCacheFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class QuarkusInternalCacheFactoryInitiator
implements StandardServiceInitiator<InternalCacheFactory> {
    public static final QuarkusInternalCacheFactoryInitiator INSTANCE = new QuarkusInternalCacheFactoryInitiator();

    private QuarkusInternalCacheFactoryInitiator() {
    }

    public InternalCacheFactory initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        return new QuarkusInternalCacheFactory();
    }

    public Class<InternalCacheFactory> getServiceInitiated() {
        return InternalCacheFactory.class;
    }

    private static class QuarkusInternalCacheFactory
    implements InternalCacheFactory {
        private QuarkusInternalCacheFactory() {
        }

        public <K, V> InternalCache<K, V> createInternalCache(int intendedApproximateSize) {
            Cache caffeineCache = Caffeine.newBuilder().maximumSize((long)intendedApproximateSize).build();
            return new QuarkusInternalCache(caffeineCache);
        }
    }
}

