/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import java.util.List;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.social.facebook.FacebookIdentityProvider;
import org.keycloak.social.facebook.FacebookIdentityProviderConfig;

public class FacebookIdentityProviderFactory
extends AbstractIdentityProviderFactory<FacebookIdentityProvider>
implements SocialIdentityProviderFactory<FacebookIdentityProvider> {
    public static final String PROVIDER_ID = "facebook";

    public String getName() {
        return "Facebook";
    }

    public FacebookIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new FacebookIdentityProvider(session, new FacebookIdentityProviderConfig(model));
    }

    public OAuth2IdentityProviderConfig createConfig() {
        return new OAuth2IdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("fetchedFields").label("Additional user's profile fields").helpText("Provide additional fields which would be fetched using the profile request. This will be appended to the default set of 'id,name,email,first_name,last_name'.").type("String").add().build();
    }
}

