/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.Extensions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;

public abstract class BaseExtensibleModel<C extends Extensible<C> & Constructible>
extends BaseModel<C>
implements Extensible<C> {
    private static final Set<String> INITIAL_SET = Collections.emptySet();
    private Set<String> extensionNames = INITIAL_SET;

    protected BaseExtensibleModel() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof BaseExtensibleModel) {
            return Objects.equals(this.extensionNames, ((BaseExtensibleModel)obj).extensionNames);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Objects.hash(this.extensionNames);
    }

    @Override
    public Map<String, Object> getAllProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(super.getAllProperties());
        properties.keySet().removeIf(Extensions::isPrivateExtension);
        return Collections.unmodifiableMap(properties);
    }

    @Override
    public void setAllProperties(Map<String, ?> allProperties) {
        this.extensionNames.clear();
        super.setAllProperties(allProperties);
    }

    @Override
    protected <P> P getProperty(String name) {
        if (this.extensionNames.contains(name)) {
            return null;
        }
        return (P)super.getProperty(name);
    }

    @Override
    protected <P> P getProperty(String name, Class<P> type) {
        if (this.extensionNames.contains(name)) {
            return null;
        }
        return super.getProperty(name, type);
    }

    @Override
    public <P> void setProperty(String name, P value) {
        if (this.extensionNames.contains(name)) {
            this.extensionNames.remove(name);
        }
        super.setProperty(name, value);
    }

    @Override
    protected <V> List<V> getListProperty(String name) {
        if (this.extensionNames.contains(name)) {
            return null;
        }
        return super.getListProperty(name);
    }

    @Override
    protected <V> void setListProperty(String name, List<V> value) {
        if (this.extensionNames.contains(name)) {
            this.extensionNames.remove(name);
        }
        super.setListProperty(name, value);
    }

    @Override
    protected <V> void addListPropertyEntry(String name, V value) {
        if (this.extensionNames.contains(name)) {
            this.extensionNames.remove(name);
        }
        super.addListPropertyEntry(name, value);
    }

    @Override
    protected <V> void removeListPropertyEntry(String name, V value) {
        if (this.extensionNames.contains(name)) {
            return;
        }
        super.removeListPropertyEntry(name, value);
    }

    @Override
    protected <V> Map<String, V> getMapProperty(String name) {
        if (this.extensionNames.contains(name)) {
            return null;
        }
        return super.getMapProperty(name);
    }

    @Override
    protected <V> void setMapProperty(String name, Map<String, V> value) {
        if (this.extensionNames.contains(name)) {
            this.extensionNames.remove(name);
        }
        super.setMapProperty(name, value);
    }

    @Override
    protected <V> void putMapPropertyEntry(String name, String key, V value) {
        if (this.extensionNames.contains(name)) {
            this.extensionNames.remove(name);
        }
        super.putMapPropertyEntry(name, key, value);
    }

    @Override
    protected void removeMapPropertyEntry(String name, String key) {
        if (this.extensionNames.contains(name)) {
            return;
        }
        super.removeMapPropertyEntry(name, key);
    }

    public Map<String, Object> getExtensions() {
        return this.getExtensions(false);
    }

    public Map<String, Object> getAllExtensions() {
        return this.getExtensions(true);
    }

    private Map<String, Object> getExtensions(boolean includePrivate) {
        if (this.extensionNames.isEmpty()) {
            return this.extensionNames == INITIAL_SET ? null : Collections.emptyMap();
        }
        if (!includePrivate && this.extensionNames.stream().allMatch(Extensions::isPrivateExtension)) {
            return null;
        }
        LinkedHashMap ext = new LinkedHashMap(this.extensionNames.size());
        for (String name : this.extensionNames) {
            if (!includePrivate && Extensions.isPrivateExtension(name)) continue;
            ext.put(name, super.getProperty(name));
        }
        return Collections.unmodifiableMap(ext);
    }

    public C addExtension(String name, Object value) {
        if (value != null) {
            if (this.extensionNames == INITIAL_SET) {
                this.extensionNames = new LinkedHashSet<String>(1);
            }
            this.extensionNames.add(name);
        }
        super.setProperty(name, value);
        return (C)this;
    }

    public void removeExtension(String name) {
        if (this.extensionNames.remove(name)) {
            super.setProperty(name, null);
        }
    }

    public void setExtensions(Map<String, Object> extensions) {
        for (String string : Set.copyOf(this.extensionNames)) {
            if (Extensions.isPrivateExtension(string)) continue;
            this.removeExtension(string);
        }
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (Map.Entry entry : extensions.entrySet()) {
            this.addExtension((String)entry.getKey(), entry.getValue());
        }
    }

    public Object getExtension(String name) {
        if (this.extensionNames.contains(name)) {
            return super.getProperty(name);
        }
        return null;
    }

    @Override
    protected boolean isExtension(String name) {
        return this.extensionNames.contains(name);
    }

    @Override
    public <T extends BaseModel<C>> void merge(T other) {
        for (Map.Entry<String, Object> property : other.properties.entrySet()) {
            String name = property.getKey();
            if (!other.isExtension(name) || this.isExtension(name)) continue;
            this.addExtension(name, property.getValue());
        }
        super.merge(other);
    }
}

