/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jsampler.CC;
import org.jsampler.DOMUtils;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.event.OrchestraAdapter;
import org.jsampler.event.OrchestraEvent;
import org.jsampler.event.OrchestraListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultOrchestraModel
implements OrchestraModel {
    private String name = "";
    private String description = "";
    private final Vector<OrchestraInstrument> instruments = new Vector();
    private final Vector<OrchestraListener> listeners = new Vector();
    private final Handler eventHandler = new Handler();

    public DefaultOrchestraModel() {
        this.addOrchestraListener(this.getHandler());
    }

    @Override
    public void addOrchestraListener(OrchestraListener orchestraListener) {
        this.listeners.add(orchestraListener);
    }

    @Override
    public void removeOrchestraListener(OrchestraListener orchestraListener) {
        this.listeners.remove(orchestraListener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.fireNameChanged();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
        this.fireDescriptionChanged();
    }

    @Override
    public int getInstrumentCount() {
        return this.instruments.size();
    }

    @Override
    public OrchestraInstrument getInstrument(int n) {
        return this.instruments.get(n);
    }

    @Override
    public void addInstrument(OrchestraInstrument orchestraInstrument) {
        this.insertInstrument(orchestraInstrument, this.getInstrumentCount());
    }

    @Override
    public void insertInstrument(OrchestraInstrument orchestraInstrument, int n) {
        if (orchestraInstrument == null) {
            throw new IllegalArgumentException("instr should be non-null!");
        }
        this.instruments.insertElementAt(orchestraInstrument, n);
        this.fireInstrumentAdded(orchestraInstrument);
    }

    @Override
    public void removeInstrument(int n) {
        OrchestraInstrument orchestraInstrument = this.instruments.get(n);
        this.instruments.removeElementAt(n);
        this.fireInstrumentRemoved(orchestraInstrument);
    }

    @Override
    public boolean removeInstrument(OrchestraInstrument orchestraInstrument) {
        boolean bl = this.instruments.removeElement(orchestraInstrument);
        if (bl) {
            this.fireInstrumentRemoved(orchestraInstrument);
        }
        return bl;
    }

    @Override
    public int getInstrumentIndex(OrchestraInstrument orchestraInstrument) {
        if (orchestraInstrument == null) {
            return -1;
        }
        for (int i = 0; i < this.getInstrumentCount(); ++i) {
            if (this.getInstrument(i) != orchestraInstrument) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void moveInstrumentOnTop(OrchestraInstrument orchestraInstrument) {
        if (orchestraInstrument == null) {
            return;
        }
        int n = this.getInstrumentIndex(orchestraInstrument);
        if (n <= 0) {
            return;
        }
        this.removeInstrument(n);
        this.insertInstrument(orchestraInstrument, 0);
    }

    @Override
    public void moveInstrumentUp(OrchestraInstrument orchestraInstrument) {
        if (orchestraInstrument == null) {
            return;
        }
        int n = this.getInstrumentIndex(orchestraInstrument);
        if (n <= 0) {
            return;
        }
        this.removeInstrument(n);
        this.insertInstrument(orchestraInstrument, n - 1);
    }

    @Override
    public void moveInstrumentDown(OrchestraInstrument orchestraInstrument) {
        if (orchestraInstrument == null) {
            return;
        }
        int n = this.getInstrumentIndex(orchestraInstrument);
        if (n < 0 || n == this.getInstrumentCount() - 1) {
            return;
        }
        this.removeInstrument(n);
        this.insertInstrument(orchestraInstrument, n + 1);
    }

    @Override
    public void moveInstrumentAtBottom(OrchestraInstrument orchestraInstrument) {
        if (orchestraInstrument == null) {
            return;
        }
        int n = this.getInstrumentIndex(orchestraInstrument);
        if (n < 0 || n == this.getInstrumentCount() - 1) {
            return;
        }
        this.removeInstrument(n);
        this.insertInstrument(orchestraInstrument, this.getInstrumentCount());
    }

    @Override
    public void readObject(Node node) {
        if (node.getNodeType() != 1 || !node.getNodeName().equals("orchestra")) {
            throw new IllegalArgumentException("Not an orchestra node!");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            throw new IllegalArgumentException("The orchestra name is undefined!");
        }
        DOMUtils.validateTextContent(node2);
        this.setName(node2.getFirstChild().getNodeValue());
        String string = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            string = node.getNodeName();
            if (string.equals("description")) {
                if (!node.hasChildNodes()) continue;
                DOMUtils.validateTextContent(node);
                this.setDescription(node.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("instrument")) {
                OrchestraInstrument orchestraInstrument = new OrchestraInstrument();
                orchestraInstrument.readObject(node);
                this.addInstrument(orchestraInstrument);
                continue;
            }
            CC.getLogger().info("Unknown field: " + string);
        }
    }

    @Override
    public void writeObject(Document document, Node node) {
        Element element = document.createElement("orchestra");
        element.setAttribute("name", this.getName());
        node.appendChild(element);
        node = element;
        element = document.createElement("description");
        element.appendChild(document.createTextNode(this.getDescription()));
        node.appendChild(element);
        for (int i = 0; i < this.getInstrumentCount(); ++i) {
            this.getInstrument(i).writeObject(document, node);
        }
    }

    private void fireNameChanged() {
        OrchestraEvent orchestraEvent = new OrchestraEvent(this);
        for (OrchestraListener orchestraListener : this.listeners) {
            orchestraListener.nameChanged(orchestraEvent);
        }
    }

    private void fireDescriptionChanged() {
        OrchestraEvent orchestraEvent = new OrchestraEvent(this);
        for (OrchestraListener orchestraListener : this.listeners) {
            orchestraListener.descriptionChanged(orchestraEvent);
        }
    }

    private void fireInstrumentAdded(OrchestraInstrument orchestraInstrument) {
        OrchestraEvent orchestraEvent = new OrchestraEvent(this, orchestraInstrument);
        for (OrchestraListener orchestraListener : this.listeners) {
            orchestraListener.instrumentAdded(orchestraEvent);
        }
    }

    private void fireInstrumentRemoved(OrchestraInstrument orchestraInstrument) {
        OrchestraEvent orchestraEvent = new OrchestraEvent(this, orchestraInstrument);
        for (OrchestraListener orchestraListener : this.listeners) {
            orchestraListener.instrumentRemoved(orchestraEvent);
        }
    }

    private void fireInstrumentChanged(OrchestraInstrument orchestraInstrument) {
        OrchestraEvent orchestraEvent = new OrchestraEvent(this, orchestraInstrument);
        for (OrchestraListener orchestraListener : this.listeners) {
            orchestraListener.instrumentChanged(orchestraEvent);
        }
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    extends OrchestraAdapter
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DefaultOrchestraModel.this.fireInstrumentChanged((OrchestraInstrument)changeEvent.getSource());
        }

        @Override
        public void instrumentAdded(OrchestraEvent orchestraEvent) {
            orchestraEvent.getInstrument().addChangeListener(DefaultOrchestraModel.this.getHandler());
        }

        @Override
        public void instrumentRemoved(OrchestraEvent orchestraEvent) {
            orchestraEvent.getInstrument().removeChangeListener(DefaultOrchestraModel.this.getHandler());
        }
    }
}

